/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.createjournals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcOperationErrorForJnlOpt;
import sanproject.sn2.controller.wizard.replication.remote.createjournals.SJctrCreateJournalsConfirmData;
import sanproject.sn2.controller.wizard.replication.remote.createjournals.SJctrCreateJournalsSelectedTableModel;
import sanproject.sn2.controller.wizard.replication.remote.createjournals.SJctrCreateJournalsSelectedTableModelErrorDetail;
import sanproject.sn2.controller.wizard.replication.remote.journalproperties.SJctrJournalPropertiesDC;
import sanproject.sn2.model.data.replication.SJmoJnlGroupIndex;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrp;

public class SJctrCreateJournalsConfirmDC
extends SJctrConfirmDataController {
    private static final int DISP_ID = 16798223;
    private static final String KEY_DETAIL = "COM_DETAIL";

    public SJctrCreateJournalsConfirmDC() throws SJcException {
        super(16798223);
        this.initDataModel();
    }

    private void initDataModel() {
        SJctrCreateJournalsSelectedTableModel confirmTable = new SJctrCreateJournalsSelectedTableModel();
        confirmTable.setPaging(false);
        this.addDataObjectModel("COM_TABLE", confirmTable);
        SJctrButtonDataModel detailButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_DETAIL, detailButton);
        detailButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrCreateJournalsConfirmDC.this.makeDetailAction(event);
            }
        });
    }

    private void makeDetailAction(SJctrItemSelectEvent<?> event) {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel("COM_TABLE");
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("makeDetailAction", "not selected");
            return;
        }
        HashMap param = new HashMap();
        param.put("COM_SELECTED_JOURNAL", selectedRowList);
        SJctrRelatedDispDataObject dialogRelated = this.createDialog(SJctrJournalPropertiesDC.class, param);
        this.addUpdateDisp(dialogRelated);
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> confirmDataList = this.getCache(SJctrCreateJournalsConfirmData.class);
        if (null == confirmDataList) {
            this.logUty.putlog("checkStartData", "Confirmation data list is null.");
            SJctrError err = new SJctrError(210, 22, 107005);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == confirmDataList.size()) {
            this.logUty.putlog("checkStartData", "Size of confirmation data list is zero.");
            SJctrError err = new SJctrError(210, 22, 107005);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrCreateJournalsConfirmData confirmData = (SJctrCreateJournalsConfirmData)confirmDataList.get(0);
        if (null == confirmData) {
            this.logUty.putlog("checkStartData", "Confirmation data is null.");
            SJctrError err = new SJctrError(210, 22, 107005);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    protected void makeDataObjectModel(Collection<String> keyList) throws SJcException {
        List<?> confirmDataList = this.getCache(SJctrCreateJournalsConfirmData.class);
        SJctrCreateJournalsConfirmData confirmData = (SJctrCreateJournalsConfirmData)confirmDataList.get(0);
        this.getProxy().getCacheMap().putAll(confirmData.getNeedDataMap());
        super.makeDataObjectModel(keyList);
    }

    @Override
    public boolean checkConstructData() {
        SJctrTableDataModel confirmTable = (SJctrTableDataModel)this.getDataObjectModel("COM_TABLE");
        if (confirmTable instanceof SJctrCreateJournalsSelectedTableModel) {
            SJctrCreateJournalsConfirmData confirmData = (SJctrCreateJournalsConfirmData)this.getProxy().getCache(SJctrCreateJournalsConfirmData.class).get(0);
            ((SJctrCreateJournalsSelectedTableModel)confirmTable).setBasicDataList(confirmData.getUrJnlGrp());
        }
        return true;
    }

    @Override
    public Map<String, List<?>> getConfirmData() {
        HashMap retMap = new HashMap();
        List<?> confirmDataList = this.getCache(SJctrCreateJournalsConfirmData.class);
        retMap.put(SJctrCreateJournalsConfirmData.class.getName(), confirmDataList);
        return retMap;
    }

    @Override
    public void getConfirmWithStatus(List<Object> result) throws SJcException {
        SJctrCreateJournalsConfirmData confirmData = (SJctrCreateJournalsConfirmData)this.getProxy().getCache(SJctrCreateJournalsConfirmData.class).get(0);
        List tempList = (List)result.get(0);
        List errorList = (List)tempList.get(0);
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>(errorList.size());
        List<SJmoUniversalReplicatorJnlGrp> rowDataList = confirmData.getUrJnlGrp();
        for (SJctrRcOperationErrorForJnlOpt error : errorList) {
            SJmoJnlGroupIndex jnlIndex = new SJmoJnlGroupIndex();
            jnlIndex.setIJnlGroupId(error.getJnlId());
            int index = Collections.binarySearch(rowDataList, jnlIndex);
            if (0 > index) continue;
            SJmoUniversalReplicatorJnlGrp urJnlGrp = rowDataList.get(index);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(urJnlGrp, error);
            errColumnList.add(errColumn);
        }
        SJctrCreateJournalsSelectedTableModelErrorDetail errTable = new SJctrCreateJournalsSelectedTableModelErrorDetail(errColumnList);
        errTable.setBasicDataMap(confirmData.getNeedDataMap());
        errTable.setBasicDataList(confirmData.getUrJnlGrp());
        errTable.initGuidance(this.getComUtility());
        this.addDataObjectModel("COM_TABLE", errTable);
        errTable.makeDataModel();
    }
}

