/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.deletejournals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.replication.remote.deletejournals.SJctrDeleteJournalsSubWizard;

public class SJctrItemSelectListenerDeleteJournals
implements SJctrItemSelectListener {
    @Override
    public void selectChanged(SJctrItemSelectEvent<?> event) {
        if (event.isSelect()) {
            SJctrDataController dc = event.getSource().getDataController();
            SJctrUserController uc = dc.getOwner();
            SJctrTableDataModel table = (SJctrTableDataModel)dc.getDataObjectModel("COM_TABLE");
            if (table == null) {
                uc.getLogUty().putlog("selectChanged", "SJctrTableDataModel is null.");
                SJctrError err = new SJctrError(210, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            List<Object> selectedJournalsList = table.getSelectedRowData();
            if (selectedJournalsList == null || selectedJournalsList.size() == 0) {
                uc.getLogUty().putlog("selectChanged", "Selected Journal table data is invalid.");
                SJctrError err = new SJctrError(210, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            int jnlType = SJctrRemoteReplicationUtility.checkJournalType(selectedJournalsList);
            if (jnlType == -1) {
                dc.getLogUty().putlog("checkConstructData", "Journal type is mixed.");
                SJctrError err = new SJctrError(210, 22, 206012);
                SJcException exp = err.createException();
                throw exp;
            }
            boolean st = SJctrRemoteReplicationUtility.checkDeleteJournalStatus(selectedJournalsList);
            if (!st) {
                uc.getLogUty().putlog("selectChanged", "Journal Status is invalid.");
                SJctrError err = new SJctrError(210, 22, 206018);
                SJcException exp = err.createException();
                throw exp;
            }
            ArrayList<Object> param = new ArrayList<Object>();
            HashMap<String, List<Object>> paramMap = new HashMap<String, List<Object>>();
            Collections.sort(selectedJournalsList);
            paramMap.put("KEY_SELECTED_JOURNAL", selectedJournalsList);
            param.add(SJctrDeleteJournalsSubWizard.class);
            param.add(paramMap);
            event.getSource().fireMessageEvent(SJctrDataController.NOTIFY_STATE.MAKE_WIZARD, param);
        }
    }
}

