/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.deleteurpairs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.replication.remote.deleteurpairs.SJctrDeleteURPairsAC;
import sanproject.sn2.controller.wizard.replication.remote.deleteurpairs.SJctrDeleteURPairsConfirmDC;
import sanproject.sn2.controller.wizard.replication.remote.deleteurpairs.SJctrDeleteURPairsConfirmData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorPairVolInfoMgr;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorPairVolInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorPairVolInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrDeleteURPairsSubWizard
extends SJctrSubWizard {
    public static final String TITLE = "DELETE_PAIR";
    private static final Class<?> CONFIRM_DC = SJctrDeleteURPairsConfirmDC.class;

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        try {
            SJctrUserController uc = wizard.getOwner();
            SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
            SJctrDeleteURPairsAC applyCntl = new SJctrDeleteURPairsAC();
            SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(SJctrWizardWindowDC.class);
            SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
            List<SJmoUniversalReplicatorPairVolInfo> selectedPairList = dc.getProxy().getCache("KEY_SELECTED_REMOTE_VOL");
            if (null == selectedPairList) {
                dc.getLogUty().putlog("constructConfirmData", "Inherited data list is null.");
                SJctrError err = new SJctrError(210, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            if (0 == selectedPairList.size()) {
                dc.getLogUty().putlog("constructConfirmData", "Size of inherited data list is zero.");
                SJctrError err = new SJctrError(210, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            SJmoUniversalReplicatorPairVolInfoMgr allURPairInfo = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorPairVolInfoMgr(dc);
            SJctrRemoteReplicationUtility.chkCacheUniversalReplicatorDetailData(dc);
            List<SJmoUniversalReplicatorPairVolInfo> pairExist = SJctrRemoteReplicationUtility.checkAndGetExistUrPairVolInfo(selectedPairList, allURPairInfo);
            SJmoRemoteReplicationMRCUInfoMgr mrcuMgr = SJctrRemoteReplicationUtility.getSJmoRemoteReplicationMRCUInfoMgr(dc);
            SJctrResourceGroupUtility rsgUty = SJctrRemoteReplicationUtility.getSJctrResourceGroupUtility(dc);
            SJctrRemoteReplicationUtility.checkPairPortRs(pairExist, mrcuMgr, rsgUty);
            int copytype = SJctrRemoteReplicationUtility.checkCopyTypeForUrPairVol(pairExist);
            if (copytype == -1) {
                dc.getLogUty().putlog("checkConstructData", "Copy type is mixed.");
                SJctrError err = new SJctrError(210, 22, 206008);
                SJcException exp = err.createException();
                throw exp;
            }
            boolean st = SJctrRemoteReplicationUtility.checkDeleteURPairStatus(pairExist);
            if (!st) {
                dc.getLogUty().putlog("checkConstructData", "Contained invaid Pair Status.");
                SJctrError err = new SJctrError(210, 22, 206013);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrDeleteURPairsConfirmData confirmData = new SJctrDeleteURPairsConfirmData();
            ArrayList<SJctrDeleteURPairsConfirmData> confirmDataList = new ArrayList<SJctrDeleteURPairsConfirmData>();
            confirmData.setPairsInfo(pairExist);
            confirmData.setCopyType(copytype);
            confirmData.setNeedData(dc);
            List<SJmoPortLunInfo> portLunList = SJctrReplicationUtility.getSJmoPortLunInfo(dc);
            List<SJmoLdevDetail> ldevDetailList = SJctrReplicationUtility.getSJmoLdevDetail(dc);
            Map<Integer, List<SJmoPortLunDetail>> ldevLUPathMap = SJctrReplicationUtility.createLDEVLUPathMap(portLunList, ldevDetailList);
            confirmData.setLUPathMap(ldevLUPathMap);
            confirmDataList.add(confirmData);
            dc.getProxy().putCache(SJctrDeleteURPairsConfirmData.class, confirmDataList);
            applyCntl.setApplyData(confirmData);
            wizard.addConfirmData(applyCntl, related);
        }
        catch (SJcException exp) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(exp, 107002);
        }
    }

    @Override
    public Class<?>[] getClassList() {
        Class[] Class2 = new Class[]{};
        return Class2;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        SJctrGuidance guidance = new SJctrGuidance("COMMON", TITLE);
        return guidance;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetKind_IF kind = new SJmoGetUniversalReplicatorPairVolInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetClprInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevLuseInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRemoteReplicationMRCUInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRemoteReplicationMRCUInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public Class<?> getConfirmClass() {
        return CONFIRM_DC;
    }
}

