/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.editjournalopts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.replication.remote.editjournalopts.SJctrEditJournalOptsSubWizard;

public class SJctrItemSelectListenerJournalOptions
implements SJctrItemSelectListener {
    @Override
    public void selectChanged(SJctrItemSelectEvent<?> event) {
        if (event.isSelect()) {
            SJctrDataController dc = event.getSource().getDataController();
            SJctrUserController uc = dc.getOwner();
            SJctrTableDataModel selectedTable = (SJctrTableDataModel)dc.getDataObjectModel("COM_TABLE");
            if (selectedTable == null) {
                uc.getLogUty().putlog("selectChanged", "SJctrTableDataModel is null.");
                SJctrError err = new SJctrError(210, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            List<Object> selectedList = selectedTable.getSelectedRowData();
            if (selectedList == null || selectedList.size() == 0) {
                uc.getLogUty().putlog("selectChanged", "Selected Journal table data is invalid.");
                SJctrError err = new SJctrError(210, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            int jnlType = SJctrRemoteReplicationUtility.checkJournalType(selectedList);
            if (jnlType == -1) {
                dc.getLogUty().putlog("selectChanged", "Journal type is mixed.");
                SJctrError err = new SJctrError(210, 22, 206012);
                SJcException exp = err.createException();
                throw exp;
            }
            HashMap<String, List<Object>> selectedMap = new HashMap<String, List<Object>>();
            selectedMap.put("KEY_SELECTED_JOURNAL", selectedList);
            ArrayList<Object> param = new ArrayList<Object>();
            param.add(SJctrEditJournalOptsSubWizard.class);
            param.add(selectedMap);
            event.getSource().fireMessageEvent(SJctrDataController.NOTIFY_STATE.MAKE_WIZARD, param);
        }
    }
}

