/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.initializeexctgs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.replication.com.SJctrUniversalReplicatorEXCTGJnlGrpInfo;
import sanproject.sn2.controller.wizard.replication.remote.initializeexctgs.SJctrInitializeExctgsAC;
import sanproject.sn2.controller.wizard.replication.remote.initializeexctgs.SJctrInitializeExctgsConfirmDC;
import sanproject.sn2.controller.wizard.replication.remote.initializeexctgs.SJctrInitializeExctgsConfirmData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorEXCTGMgr;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorEXCTG;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorEXCTGJnlGrp;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrp;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorEXCTGMgr;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;

public class SJctrInitializeExctgsSubWizard
extends SJctrSubWizard {
    public static final String TITLE = "INITIALIZE_EXCTGS";
    private static final Class<?> CONFIRM_DC = SJctrInitializeExctgsConfirmDC.class;

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        try {
            SJctrUserController uc = wizard.getOwner();
            SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
            SJctrInitializeExctgsAC applyCntl = new SJctrInitializeExctgsAC();
            SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(SJctrWizardWindowDC.class);
            SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
            List<SJmoUniversalReplicatorEXCTG> selectedExctgList = dc.getProxy().getCache("KEY_SELECTED_EXCTG");
            if (null == selectedExctgList) {
                dc.getLogUty().putlog("constructConfirmData", "Inherited data list is null.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107002);
            }
            if (0 == selectedExctgList.size()) {
                dc.getLogUty().putlog("constructConfirmData", "Size of inherited data list is zero.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107002);
            }
            SJmoUniversalReplicatorEXCTGMgr allExctgInfo = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorEXCTGMgr(dc);
            List<SJmoUniversalReplicatorEXCTG> exctgList = SJctrRemoteReplicationUtility.checkAndGetExistExctgInfo(selectedExctgList, allExctgInfo);
            List<SJctrUniversalReplicatorEXCTGJnlGrpInfo> rows = this.checkAndGetInitializeExctgs(dc, exctgList);
            SJctrInitializeExctgsConfirmData confirmData = new SJctrInitializeExctgsConfirmData();
            ArrayList<SJctrInitializeExctgsConfirmData> confirmDataList = new ArrayList<SJctrInitializeExctgsConfirmData>(1);
            confirmData.setExctgJnlInfo(rows);
            confirmData.setNeedData(dc);
            confirmDataList.add(confirmData);
            dc.getProxy().putCache(SJctrInitializeExctgsConfirmData.class, confirmDataList);
            applyCntl.setApplyData(confirmData);
            wizard.addConfirmData(applyCntl, related);
        }
        catch (SJcException exp) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(exp, 107002);
        }
    }

    @Override
    public Class<?>[] getClassList() {
        Class[] Class2 = new Class[]{};
        return Class2;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        SJctrGuidance guidance = new SJctrGuidance("COMMON", TITLE);
        return guidance;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetKind_IF kind = new SJmoGetUniversalReplicatorEXCTGMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSubsystemInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetUniversalReplicatorJnlGrpMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public Class<?> getConfirmClass() {
        return CONFIRM_DC;
    }

    private List<SJctrUniversalReplicatorEXCTGJnlGrpInfo> checkAndGetInitializeExctgs(SJctrDataController dc, List<SJmoUniversalReplicatorEXCTG> exctgList) {
        ArrayList<SJctrUniversalReplicatorEXCTGJnlGrpInfo> rowData = new ArrayList<SJctrUniversalReplicatorEXCTGJnlGrpInfo>();
        boolean exctgused = SJctrRemoteReplicationUtility.isExctgUsed(exctgList);
        if (!exctgused) {
            dc.getLogUty().putlog("chkInitializeExctgs", "Selected EXCTG is not used.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206128);
        }
        SJctrRemoteReplicationUtility remoteUty = this.getComUtility().getRemoteReplicationUtility();
        SJmoSubsystemInfo subsysInfo = SJctrRemoteReplicationUtility.getSJmoSubsystemInfo(dc);
        int modelIdLocal = remoteUty.getModelIDfromSubsysInfo(subsysInfo);
        String snLocal = subsysInfo.getDKCSNString();
        List<SJmoRSGgetAllRsgs> allRsgInfoList = SJctrReplicationUtility.getSJmoRSGgetAllRsgs(dc);
        SJmoRSGgetAllRsgs allRsgInfo = SJctrReplicationUtility.checkSJmoRSGgetAllRsgsInfo(dc, allRsgInfoList);
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(dc.getOwner(), allRsgInfo);
        SJmoUniversalReplicatorJnlGrpMgr allJnlInfo = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorJnlGrpMgr(dc);
        for (SJmoUniversalReplicatorEXCTG exctg : exctgList) {
            ArrayList<SJmoUniversalReplicatorEXCTGJnlGrp> exctgJnlList = exctg.getJnlGrpList();
            for (SJmoUniversalReplicatorEXCTGJnlGrp exctgJnl : exctgJnlList) {
                if (remoteUty.isUsedStorageSystemFromExctgJnl(modelIdLocal, snLocal, exctgJnl)) {
                    int jnlid = exctgJnl.getJnlGrpId();
                    SJmoUniversalReplicatorJnlGrp jnlinfo = allJnlInfo.getJnlGroup(jnlid);
                    if (null == jnlinfo) {
                        dc.getLogUty().putlog("chkInitializeExctgs", "Selected EXCTG journal is null.");
                        throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206510);
                    }
                    if (!SJctrRemoteReplicationUtility.hasTopJnlVolRs(jnlinfo, rsgUtil)) {
                        dc.getLogUty().putlog("chkInitializeExctgs", "Selected EXCTG journal is no authority.");
                        throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206129);
                    }
                }
                SJctrUniversalReplicatorEXCTGJnlGrpInfo row = new SJctrUniversalReplicatorEXCTGJnlGrpInfo(exctg.getIExCtgId(), exctgJnl);
                rowData.add(row);
            }
        }
        Collections.sort(rowData);
        return rowData;
    }
}

