/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.removeremotepaths;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrObjectSetListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcMessageEventListener;
import sanproject.sn2.controller.wizard.replication.com.SJctrRemoteConnectionUtility;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.com.SJctrRemoteReplicationTargetPathInfo;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.model.SJctrLocalStorageSysDataModel;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.model.SJctrRemotePathDataModel;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.model.SJctrRemoteStorageSysDataModel;
import sanproject.sn2.controller.wizard.replication.remote.removeremotepaths.SJctrRemoveRemotePathConfirmData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetPathInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetPathInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUPathInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;

public class SJctrRemoveRemotePathDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17831313;
    private static final String DISP_TITLE = "REMOVE_REMOTE_PATHS";
    private static final String KEY_SELECT_INDEX_MODEL = "COM_SELECT_INDEX_MODEL";
    private static final String KEY_SELECT_INDEX = "COM_SELECT_INDEX";
    private static final String KEY_SELECTED_RCU_INFO = "COM_SELECTED_RCU_INFO";

    public SJctrRemoveRemotePathDC() {
        super(17831313);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    private void initDataModel() {
        SJctrLocalStorageSysDataModel localSysModel = new SJctrLocalStorageSysDataModel();
        this.addDataObjectModel("COM_LOCAL_STORAGE_SYS_PANEL", localSysModel);
        SJctrRemoteStorageSysDataModel remoteSysModel = new SJctrRemoteStorageSysDataModel();
        this.addDataObjectModel("COM_REMOTE_STORAGE_SYS_PANEL", remoteSysModel);
        SJctrRemotePathDataModel remotePathModel = new SJctrRemotePathDataModel();
        this.addDataObjectModel("COM_REMOTE_PATHS_PANEL", remotePathModel);
        SJctrSimpleDataModel selectIndexModel = new SJctrSimpleDataModel();
        selectIndexModel.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                SJctrDataObject data;
                Integer index;
                if (setObject instanceof SJctrDataObject && (index = (Integer)(data = (SJctrDataObject)setObject).getData(SJctrRemoveRemotePathDC.KEY_SELECT_INDEX)) != null) {
                    SJctrSimpleDataModel selectIndexModel = (SJctrSimpleDataModel)SJctrRemoveRemotePathDC.this.getDataObjectModel(SJctrRemoveRemotePathDC.KEY_SELECT_INDEX_MODEL);
                    ((SJctrDataObject)selectIndexModel.getManageData()).setData(SJctrRemoveRemotePathDC.KEY_SELECT_INDEX, index);
                    SJctrRemoveRemotePathDC.this.fireMessageEvent(REMOVE_REMOTE_PATH_MSG.CHECK_REMOVE_PATH);
                }
            }
        });
        this.addDataObjectModel(KEY_SELECT_INDEX_MODEL, selectIndexModel);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void initListener() {
        this.addMessageEventListener(REMOVE_REMOTE_PATH_MSG.CHECK_REMOVE_PATH, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrRemoveRemotePathDC.this.chgStateReomoveCheckboxAction(event, dstModel);
                SJctrRemoteReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addMessageEventListener(SJctrRemotePathDataModel.REMOTE_PATH_MSG.CHANGED_RADIO_SELECT_TYPE, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrRemoveRemotePathDC.this.chgSelectTypeAction(event, dstModel);
            }
        });
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetRemoteReplicationMRCUInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSubsystemInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiTargetPathInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> viewDataList = this.getProxy().getCache("KEY_REMOTE_SELECTED_CONNECTION");
        if (null == viewDataList) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == viewDataList.size()) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (null == viewDataList.get(0)) {
            this.logUty.putlog("checkStartData", "Information of selected RCU is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJmoRemoteReplicationMRCUInfoMgr mrcuInfoMgr = SJctrRemoteReplicationUtility.getSJmoRemoteReplicationMRCUInfoMgr(this);
            SJmoSubsystemInfo subsysInfo = SJctrRemoteReplicationUtility.getSJmoSubsystemInfo(this);
            List<SJmoPortDetail> portDtlList = SJctrReplicationUtility.getSJmoPortDetail(this);
            List<SJmoRSGgetAllRsgs> allRsgInfoList = SJctrReplicationUtility.getSJmoRSGgetAllRsgs(this);
            SJmoRSGgetAllRsgs allRsgInfo = SJctrReplicationUtility.checkSJmoRSGgetAllRsgsInfo(this, allRsgInfoList);
            List<SJmoPortIscsiTargetPathInfo> portIscsiPathInfoList = SJctrIscsiUtility.getSJmoPortIscsiTargetPathInfoList(this);
            List<SJmoRemoteReplicationRCUInfo> viewDataList = this.getProxy().getCache("KEY_REMOTE_SELECTED_CONNECTION");
            List<SJmoRemoteReplicationRCUInfo> selectedRCUInfoList = SJctrRemoteReplicationUtility.checkAndGetExistConnectionInfoSelectableClone(viewDataList, mrcuInfoMgr, false);
            SJmoRemoteReplicationRCUInfo selectedRCUInfo = selectedRCUInfoList.get(0);
            this.putCache(KEY_SELECTED_RCU_INFO, selectedRCUInfoList);
            SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), allRsgInfo);
            if (!SJctrRemoteReplicationUtility.hasRcuPortRs(selectedRCUInfo, rsgUtil)) {
                this.logUty.putlog("checkConstructData", "Can't remove path because local port don't have resource authorization exist.");
                SJctrError err = new SJctrError(210, 22, 206041);
                SJcException exp = err.createException();
                throw exp;
            }
            if (selectedRCUInfo.getRCUOption().getINumofMimPath() == selectedRCUInfo.getPathInfoList().size()) {
                this.logUty.putlog("checkConstructData", "Can't remove path because minimum path count equal set path count.");
                SJctrError err = new SJctrError(210, 22, 206040);
                SJcException exp = err.createException();
                throw exp;
            }
            if (selectedRCUInfo.getRCUOption().getINumofMimPath() > selectedRCUInfo.getPathInfoList().size()) {
                this.logUty.putlog("checkConstructData", "Can't remove path because set path count under the minimum path count.");
                SJctrError err = new SJctrError(210, 22, 206146);
                SJcException exp = err.createException();
                throw exp;
            }
            Map<String, List> rcuInfoMap = SJctrRemoteConnectionUtility.getPortTypeRCUPathInfoMap(selectedRCUInfo, this);
            this.putCachePortTypeRCUPathInfo(rcuInfoMap);
            SJmoRemoteReplicationRCUInfo fibreRCUInfo = (SJmoRemoteReplicationRCUInfo)rcuInfoMap.get("COM_FIBRE_RCU_PATH_INFO_LIST").get(0);
            ArrayList<SJmoRemoteReplicationRCUPathInfo> fibreRCUPathInfoList = fibreRCUInfo.getPathInfoList();
            SJmoRemoteReplicationRCUInfo iscsiRCUInfo = (SJmoRemoteReplicationRCUInfo)rcuInfoMap.get("COM_ISCSI_RCU_PATH_INFO_LIST").get(0);
            ArrayList<SJmoRemoteReplicationRCUPathInfo> iscsiRCUPathInfoList = iscsiRCUInfo.getPathInfoList();
            SJctrRemoteConnectionUtility.setEnableStatusSelectTypeRadio(fibreRCUPathInfoList, iscsiRCUPathInfoList, selectedRCUInfo.getIControllerID(), this);
            SJctrRemoteConnectionUtility.setSelectStatusSelectTypeRadio(fibreRCUPathInfoList, selectedRCUInfo.getIControllerID(), this);
            int totalPaths = fibreRCUPathInfoList.size() + iscsiRCUPathInfoList.size();
            SJctrRemoteConnectionUtility.updateTotalNumberOfPaths(totalPaths, this);
            Map<String, SJctrRemoteReplicationTargetPathInfo> targetPathInfoMap = SJctrRemoteConnectionUtility.createRemoteReplicationTargetPathInfoMap(iscsiRCUInfo, portIscsiPathInfoList, subsysInfo.getDKCSNString());
            this.putCacheTargetPathInfoMap(targetPathInfoMap);
            selectedRCUInfo = SJctrRemoteConnectionUtility.getCacheSelectTypeRCUPathInfoList(this).get(0);
            SJctrRemoteConnectionUtility.setRemoteConnLocalStorageSysLabelPanel(subsysInfo, this, selectedRCUInfo, this.getComUtility());
            SJctrRemoteConnectionUtility.setRemoteConnRemoteStorageSysLabelPanel(this, selectedRCUInfo, this.getComUtility());
            SJctrRemoteConnectionUtility.setRemoteConnRemotePathLabelPanel(this, selectedRCUInfo, portDtlList);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        try {
            List<SJmoRemoteReplicationRCUInfo> moRcuInfoList = SJctrRemoteConnectionUtility.getCacheSelectTypeRCUPathInfoList(this);
            SJmoRemoteReplicationRCUInfo rcuInfo = null;
            try {
                rcuInfo = (SJmoRemoteReplicationRCUInfo)moRcuInfoList.get(0).clone();
            }
            catch (CloneNotSupportedException e) {
                this.getLogUty().putlog("checkEndData", "Information of SJmoRemoteReplicationRCUInfo cannot clone.");
                SJctrError err = new SJctrError(210, 22, 107003);
                SJcException exp = err.createException();
                throw exp;
            }
            ArrayList<Integer> portIDIdxList = this.getCheckOnPortIDIndexList();
            ArrayList<SJmoRemoteReplicationRCUPathInfo> pathInfoList = new ArrayList<SJmoRemoteReplicationRCUPathInfo>();
            SJctrRemotePathDataModel remotePathModel = SJctrRemoteConnectionUtility.getRemotePathModel(this);
            int selectType = remotePathModel.getSelectType();
            Map targetPathInfoMap = (Map)this.getCache("COM_ISCSI_TARGET_PATH_INFO_LIST").get(0);
            ArrayList<SJctrRemoteReplicationTargetPathInfo> targetPathInfoList = new ArrayList<SJctrRemoteReplicationTargetPathInfo>();
            for (int idx : portIDIdxList) {
                SJmoRemoteReplicationRCUPathInfo pathInfo = new SJmoRemoteReplicationRCUPathInfo();
                pathInfo = rcuInfo.getPathInfoList().get(idx);
                pathInfoList.add(pathInfo);
                SJctrRemoteReplicationTargetPathInfo replicaPathInfo = SJctrRemoteConnectionUtility.createSJctrRemoteReplicationTargetPathInfo(pathInfo, selectType, targetPathInfoMap);
                targetPathInfoList.add(replicaPathInfo);
            }
            for (int delIdx = portIDIdxList.size() - 1; delIdx >= 0; --delIdx) {
                rcuInfo.getPathInfoList().remove(portIDIdxList.get(delIdx));
            }
            SJmoRemoteReplicationRCUInfo otherSelectRCUPathInfo = null;
            otherSelectRCUPathInfo = selectType == 0 ? SJctrRemoteConnectionUtility.getCacheSelectTypeRCUPathInfoList(1, this).get(0) : SJctrRemoteConnectionUtility.getCacheSelectTypeRCUPathInfoList(0, this).get(0);
            rcuInfo.getPathInfoList().addAll(otherSelectRCUPathInfo.getPathInfoList());
            ArrayList<SJmoRemoteReplicationRCUInfo> rcuInfoList = new ArrayList<SJmoRemoteReplicationRCUInfo>();
            rcuInfoList.add(rcuInfo);
            SJctrRemoveRemotePathConfirmData confirmData = new SJctrRemoveRemotePathConfirmData();
            confirmData.setRCUInfo(rcuInfoList);
            confirmData.setRmvRCUPathInfo(pathInfoList);
            confirmData.setRemotePathInfoList(targetPathInfoList);
            ArrayList<SJctrRemoveRemotePathConfirmData> confirmDataList = new ArrayList<SJctrRemoveRemotePathConfirmData>();
            confirmDataList.add(confirmData);
            confirmData.setNeedData(this);
            this.putCache(SJctrRemoveRemotePathConfirmData.class, confirmDataList);
            SJctrRemoteReplicationUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107003);
        }
        return true;
    }

    protected void chgStateReomoveCheckboxAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            SJctrRemotePathDataModel remotePathModel = SJctrRemoteConnectionUtility.getRemotePathModel(this);
            int pathCount = (Integer)((SJctrDataObject)remotePathModel.getManageData()).getData("COM_DISP_PATH_COUNT");
            int checkOnCount = 0;
            ArrayList<SJctrCheckBoxDataModel> checkOffs = new ArrayList<SJctrCheckBoxDataModel>();
            for (int pid = 0; pid < pathCount; ++pid) {
                SJctrCheckBoxDataModel chkBox = SJctrRemoteConnectionUtility.getRemotePathRemoveCheckboxModel(this, pid);
                if (!chkBox.isSelect()) {
                    checkOffs.add(chkBox);
                    continue;
                }
                ++checkOnCount;
            }
            int checkOffCount = checkOffs.size();
            int minPath = Integer.parseInt((String)((SJctrDataObject)remotePathModel.getManageData()).getData("COM_MIN_NUM_OF_PATHS_STR"));
            int totalPaths = this.getCacheRCUPathInfoSize() - checkOnCount;
            for (int idx = 0; idx < checkOffCount; ++idx) {
                SJctrCheckBoxDataModel rmCheckbox = (SJctrCheckBoxDataModel)checkOffs.get(idx);
                if (totalPaths <= minPath) {
                    rmCheckbox.setEnable(false);
                    continue;
                }
                rmCheckbox.setEnable(true);
            }
            SJctrRemoteConnectionUtility.updateTotalNumberOfPaths(totalPaths, this);
            this.updateFooter();
            this.setDirtyAll();
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107004);
        }
    }

    private ArrayList<Integer> getCheckOnPortIDIndexList() {
        ArrayList<Integer> portIDIdx = new ArrayList<Integer>();
        SJctrRemotePathDataModel remotePathModel = SJctrRemoteConnectionUtility.getRemotePathModel(this);
        int pathCount = (Integer)((SJctrDataObject)remotePathModel.getManageData()).getData("COM_DISP_PATH_COUNT");
        for (int pid = 0; pid < pathCount; ++pid) {
            SJctrCheckBoxDataModel chkBox = SJctrRemoteConnectionUtility.getRemotePathRemoveCheckboxModel(this, pid);
            if (!chkBox.isSelect()) continue;
            portIDIdx.add(pid);
        }
        return portIDIdx;
    }

    private void chgSelectTypeAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            SJmoRemoteReplicationRCUInfo rcuInfo = SJctrRemoteConnectionUtility.getCacheSelectTypeRCUPathInfoList(this).get(0);
            List<SJmoPortDetail> portDetailList = SJctrReplicationUtility.getSJmoPortDetail(this);
            SJctrRemoteConnectionUtility.setPortIDPanel(this, rcuInfo, portDetailList);
            for (int pid = 0; pid < 8; ++pid) {
                SJctrCheckBoxDataModel removeCheckBoxModel = SJctrRemoteConnectionUtility.getRemotePathRemoveCheckboxModel(this, pid);
                removeCheckBoxModel.setSelect(false);
                removeCheckBoxModel.setEnable(true);
            }
            int totalNumPaths = this.getCacheRCUPathInfoSize();
            SJctrRemoteConnectionUtility.updateTotalNumberOfPaths(totalNumPaths, this);
            this.updateFooter();
            this.setDirtyAll();
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107004);
        }
    }

    private void putCachePortTypeRCUPathInfo(Map<String, List> map) {
        List fibreRCUInfoList = map.get("COM_FIBRE_RCU_PATH_INFO_LIST");
        this.getProxy().putCache("COM_FIBRE_RCU_PATH_INFO_LIST", fibreRCUInfoList);
        List iscsiRCUInfoList = map.get("COM_ISCSI_RCU_PATH_INFO_LIST");
        this.getProxy().putCache("COM_ISCSI_RCU_PATH_INFO_LIST", iscsiRCUInfoList);
    }

    private void putCacheTargetPathInfoMap(Map<String, SJctrRemoteReplicationTargetPathInfo> map) {
        ArrayList<Map<String, SJctrRemoteReplicationTargetPathInfo>> mapList = new ArrayList<Map<String, SJctrRemoteReplicationTargetPathInfo>>(1);
        mapList.add(map);
        this.getProxy().putCache("COM_ISCSI_TARGET_PATH_INFO_LIST", mapList);
    }

    private int getCacheRCUPathInfoSize() {
        SJmoRemoteReplicationRCUInfo fibreRCUInfo = (SJmoRemoteReplicationRCUInfo)this.getCache("COM_FIBRE_RCU_PATH_INFO_LIST").get(0);
        SJmoRemoteReplicationRCUInfo iscsiRCUInfo = (SJmoRemoteReplicationRCUInfo)this.getCache("COM_ISCSI_RCU_PATH_INFO_LIST").get(0);
        return fibreRCUInfo.getPathInfoList().size() + iscsiRCUInfo.getPathInfoList().size();
    }

    private static enum REMOVE_REMOTE_PATH_MSG implements SJctrNotifyState
    {
        CHECK_REMOVE_PATH;

    }
}

