/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.resyncurpairs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcPairTableDataModelBase;
import sanproject.sn2.controller.wizard.replication.remote.resyncurpairs.SJctrResyncURPairsConfirmData;
import sanproject.sn2.controller.wizard.replication.remote.resyncurpairs.SJctrResyncURPairsDataModel;
import sanproject.sn2.controller.wizard.replication.remote.resyncurpairs.SJctrResyncURPairsTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorPairVolInfoMgr;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorPairVolInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorPairVolInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrResyncURPairsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 18486321;
    private static final String DISP_TITLE = "RESYNC_PAIRS";
    private static final String KEY_TABLE = "COM_RESYNC_UR_PAIRS_TABLE";
    private static final String KEY_RESYNC_UR_PAIR_MODEL = "COM_RESYNC_UR_PAIR_MODEL";
    protected static final String KEY_COPY_PRIORITY = "COM_COPY_PRIORITY";
    private static final String KEY_BTN_CHANGE = "COM_BTN_CHANGE";

    public SJctrResyncURPairsDC() {
        super(18486321);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetUniversalReplicatorPairVolInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetClprInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevLuseInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TABLE, new SJctrResyncURPairsTableModel());
        this.addDataObjectModel(KEY_RESYNC_UR_PAIR_MODEL, new SJctrResyncURPairsDataModel());
        SJctrTextBoxDataModel copyPrioritySpin = new SJctrTextBoxDataModel();
        copyPrioritySpin.setValue(String.valueOf(32));
        this.addDataObjectModel(KEY_COPY_PRIORITY, copyPrioritySpin);
        SJctrButtonDataModel changeBtn = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_BTN_CHANGE, changeBtn);
        changeBtn.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrRemoteReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
                SJctrResyncURPairsDC.this.changePriority();
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> viewDataList = this.getProxy().getCache("KEY_SELECTED_REMOTE_VOL");
        if (null == viewDataList) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == viewDataList.size()) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJmoUniversalReplicatorPairVolInfoMgr allURPairInfo = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorPairVolInfoMgr(this);
            List<SJmoUniversalReplicatorPairVolInfo> viewData = this.getProxy().getCache("KEY_SELECTED_REMOTE_VOL");
            SJctrRemoteReplicationUtility.chkCacheUniversalReplicatorDetailData(this);
            List<SJmoUniversalReplicatorPairVolInfo> pairExist = SJctrRemoteReplicationUtility.checkAndGetExistUrPairVolInfo(viewData, allURPairInfo);
            int copytype = SJctrRemoteReplicationUtility.checkCopyTypeForUrPairVol(pairExist);
            if (copytype == -1) {
                this.logUty.putlog("checkConstructData", "Mixed copytype.");
                SJctrError err = new SJctrError(210, 22, 206008);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrUserController uc = this.getOwner();
            SJctrRemoteReplicationUtility.checkPpLicenseForURList(uc, copytype);
            boolean attribute = SJctrRemoteReplicationUtility.checkURPairPositionPrimary(pairExist);
            if (!attribute) {
                this.logUty.putlog("checkConstructData", "Contained Secondary volume.");
                SJctrError err = new SJctrError(210, 22, 206004);
                SJcException exp = err.createException();
                throw exp;
            }
            boolean isPvolDuplicate = SJctrRemoteReplicationUtility.isLocalVolDuplicateForUrPair(pairExist);
            if (isPvolDuplicate) {
                this.logUty.putlog("checkConstructData", "Selected Local Volume of Multi Mirror Used.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206287);
            }
            boolean st = SJctrRemoteReplicationUtility.checkResyncURPairStatus(pairExist);
            if (!st) {
                this.logUty.putlog("checkConstructData", "Contained invaid status.");
                SJctrError err = new SJctrError(210, 22, 206013);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrResyncURPairsDataModel dataModel = (SJctrResyncURPairsDataModel)this.getDataObjectModel(KEY_RESYNC_UR_PAIR_MODEL);
            dataModel.setCopytype(copytype);
            dataModel.setPairList(pairExist);
            SJctrResyncURPairsTableModel table = (SJctrResyncURPairsTableModel)this.getDataObjectModel(KEY_TABLE);
            table.setBasicDataList(pairExist);
            String copyTypeStr = "?";
            if (copytype == 1) {
                copyTypeStr = "COM_COPY_TYPE_OPEN";
            } else if (copytype == 0) {
                copyTypeStr = "COM_COPY_TYPE_MF";
            }
            this.getManageData().setData("COM_COPY_TYPE", copyTypeStr);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        try {
            SJctrResyncURPairsConfirmData confirmData = new SJctrResyncURPairsConfirmData();
            SJctrRcPairTableDataModelBase table = (SJctrRcPairTableDataModelBase)this.getDataObjectModel(KEY_TABLE);
            List<Object> selectedList = table.getAllRowData();
            SJmoUniversalReplicatorPairVolInfo pair = (SJmoUniversalReplicatorPairVolInfo)selectedList.get(0);
            int copytype = SJctrRemoteReplicationUtility.checkCopyTypeForUrPairVolInfo(pair);
            confirmData.setCopyType(copytype);
            SJctrResyncURPairsDataModel dataModel = (SJctrResyncURPairsDataModel)this.getDataObjectModel(KEY_RESYNC_UR_PAIR_MODEL);
            SJctrComboBoxDataModel errorLevel = (SJctrComboBoxDataModel)dataModel.getDataModel("COM_ERROR_LEVEL");
            int errorLv = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(errorLevel);
            for (SJmoUniversalReplicatorPairVolInfo sJmoUniversalReplicatorPairVolInfo : selectedList) {
                sJmoUniversalReplicatorPairVolInfo.setErrLv(errorLv);
            }
            confirmData.setPairsInfo(selectedList);
            List<SJmoPortLunInfo> portLunList = SJctrReplicationUtility.getSJmoPortLunInfo(this);
            List<SJmoLdevDetail> list = SJctrReplicationUtility.getSJmoLdevDetail(this);
            Map<Integer, List<SJmoPortLunDetail>> ldevLUPathMap = SJctrReplicationUtility.createLDEVLUPathMap(portLunList, list);
            confirmData.setLUPathMap(ldevLUPathMap);
            confirmData.setNeedData(this);
            ArrayList<SJctrResyncURPairsConfirmData> confirmDataList = new ArrayList<SJctrResyncURPairsConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrResyncURPairsConfirmData.class, confirmDataList);
            SJctrRemoteReplicationUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107003);
        }
        return true;
    }

    private void changePriority() {
        SJctrResyncURPairsTableModel tableData = (SJctrResyncURPairsTableModel)this.getDataObjectModel(KEY_TABLE);
        SJctrTextBoxDataModel prioritySpin = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_COPY_PRIORITY);
        int priority = SJctrRemoteReplicationUtility.getValueTextBoxNum(prioritySpin);
        List<Object> selectRowDataList = tableData.getSelectedRowData();
        for (Object selectRowData : selectRowDataList) {
            ((SJmoUniversalReplicatorPairVolInfo)selectRowData).setCopyPriority(priority);
        }
        tableData.doRefresh();
        tableData.addRowSelectionList(selectRowDataList);
        this.updateFooter();
    }
}

