/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.viewpairprops;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import sanproject.serverux.dataimpl.HUR1DataVol;
import sanproject.serverux.dataimpl.HURget1PairDetail;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.wizard.replication.com.SJctrSelectedRmPathTableDataModelBase;
import sanproject.sn2.controller.wizard.replication.remote.viewpairprops.SJctrGetHurPairDetail;
import sanproject.sn2.controller.wizard.replication.remote.viewpairprops.SJctrRemotePairPropNumOfLunPathTableDataModel;
import sanproject.sn2.controller.wizard.replication.remote.viewpairprops.SJctrRemotePairPropPathGroupTableDataModel;
import sanproject.sn2.controller.wizard.replication.remote.viewpairprops.com.SJctrViewRemotePairPropertiesDataMacro;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUInfo;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrp;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorPairVolInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.data.system.SJmoClprIndex;
import sanproject.sn2.model.data.system.SJmoClprInfo;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevLuseInfo;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;

public class SJctrUrViewPairPropertiesPropertiesDataModel
extends SJctrSimpleDataModel {
    protected static final String IMAGE_PATH_HI = "image/remote/";
    protected static final String IMAGE_PATH_HP = "image/remote/hp/";
    protected static final String BG_FILE_UR_SINGLE = "gp_ur_bkg1.png";
    protected static final String BG_FILE_URMF_SINGLE = "gp_ur_bkg1_mf.png";
    protected static final String BG_FILE_UR_MULTI = "gp_ur_bkg2.png";
    protected static final String BG_FILE_URMF_MULTI = "gp_ur_bkg2_mf.png";
    protected static final String GP_ERROR_L = "image/remote/gp_error_l.png";
    protected static final String PAIR1_COPY_DIRECTION_TO_REMOTE = "image/remote/gp_ur_pair1_to_remote.png";
    protected static final String PAIR1_COPY_DIRECTION_TO_LOCAL = "image/remote/gp_ur_pair1_to_local.png";
    protected static final String PAIR1_COPY_DIRECTION_HOLD = "image/remote/gp_ur_pair1_hold.png";
    protected static final String PAIR2_COPY_DIRECTION_TO_REMOTE = "image/remote/gp_ur_pair2_to_remote.png";
    protected static final String PAIR2_COPY_DIRECTION_TO_LOCAL = "image/remote/gp_ur_pair2_to_local.png";
    protected static final String PAIR2_COPY_DIRECTION_HOLD = "image/remote/gp_ur_pair2_hold.png";
    private static final int DIGIT_HG = 2;
    private static final int DIGIT_LUN = 4;
    private static final int DIGIT_JNL = 3;
    private String imageDirectory = "image/remote/";
    private List<HURget1PairDetail> rmiPairList = null;
    private List<SJmoLdevDetail> ldevDetailList = null;
    private List<SJmoLdevNicknameInfo> ldevNameList = null;
    private List<SJmoLdevLuseInfo> luseList = null;
    private List<SJmoClprInfo> clprList = null;
    private SJmoSubsystemInfo subsystemInfo = null;
    private SJmoRemoteReplicationMRCUInfoMgr mrcuMgr = null;
    private SJmoUniversalReplicatorJnlGrpMgr urJnlGrpMgr = null;

    public SJctrUrViewPairPropertiesPropertiesDataModel() {
        this.initDataModel();
    }

    private void initDataModel() {
        this.addDataModel("COM_LOCAL_STORAGE_SYSTEM_INF", new SJctrSimpleDataModel());
        this.addDataModel("COM_REMOTE_STORAGE_SYSTEM1_INF", new SJctrSimpleDataModel());
        this.addDataModel("COM_REMOTE_STORAGE_SYSTEM2_INF", new SJctrSimpleDataModel());
        this.addDataModel("COM_TABLE_NUM_OF_PATHS", new SJctrRemotePairPropNumOfLunPathTableDataModel());
        this.addDataModel("COM_TABLE_PATH_GROUP_PAIR1", new SJctrRemotePairPropPathGroupTableDataModel());
        this.addDataModel("COM_TABLE_PATH_GROUP_PAIR2", new SJctrRemotePairPropPathGroupTableDataModel());
    }

    @Override
    public void makeDataObject() {
        if (SJctrRemoteReplicationUtility.isHP()) {
            this.imageDirectory = IMAGE_PATH_HP;
        }
        this.rmiPairList = this.getDataController().getProxy().getCache(SJctrGetHurPairDetail.class);
        this.ldevDetailList = SJctrReplicationUtility.getSJmoLdevDetail(this.getDataController());
        Collections.sort(this.ldevDetailList);
        this.ldevNameList = SJctrReplicationUtility.getSJmoLdevNicknameInfo(this.getDataController());
        Collections.sort(this.ldevNameList);
        this.luseList = SJctrReplicationUtility.getSJmoLdevLuseInfo(this.getDataController());
        Collections.sort(this.luseList);
        this.clprList = SJctrReplicationUtility.getSJmoClprInfo(this.getDataController());
        Collections.sort(this.clprList);
        this.subsystemInfo = SJctrRemoteReplicationUtility.getSJmoSubsystemInfo(this.getDataController());
        this.mrcuMgr = SJctrRemoteReplicationUtility.getSJmoRemoteReplicationMRCUInfoMgr(this.getDataController());
        this.urJnlGrpMgr = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorJnlGrpMgr(this.getDataController());
    }

    public void makeProperties(SJmoReplicationPairVolInfo localVol, List<SJmoUniversalReplicatorPairVolInfo> remoteVolList, SJctrDataController dc) {
        if (localVol == null) {
            this.logUty.putlog("makeProperties", "Pair Information is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (remoteVolList.size() == 0) {
            this.logUty.putlog("makeProperties", "size of Remote Volume List is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        int pairNum = remoteVolList.size();
        if (1 > pairNum || pairNum > 2) {
            this.logUty.putlog("makeProperties", "Pair Configuration is invalid.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        ((SJctrDataObject)this.getManageData()).setData("COM_PAIR_NUM", pairNum);
        Collections.sort(remoteVolList, new Comparator(){

            public int compare(Object o1, Object o2) {
                int ret = ((SJmoUniversalReplicatorPairVolInfo)o1).getMirrorId() - ((SJmoUniversalReplicatorPairVolInfo)o2).getMirrorId();
                return ret;
            }
        });
        SJmoUniversalReplicatorPairVolInfo remoteVol1 = remoteVolList.get(0);
        this.makePropertiesPair1(remoteVol1, localVol, dc);
        if (pairNum == 1) {
            this.setCopyTypeImageSingle(remoteVol1);
        } else {
            SJmoUniversalReplicatorPairVolInfo remoteVol2 = remoteVolList.get(1);
            this.setCopyTypeImageMulti(remoteVol2);
            this.makePropertiesPair2(remoteVol2, localVol);
        }
    }

    private void setCopyTypeImageSingle(SJmoUniversalReplicatorPairVolInfo pairInfo) {
        String copyTypeImage = this.imageDirectory;
        if (SJctrRemoteReplicationUtility.isOpen(pairInfo)) {
            copyTypeImage = copyTypeImage + BG_FILE_UR_SINGLE;
        } else if (SJctrRemoteReplicationUtility.isMainframe(pairInfo)) {
            copyTypeImage = copyTypeImage + BG_FILE_URMF_SINGLE;
        } else {
            this.logUty.putlog("setCopyTypeImageSingle", "Unknown Copy Type.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        ((SJctrDataObject)this.getManageData()).setData("COM_COPY_TYPE_IMAGE", copyTypeImage);
    }

    private void setCopyTypeImageMulti(SJmoUniversalReplicatorPairVolInfo pairInfo) {
        String copyTypeImage = this.imageDirectory;
        if (SJctrRemoteReplicationUtility.isOpen(pairInfo)) {
            copyTypeImage = copyTypeImage + BG_FILE_UR_MULTI;
        } else if (SJctrRemoteReplicationUtility.isMainframe(pairInfo)) {
            copyTypeImage = copyTypeImage + BG_FILE_URMF_MULTI;
        } else {
            this.logUty.putlog("setCopyTypeImageMulti", "Unknown Copy Type.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        ((SJctrDataObject)this.getManageData()).setData("COM_COPY_TYPE_IMAGE", copyTypeImage);
    }

    private void makePropertiesPair1(SJmoUniversalReplicatorPairVolInfo remoteVol1, SJmoReplicationPairVolInfo localVol, SJctrDataController dc) {
        this.setPair1Info(remoteVol1);
        this.setLocalStorageSystemInfo(localVol, remoteVol1, dc);
        this.makeRemoteStorageSystemInfo("COM_REMOTE_STORAGE_SYSTEM1_INF", remoteVol1);
        if (SJctrRemoteReplicationUtility.isOpen(remoteVol1)) {
            SJctrRemotePairPropNumOfLunPathTableDataModel lunTable = (SJctrRemotePairPropNumOfLunPathTableDataModel)this.getDataModel("COM_TABLE_NUM_OF_PATHS");
            lunTable.updateNumOfPaths(localVol);
        }
        SJctrRemotePairPropPathGroupTableDataModel pair1PathGrpTable = (SJctrRemotePairPropPathGroupTableDataModel)this.getDataModel("COM_TABLE_PATH_GROUP_PAIR1");
        this.setPortAttribute(remoteVol1, "COM_TABLE_PATH_GROUP_PAIR1");
        SJmoRemoteReplicationRCUInfo rcuInfo = SJctrRemoteReplicationUtility.getPairRcuInfoNoThrow(remoteVol1, this.mrcuMgr);
        pair1PathGrpTable.updatePathTable(rcuInfo);
    }

    private void makePropertiesPair2(SJmoUniversalReplicatorPairVolInfo remoteVol2, SJmoReplicationPairVolInfo localVol) {
        this.setPair2Info(remoteVol2);
        this.makeRemoteStorageSystemInfo("COM_REMOTE_STORAGE_SYSTEM2_INF", remoteVol2);
        SJctrRemotePairPropPathGroupTableDataModel pair2PathGrpTable = (SJctrRemotePairPropPathGroupTableDataModel)this.getDataModel("COM_TABLE_PATH_GROUP_PAIR2");
        this.setPortAttribute(remoteVol2, "COM_TABLE_PATH_GROUP_PAIR2");
        SJmoRemoteReplicationRCUInfo rcuInfo = SJctrRemoteReplicationUtility.getPairRcuInfoNoThrow(remoteVol2, this.mrcuMgr);
        pair2PathGrpTable.updatePathTable(rcuInfo);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setPair1Info(SJmoUniversalReplicatorPairVolInfo remoteVol1) {
        HURget1PairDetail rmiPair1 = SJctrRemoteReplicationUtility.getRmiPairRelatedModelPair(this.rmiPairList, remoteVol1);
        if (rmiPair1 == null) {
            this.logUty.putlog("setPair1Info", "Pair Information from RMI is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrRemoteReplicationUtility remoteUty = this.getComUtility().getRemoteReplicationUtility();
        String status = remoteUty.getUrCopyStatusString(remoteVol1);
        ((SJctrDataObject)this.getManageData()).setData("COM_STATUS_PAIR1", status);
        int statusIconId = SJctrRemoteReplicationUtility.getUrPairStatusIconId(remoteVol1);
        ((SJctrDataObject)this.getManageData()).setData("COM_STATUS_ICON_PAIR1", statusIconId);
        if (statusIconId == 16405) {
            ((SJctrDataObject)this.getManageData()).setData("COM_STATUS_ICON_W_PAIR1", GP_ERROR_L);
        } else {
            ((SJctrDataObject)this.getManageData()).setData("COM_STATUS_ICON_W_PAIR1", "");
        }
        if (rmiPair1.delta == 0) {
            if (rmiPair1.volType == 0) {
                ((SJctrDataObject)this.getManageData()).setData("COM_COPY_DIRECTION_PAIR1", PAIR1_COPY_DIRECTION_TO_REMOTE);
            } else {
                if (rmiPair1.volType != 1) {
                    this.logUty.putlog("makeProperties", "Local Pair Position is invalid.");
                    SJctrError err = new SJctrError(210, 22, 107001);
                    SJcException exp = err.createException();
                    throw exp;
                }
                ((SJctrDataObject)this.getManageData()).setData("COM_COPY_DIRECTION_PAIR1", PAIR1_COPY_DIRECTION_TO_LOCAL);
            }
        } else {
            ((SJctrDataObject)this.getManageData()).setData("COM_COPY_DIRECTION_PAIR1", PAIR1_COPY_DIRECTION_HOLD);
        }
        String pathGrpID = remoteUty.getUrPathGroupIdString(remoteVol1);
        ((SJctrDataObject)this.getManageData()).setData("COM_PATH_GROUP_PAIR1", pathGrpID);
        boolean pathGrpFlg = rmiPair1.volType == 0;
        ((SJctrDataObject)this.getManageData()).setData(SJctrViewRemotePairPropertiesDataMacro.KEY_PATH_LINK_FLG_PAIR1, pathGrpFlg);
        String mirrorID = remoteUty.getMirrorIdString(remoteVol1);
        ((SJctrDataObject)this.getManageData()).setData("COM_MIRROR_ID_PAIR1", mirrorID);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setPair2Info(SJmoUniversalReplicatorPairVolInfo remoteVol2) {
        HURget1PairDetail rmiPair2 = SJctrRemoteReplicationUtility.getRmiPairRelatedModelPair(this.rmiPairList, remoteVol2);
        if (rmiPair2 == null) {
            this.logUty.putlog("setPair2Info", "Pair Information from RMI is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrRemoteReplicationUtility remoteUty = this.getComUtility().getRemoteReplicationUtility();
        String status = remoteUty.getUrCopyStatusString(remoteVol2);
        ((SJctrDataObject)this.getManageData()).setData("COM_STATUS_PAIR2", status);
        int statusIconId = SJctrRemoteReplicationUtility.getUrPairStatusIconId(remoteVol2);
        ((SJctrDataObject)this.getManageData()).setData("COM_STATUS_ICON_PAIR2", statusIconId);
        if (statusIconId == 16405) {
            ((SJctrDataObject)this.getManageData()).setData("COM_STATUS_ICON_W_PAIR2", GP_ERROR_L);
        } else {
            ((SJctrDataObject)this.getManageData()).setData("COM_STATUS_ICON_W_PAIR2", "");
        }
        if (rmiPair2.delta == 0) {
            if (rmiPair2.volType == 0) {
                ((SJctrDataObject)this.getManageData()).setData("COM_COPY_DIRECTION_PAIR2", PAIR2_COPY_DIRECTION_TO_REMOTE);
            } else {
                if (rmiPair2.volType != 1) {
                    this.logUty.putlog("setPair2Info", "Local Pair Position is invalid.");
                    SJctrError err = new SJctrError(210, 22, 107001);
                    SJcException exp = err.createException();
                    throw exp;
                }
                ((SJctrDataObject)this.getManageData()).setData("COM_COPY_DIRECTION_PAIR2", PAIR2_COPY_DIRECTION_TO_LOCAL);
            }
        } else {
            ((SJctrDataObject)this.getManageData()).setData("COM_COPY_DIRECTION_PAIR2", PAIR2_COPY_DIRECTION_HOLD);
        }
        String pathGrpID = remoteUty.getUrPathGroupIdString(remoteVol2);
        ((SJctrDataObject)this.getManageData()).setData("COM_PATH_GROUP_PAIR2", pathGrpID);
        boolean pathGrpFlg = rmiPair2.volType == 0;
        ((SJctrDataObject)this.getManageData()).setData(SJctrViewRemotePairPropertiesDataMacro.KEY_PATH_LINK_FLG_PAIR2, pathGrpFlg);
        String mirrorID = remoteUty.getMirrorIdString(remoteVol2);
        ((SJctrDataObject)this.getManageData()).setData("COM_MIRROR_ID_PAIR2", mirrorID);
    }

    private void setLocalStorageSystemInfo(SJmoReplicationPairVolInfo localVol, SJmoUniversalReplicatorPairVolInfo remoteVol, SJctrDataController dc) {
        String jnlIdEncryption;
        String ldevAttr;
        SJctrSimpleDataModel localSysInfo = (SJctrSimpleDataModel)this.getDataModel("COM_LOCAL_STORAGE_SYSTEM_INF");
        HURget1PairDetail rmiPair = SJctrRemoteReplicationUtility.getRmiPairRelatedModelPair(this.rmiPairList, remoteVol);
        if (rmiPair == null) {
            this.logUty.putlog("setLocalStorageSystemInfo", "Pair Information from RMI is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoLdevDetail ldevDetail = null;
        int index = Collections.binarySearch(this.ldevDetailList, localVol);
        if (0 > index) {
            this.logUty.putlog("setLocalStorageSystemInfo", "LDEV Detail Information is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        ldevDetail = this.ldevDetailList.get(index);
        SJctrRemoteReplicationUtility remoteUty = this.getComUtility().getRemoteReplicationUtility();
        SJctrLdevUtility ldevUty = this.getComUtility().getLdevUtility();
        String ldevId = SJctrRemoteReplicationUtility.getLdevIdWithLdevName(localVol, this.ldevNameList, ldevUty);
        ((SJctrDataObject)localSysInfo.getManageData()).setData("COM_LDEV_ID", ldevId);
        ((SJctrDataObject)localSysInfo.getManageData()).setData("COM_NUM_OF_PATHS", String.valueOf(ldevDetail.getILUPathNumber()));
        ((SJctrDataObject)localSysInfo.getManageData()).setData("COM_NUM_OF_PATHS_FLG", SJctrRemoteReplicationUtility.isOpen(remoteVol));
        String provisioningType = ldevUty.toVolumeTypeDisplay(ldevDetail);
        String encrypted = remoteUty.getLocalEncryptedStr(ldevDetail);
        String t10pi = SJctrRemoteReplicationUtility.addDelimiter(remoteUty.getT10PIString(ldevDetail));
        if (!"".equals(encrypted)) {
            provisioningType = provisioningType + " , " + encrypted;
        }
        provisioningType = provisioningType + t10pi;
        ((SJctrDataObject)localSysInfo.getManageData()).setData("COM_PROVISIONING_TYPE", provisioningType);
        String emuCap = "";
        emuCap = SJctrDataController.isHM() ? (ldevUty.isLdevAttributeNone(ldevAttr = ldevUty.toLdevAttributeDisplay(ldevDetail)) ? this.getLocalCapacityStr(rmiPair, remoteVol) : ldevAttr + " , " + this.getLocalCapacityStr(rmiPair, remoteVol)) : this.getLocalEmuTypeStr(rmiPair, remoteVol) + " , " + this.getLocalCapacityStr(rmiPair, remoteVol);
        ((SJctrDataObject)localSysInfo.getManageData()).setData("COM_EMULATION_TYPE_CAP", emuCap);
        if (rmiPair.volType == 0) {
            jnlIdEncryption = SJctrComUtility.toHexString(rmiPair.mjnlGrp, 3, true) + this.getJnlEncryptionStringUsedPairProperty(rmiPair.mjnlGrp, this.urJnlGrpMgr);
            ((SJctrDataObject)localSysInfo.getManageData()).setData("COM_JOURNAL_ID", jnlIdEncryption);
        } else if (rmiPair.volType == 1) {
            jnlIdEncryption = SJctrComUtility.toHexString(rmiPair.rjnlGrp, 3, true) + this.getJnlEncryptionStringUsedPairProperty(rmiPair.rjnlGrp, this.urJnlGrpMgr);
            ((SJctrDataObject)localSysInfo.getManageData()).setData("COM_JOURNAL_ID", jnlIdEncryption);
        } else {
            this.logUty.putlog("setLocalStorageSystemInfo", "Local Pair Position is invalid.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        int modelId = remoteUty.getModelIDfromSubsysInfo(this.subsystemInfo);
        String modelIdString = dc.getOwner().getProductName();
        String serialNumber = this.subsystemInfo.getDKCSNString();
        SJmoClprIndex clprIndex = new SJmoClprIndex();
        clprIndex.setSClpr(ldevDetail.getSCLPR());
        index = Collections.binarySearch(this.clprList, clprIndex);
        String clprString = "?";
        if (0 <= index) {
            clprString = ldevUty.toClprDisplay(this.clprList.get(index));
        }
        String modelSnClpr = modelIdString + " / " + serialNumber + " , " + clprString;
        ((SJctrDataObject)localSysInfo.getManageData()).setData("COM_MODEL_SERIAL_NUM_CLPR", modelSnClpr);
    }

    private void makeRemoteStorageSystemInfo(String infoKey, SJmoUniversalReplicatorPairVolInfo remoteVol) {
        SJctrSimpleDataModel remoteStorageSystemInfo = (SJctrSimpleDataModel)this.getDataModel(infoKey);
        HURget1PairDetail rmiPair = SJctrRemoteReplicationUtility.getRmiPairRelatedModelPair(this.rmiPairList, remoteVol);
        SJctrLdevUtility ldevUty = this.getComUtility().getLdevUtility();
        SJctrRemoteReplicationUtility remoteUty = this.getComUtility().getRemoteReplicationUtility();
        String ldevId = ldevUty.toLdevDisplay(remoteVol);
        ((SJctrDataObject)remoteStorageSystemInfo.getManageData()).setData("COM_LDEV_ID", ldevId);
        boolean lunDispFlg = SJctrRemoteReplicationUtility.isOpen(remoteVol);
        ((SJctrDataObject)remoteStorageSystemInfo.getManageData()).setData("COM_PORT_HOSTGROUP_LUN_FLG", lunDispFlg);
        if (lunDispFlg) {
            HUR1DataVol rmiRemoteVol = null;
            if (rmiPair.volType == 0) {
                rmiRemoteVol = rmiPair.svol;
            } else if (rmiPair.volType == 1) {
                rmiRemoteVol = rmiPair.pvol;
            } else {
                this.logUty.putlog("makeRemoteStorageSystemInfo", "Local Pair Position is invalid.");
                SJctrError err = new SJctrError(210, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            String portId = this.getComUtility().getGuidance("PORT_NAME_PART_CL");
            portId = portId + SJctrRemoteReplicationUtility.getPortNameMap(rmiPair.modelID).get((short)rmiRemoteVol.port);
            String hgId = SJctrComUtility.toHexString(rmiRemoteVol.hostGroup, 2, true);
            String lunId = null;
            lunId = SJctrRemoteReplicationUtility.isLunDec(this.getDataController().getOwner().getUserSession()) ? String.valueOf(rmiRemoteVol.lun) : SJctrComUtility.toHexString(rmiRemoteVol.lun, 4, true);
            String portHgLun = portId + " / " + hgId + " / " + lunId;
            ((SJctrDataObject)remoteStorageSystemInfo.getManageData()).setData("COM_PORT_HOSTGROUP_LUN", portHgLun);
        }
        String emuCap = "";
        emuCap = SJctrDataController.isHM() ? this.getRemoteCapacityStr(rmiPair, remoteVol) : this.getRemoteEmuTypeStr(rmiPair, remoteVol) + " , " + this.getRemoteCapacityStr(rmiPair, remoteVol);
        ((SJctrDataObject)remoteStorageSystemInfo.getManageData()).setData("COM_EMULATION_TYPE_CAP", emuCap);
        if (rmiPair.volType == 0) {
            ((SJctrDataObject)remoteStorageSystemInfo.getManageData()).setData("COM_JOURNAL_ID", SJctrComUtility.toHexString(rmiPair.rjnlGrp, 3, true));
        } else if (rmiPair.volType == 1) {
            ((SJctrDataObject)remoteStorageSystemInfo.getManageData()).setData("COM_JOURNAL_ID", SJctrComUtility.toHexString(rmiPair.mjnlGrp, 3, true));
        } else {
            this.logUty.putlog("makeRemoteStorageSystemInfo", "Local Pair Position is invalid.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        String modelSnStr = remoteUty.getModelSNoString(rmiPair.modelID, rmiPair.pairSN);
        ((SJctrDataObject)remoteStorageSystemInfo.getManageData()).setData("COM_MODEL_SERIAL_NUM", modelSnStr);
    }

    private void setPortAttribute(SJmoUniversalReplicatorPairVolInfo urPair, String tableKey) {
        int attribute = SJctrRemoteReplicationUtility.getPairPortAttribute(urPair);
        SJctrSelectedRmPathTableDataModelBase table = (SJctrSelectedRmPathTableDataModelBase)this.getDataModel(tableKey);
        table.setPortAttribute(attribute);
    }

    private String getLocalEmuTypeStr(HURget1PairDetail rmiPair, SJmoUniversalReplicatorPairVolInfo modelPair) {
        String ret = "?";
        if (SJctrRemoteReplicationUtility.isPvol(modelPair)) {
            ret = rmiPair.svolDevice;
        } else if (SJctrRemoteReplicationUtility.isSvol(modelPair)) {
            ret = rmiPair.pvolDevice;
        }
        return ret;
    }

    private String getLocalCapacityStr(HURget1PairDetail rmiPair, SJmoUniversalReplicatorPairVolInfo modelPair) {
        String ret = "?";
        SJctrCapacityUtility capaUtil = this.getComUtility().getCapacityUtility();
        if (SJctrRemoteReplicationUtility.isOpenPvol(modelPair)) {
            ret = capaUtil.toUnitString(rmiPair.svolCapacity);
        } else if (SJctrRemoteReplicationUtility.isOpenSvol(modelPair)) {
            ret = capaUtil.toUnitString(rmiPair.pvolCapacity);
        } else if (SJctrRemoteReplicationUtility.isMainframePvol(modelPair)) {
            ret = String.valueOf(rmiPair.svolCylinder) + " " + capaUtil.getUnitString(SJctrCapacityUtility.UNIT.CYL);
        } else if (SJctrRemoteReplicationUtility.isMainframeSvol(modelPair)) {
            ret = String.valueOf(rmiPair.pvolCylinder) + " " + capaUtil.getUnitString(SJctrCapacityUtility.UNIT.CYL);
        }
        return ret;
    }

    private String getRemoteEmuTypeStr(HURget1PairDetail rmiPair, SJmoUniversalReplicatorPairVolInfo modelPair) {
        String ret = "?";
        if (SJctrRemoteReplicationUtility.isPvol(modelPair)) {
            ret = rmiPair.pvolDevice;
        } else if (SJctrRemoteReplicationUtility.isSvol(modelPair)) {
            ret = rmiPair.svolDevice;
        }
        return ret;
    }

    private String getRemoteCapacityStr(HURget1PairDetail rmiPair, SJmoUniversalReplicatorPairVolInfo modelPair) {
        String ret = "?";
        SJctrCapacityUtility capaUtil = this.getComUtility().getCapacityUtility();
        if (SJctrRemoteReplicationUtility.isOpenPvol(modelPair)) {
            ret = capaUtil.toUnitString(rmiPair.pvolCapacity);
        } else if (SJctrRemoteReplicationUtility.isOpenSvol(modelPair)) {
            ret = capaUtil.toUnitString(rmiPair.svolCapacity);
        } else if (SJctrRemoteReplicationUtility.isMainframePvol(modelPair)) {
            ret = String.valueOf(rmiPair.pvolCylinder) + " " + capaUtil.getUnitString(SJctrCapacityUtility.UNIT.CYL);
        } else if (SJctrRemoteReplicationUtility.isMainframeSvol(modelPair)) {
            ret = String.valueOf(rmiPair.svolCylinder) + " " + capaUtil.getUnitString(SJctrCapacityUtility.UNIT.CYL);
        }
        return ret;
    }

    private String getJnlEncryptionStringUsedPairProperty(int jnlId, SJmoUniversalReplicatorJnlGrpMgr jnlGrpInfo) {
        String ret = "(?)";
        SJmoUniversalReplicatorJnlGrp urJnlGrp = jnlGrpInfo.getJnlGroup(jnlId);
        if (urJnlGrp != null) {
            SJctrRemoteReplicationUtility remoteUtil = this.getComUtility().getRemoteReplicationUtility();
            String encryption = remoteUtil.getPairPropertyEncryptionString(urJnlGrp.getIEncrypt());
            ret = !"".equals(encryption) ? "(" + encryption + ")" : encryption;
        }
        return ret;
    }
}

