/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.addextvols;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import sanproject.common.Robj_interface_RJiResourceName;
import sanproject.serverux.dataimpl.EXDAddVolumeForEXD;
import sanproject.serverux.dataimpl.EXDExternalVolume;
import sanproject.serverux.dataimpl.EXDLDEVInfoDetail;
import sanproject.serverux.dataimpl.EXDPhysicalPath;
import sanproject.serverux.dataimpl.EXDTargetPort;
import sanproject.serverux.dataimpl.EXDsetAddVolumeForEXD_IN;
import sanproject.serverux.dataimpl.EXDsetAddVolumeForEXD_OUT;
import sanproject.serverux.dataimpl.RJiRESOURCEsetName_IN;
import sanproject.serverux.dataimpl.RJiRESOURCEsetName_OUT;
import sanproject.serverux.dataimpl.RJiResourceName;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSUtility;
import sanproject.sn2.controller.wizard.uvm.addextvols.SJctrAddExtVolError;
import sanproject.sn2.controller.wizard.uvm.com.SJctrExdPathGroupPhysicalPathInfoTableKey;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.model.data.exdevice.SJmoExdPathGroupInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdPhysicalPathInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdSubsystemInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdTargetPortInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfo;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdSubsystemInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdTargetPortInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;
import sanproject.sn2.model.data.volume.SJmoPgIndex;

public class SJctrAddExtVolsAC
extends SJctrApplyController {
    static final int RESULT_NORMAL = 0;
    static final int RESULT_REPRESENT_ERROR = 106039;
    static final int RESULT_INVALID_DATA = 107001;
    static final int RESULT_SETLDEVNAME_NOTEXECUTED = 105262;
    private List<SJmoExdVolumeInfo> exdVolList;
    private List<SJctrExdPathGroupPhysicalPathInfoTableKey> exdPathList;
    private SJmoExdTargetPortInfoMgr targetPortMgr;
    private SJmoExdSubsystemInfoMgr subsystemMgr;
    private Map<String, List<EXDLDEVInfoDetail>> ldevMap;
    private List<SJmoLdevNicknameInfo> ldevNameList;
    private int setLdevNameResult;
    public static final int ERC_LICENSED_CAPACITY_OVER = 56536;
    public static final int ERC_DKC_LICENSED_CAPACITY_OVER = 56507;
    public static final int SUBPARAMETER_ERROR = 66797;
    List<SJctrError> resultData = null;

    @Override
    public ArrayList<?> getSetList() {
        ArrayList<EXDsetAddVolumeForEXD_IN> applyList = null;
        EXDsetAddVolumeForEXD_IN input = new EXDsetAddVolumeForEXD_IN();
        SJmoExdPathGroupInfo pathGroup = this.exdPathList.get(0).getPathGroupInfo();
        int subsystemID = pathGroup.getRmiExdPathGroupInfo().referSubsystemID();
        SJmoExdSubsystemInfo subsystemInfo = this.subsystemMgr.getExdSubsystemInfo(subsystemID);
        EXDPhysicalPath[] rmiPathList = new EXDPhysicalPath[this.exdPathList.size()];
        EXDTargetPort[] rmiTargetPortList = new EXDTargetPort[this.exdPathList.size()];
        for (int path = 0; path < this.exdPathList.size(); ++path) {
            SJctrExdPathGroupPhysicalPathInfoTableKey exdPath = this.exdPathList.get(path);
            SJmoExdPhysicalPathInfo physicalPath = exdPath.getPhysicalPathInfo();
            EXDPhysicalPath rmiPhysicalPath = physicalPath.getRmiExdPhysicalPathInfo();
            int targetPortId = rmiPhysicalPath.referTargetPortId();
            SJmoExdTargetPortInfo targetPortInfo = this.targetPortMgr.getExdTargetPortInfo(targetPortId);
            EXDTargetPort rmiTargetPort = targetPortInfo.getRmiExdTargetPortInfo();
            rmiPathList[path] = rmiPhysicalPath;
            rmiTargetPortList[path] = rmiTargetPort;
        }
        for (SJmoExdVolumeInfo exdVol : this.exdVolList) {
            EXDAddVolumeForEXD addVol = new EXDAddVolumeForEXD();
            addVol.setSubsystem(subsystemInfo.getRmiExdSubsystemInfo());
            EXDExternalVolume rmiVolume = exdVol.getRmiExdVolumeInfo();
            addVol.setPGInfo(rmiVolume);
            long volumeSize = rmiVolume.getExternalDeviceInfo().getVolumeSize();
            rmiVolume.setLPGLBASize(volumeSize);
            addVol.setPhysicalPath(rmiPathList);
            addVol.setTargetPort(rmiTargetPortList);
            String identity2 = exdVol.getRmiExdVolumeInfo().getExternalDeviceInfo().getIdentity2();
            List<EXDLDEVInfoDetail> mapLdevList = this.ldevMap.get(identity2);
            if (mapLdevList != null) {
                for (EXDLDEVInfoDetail mapLdev : mapLdevList) {
                    mapLdev.setOwnership(rmiVolume.getOwnership());
                    addVol.setLdev(mapLdev);
                }
            }
            input.setAddVolume(addVol);
        }
        applyList = new ArrayList<EXDsetAddVolumeForEXD_IN>(1);
        applyList.add(input);
        return applyList;
    }

    @Override
    protected void applyStart(SJdsSupplierAgent supplier) {
        if (supplier == null) {
            throw new NullPointerException();
        }
        Object resultObject = null;
        Object setNameResultObject = null;
        boolean addVolSuccess = true;
        try {
            this.setLdevNameResult = 105262;
            ArrayList<?> setList = this.getSetList();
            SJctrLogUty.info(this.title, "applyStart", "Apply Start!! (EXDsetAddVolumeForEXD)");
            resultObject = supplier.applyStart(this.getLockId(), setList);
            SJctrLogUty.info(this.title, "applyStart", "Apply End!! (EXDsetAddVolumeForEXD)");
            int delegateErc = 0;
            if (resultObject == null) {
                delegateErc = 107001;
            } else if (resultObject instanceof EXDsetAddVolumeForEXD_OUT) {
                EXDsetAddVolumeForEXD_OUT out = (EXDsetAddVolumeForEXD_OUT)resultObject;
                EXDAddVolumeForEXD[] data = out.getAllAddVolumeForEXD();
                if (data.length > 0) {
                    ArrayList<RJiRESOURCEsetName_IN> addList = new ArrayList<RJiRESOURCEsetName_IN>();
                    ArrayList<RJiResourceName> resourceNameList = new ArrayList<RJiResourceName>(data.length);
                    Collections.sort(this.ldevNameList);
                    for (int index = 0; index < data.length; ++index) {
                        EXDAddVolumeForEXD addVolResult = data[index];
                        if (addVolResult.getResult() != 0) {
                            addVolSuccess = false;
                            break;
                        }
                        String identity2 = addVolResult.getPGInfo().getExternalDeviceInfo().getIdentity2();
                        List<EXDLDEVInfoDetail> mapLdevList = this.ldevMap.get(identity2);
                        if (mapLdevList == null) continue;
                        for (EXDLDEVInfoDetail mapLdev : mapLdevList) {
                            SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
                            ldevIndex.setLdevIndex(mapLdev.getSLDKC(), mapLdev.getSCU(), mapLdev.getSLDEV());
                            int search = Collections.binarySearch(this.ldevNameList, ldevIndex);
                            String ldevName = this.ldevNameList.get(search).getStrNickname();
                            RJiResourceName resourceName = new RJiResourceName();
                            resourceName.setNumber(SJctrCVSUtility.getLdevNumber(ldevIndex));
                            resourceName.setType(1);
                            resourceName.setName(ldevName);
                            resourceNameList.add(resourceName);
                        }
                    }
                    if (addVolSuccess) {
                        this.setLdevNameResult = 0;
                        if (resourceNameList.size() > 0) {
                            RJiRESOURCEsetName_IN applyData = new RJiRESOURCEsetName_IN();
                            Robj_interface_RJiResourceName[] apply = new RJiResourceName[resourceNameList.size()];
                            resourceNameList.toArray(apply);
                            applyData.setResourceName(apply);
                            addList.add(applyData);
                            ArrayList<RJiRESOURCEsetName_IN> applyList = new ArrayList<RJiRESOURCEsetName_IN>(addList.size());
                            applyList.addAll(addList);
                            SJctrLogUty.info(this.title, "applyStart", "Apply Start!! (RJiRESOURCEsetName)");
                            setNameResultObject = supplier.applyStart(this.getLockId(), applyList);
                            SJctrLogUty.info(this.title, "applyStart", "Apply End!! (RJiRESOURCEsetName)");
                            if (setNameResultObject == null) {
                                delegateErc = 107001;
                            } else if (setNameResultObject instanceof RJiRESOURCEsetName_OUT) {
                                RJiRESOURCEsetName_OUT setNameOut = (RJiRESOURCEsetName_OUT)setNameResultObject;
                                for (int index = 0; index < setNameOut.result.length; ++index) {
                                    int[] error = setNameOut.result[index].getError();
                                    if (error[1] == 0) continue;
                                    this.setLdevNameResult = error[1];
                                    break;
                                }
                            }
                        }
                    }
                    this.setApplyResult(resultObject);
                } else {
                    delegateErc = 107001;
                }
            } else {
                delegateErc = 107001;
            }
        }
        catch (Exception e) {
            SJctrLogUty.info(this.title, "applyStart", "exception", e);
            SJctrError error = SJctrError.parseError(e);
            this.setError(error);
        }
    }

    @Override
    protected void setApplyResult(Object resultObject) {
        int delegateErc = 0;
        int errfunc = 6;
        int errmodule = 22;
        if (resultObject == null) {
            delegateErc = 107001;
        } else if (resultObject instanceof EXDsetAddVolumeForEXD_OUT) {
            EXDsetAddVolumeForEXD_OUT out = (EXDsetAddVolumeForEXD_OUT)resultObject;
            EXDAddVolumeForEXD[] data = out.getAllAddVolumeForEXD();
            if (data.length > 0) {
                HashSet<Integer> errSet = new HashSet<Integer>(data.length);
                this.resultData = new ArrayList<SJctrError>(data.length);
                for (int index = 0; index < data.length; ++index) {
                    SJctrAddExtVolError applyResult;
                    EXDAddVolumeForEXD oneData = data[index];
                    int addVolResult = oneData.getResult();
                    SJmoPgIndex pgIndex = new SJmoPgIndex();
                    pgIndex.setFB4(oneData.getPGInfo().getIFB4());
                    pgIndex.setPG(oneData.getPGInfo().getIPG());
                    if (addVolResult == 0) {
                        if (this.setLdevNameResult == 0) continue;
                        if (this.setLdevNameResult == 105262) {
                            applyResult = new SJctrAddExtVolError(6, 22, this.setLdevNameResult, pgIndex);
                            this.resultData.add(applyResult);
                        } else {
                            applyResult = new SJctrAddExtVolError(30, 5, this.setLdevNameResult, pgIndex);
                            this.resultData.add(applyResult);
                        }
                        errSet.add(this.setLdevNameResult);
                        continue;
                    }
                    applyResult = new SJctrAddExtVolError(6, 5, addVolResult, pgIndex);
                    this.resultData.add(applyResult);
                    errSet.add(addVolResult);
                }
                if (errSet.size() == 0) {
                    delegateErc = 0;
                } else if (errSet.size() == 1) {
                    if (this.setLdevNameResult == 105262) {
                        errfunc = 6;
                        errmodule = 5;
                    } else {
                        errfunc = 30;
                        errmodule = 5;
                    }
                    Object[] errArray = errSet.toArray();
                    delegateErc = (Integer)errArray[0];
                } else {
                    errfunc = 201;
                    delegateErc = 106039;
                }
            } else {
                delegateErc = 107001;
            }
        } else {
            delegateErc = 107001;
        }
        SJctrError result = new SJctrError(errfunc, errmodule, delegateErc);
        this.setError(result);
    }

    @Override
    protected List<SJctrError> getResultData() {
        return this.resultData;
    }

    @Override
    public boolean hasApplyResult() {
        return true;
    }

    @Override
    public int getLeadTime() {
        int leadTime = 0;
        int volumeTime = (this.exdVolList.size() / 800 + 1) * 40;
        int ldevTime = 0;
        ldevTime = this.ldevMap.size() % 2048 == 0 ? this.ldevMap.size() / 2048 * 6 : (this.ldevMap.size() / 2048 + 1) * 6;
        leadTime = volumeTime + ldevTime;
        return leadTime;
    }

    public void setApplyData(List<SJmoExdVolumeInfo> exdVolList, List<SJctrExdPathGroupPhysicalPathInfoTableKey> exdPathList, SJmoExdTargetPortInfoMgr targetPortMgr, SJmoExdSubsystemInfoMgr subsystemMgr, Map<String, List<EXDLDEVInfoDetail>> ldevMap, List<SJmoLdevNicknameInfo> ldevNameList) {
        this.exdVolList = exdVolList;
        this.exdPathList = exdPathList;
        this.targetPortMgr = targetPortMgr;
        this.subsystemMgr = subsystemMgr;
        this.ldevMap = ldevMap;
        this.ldevNameList = ldevNameList;
    }
}

