/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.discnctextpaths;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrExtUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.uvm.com.SJctrUvmWizardDataController;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrPhysicalPathManager;
import sanproject.sn2.controller.wizard.uvm.discnctextpaths.SJctrByTargetDataModel;
import sanproject.sn2.controller.wizard.uvm.discnctextpaths.SJctrDiscnctExtPathsSubWizard;
import sanproject.sn2.controller.wizard.uvm.discnctextpaths.SJctrMainteExtPathsConfirmData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExdPathGroupInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdPathStatusInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdPhysicalPathInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdProfileInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdSubsystemInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdTargetPortInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdVolumeInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.exdevice.SJmoExdPathGroupInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdPhysicalPathInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdTargetPortInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfoOnPathGroup;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdPathGroupInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdPathStatusInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdPhysicalPathInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdProfileInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdSubsystemInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdTargetPortInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdVolumeInfoMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoPgIndex;

public class SJctrDiscnctExtPathsDC
extends SJctrUvmWizardDataController {
    private static final int DISP_ID = 0x1101001;
    protected static final String KEY_DISCONNECTINFO = "COM_DISCONNECTINFO";
    private static final String KEY_TABLE = "COM_TABLE";
    public static final String TITLE = "DISP_DI100S_TITLE";
    List<SJmoExdPhysicalPathInfo> exdPhysicalPathList = null;
    List<SJmoExdPhysicalPathInfoMgr> exdPhysicalPathMgrList = null;
    List<SJmoExdTargetPortInfoMgr> exdTargetPortMgrList = null;
    List<SJmoExdPathGroupInfoMgr> exdPathGrpMgrList = null;
    List<SJmoExdSubsystemInfoMgr> exdSubsystemMgrList = null;
    List<SJmoExdProfileInfoMgr> exdProfileMgrList = null;
    List<SJmoPortDetail> portDetailList = null;
    List<SJmoExdPathStatusInfoMgr> exdPathStatusMgrList = null;
    SJmoExdVolumeInfoMgr exdVolMgr = null;
    SJctrResourceGroupUtility rsgUtil = null;
    protected List<SJmoPortIndex> unUsablePortList = Collections.emptyList();
    protected List<SJmoPgIndex> unUsablePgList = Collections.emptyList();
    private SJctrByTargetDataModel byTargetDataModel = null;
    public static int RESULT_NORMAL = 0;
    public static int DISCNCTEXTPATHS_NOT_FOUND_PARAM = 107001;
    public static int DISCNCTEXTPATHS_NOT_FOUND_MODEL = 107018;
    public static int DISCNCTEXTPATHS_NOT_EQUIP_PATH = 106526;
    public static int DISCNCTEXTPATHS_NOT_EQUIP_TARGET = 106528;
    public static int DISCNCTEXTPATHS_UNUSABLE_RSGPORT = 105267;
    public static int DISCNCTEXTPATHS_UNUSABLE_RSGPG = 105275;
    public static int DISCNCTEXTPATHS_UNUSABLE_RSGPORT_WWN2 = 105273;
    public static int DISCNCTEXTPATHS_UNUSABLE_RSGPG_WWN2 = 105274;
    public static int DISCNCTEXTPATHS_UNUSABLE_RSGPORT_PATH2 = 105276;
    public static int DISCNCTEXTPATHS_UNUSABLE_RSGPG_PATH2 = 105277;
    public static int DISCNCTEXTPATHS_SELECT_PORT_KIND_MIX = 205149;

    public SJctrDiscnctExtPathsDC() throws SJcException {
        this(0x1101001);
    }

    public SJctrDiscnctExtPathsDC(int dispId) throws SJcException {
        super(dispId);
        this.initDataModel();
        this.initManager();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("UVM", TITLE);
    }

    protected void initDataModel() {
        this.byTargetDataModel = new SJctrByTargetDataModel();
        this.addDataObjectModel(KEY_DISCONNECTINFO, this.byTargetDataModel);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        SJctrButtonDataModel finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH);
        finishButton.setChangeCheck(false);
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        int errorCode = RESULT_NORMAL;
        List<?> targetList = this.getCache(SJctrDiscnctExtPathsSubWizard.DISCNCT_EXT_PATHS_DATA);
        if (targetList == null || targetList.size() == 0) {
            errorCode = DISCNCTEXTPATHS_NOT_FOUND_PARAM;
        } else {
            for (Object targetObj : targetList) {
                if (targetObj instanceof SJmoExdPhysicalPathInfo) continue;
                errorCode = DISCNCTEXTPATHS_NOT_FOUND_PARAM;
            }
        }
        if (errorCode != RESULT_NORMAL) {
            SJctrError err = new SJctrError(6, 22, errorCode);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        SJctrErrorColumnData errData;
        boolean ret = true;
        List<?> dat = this.getCache(SJctrDiscnctExtPathsSubWizard.DISCNCT_EXT_PATHS_DATA);
        this.exdPhysicalPathList = dat;
        this.checkModelData();
        SJctrDataController parentDC = this.getWizardWindow().getParentDC();
        SJctrTableDataModel parentTbl = (SJctrTableDataModel)parentDC.getDataObjectModel(KEY_TABLE);
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(this.exdPhysicalPathList.size());
        SJmoExdPhysicalPathInfoMgr physicalPathMgr = this.exdPhysicalPathMgrList.get(0);
        HashSet<Boolean> chkPortKindSet = new HashSet<Boolean>();
        for (SJmoExdPhysicalPathInfo exdPhysicalPath : this.exdPhysicalPathList) {
            SJmoPortDetail portDtl;
            boolean result = true;
            if (physicalPathMgr.getAlExdPhysicalPathInfo().size() == 0) {
                result = false;
            } else {
                int exdPhysicalPathId = exdPhysicalPath.getRmiExdPhysicalPathInfo().getId();
                SJmoExdPhysicalPathInfo moExdPhysicalPath = physicalPathMgr.getExdPhysicalPathInfo(exdPhysicalPathId);
                if (moExdPhysicalPath == null) {
                    result = false;
                }
            }
            if (!result) {
                ret = false;
                SJctrError errInfo = new SJctrError(6, 22, DISCNCTEXTPATHS_NOT_EQUIP_PATH);
                SJctrErrorColumnData errData2 = new SJctrErrorColumnData(exdPhysicalPath, errInfo);
                errList.add(errData2);
            }
            if ((portDtl = SJctrExtUtility.getPortDtlFromPhysicalPathInfo(exdPhysicalPath, this.portDetailList)) == null) continue;
            chkPortKindSet.add(SJctrPortUtility.isIscsiPort(portDtl));
        }
        if (chkPortKindSet.size() != 1) {
            SJctrError errInfo = new SJctrError(6, 22, DISCNCTEXTPATHS_SELECT_PORT_KIND_MIX);
            SJcException exp = errInfo.createException();
            throw exp;
        }
        if (ret) {
            SJmoExdTargetPortInfoMgr targetPortMgr = this.exdTargetPortMgrList.get(0);
            for (SJmoExdPhysicalPathInfo exdPhysicalPath : this.exdPhysicalPathList) {
                boolean result = true;
                if (targetPortMgr.getAlExdTargetPortInfo().size() == 0) {
                    result = false;
                } else {
                    int wwnId = exdPhysicalPath.getRmiExdPhysicalPathInfo().referTargetPortId();
                    SJmoExdTargetPortInfo moExdTargetPortInfo = targetPortMgr.getExdTargetPortInfo(wwnId);
                    if (moExdTargetPortInfo == null) {
                        result = false;
                    }
                }
                if (result) continue;
                ret = false;
                SJctrError errInfo = new SJctrError(6, 22, DISCNCTEXTPATHS_NOT_EQUIP_TARGET);
                errData = new SJctrErrorColumnData(exdPhysicalPath, errInfo);
                errList.add(errData);
            }
        }
        if (ret) {
            SJmoExdPathGroupInfoMgr pathGrpMgr = this.exdPathGrpMgrList.get(0);
            ArrayList pathGrpList = pathGrpMgr.getAlExdPathGroupInfo();
            for (SJmoExdPhysicalPathInfo exdPhysicalPath : this.exdPhysicalPathList) {
                SJctrError errInfo;
                if (this.checkRsg(exdPhysicalPath, this.exdVolMgr, pathGrpList, this.rsgUtil, errInfo = new SJctrError(6, 22, RESULT_NORMAL))) continue;
                ret = false;
                errData = new SJctrErrorColumnData(exdPhysicalPath, errInfo);
                errList.add(errData);
            }
        }
        if (!ret) {
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            errDc.setParameter(parentTbl, errList);
            SJctrError representErrorInfo = errDc.getRepresentativeError(errList, 5);
            SJcException exp = representErrorInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        return ret;
    }

    protected void checkModelData() {
        boolean result = true;
        List<Object> exdVolMgrList = Collections.emptyList();
        List<Object> rsgInfoList = Collections.emptyList();
        this.exdPhysicalPathMgrList = this.getCache(SJmoGetExdPhysicalPathInfoMgr.class);
        if (this.exdPhysicalPathMgrList == null || this.exdPhysicalPathMgrList.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkModelData", "SJmoExdPhysicalPathInfoMgr is null or Empty.");
            result = false;
        } else {
            this.exdTargetPortMgrList = this.getCache(SJmoGetExdTargetPortInfoMgr.class);
            if (this.exdTargetPortMgrList == null || this.exdTargetPortMgrList.isEmpty()) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkModelData", "SJmoExdTargetPortInfoMgr is null or Empty.");
                result = false;
            } else {
                this.exdPathGrpMgrList = this.getCache(SJmoGetExdPathGroupInfoMgr.class);
                if (this.exdPathGrpMgrList == null || this.exdPathGrpMgrList.isEmpty()) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "checkModelData", "SJmoExdPathGroupInfoMgr is null or Empty.");
                    result = false;
                } else {
                    this.exdSubsystemMgrList = this.getCache(SJmoGetExdSubsystemInfoMgr.class);
                    if (this.exdSubsystemMgrList == null || this.exdSubsystemMgrList.isEmpty()) {
                        SJctrLogUty.warn(this.getClass().getSimpleName(), "checkModelData", "SJmoExdSubsystemInfoMgr is null or Empty.");
                        result = false;
                    } else {
                        this.exdProfileMgrList = this.getCache(SJmoGetExdProfileInfoMgr.class);
                        if (this.exdProfileMgrList == null || this.exdProfileMgrList.isEmpty()) {
                            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkModelData", "SJmoExdProfileInfoMgr is null or Empty.");
                            result = false;
                        } else {
                            this.portDetailList = this.getCache(SJmoGetPortDetail.class);
                            if (this.portDetailList == null) {
                                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkModelData", "SJmoPortDetail is null or Empty.");
                                result = false;
                            } else {
                                this.exdPathStatusMgrList = this.getCache(SJmoGetExdPathStatusInfoMgr.class);
                                if (this.exdPathStatusMgrList == null || this.exdPathStatusMgrList.isEmpty()) {
                                    SJctrLogUty.warn(this.getClass().getSimpleName(), "checkModelData", "SJmoExdPathStatusInfoMgr is null or Empty.");
                                    result = false;
                                } else {
                                    exdVolMgrList = this.getCache(SJmoGetExdVolumeInfoMgr.class);
                                    if (exdVolMgrList == null || exdVolMgrList.size() == 0) {
                                        SJctrLogUty.warn(this.getClass().getSimpleName(), "checkModelData", "SJmoExdVolumeInfoMgr is null or Empty.");
                                        result = false;
                                    } else {
                                        rsgInfoList = this.getCache(SJmoGetRSGgetAllRsgs.class);
                                        if (rsgInfoList == null || rsgInfoList.size() == 0) {
                                            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkModelData", "SJmoRSGgetAllRsgs is null or Empty.");
                                            result = false;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!result) {
            SJctrError err = new SJctrError(6, 22, DISCNCTEXTPATHS_NOT_FOUND_MODEL);
            SJcException exp = err.createException();
            throw exp;
        }
        this.exdVolMgr = (SJmoExdVolumeInfoMgr)exdVolMgrList.get(0);
        this.rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgInfoList.get(0));
        this.unUsablePortList = SJctrExtUtility.getImpossibleExdPortList(this.exdPhysicalPathMgrList.get(0), this.rsgUtil);
        this.unUsablePgList = SJctrExtUtility.getImpossibleExdPgList(this.exdVolMgr, this.rsgUtil);
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        List<SJmoExdPhysicalPathInfo> targetPhysicalPathInfoList = this.getTargetPhysicalPathList();
        this.createConfirmData(targetPhysicalPathInfoList);
        return ret;
    }

    protected List<SJmoExdPhysicalPathInfo> getTargetPhysicalPathList() {
        List<Object> targetPhysicalPathInfoList = Collections.emptyList();
        targetPhysicalPathInfoList = this.byTargetDataModel.isSelectPorts() ? this.getPhysicalPathInfoByPorts(this.exdPhysicalPathList) : (this.byTargetDataModel.isSelectWwns() ? this.getPhysicalPathInfoByWwns(this.exdPhysicalPathList) : new ArrayList(0));
        SJmoExdPathGroupInfoMgr pathGrpMgr = this.exdPathGrpMgrList.get(0);
        ArrayList pathGrpList = pathGrpMgr.getAlExdPathGroupInfo();
        SJctrError errInfo = new SJctrError(6, 22, RESULT_NORMAL);
        for (SJmoExdPhysicalPathInfo sJmoExdPhysicalPathInfo : targetPhysicalPathInfoList) {
            if (this.byTargetDataModel.isSelectPorts()) {
                if (!this.isUsablePhysicalPathAtPort(sJmoExdPhysicalPathInfo, this.rsgUtil)) {
                    errInfo.setError(DISCNCTEXTPATHS_UNUSABLE_RSGPORT_PATH2);
                    SJcException exp = errInfo.createException();
                    throw exp;
                }
                if (this.isUsablePhysicalPathAtExtVol(sJmoExdPhysicalPathInfo, this.exdVolMgr, pathGrpList, this.rsgUtil)) continue;
                errInfo.setError(DISCNCTEXTPATHS_UNUSABLE_RSGPG_PATH2);
                SJcException exp = errInfo.createException();
                throw exp;
            }
            if (!this.isUsablePhysicalPathAtPort(sJmoExdPhysicalPathInfo, this.rsgUtil)) {
                errInfo.setError(DISCNCTEXTPATHS_UNUSABLE_RSGPORT_WWN2);
                SJcException exp = errInfo.createException();
                throw exp;
            }
            if (this.isUsablePhysicalPathAtExtVol(sJmoExdPhysicalPathInfo, this.exdVolMgr, pathGrpList, this.rsgUtil)) continue;
            errInfo.setError(DISCNCTEXTPATHS_UNUSABLE_RSGPG_WWN2);
            SJcException exp = errInfo.createException();
            throw exp;
        }
        return targetPhysicalPathInfoList;
    }

    protected void createConfirmData(List<SJmoExdPhysicalPathInfo> targetPhysicalPathInfoList) {
        SJctrMainteExtPathsConfirmData confirmData = new SJctrMainteExtPathsConfirmData();
        confirmData.setExdPhysicalPathInfo(targetPhysicalPathInfoList);
        confirmData.setExdSubsystemInfoMgr(this.exdSubsystemMgrList);
        confirmData.setExdProfileInfoMgr(this.exdProfileMgrList);
        confirmData.setExdTargetPortInfoMgr(this.exdTargetPortMgrList);
        confirmData.setPortDetail(this.portDetailList);
        ArrayList<SJctrMainteExtPathsConfirmData> confirmDataList = new ArrayList<SJctrMainteExtPathsConfirmData>();
        confirmDataList.add(confirmData);
        this.putCache(SJctrMainteExtPathsConfirmData.class, confirmDataList);
    }

    protected List<SJmoExdPhysicalPathInfo> getPhysicalPathInfoByPorts(List<SJmoExdPhysicalPathInfo> physicalPathinfoList) {
        HashSet<Integer> port = new HashSet<Integer>(physicalPathinfoList.size());
        ArrayList<SJmoExdPhysicalPathInfo> retList = new ArrayList<SJmoExdPhysicalPathInfo>();
        SJmoExdPhysicalPathInfoMgr physicalPathMgr = this.exdPhysicalPathMgrList.get(0);
        for (SJmoExdPhysicalPathInfo pathInfo : physicalPathinfoList) {
            int portId = pathInfo.getRmiExdPhysicalPathInfo().referInitiatorPortId();
            ArrayList getList = physicalPathMgr.getAlPhysicalPathInfoOfInitiatorPortId(portId);
            if (!port.contains(portId)) {
                retList.addAll(getList);
            }
            port.add(portId);
        }
        return retList;
    }

    private List<SJmoExdPhysicalPathInfo> getPhysicalPathInfoByWwns(List<SJmoExdPhysicalPathInfo> physicalPathinfoList) {
        HashSet<Integer> wwn = new HashSet<Integer>(physicalPathinfoList.size());
        ArrayList<SJmoExdPhysicalPathInfo> retList = new ArrayList<SJmoExdPhysicalPathInfo>();
        SJmoExdPhysicalPathInfoMgr physicalPathMgr = this.exdPhysicalPathMgrList.get(0);
        for (SJmoExdPhysicalPathInfo pathInfo : physicalPathinfoList) {
            int wwnId = pathInfo.getRmiExdPhysicalPathInfo().referTargetPortId();
            ArrayList getList = physicalPathMgr.getAlPhysicalPathInfoOfTargetPortId(wwnId);
            if (!wwn.contains(wwnId)) {
                retList.addAll(getList);
            }
            wwn.add(wwnId);
        }
        return retList;
    }

    private void initManager() {
        this.addManager(SJctrPhysicalPathManager.class);
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdTargetPortInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdPhysicalPathInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdPathGroupInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdSubsystemInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdProfileInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdPathStatusInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdVolumeInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private boolean checkRsg(SJmoExdPhysicalPathInfo physicalPath, SJmoExdVolumeInfoMgr exdVolMgr, List<SJmoExdPathGroupInfo> pathGrpList, SJctrResourceGroupUtility rsgUtil, SJctrError errInfo) {
        boolean result = true;
        if (!this.isUsablePhysicalPathAtPort(physicalPath, rsgUtil)) {
            result = false;
            errInfo.setError(DISCNCTEXTPATHS_UNUSABLE_RSGPORT);
        } else if (!this.isUsablePhysicalPathAtExtVol(physicalPath, exdVolMgr, pathGrpList, rsgUtil)) {
            result = false;
            errInfo.setError(DISCNCTEXTPATHS_UNUSABLE_RSGPG);
        }
        return result;
    }

    boolean isUsablePhysicalPathAtPort(SJmoExdPhysicalPathInfo physicalPath, SJctrResourceGroupUtility rsgUtil) {
        boolean result = true;
        if (!this.unUsablePortList.isEmpty()) {
            SJmoPortIndex portIndex = new SJmoPortIndex();
            portIndex.setSPort((short)physicalPath.getRmiExdPhysicalPathInfo().referInitiatorPortId());
            if (Collections.binarySearch(this.unUsablePortList, portIndex) >= 0) {
                result = false;
            }
        }
        return result;
    }

    boolean isUsablePhysicalPathAtExtVol(SJmoExdPhysicalPathInfo physicalPath, SJmoExdVolumeInfoMgr exdVolMgr, List<SJmoExdPathGroupInfo> pathGrpList, SJctrResourceGroupUtility rsgUtil) {
        boolean result = true;
        if (!this.unUsablePgList.isEmpty()) {
            SJctrExtUtility extUtil = this.getComUtility().getExtUtility();
            int physicalPathId = physicalPath.getRmiExdPhysicalPathInfo().getId();
            List<SJmoExdPathGroupInfo> pathGrpphysicalPathList = extUtil.getPathGroupListPhysicalPath(pathGrpList, physicalPathId);
            block0: for (SJmoExdPathGroupInfo pathgrp : pathGrpphysicalPathList) {
                int pathGrpId = pathgrp.getRmiExdPathGroupInfo().getPathGroupID();
                SJmoExdVolumeInfoOnPathGroup exdVolonPathGrp = exdVolMgr.getExdVolumeInfoOnPathGroup(pathGrpId);
                ArrayList exdVolInfoList = exdVolonPathGrp.getAlExdVolumeInfo();
                for (SJmoExdVolumeInfo exdVol : exdVolInfoList) {
                    int fb4 = exdVol.getRmiExdVolumeInfo().getIFB4();
                    int pg = exdVol.getRmiExdVolumeInfo().getIPG();
                    SJmoPgIndex pgIndex = new SJmoPgIndex();
                    pgIndex.setFB4(fb4);
                    pgIndex.setPG(pg);
                    if (Collections.binarySearch(this.unUsablePgList, pgIndex) >= 0) {
                        result = false;
                        continue block0;
                    }
                    if (result) continue;
                    continue block0;
                }
            }
        }
        return result;
    }
}

