/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.editextwwns;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import sanproject.serverux.dataimpl.EXDTargetPort_Fiber;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrExtUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.uvm.com.SJctrUvmWizardDataController;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrTargetPortManager;
import sanproject.sn2.controller.wizard.uvm.editextwwns.SJctrEditExtWwnsConfirmData;
import sanproject.sn2.controller.wizard.uvm.editextwwns.SJctrEditExtWwnsSubWizard;
import sanproject.sn2.controller.wizard.uvm.editextwwns.SJctrIoTovDataModel;
import sanproject.sn2.controller.wizard.uvm.editextwwns.SJctrPathBlkWatchDataModel;
import sanproject.sn2.controller.wizard.uvm.editextwwns.SJctrQdepthDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExdPathGroupInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdPhysicalPathInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdTargetPortInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdVolumeInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.exdevice.SJmoExdPathGroupInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdPhysicalPathInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdTargetPortInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfoOnPathGroup;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdPathGroupInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdPhysicalPathInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdTargetPortInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdVolumeInfoMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoPgIndex;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;

public class SJctrEditExtWwnsDC
extends SJctrUvmWizardDataController {
    private static final int DISP_ID = 17827473;
    private static final String KEY_QDEPTHINF = "COM_QDEPTHINF";
    private static final String KEY_IOTOVINF = "COM_IOTOVINF";
    private static final String KEY_PATHBLKSECINF = "COM_PATHBLKSECINF";
    private static final String KEY_TABLE = "COM_TABLE";
    private final String TITLE = "DISP_DI69S_TITLE";
    private SJctrResourceGroupUtility rsgUtil = null;
    List<SJmoExdPhysicalPathInfo> exdPhysicalPathList = null;
    List<SJmoExdPhysicalPathInfoMgr> exdPhysicalPathMgrList = null;
    List<SJmoExdTargetPortInfoMgr> exdTargetPortMgrList = null;
    List<SJmoExdPathGroupInfo> exdPathGroupList = null;
    List<SJmoPortDetail> portDetailList = null;
    SJmoExdVolumeInfoMgr exdVolMgr = null;
    SJctrQdepthDataModel qdepthModeDataModel = null;
    SJctrIoTovDataModel iotovDataModel = null;
    SJctrPathBlkWatchDataModel pathBlkWatchDataModel = null;
    private static final short INIT_SHORT = 0;
    private static final String INIT_STRING = "";
    private static final short QDEPTH_MIN = 2;
    private static final short QDEPTH_MAX = 128;
    private static final short IOTOV_MIN = 5;
    private static final short IOTOV_MAX = 240;
    private static final short PATHWATCH_MIN = 5;
    private static final short PATHWATCH_MAX = 180;
    public static int RESULT_NORMAL = 0;
    public static int EDITEXTWWNS_NOT_FOUND_PARAM = 107001;
    public static int EDITEXTWWNS_NOT_FOUND_MODEL = 107018;
    public static int EDITEXTWWNS_NOT_EQUIP_PHYSICALPATH = 106526;
    public static int EDITEXTWWNS_NOT_EQUIP_TARGETPORT = 106528;
    public static int EDITEXTWWNS_NOT_EQUIP_PORTDETAIL = 106528;
    public static int EDITEXTWWNS_INPUT_INVALID_DATA = 105084;
    public static int EDITEXTWWNS_UNUSABLE_RSGPORT = 105271;
    public static int EDITEXTWWNS_UNUSABLE_RSGPG = 105272;
    public static int EDITEXTWWNS_PTTYPE_ISCSI = 205150;

    public SJctrEditExtWwnsDC() throws SJcException {
        this(17827473);
    }

    public SJctrEditExtWwnsDC(int dispId) throws SJcException {
        super(dispId);
        this.initDataModel();
        this.initManager();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("UVM", "DISP_DI69S_TITLE");
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_QDEPTHINF, new SJctrQdepthDataModel());
        this.addDataObjectModel(KEY_IOTOVINF, new SJctrIoTovDataModel());
        this.addDataObjectModel(KEY_PATHBLKSECINF, new SJctrPathBlkWatchDataModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        SJctrButtonDataModel finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH);
        finishButton.setChangeCheck(false);
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        int errorCode = RESULT_NORMAL;
        List<?> targetList = this.getCache(SJctrEditExtWwnsSubWizard.EDIT_EXT_WWNS_DATA);
        if (targetList == null || targetList.size() == 0) {
            errorCode = EDITEXTWWNS_NOT_FOUND_PARAM;
        } else {
            for (Object targetObj : targetList) {
                if (targetObj instanceof SJmoExdPhysicalPathInfo) continue;
                errorCode = EDITEXTWWNS_NOT_FOUND_PARAM;
            }
        }
        if (errorCode != RESULT_NORMAL) {
            SJctrError err = new SJctrError(6, 22, errorCode);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        boolean ret = true;
        int errorCode = RESULT_NORMAL;
        this.qdepthModeDataModel = (SJctrQdepthDataModel)this.getDataObjectModel(KEY_QDEPTHINF);
        this.iotovDataModel = (SJctrIoTovDataModel)this.getDataObjectModel(KEY_IOTOVINF);
        this.pathBlkWatchDataModel = (SJctrPathBlkWatchDataModel)this.getDataObjectModel(KEY_PATHBLKSECINF);
        List<?> dat = this.getCache(SJctrEditExtWwnsSubWizard.EDIT_EXT_WWNS_DATA);
        this.exdPhysicalPathList = dat;
        this.exdPhysicalPathMgrList = this.getCache(SJmoGetExdPhysicalPathInfoMgr.class);
        if (this.exdPhysicalPathMgrList == null || this.exdPhysicalPathMgrList.size() == 0) {
            errorCode = EDITEXTWWNS_NOT_FOUND_MODEL;
        }
        if (errorCode == RESULT_NORMAL) {
            this.exdTargetPortMgrList = this.getCache(SJmoGetExdTargetPortInfoMgr.class);
            if (this.exdTargetPortMgrList == null || this.exdTargetPortMgrList.size() == 0) {
                errorCode = EDITEXTWWNS_NOT_FOUND_MODEL;
            } else {
                SJmoExdTargetPortInfoMgr exdTargetPortMgr = this.exdTargetPortMgrList.get(0);
                if (exdTargetPortMgr.getAlExdTargetPortInfo().size() == 0) {
                    errorCode = EDITEXTWWNS_NOT_EQUIP_TARGETPORT;
                }
            }
        }
        if (errorCode == RESULT_NORMAL) {
            this.portDetailList = this.getCache(SJmoGetPortDetail.class);
            if (this.portDetailList == null) {
                errorCode = EDITEXTWWNS_NOT_FOUND_MODEL;
            } else if (this.portDetailList.size() == 0) {
                errorCode = EDITEXTWWNS_NOT_EQUIP_PORTDETAIL;
            }
        }
        if (errorCode == RESULT_NORMAL) {
            List<?> exdPathGroupMgrList = this.getCache(SJmoGetExdPathGroupInfoMgr.class);
            if (exdPathGroupMgrList == null || exdPathGroupMgrList.size() == 0) {
                errorCode = EDITEXTWWNS_NOT_FOUND_MODEL;
            } else {
                SJmoExdPathGroupInfoMgr pathGrpMgr = (SJmoExdPathGroupInfoMgr)exdPathGroupMgrList.get(0);
                this.exdPathGroupList = pathGrpMgr.getAlExdPathGroupInfo();
            }
        }
        if (errorCode == RESULT_NORMAL) {
            List<?> exdVolMgrList = this.getCache(SJmoGetExdVolumeInfoMgr.class);
            if (exdVolMgrList == null || exdVolMgrList.size() == 0) {
                errorCode = EDITEXTWWNS_NOT_FOUND_MODEL;
            } else {
                this.exdVolMgr = (SJmoExdVolumeInfoMgr)exdVolMgrList.get(0);
            }
        }
        if (errorCode == RESULT_NORMAL) {
            SJctrUserController uc = this.getOwner();
            List<?> rsgInfoList = this.getCache(SJmoGetRSGgetAllRsgs.class);
            if (rsgInfoList == null || rsgInfoList.size() == 0) {
                errorCode = EDITEXTWWNS_NOT_FOUND_MODEL;
            } else {
                SJmoRSGgetAllRsgs rsgInfo = (SJmoRSGgetAllRsgs)rsgInfoList.get(0);
                this.rsgUtil = new SJctrResourceGroupUtility(uc, rsgInfo);
            }
        }
        if (errorCode != RESULT_NORMAL) {
            SJctrError err = new SJctrError(6, 22, errorCode);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrDataController parentDC = this.getWizardWindow().getParentDC();
        SJctrTableDataModel parentTbl = (SJctrTableDataModel)parentDC.getDataObjectModel(KEY_TABLE);
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(this.exdPhysicalPathList.size());
        SJmoExdPhysicalPathInfoMgr physicalPathMgr = this.exdPhysicalPathMgrList.get(0);
        SJctrExtUtility extUtil = this.getComUtility().getExtUtility();
        for (SJmoExdPhysicalPathInfo exdPhysicalPath : this.exdPhysicalPathList) {
            boolean result = true;
            SJctrError errInfo = new SJctrError(6, 22, RESULT_NORMAL);
            if (physicalPathMgr.getAlExdPhysicalPathInfo().size() == 0) {
                result = false;
                errInfo.setError(EDITEXTWWNS_NOT_EQUIP_PHYSICALPATH);
            }
            if (result) {
                SJmoPortDetail portDtl = SJctrExtUtility.getPortDtlFromPhysicalPathInfo(exdPhysicalPath, this.portDetailList);
                if (portDtl != null) {
                    errorCode = this.checkPortType(portDtl);
                    if (errorCode != RESULT_NORMAL) {
                        result = false;
                        errInfo.setError(errorCode);
                    }
                } else {
                    SJctrError err = new SJctrError(6, 22, EDITEXTWWNS_NOT_FOUND_MODEL);
                    SJcException exp = err.createException();
                    throw exp;
                }
            }
            if (result) {
                int wwnId = exdPhysicalPath.getRmiExdPhysicalPathInfo().referTargetPortId();
                ArrayList physicalPathListWwn = physicalPathMgr.getAlPhysicalPathInfoOfTargetPortId(wwnId);
                for (SJmoExdPhysicalPathInfo physicalPath : physicalPathListWwn) {
                    if (!this.isUsablePhysicalPathAtPort(physicalPath, this.rsgUtil)) {
                        result = false;
                        errInfo.setError(EDITEXTWWNS_UNUSABLE_RSGPORT);
                        break;
                    }
                    if (this.isUsablePhysicalPathAtExtVol(physicalPath, this.exdVolMgr, this.exdPathGroupList, this.rsgUtil)) continue;
                    result = false;
                    errInfo.setError(EDITEXTWWNS_UNUSABLE_RSGPG);
                    break;
                }
            }
            if (result) continue;
            ret = false;
            SJctrErrorColumnData errData = new SJctrErrorColumnData(exdPhysicalPath, errInfo);
            errList.add(errData);
        }
        this.initTextBox();
        if (!ret) {
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            errDc.setParameter(parentTbl, errList);
            SJctrError representErrorInfo = errDc.getRepresentativeError(errList, 5);
            SJcException exp = representErrorInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        return ret;
    }

    protected int checkPortType(SJmoPortDetail portDtl) {
        int errorCode = RESULT_NORMAL;
        if (SJctrPortUtility.isIscsiPort(portDtl)) {
            errorCode = EDITEXTWWNS_PTTYPE_ISCSI;
        }
        return errorCode;
    }

    private void initTextBox() {
        SJmoExdTargetPortInfoMgr exdTargetPortMgr = this.exdTargetPortMgrList.get(0);
        short qdepth = 0;
        short iotov = 0;
        short pathwatch = 0;
        String qdepthValue = INIT_STRING;
        String iotovValue = INIT_STRING;
        String pathwatchValue = INIT_STRING;
        SJmoExdPhysicalPathInfo physicalPath = this.exdPhysicalPathList.get(0);
        int wwnId = physicalPath.getRmiExdPhysicalPathInfo().referTargetPortId();
        SJmoExdTargetPortInfo targetPort = exdTargetPortMgr.getExdTargetPortInfo(wwnId);
        EXDTargetPort_Fiber port = (EXDTargetPort_Fiber)targetPort.getRmiExdTargetPortInfo();
        qdepth = port.getQdepth();
        qdepthValue = Short.toString(qdepth);
        iotov = port.getIoTov();
        iotovValue = Short.toString(iotov);
        pathwatch = port.getPathWatch();
        pathwatchValue = Short.toString(pathwatch);
        for (SJmoExdPhysicalPathInfo selectData : this.exdPhysicalPathList) {
            SJmoExdPhysicalPathInfo physicalPath2 = selectData;
            int wwnId2 = physicalPath2.getRmiExdPhysicalPathInfo().referTargetPortId();
            SJmoExdTargetPortInfo targetPort2 = exdTargetPortMgr.getExdTargetPortInfo(wwnId2);
            EXDTargetPort_Fiber port2 = (EXDTargetPort_Fiber)targetPort2.getRmiExdTargetPortInfo();
            if (qdepth != port2.getQdepth()) {
                qdepthValue = INIT_STRING;
            }
            if (iotov != port2.getIoTov()) {
                iotovValue = INIT_STRING;
            }
            if (pathwatch == port2.getPathWatch()) continue;
            pathwatchValue = INIT_STRING;
        }
        this.qdepthModeDataModel.setDisplayQepth(qdepthValue);
        this.iotovDataModel.setDisplayIoTov(iotovValue);
        this.pathBlkWatchDataModel.setDisplayPathBlkWatch(pathwatchValue);
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        if (!(this.qdepthModeDataModel.isSelectCheckBox() || this.iotovDataModel.isSelectCheckBox() || this.pathBlkWatchDataModel.isSelectCheckBox())) {
            ret = false;
            return ret;
        }
        SJmoExdTargetPortInfoMgr exdTargetPortMgr = this.exdTargetPortMgrList.get(0);
        ArrayList<SJmoExdTargetPortInfo> createTargetPortList = new ArrayList<SJmoExdTargetPortInfo>();
        Iterator<SJmoExdPhysicalPathInfo> i$ = this.exdPhysicalPathList.iterator();
        while (i$.hasNext()) {
            SJmoExdPhysicalPathInfo selectData;
            SJmoExdPhysicalPathInfo physicalPath = selectData = i$.next();
            int wwnId = physicalPath.getRmiExdPhysicalPathInfo().referTargetPortId();
            SJmoExdTargetPortInfo targetPort = exdTargetPortMgr.getExdTargetPortInfo(wwnId);
            SJmoExdTargetPortInfo createTargetPort = null;
            try {
                createTargetPort = (SJmoExdTargetPortInfo)targetPort.clone();
            }
            catch (CloneNotSupportedException e) {
                this.getLogUty().putlog("selectPhysicalPath", "TargetPortInfo clone fail", e, 40000);
                continue;
            }
            EXDTargetPort_Fiber updatePort = (EXDTargetPort_Fiber)createTargetPort.getRmiExdTargetPortInfo();
            if (this.qdepthModeDataModel.isSelectCheckBox()) {
                updatePort.setQdepth(this.qdepthModeDataModel.getQepth());
            }
            if (this.iotovDataModel.isSelectCheckBox()) {
                updatePort.setIoTov(this.iotovDataModel.getIoTov());
            }
            if (this.pathBlkWatchDataModel.isSelectCheckBox()) {
                updatePort.setPathWatch(this.pathBlkWatchDataModel.getPathBlkWatch());
            }
            createTargetPortList.add(createTargetPort);
        }
        SJmoExdTargetPortInfoMgr createTargetPortMgr = new SJmoExdTargetPortInfoMgr(createTargetPortList);
        ArrayList<SJmoExdTargetPortInfoMgr> createTargetPortMgrList = new ArrayList<SJmoExdTargetPortInfoMgr>();
        createTargetPortMgrList.add(createTargetPortMgr);
        SJctrEditExtWwnsConfirmData confirmData = new SJctrEditExtWwnsConfirmData();
        confirmData.setExdPhysicalPathInfo(this.exdPhysicalPathList);
        confirmData.setExdTargetPortInfoMgr(createTargetPortMgrList);
        confirmData.setPortDetail(this.portDetailList);
        ArrayList<SJctrEditExtWwnsConfirmData> confirmDataList = new ArrayList<SJctrEditExtWwnsConfirmData>();
        confirmDataList.add(confirmData);
        this.putCache(SJctrEditExtWwnsConfirmData.class, confirmDataList);
        return ret;
    }

    private int checkTextBoxData() {
        int result = 0;
        if (this.qdepthModeDataModel.getQepth() < 2 || 128 < this.qdepthModeDataModel.getQepth()) {
            return EDITEXTWWNS_INPUT_INVALID_DATA;
        }
        if (this.iotovDataModel.getIoTov() < 5 || 240 < this.iotovDataModel.getIoTov()) {
            return EDITEXTWWNS_INPUT_INVALID_DATA;
        }
        if (this.pathBlkWatchDataModel.getPathBlkWatch() < 5 || 180 < this.pathBlkWatchDataModel.getPathBlkWatch()) {
            return EDITEXTWWNS_INPUT_INVALID_DATA;
        }
        return result;
    }

    private void initManager() {
        this.addManager(SJctrTargetPortManager.class);
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdPhysicalPathInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdTargetPortInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdPathGroupInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdVolumeInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    boolean isUsablePhysicalPathAtPort(SJmoExdPhysicalPathInfo physicalPath, SJctrResourceGroupUtility rsgUtil) {
        boolean result = true;
        SJmoPortIndex portIndex = new SJmoPortIndex();
        portIndex.setSPort((short)physicalPath.getRmiExdPhysicalPathInfo().referInitiatorPortId());
        ArrayList<SJmoPortIndex> portList = new ArrayList<SJmoPortIndex>();
        portList.add(portIndex);
        if (rsgUtil.extractImpossiblePort(portList).size() > 0) {
            result = false;
        }
        return result;
    }

    boolean isUsablePhysicalPathAtExtVol(SJmoExdPhysicalPathInfo physicalPath, SJmoExdVolumeInfoMgr exdVolMgr, List<SJmoExdPathGroupInfo> pathGrpList, SJctrResourceGroupUtility rsgUtil) {
        boolean result = true;
        SJctrExtUtility extUtil = this.getComUtility().getExtUtility();
        int physicalPathId = physicalPath.getRmiExdPhysicalPathInfo().getId();
        List<SJmoExdPathGroupInfo> pathGrpphysicalPathList = extUtil.getPathGroupListPhysicalPath(pathGrpList, physicalPathId);
        ArrayList<SJmoPgIndex> pgList = new ArrayList<SJmoPgIndex>(SJctrExtUtility.SUBSYSTEM_MAPVOL_MAX);
        ArrayList ldevList = new ArrayList(SJmoDataMacro_IF.MAX_LDEV_LDKC);
        for (SJmoExdPathGroupInfo pathgrp : pathGrpphysicalPathList) {
            int pathGrpId = pathgrp.getRmiExdPathGroupInfo().getPathGroupID();
            SJmoExdVolumeInfoOnPathGroup exdVolonPathGrp = exdVolMgr.getExdVolumeInfoOnPathGroup(pathGrpId);
            ArrayList exdVolInfoList = exdVolonPathGrp.getAlExdVolumeInfo();
            for (SJmoExdVolumeInfo exdVol : exdVolInfoList) {
                int fb4 = exdVol.getRmiExdVolumeInfo().getIFB4();
                int pg = exdVol.getRmiExdVolumeInfo().getIPG();
                SJmoPgIndex pgIndex = new SJmoPgIndex();
                pgIndex.setFB4(fb4);
                pgIndex.setPG(pg);
                pgList.add(pgIndex);
            }
        }
        if (rsgUtil.extractImpossiblePg(pgList).size() > 0) {
            result = false;
        }
        return result;
    }
}

