/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.volumemigration.migratevolumes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrVolumeMigrationUtility;
import sanproject.sn2.controller.com.comparator.SJctrErrorColumnDataComparator;
import sanproject.sn2.controller.wizard.volumemigration.migratevolumes.SJctrAvailableTargetVolsData;
import sanproject.sn2.controller.wizard.volumemigration.migratevolumes.SJctrAvailableVolumesData;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoPgIndex;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;

public class SJctrAvailableSourceVolsData
extends SJctrAvailableVolumesData {
    private HashMap<String, Object> pgPoolMap = new HashMap();
    private boolean bExist = true;
    private List<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>();
    private List<?> transLdevList = null;
    private boolean bOpenVolFlg = false;
    private boolean bMFVolFlg = false;
    private List<SJmoPoolDetail> beforePoolList = null;

    public SJctrAvailableSourceVolsData(List<SJmoHDPRelation> dpVolList, SJctrComUtility comUtil, List<?> transLdevList, List<SJmoPgScatteredInfo> pgScatList, List<SJmoLdevDetail> ldevDtlList, List<SJmoPoolDetail> poolList) {
        super(dpVolList, comUtil, pgScatList, ldevDtlList);
        this.transLdevList = transLdevList;
        this.beforePoolList = poolList;
    }

    @Override
    public void addVolData(SJmoLdevDetail addSrcLdev, SJmoLdevDetail addTargetLdev) {
        if (addSrcLdev == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "addVolData", "addSrcLdev null.");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (addTargetLdev == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "addVolData", "addTargetLdev null.");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        this.addVolData(addSrcLdev);
        this.addVolData(addTargetLdev);
    }

    protected void addVolData(SJmoLdevDetail addLdev) {
        int iPoint = Collections.binarySearch(this.delVolList, addLdev);
        if (iPoint >= 0) {
            this.setPgPoolData(addLdev, this.pgPoolMap, 0);
            this.delVolList.remove(iPoint);
        }
    }

    @Override
    public void removeVolData(SJmoLdevDetail removeSrcLdev, SJmoLdevDetail removeTargetLdev) {
        if (removeSrcLdev == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "removeVolData", "removeSrcLdev null.");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (removeTargetLdev == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "removeVolData", "removeTargetLdev null.");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        String keySrcPgPoolKey = this.getPgPoolIDKey(removeSrcLdev);
        String keyTargetPgPoolKey = this.getPgPoolIDKey(removeTargetLdev);
        this.removePgPoolData(removeSrcLdev, keySrcPgPoolKey, this.pgPoolMap, 0);
        this.removePgPoolData(removeTargetLdev, keyTargetPgPoolKey, this.pgPoolMap, 0);
    }

    public HashMap<String, Object> getAvailableSrcVolMap() {
        HashMap clnMap = (HashMap)this.pgPoolMap.clone();
        return clnMap;
    }

    public List<SJmoLdevDetail> getAvailableLdevList(String strKey) {
        ArrayList<SJmoLdevDetail> ldevList = new ArrayList<SJmoLdevDetail>();
        HashMap srcVolMap = (HashMap)this.pgPoolMap.clone();
        if (srcVolMap.containsKey(strKey)) {
            ldevList = new ArrayList((List)srcVolMap.get(strKey));
        }
        return ldevList;
    }

    public void execSrcVolFilter(SJctrAvailableTargetVolsData targetVolData) {
        if (targetVolData == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "execSrcVolFilter", "targetVolData null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        HashMap<String, Object> targetVolMap = targetVolData.getAvailableVolDataMap();
        if (targetVolMap == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "execSrcVolFilter", "targetVolMap null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (this.availableVolDataMap.isEmpty()) {
            this.bExist = false;
            return;
        }
        if (targetVolMap.isEmpty()) {
            this.bExist = false;
            Set keySet = this.availableVolDataMap.keySet();
            for (String strKey : keySet) {
                this.makeErrList(this.availableVolDataMap, strKey);
            }
            SJctrErrorColumnDataComparator COMPARATOR = new SJctrErrorColumnDataComparator();
            Collections.sort(this.errList, COMPARATOR);
            this.availableVolDataMap.clear();
            return;
        }
        Iterator iterator = this.availableVolDataMap.keySet().iterator();
        while (iterator.hasNext()) {
            String strKey = (String)iterator.next();
            if (!targetVolMap.containsKey(strKey)) {
                this.makeErrList(this.availableVolDataMap, strKey);
                iterator.remove();
                continue;
            }
            HashMap srcPgDpMap = (HashMap)this.availableVolDataMap.get(strKey);
            HashMap targetPgDpMap = (HashMap)targetVolMap.get(strKey);
            this.execDpPgFilter(srcPgDpMap, targetPgDpMap, targetVolData);
            if (!srcPgDpMap.isEmpty()) continue;
            iterator.remove();
        }
        if (this.availableVolDataMap.isEmpty()) {
            this.bExist = false;
        }
        SJctrErrorColumnDataComparator COMPARATOR = new SJctrErrorColumnDataComparator();
        Collections.sort(this.errList, COMPARATOR);
        if (this.errList.isEmpty() && this.bExist) {
            this.changeSoruceVolData();
        }
    }

    private void execDpPgFilter(HashMap<String, Object> srcPgDpMap, HashMap<String, Object> targetPgDpMap, SJctrAvailableTargetVolsData targetVolData) {
        HashSet<String> srcPgDpKeySet = new HashSet<String>(srcPgDpMap.keySet());
        for (String strSrcPgDpKey : srcPgDpKeySet) {
            HashMap targetPoolMap;
            boolean bPermit;
            HashMap<String, Object> tmpTargetPgDpMap = new HashMap<String, Object>(targetPgDpMap);
            if (!strSrcPgDpKey.equals(this.comUtil.getGuidance("THP"))) {
                HashSet<String> deletePGList = new HashSet<String>();
                ArrayList ldevList = (ArrayList)srcPgDpMap.get(strSrcPgDpKey);
                SJmoLdevDetail ldev = (SJmoLdevDetail)ldevList.get(0);
                if (ldev.getbNormalVolume()) {
                    SJmoPgIndex chkPGIndex = new SJmoPgIndex();
                    chkPGIndex.setFB4(ldev.getIFB4());
                    chkPGIndex.setPG(ldev.getIPG());
                    ArrayList<String> deleteList = SJctrVolumeMigrationUtility.getPGScatteredKeyList(chkPGIndex, this.pgScatList, this.comUtil);
                    if (!deleteList.isEmpty()) {
                        deletePGList.addAll(deleteList);
                    }
                }
                if (tmpTargetPgDpMap.containsKey(strSrcPgDpKey)) {
                    deletePGList.add(strSrcPgDpKey);
                }
                for (String pgInfo : deletePGList) {
                    if (!tmpTargetPgDpMap.containsKey(pgInfo.toString())) continue;
                    tmpTargetPgDpMap.remove(pgInfo.toString());
                }
                if (tmpTargetPgDpMap.isEmpty()) {
                    this.makeErrList(srcPgDpMap, strSrcPgDpKey);
                    srcPgDpMap.remove(strSrcPgDpKey);
                    continue;
                }
            }
            if (!this.isContinue(tmpTargetPgDpMap) || (bPermit = this.checkPool(targetPoolMap = (HashMap)tmpTargetPgDpMap.get(this.comUtil.getGuidance("THP")), srcPgDpMap, targetVolData, strSrcPgDpKey))) continue;
            srcPgDpMap.remove(strSrcPgDpKey);
        }
    }

    private boolean isContinue(HashMap<String, Object> targetPgDpMap) {
        boolean bRet = false;
        if (targetPgDpMap.size() == 1 && targetPgDpMap.containsKey(this.comUtil.getGuidance("THP"))) {
            bRet = true;
        }
        return bRet;
    }

    private boolean checkPool(HashMap<String, Object> targetPoolMap, HashMap<String, Object> srcPgDpMap, SJctrAvailableTargetVolsData targetVolData, String strSrcPgDpKey) {
        boolean bPermitFlg = true;
        if (targetPoolMap.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkPool", "targetPoolMap empty");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (strSrcPgDpKey.equals(this.comUtil.getGuidance("THP"))) {
            HashMap poolMap = (HashMap)srcPgDpMap.get(strSrcPgDpKey);
            HashSet poolKeySet = new HashSet(poolMap.keySet());
            Iterator i$ = poolKeySet.iterator();
            while (i$.hasNext()) {
                HashMap<String, Object> tmpTargetPoolMap = new HashMap<String, Object>(targetPoolMap);
                String poolKey = (String)i$.next();
                if (tmpTargetPoolMap.containsKey(poolKey)) {
                    if (tmpTargetPoolMap.size() == 1) {
                        this.makeErrList(poolMap, poolKey);
                        poolMap.remove(poolKey);
                        continue;
                    }
                    tmpTargetPoolMap.remove(poolKey);
                }
                List poolLdevList = (List)poolMap.get(poolKey);
                this.execPoolUsedFilter(poolLdevList, tmpTargetPoolMap, targetVolData, poolKey);
                if (!poolLdevList.isEmpty()) continue;
                poolMap.remove(poolKey);
            }
            if (poolMap.isEmpty()) {
                bPermitFlg = false;
            }
        } else {
            List pgLdevList = (List)srcPgDpMap.get(strSrcPgDpKey);
            this.execPoolUsedFilter(pgLdevList, new HashMap<String, Object>(targetPoolMap), targetVolData, "");
            if (pgLdevList.isEmpty()) {
                bPermitFlg = false;
            }
        }
        return bPermitFlg;
    }

    private void execPoolUsedFilter(List<SJmoLdevDetail> modList, HashMap<String, Object> tmpTargetPoolMap, SJctrAvailableTargetVolsData targetVolData, String strSrcPoolKey) {
        ArrayList<SJmoLdevDetail> loopList = new ArrayList<SJmoLdevDetail>(modList);
        for (SJmoLdevDetail ldev : loopList) {
            boolean bPermitFlg = false;
            HashSet<String> poolMapKeySet = new HashSet<String>(tmpTargetPoolMap.keySet());
            block1: for (String targetPoolPgKey : poolMapKeySet) {
                SJmoPoolDetail targetPoolInfo = targetVolData.makePermissionPoolInfo(targetPoolPgKey);
                ArrayList targetLdevList = new ArrayList((ArrayList)tmpTargetPoolMap.get(targetPoolPgKey));
                for (SJmoLdevDetail targetLdevDetail : targetLdevList) {
                    int iTargetStart;
                    long lSrcLdevPage = this.comUtil.getVmUtility().getAddSrcVolLdevPages(ldev, targetLdevDetail, targetPoolInfo, this.dpVolList, this.comUtil);
                    targetPoolInfo.setPoolUsedPages(targetPoolInfo.getPoolUsedPages() + lSrcLdevPage);
                    double poolUsedPercent = SJctrVolumeMigrationUtility.getDPoolUsedPercent(targetPoolInfo);
                    targetPoolInfo.setPoolUsedPages(targetPoolInfo.getPoolUsedPages() - lSrcLdevPage);
                    double poolUsedBasicPercent = 0.0;
                    if (SJctrVolumeMigrationUtility.chkPoolVirtMode(targetPoolInfo.getPoolId(), this.m_lsLdevDtl) && (iTargetStart = Collections.binarySearch(this.beforePoolList, targetPoolInfo)) >= 0) {
                        SJmoPoolDetail startPool = this.beforePoolList.get(iTargetStart);
                        long lBeforBasicPage = startPool.getLPoolActualUsedPages();
                        long lNowBasicPage = targetPoolInfo.getLPoolActualUsedPages();
                        long lDiffBasicPage = lNowBasicPage - lBeforBasicPage;
                        long lMinSrcLdevPage = (lDiffBasicPage + lSrcLdevPage) / 16L;
                        if ((lDiffBasicPage + lSrcLdevPage) % 16L != 0L) {
                            ++lMinSrcLdevPage;
                        }
                        targetPoolInfo.setLPoolActualUsedPages(startPool.getLPoolActualUsedPages() + lMinSrcLdevPage);
                        poolUsedBasicPercent = SJctrVolumeMigrationUtility.getDPoolBasicUsedPercent(targetPoolInfo);
                        targetPoolInfo.setLPoolActualUsedPages(lNowBasicPage);
                    }
                    if (!(poolUsedPercent < 100.0) || !(poolUsedBasicPercent < 100.0)) continue;
                    bPermitFlg = true;
                    continue block1;
                }
            }
            if (bPermitFlg) continue;
            int iPoint = Collections.binarySearch(modList, ldev);
            modList.remove(iPoint);
            if (this.transLdevList.isEmpty()) continue;
            SJctrErrorColumnData errData = SJctrVolumeMigrationUtility.makeVMCtrlErrColumnData(206096, ldev);
            this.errList.add(errData);
        }
    }

    private void changeSoruceVolData() {
        Set emuCapaKeySet = this.availableVolDataMap.keySet();
        List<SJmoLdevDetail> tmpLdevList = null;
        for (String strEmuCapaKey : emuCapaKeySet) {
            Map tmpPgDpMap = (Map)this.availableVolDataMap.get(strEmuCapaKey);
            Set dpPgKeySet = tmpPgDpMap.keySet();
            for (String dpPgKey : dpPgKeySet) {
                tmpLdevList = dpPgKey.equals(this.comUtil.getGuidance("THP")) ? SJctrVolumeMigrationUtility.getAvailableDpVolList((Map)tmpPgDpMap.get(dpPgKey)) : (List<SJmoLdevDetail>)tmpPgDpMap.get(dpPgKey);
                List<SJmoLdevDetail> ldevList = null;
                if (this.pgPoolMap.containsKey(dpPgKey)) {
                    ldevList = (List)this.pgPoolMap.get(dpPgKey);
                } else {
                    ldevList = new ArrayList();
                    this.pgPoolMap.put(dpPgKey, ldevList);
                }
                for (SJmoLdevDetail addData : tmpLdevList) {
                    int iPoint = Collections.binarySearch(ldevList, addData);
                    if (iPoint < 0) {
                        iPoint = -iPoint - 1;
                        ldevList.add(iPoint, addData);
                        continue;
                    }
                    throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
                }
            }
        }
        this.setOpenMfFlg();
        this.availableVolDataMap.clear();
        this.availableVolDataMap = null;
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        if (this.pgPoolMap != null) {
            this.pgPoolMap.clear();
            this.pgPoolMap = null;
        }
    }

    private void makeErrList(HashMap<String, Object> volMap, String strKey) {
        if (this.transLdevList.isEmpty()) {
            return;
        }
        if (volMap.get(strKey) instanceof Map) {
            Set keySet = ((Map)volMap.get(strKey)).keySet();
            for (String strNextKey : keySet) {
                this.makeErrList((HashMap)volMap.get(strKey), strNextKey);
            }
        } else {
            List ldevList = (List)volMap.get(strKey);
            for (SJmoLdevDetail ldev : ldevList) {
                SJctrErrorColumnData errData = SJctrVolumeMigrationUtility.makeVMCtrlErrColumnData(206096, ldev);
                this.errList.add(errData);
            }
        }
    }

    public List<SJctrErrorColumnData> getErrList() {
        return this.errList;
    }

    public boolean isBExist() {
        return this.bExist;
    }

    private void setOpenMfFlg() {
        boolean bOpenFlg = false;
        boolean bMfFlg = false;
        HashMap srcVolMap = this.availableVolDataMap;
        Iterator iterator = srcVolMap.keySet().iterator();
        while (iterator.hasNext()) {
            SJmoLdevDetail chkLdevDetail = new SJmoLdevDetail();
            String strKey = (String)iterator.next();
            HashMap emuCapaMap = (HashMap)srcVolMap.get(strKey);
            for (String strEmuKey : emuCapaMap.keySet()) {
                if (strEmuKey.equals(this.comUtil.getGuidance("THP"))) {
                    HashMap dpMap = (HashMap)emuCapaMap.get(strEmuKey);
                    Iterator poolIterator = dpMap.keySet().iterator();
                    if (poolIterator.hasNext()) {
                        String strPoolKey = (String)poolIterator.next();
                        ArrayList ldevList = (ArrayList)dpMap.get(strPoolKey);
                        chkLdevDetail = (SJmoLdevDetail)ldevList.get(0);
                    }
                } else {
                    ArrayList ldevList = (ArrayList)emuCapaMap.get(strEmuKey);
                    chkLdevDetail = (SJmoLdevDetail)ldevList.get(0);
                }
                if (SJctrLdevUtility.isOpenVolume(chkLdevDetail)) {
                    bOpenFlg = true;
                    continue;
                }
                if (!SJctrLdevUtility.isMFVolume(chkLdevDetail)) continue;
                bMfFlg = true;
            }
            if (!bOpenFlg || !bMfFlg) continue;
            break;
        }
        this.setBOpenVolFlg(bOpenFlg);
        this.setBMFVolFlg(bMfFlg);
    }

    public boolean isBOpenVolFlg() {
        return this.bOpenVolFlg;
    }

    public void setBOpenVolFlg(boolean openVolFlg) {
        this.bOpenVolFlg = openVolFlg;
    }

    public boolean isBMFVolFlg() {
        return this.bMFVolFlg;
    }

    public void setBMFVolFlg(boolean volFlg) {
        this.bMFVolFlg = volFlg;
    }
}

