/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.volumemigration.migratevolumes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrVolumeMigrationUtility;
import sanproject.sn2.controller.wizard.volumemigration.migratevolumes.SJctrAvailableVolumesData;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.util.SJmoDataUtility;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoPgIndex;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;

public class SJctrAvailableTargetVolsData
extends SJctrAvailableVolumesData {
    protected List<SJmoPoolDetail> poolList = null;
    protected List<SJmoPoolDetail> beforePoolList = null;
    protected Set<Integer> NfCompUsedPoolIds = null;

    private boolean chkNfCompUsedPoolId(int iPoolID, List<SJmoLdevDetail> ldevlist) {
        if (this.NfCompUsedPoolIds == null) {
            this.NfCompUsedPoolIds = new HashSet<Integer>();
            for (SJmoLdevDetail ldevDetail : ldevlist) {
                if (!ldevDetail.getbPoolVol() || !ldevDetail.getBVirtMode()) continue;
                this.NfCompUsedPoolIds.add(Integer.valueOf(ldevDetail.getSPoolID()));
            }
        }
        return this.NfCompUsedPoolIds.contains(iPoolID);
    }

    public SJctrAvailableTargetVolsData(List<SJmoHDPRelation> dpVolList, SJctrComUtility comUtil, List<SJmoPoolDetail> poolList, List<SJmoPgScatteredInfo> pgScatList, List<SJmoLdevDetail> ldvDtlList) {
        super(dpVolList, comUtil, pgScatList, ldvDtlList);
        if (poolList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "constructor", "poolList null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        this.poolList = SJmoDataUtility.alDeepCopy(new ArrayList<SJmoPoolDetail>(poolList));
        this.beforePoolList = SJmoDataUtility.alDeepCopy(new ArrayList<SJmoPoolDetail>(poolList));
    }

    @Override
    public void addVolData(SJmoLdevDetail addSrcLdev, SJmoLdevDetail addTargetLdev) {
        if (addSrcLdev == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "addVolData", "addSrcLdev null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (addTargetLdev == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "addVolData", "addTargetLdev null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        this.addVolData(addSrcLdev);
        if (this.addVolData(addTargetLdev) && addTargetLdev.getByVolumeType() == 3) {
            this.setPoolUsed(addSrcLdev, addTargetLdev, true);
        }
    }

    protected boolean addVolData(SJmoLdevDetail addLdev) {
        boolean bAdd = false;
        int iPoint = Collections.binarySearch(this.delVolList, addLdev);
        if (iPoint >= 0) {
            this.setVolData(addLdev, 1);
            this.delVolList.remove(iPoint);
            bAdd = true;
        }
        return bAdd;
    }

    @Override
    public void removeVolData(SJmoLdevDetail removeSrcLdev, SJmoLdevDetail removeTargetLdev) {
        String keyTargetStr;
        if (removeSrcLdev == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "removeVolData", "removeSrcLdev null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (removeTargetLdev == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "removeVolData", "removeTargetLdev null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        String keySrcStr = SJctrVolumeMigrationUtility.getStrEmuCapaKey(removeSrcLdev, this.comUtil);
        if (!keySrcStr.equals(keyTargetStr = SJctrVolumeMigrationUtility.getStrEmuCapaKey(removeTargetLdev, this.comUtil))) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "removeVolData", "Key Disagreement");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        HashMap emuCapaMap = (HashMap)this.availableVolDataMap.get(keySrcStr);
        String keySrcPgPoolKey = this.getPgPoolIDKey(removeSrcLdev);
        String keyTargetPgPoolKey = this.getPgPoolIDKey(removeTargetLdev);
        this.removePgPoolData(removeSrcLdev, keySrcPgPoolKey, emuCapaMap, 1);
        if (this.removePgPoolData(removeTargetLdev, keyTargetPgPoolKey, emuCapaMap, 1) && removeTargetLdev.getByVolumeType() == 3) {
            this.setPoolUsed(removeSrcLdev, removeTargetLdev, false);
        }
    }

    private void setPoolUsed(SJmoLdevDetail srcLdev, SJmoLdevDetail targetLdev, boolean bSubtraction) {
        int iPoint = Collections.binarySearch(this.dpVolList, targetLdev);
        if (iPoint < 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "setPoolUsed", "target DP-VOL Info nothing.");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        SJmoHDPRelation dpVol = (SJmoHDPRelation)this.dpVolList.get(iPoint);
        SJmoPoolIndex compPoolIdx = new SJmoPoolIndex();
        compPoolIdx.setPoolId(dpVol.getIPoolId());
        int iPoolPoint = Collections.binarySearch(this.poolList, compPoolIdx);
        if (iPoolPoint < 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "setPoolUsed", "target Pool Info nothing.");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        SJmoPoolDetail poolDtl = this.poolList.get(iPoolPoint);
        long lSrcLdevPage = this.comUtil.getVmUtility().getAddSrcVolLdevPages(srcLdev, targetLdev, poolDtl, this.dpVolList, this.comUtil);
        if (bSubtraction) {
            poolDtl.setPoolUsedPages(poolDtl.getPoolUsedPages() - lSrcLdevPage);
            poolDtl.setLPoolActualUsedPages(poolDtl.getLPoolActualUsedPages() - lSrcLdevPage);
        } else {
            poolDtl.setPoolUsedPages(poolDtl.getPoolUsedPages() + lSrcLdevPage);
            poolDtl.setLPoolActualUsedPages(poolDtl.getLPoolActualUsedPages() + lSrcLdevPage);
        }
    }

    public List<SJmoLdevDetail> getAvailableLdevList(SJmoLdevDetail srcldev, String strKey) {
        List<SJmoLdevDetail> ldevList = new ArrayList<SJmoLdevDetail>();
        HashMap<String, Object> targetVolMap = this.getAvailableLdevMap(srcldev);
        if (targetVolMap.containsKey(strKey)) {
            if (strKey.equals(this.comUtil.getGuidance("THP"))) {
                Map ldevMap = (Map)targetVolMap.get(strKey);
                ldevList = SJctrVolumeMigrationUtility.getAvailableDpVolList(ldevMap);
            } else {
                ldevList = (List)targetVolMap.get(strKey);
            }
        }
        return ldevList;
    }

    public HashMap<String, Object> getAvailableLdevMap(SJmoLdevDetail srcVolData) {
        HashMap<String, Object> availableVolMap = new HashMap<String, Object>();
        String strEmuCapaKey = SJctrVolumeMigrationUtility.getStrEmuCapaKey(srcVolData, this.comUtil);
        if (this.availableVolDataMap.containsKey(strEmuCapaKey)) {
            availableVolMap = new HashMap((HashMap)this.availableVolDataMap.get(strEmuCapaKey));
            HashSet<String> deletePGList = new HashSet<String>();
            String strPgPoolKey = this.getPgPoolIDKey(srcVolData);
            if (srcVolData.getbNormalVolume()) {
                SJmoPgIndex chkPGIndex = new SJmoPgIndex();
                chkPGIndex.setFB4(srcVolData.getIFB4());
                chkPGIndex.setPG(srcVolData.getIPG());
                ArrayList<String> deleteList = SJctrVolumeMigrationUtility.getPGScatteredKeyList(chkPGIndex, this.pgScatList, this.comUtil);
                if (!deleteList.isEmpty()) {
                    deletePGList.addAll(deleteList);
                }
            }
            if (availableVolMap.containsKey(strPgPoolKey)) {
                deletePGList.add(strPgPoolKey);
            }
            for (String pgInfo : deletePGList) {
                if (!availableVolMap.containsKey(pgInfo.toString())) continue;
                availableVolMap.remove(pgInfo.toString());
            }
            if (availableVolMap.containsKey(this.comUtil.getGuidance("THP"))) {
                HashMap<String, Object> poolMap = new HashMap<String, Object>((HashMap)availableVolMap.get(this.comUtil.getGuidance("THP")));
                this.poolFilter(poolMap, strPgPoolKey, srcVolData);
                if (poolMap.isEmpty()) {
                    availableVolMap.remove(this.comUtil.getGuidance("THP"));
                } else {
                    availableVolMap.put(this.comUtil.getGuidance("THP"), poolMap);
                }
            }
        }
        return availableVolMap;
    }

    public List<SJmoPoolDetail> makePermissionPoolInfo(Set<String> poolPgKeySet) {
        if (poolPgKeySet == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "makePermissionPoolInfo", "poolPgKeySet null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (poolPgKeySet.isEmpty()) {
            return new ArrayList<SJmoPoolDetail>();
        }
        ArrayList<SJmoPoolDetail> tmpList = new ArrayList<SJmoPoolDetail>();
        for (String targetPoolPgKey : poolPgKeySet) {
            if (targetPoolPgKey.indexOf("POOLID") == -1) continue;
            String strID = targetPoolPgKey.substring("POOLID".length());
            int iPoolId = Integer.parseInt(strID);
            SJmoPoolIndex poolComp = new SJmoPoolIndex();
            poolComp.setPoolId(iPoolId);
            int iPoint = Collections.binarySearch(this.beforePoolList, poolComp);
            if (iPoint < 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "makePermissionPoolInfo", "poolData nothing");
                throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
            }
            SJmoPoolDetail poolDtl = this.poolList.get(iPoint);
            try {
                tmpList.add((SJmoPoolDetail)poolDtl.clone());
            }
            catch (CloneNotSupportedException e) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "makePermissionPoolInfo", "poolData nothing", e);
            }
        }
        return tmpList;
    }

    public SJmoPoolDetail makePermissionPoolInfo(String poolPgKey) {
        if (poolPgKey == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "makePermissionPoolInfo(String)", "poolPgKey null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        SJmoPoolDetail poolDtl = new SJmoPoolDetail();
        if (poolPgKey.indexOf("POOLID") != -1) {
            String strID = poolPgKey.substring("POOLID".length());
            int iPoolId = Integer.parseInt(strID);
            SJmoPoolIndex poolComp = new SJmoPoolIndex();
            poolComp.setPoolId(iPoolId);
            int iPoint = Collections.binarySearch(this.beforePoolList, poolComp);
            if (iPoint < 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "makePermissionPoolInfo(String)", "poolData nothing");
                throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
            }
            try {
                poolDtl = (SJmoPoolDetail)this.poolList.get(iPoint).clone();
            }
            catch (CloneNotSupportedException e) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "makePermissionPoolInfo(String)", "poolData nothing", e);
            }
        }
        return poolDtl;
    }

    private void poolFilter(HashMap<String, Object> poolMap, String strSrcPgPoolKey, SJmoLdevDetail srcVolData) {
        poolMap.remove(strSrcPgPoolKey);
        HashSet<String> poolMapKeySet = new HashSet<String>(poolMap.keySet());
        for (String targetPoolPgKey : poolMapKeySet) {
            SJmoPoolDetail poolInfo = this.makePermissionPoolInfo(targetPoolPgKey);
            ArrayList targetTmpLdevList = new ArrayList((ArrayList)poolMap.get(targetPoolPgKey));
            for (SJmoLdevDetail targetLdevDetail : targetTmpLdevList) {
                int iTargetStart;
                long lSrcVolPages = this.comUtil.getVmUtility().getAddSrcVolLdevPages(srcVolData, targetLdevDetail, poolInfo, this.dpVolList, this.comUtil);
                poolInfo.setPoolUsedPages(poolInfo.getPoolUsedPages() + lSrcVolPages);
                double poolUsedPercent = SJctrVolumeMigrationUtility.getDPoolUsedPercent(poolInfo);
                poolInfo.setPoolUsedPages(poolInfo.getPoolUsedPages() - lSrcVolPages);
                double poolUsedBasicPercent = 0.0;
                boolean chkVirtResult = this.chkNfCompUsedPoolId(poolInfo.getPoolId(), this.m_lsLdevDtl);
                if (chkVirtResult && (iTargetStart = Collections.binarySearch(this.beforePoolList, poolInfo)) >= 0) {
                    SJmoPoolDetail startPool = this.beforePoolList.get(iTargetStart);
                    long lBeforBasicPage = startPool.getLPoolActualUsedPages();
                    long lNowBasicPage = poolInfo.getLPoolActualUsedPages();
                    long lDiffBasicPage = lNowBasicPage - lBeforBasicPage;
                    long lMinSrcLdevPage = (lDiffBasicPage + lSrcVolPages) / 16L;
                    if ((lDiffBasicPage + lSrcVolPages) % 16L != 0L) {
                        ++lMinSrcLdevPage;
                    }
                    poolInfo.setLPoolActualUsedPages(startPool.getLPoolActualUsedPages() + lMinSrcLdevPage);
                    poolUsedBasicPercent = SJctrVolumeMigrationUtility.getDPoolBasicUsedPercent(poolInfo);
                    poolInfo.setLPoolActualUsedPages(lNowBasicPage);
                }
                if (!(poolUsedPercent >= 100.0) && !(poolUsedBasicPercent >= 100.0)) continue;
                ArrayList targetLdevList = new ArrayList((ArrayList)poolMap.get(targetPoolPgKey));
                int iPoint = Collections.binarySearch(targetLdevList, targetLdevDetail);
                if (iPoint < 0) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "poolFilter", "target DP-VOL Info nothing.");
                    throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
                }
                targetLdevList.remove(iPoint);
                if (targetLdevList.size() == 0) {
                    poolMap.remove(targetPoolPgKey);
                    continue;
                }
                poolMap.put(targetPoolPgKey, targetLdevList);
            }
        }
    }

    public List<SJmoPoolDetail> getPoolList() {
        return this.poolList;
    }
}

