/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.volumemigration.migratevolumes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.common.Robj_interface_HIHsmManualPlanProgressEx;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.controller.com.SJctrComCVSUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrMessageDataController;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.SJctrVolumeMigrationUtility;
import sanproject.sn2.controller.com.comparator.SJctrErrorColumnDataComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.volumemigration.com.SJctrVMBasicData;
import sanproject.sn2.controller.wizard.volumemigration.com.SJctrVolumeMigrationMacro;
import sanproject.sn2.controller.wizard.volumemigration.migratevolumes.SJctrAvailableSourceVolsData;
import sanproject.sn2.controller.wizard.volumemigration.migratevolumes.SJctrAvailableTargetVolsData;
import sanproject.sn2.controller.wizard.volumemigration.migratevolumes.SJctrMigrateVolumesConfirmData;
import sanproject.sn2.controller.wizard.volumemigration.migratevolumes.SJctrProvisioningTypeDataModel;
import sanproject.sn2.controller.wizard.volumemigration.migratevolumes.SJctrSelectedMigrationPlansTableModel;
import sanproject.sn2.controller.wizard.volumemigration.migratevolumes.SJctrSourceVolumeTableModel;
import sanproject.sn2.controller.wizard.volumemigration.migratevolumes.SJctrTargetVolumesTableModel;
import sanproject.sn2.controller.wizard.volumemigration.migratevolumes.SJctrVMProvTypeComparator;
import sanproject.sn2.controller.wizard.volumemigration.migratevolumes.SJctrVMProvTypeStringWrapper;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolNameInfo;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualLdev;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.system.SJmoClprIndex;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;

public class SJctrMigrateVolumesDC
extends SJctrWizardDataController {
    private List<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>();
    HashSet<Integer> manualPlanPlogressDataSet = new HashSet();
    private List<SJcMessage> msgList = new ArrayList<SJcMessage>();
    private Class[] cacheDataList = new Class[]{SJctrVolumeMigrationMacro.KEY_CLASS_LDEV_NICKNAME, SJctrVolumeMigrationMacro.KEY_CLASS_LDEV_DETAIL, SJctrVolumeMigrationMacro.KEY_CLASS_POOLNAME_INFO, SJctrVolumeMigrationMacro.KEY_CLASS_POOL_DETAIL, SJctrVolumeMigrationMacro.KEY_CLASS_RSG_GETALLRSG, SJctrVolumeMigrationMacro.KEY_CLASS_LDEV_STATUS, SJctrVolumeMigrationMacro.KEY_CLASS_HDP_RELATION, SJctrVolumeMigrationMacro.KEY_CLASS_PG_ENCRYP_INFO, SJctrVolumeMigrationMacro.KEY_CLASS_LOCAL_REPLICATION_INFO, SJctrVolumeMigrationMacro.KEY_CLASS_PG_DETAIL_INFO, SJctrVolumeMigrationMacro.KEY_CLASS_CLPR_INDEX, SJctrVolumeMigrationMacro.KEY_CLASS_GET_PG_SCATTERD_INFO, SJctrVolumeMigrationMacro.KEY_CLASS_GET_HUVM_VIRTUAL_LDEV, SJctrVolumeMigrationMacro.KEY_CLASS_GET_RMI_MIGPLAN_DATA};
    private Object[][] strParamListDD71 = new Object[][]{{"KEY_LDEV_NICKNAME", SJctrVolumeMigrationMacro.KEY_CLASS_LDEV_NICKNAME}, {"KEY_LDEV_DETAIL", SJctrVolumeMigrationMacro.KEY_CLASS_LDEV_DETAIL}, {"KEY_POOLNAME_INFO", SJctrVolumeMigrationMacro.KEY_CLASS_POOLNAME_INFO}, {"KEY_POOL_DETAIL", SJctrVolumeMigrationMacro.KEY_CLASS_POOL_DETAIL}, {"KEY_LDEV_STATUS", SJctrVolumeMigrationMacro.KEY_CLASS_LDEV_STATUS}, {"KEY_HDP_RELATION", SJctrVolumeMigrationMacro.KEY_CLASS_HDP_RELATION}, {"KEY_RSG_GETALLRSG", SJctrVolumeMigrationMacro.KEY_CLASS_RSG_GETALLRSG}, {"KEY_LOCAL_REPLICATION_INFO", SJctrVolumeMigrationMacro.KEY_CLASS_LOCAL_REPLICATION_INFO}, {"KEY_PG_ENCRYP_INFO", SJctrVolumeMigrationMacro.KEY_CLASS_PG_ENCRYP_INFO}, {"KEY_PG_DETAIL_INFO", SJctrVolumeMigrationMacro.KEY_CLASS_PG_DETAIL_INFO}, {"KEY_CLPR_INDEX", SJctrVolumeMigrationMacro.KEY_CLASS_CLPR_INDEX}, {"KEY_PG_SCATTERD_INFO", SJctrVolumeMigrationMacro.KEY_CLASS_GET_PG_SCATTERD_INFO}, {"KEY_ SELECT_SOURCE_VOLUME", "KEY_ SELECT_SOURCE_VOLUME"}, {"KEY_ SOURCE_VOLUMES", "KEY_ SOURCE_VOLUMES"}, {"KEY_TARGET_VOLUMES", "KEY_TARGET_VOLUMES"}, {"KEY_SOURCE_VOLDISPLAY_ORDER", "KEY_SOURCE_VOLDISPLAY_ORDER"}};

    public SJctrMigrateVolumesDC() {
        super(0x1007101);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public boolean checkStartData() {
        boolean bRetChk = true;
        List<?> ldevIndexList = this.getCache("KEY_SELECT_LDEV_INDEX");
        List<?> targeDispIDtList = this.getCache("KEY_SELECT_DISPID");
        if (ldevIndexList != null && targeDispIDtList != null) {
            if (targeDispIDtList.isEmpty()) {
                if (!ldevIndexList.isEmpty()) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "checkStartData", "ldevIndexList param error");
                    SJcException ctrExp = SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
                    throw ctrExp;
                }
            } else if (!ldevIndexList.isEmpty() && !(ldevIndexList.get(0) instanceof SJmoLdevIndex)) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkStartData", "ldevIndexList instanceof SJmoLdevIndex false");
                SJcException ctrExp = SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
                throw ctrExp;
            }
        }
        return bRetChk;
    }

    @Override
    protected void updateFooter() {
        super.updateFooter();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        SJctrTableDataModel selectedTable = (SJctrTableDataModel)this.getDataObjectModel("COM_SEL_MIG_TABLE");
        List<Object> selectedList = selectedTable.getAllRowData();
        if (0 < selectedList.size()) {
            footer.setEnableButton(SJctrFooterDataModel.Button.FINISH, true);
        } else {
            footer.setEnableButton(SJctrFooterDataModel.Button.FINISH, false);
        }
    }

    @Override
    public boolean checkConstructData() {
        boolean bRetChk = true;
        this.checkCacheData();
        this.changeRmiDataForCheck();
        List<?> ldevIndexList = this.getCache("KEY_SELECT_LDEV_INDEX");
        List<?> ldevDetailList = this.getCache(SJctrVolumeMigrationMacro.KEY_CLASS_LDEV_DETAIL);
        List<?> pgDetailList = this.getCache(SJctrVolumeMigrationMacro.KEY_CLASS_PG_DETAIL_INFO);
        if (ldevIndexList != null && !ldevIndexList.isEmpty()) {
            Collections.sort(ldevIndexList);
            for (SJmoLdevIndex ldevIndex : ldevIndexList) {
                int target = Collections.binarySearch(ldevDetailList, ldevIndex);
                if (target >= 0) continue;
                SJctrLogUty.warn(this.getClass().getSimpleName(), " checkConstructData ", " err not component ldev ");
                SJcException ctrExp = SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(206095);
                throw ctrExp;
            }
        }
        this.checkVolumeForSourceAndTargetData();
        if (ldevIndexList != null && !ldevIndexList.isEmpty()) {
            SJmoLdevIndex mostLowNumberLdevIndex = (SJmoLdevIndex)ldevIndexList.get(0);
            int itarget = Collections.binarySearch(ldevDetailList, mostLowNumberLdevIndex);
            if (itarget < 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), " checkConstructData ", " err not component mostLowNumberLdevIndex ");
                SJcException ctrExp = SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(206095);
                throw ctrExp;
            }
            SJmoLdevDetail mostLowNumberLdevDetail = (SJmoLdevDetail)ldevDetailList.get(itarget);
            ArrayList<SJmoLdevDetail> list = new ArrayList<SJmoLdevDetail>();
            list.add(mostLowNumberLdevDetail);
            this.putCache("KEY_ SELECT_SOURCE_VOLUME", list);
        } else {
            ArrayList list = new ArrayList();
            this.putCache("KEY_ SELECT_SOURCE_VOLUME", list);
        }
        return bRetChk;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> setReq = super.getModelDirect();
        HashSet<SJctrGetDirectWrapper> setMigrateVolReq = new HashSet<SJctrGetDirectWrapper>();
        for (int iCnt = 0; iCnt < this.cacheDataList.length; ++iCnt) {
            if (this.cacheDataList[iCnt].getName().equals(SJctrVolumeMigrationMacro.KEY_CLASS_GET_RMI_MIGPLAN_DATA.getName())) {
                setMigrateVolReq.add(SJctrVolumeMigrationUtility.createMigPlanGetInput());
                continue;
            }
            setMigrateVolReq.add(this.createModelDirect(this.cacheDataList[iCnt]));
        }
        setReq.addAll(setMigrateVolReq);
        return setReq;
    }

    private SJctrGetDirectWrapper createModelDirect(Class<? extends SJmoGetKind_IF> reqClass) {
        SJctrGetDirectWrapper directWrapper = null;
        SJmoGetKind_IF kind = null;
        SJmoGetRange_IF range = null;
        ArrayList filterList = null;
        SJmoGetDirect direct = null;
        try {
            kind = reqClass.newInstance();
            range = null;
            filterList = new ArrayList();
            direct = new SJmoGetDirect(kind, range, filterList);
            directWrapper = new SJctrGetDirectWrapper(direct);
        }
        catch (InstantiationException insExp) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "SJctrGetDirectWrapper", "InstantiationException");
            SJcException ctrExp = SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
            throw ctrExp;
        }
        catch (IllegalAccessException illExp) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "SJctrGetDirectWrapper", "IllegalAccessException");
            SJcException ctrExp = SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
            throw ctrExp;
        }
        return directWrapper;
    }

    private void initDataModel() {
        this.addDataObjectModel("COM_SEL_VOL_TABLE", new SJctrSourceVolumeTableModel());
        SJctrProvisioningTypeDataModel comboBox = new SJctrProvisioningTypeDataModel();
        this.addDataObjectModel("COM_ATTR", comboBox);
        comboBox.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrMigrateVolumesDC.this.fireMessageEvent(NOTIFY_MIGRATE_VOLUME.CHANGE_PROVISION);
                }
            }
        });
        this.addDataObjectModel("COM_AVAIL_VOL_TABLE", new SJctrTargetVolumesTableModel());
        SJctrButtonDataModel addButton = new SJctrButtonDataModel();
        this.addDataObjectModel("COM_ADD", addButton);
        addButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrMigrateVolumesDC.this.fireMessageEvent(NOTIFY_MIGRATE_VOLUME.ADD);
                }
            }
        });
        this.addDataObjectModel("COM_SEL_MIG_TABLE", new SJctrSelectedMigrationPlansTableModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void initListener() {
        this.addMessageEventListener(NOTIFY_MIGRATE_VOLUME.SELECT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrLogUty.info(this.getClass().getSimpleName(), " selectAction ", " START ");
                SJctrMigrateVolumesDC.this.selectAction();
                SJctrLogUty.info(this.getClass().getSimpleName(), " selectAction ", " END");
            }
        });
        this.addMessageEventListener(NOTIFY_MIGRATE_VOLUME.CHANGE_PROVISION, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrLogUty.info(this.getClass().getSimpleName(), " changeProvisioningTypeAction ", " START");
                SJctrMigrateVolumesDC.this.changeProvisioningTypeAction();
                SJctrLogUty.info(this.getClass().getSimpleName(), " changeProvisioningTypeAction ", " END");
            }
        });
        this.addMessageEventListener(NOTIFY_MIGRATE_VOLUME.ADD, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrLogUty.info(this.getClass().getSimpleName(), " addAction ", " START");
                SJctrMigrateVolumesDC.this.addAction();
                SJctrLogUty.info(this.getClass().getSimpleName(), " addAction ", " END");
            }
        });
        this.addMessageEventListener(NOTIFY_MIGRATE_VOLUME.REMOVE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrLogUty.info(this.getClass().getSimpleName(), " removeAction ", " START");
                SJctrMigrateVolumesDC.this.removeAction();
                SJctrLogUty.info(this.getClass().getSimpleName(), " removeAction ", " END");
            }
        });
        this.addMessageEventListener(SJctrDialogDataController.DIALOG_MSG.EXIT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrLogUty.info(this.getClass().getSimpleName(), " ExitEvent ", " START");
                SJctrMigrateVolumesDC.this.exitEvent(event);
                SJctrLogUty.info(this.getClass().getSimpleName(), " ExitEvent ", " END");
            }
        });
        this.addMessageEventListener(NOTIFY_MIGRATE_VOLUME.DIAROGOK, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrLogUty.info(this.getClass().getSimpleName(), " migarateVolDialogOKAction ", " START");
                SJctrMigrateVolumesDC.this.migarateVolMsgDialogOKAction();
                SJctrLogUty.info(this.getClass().getSimpleName(), " migarateVolDialogOKAction ", " END");
            }
        });
    }

    @Override
    public String getDispName() {
        String strDispName = this.getComUtility().getGuidance("MIGRATE_VOL");
        return strDispName;
    }

    public SJctrMigrateVolumesConfirmData createConfirmData() {
        SJctrMigrateVolumesConfirmData confirmData = new SJctrMigrateVolumesConfirmData();
        SJctrSelectedMigrationPlansTableModel selectedMigPlansTable = (SJctrSelectedMigrationPlansTableModel)this.getDataObjectModel("COM_SEL_MIG_TABLE");
        List<Object> allBasicDataList = selectedMigPlansTable.getAllRowData();
        if (allBasicDataList.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), " createConfirmData ", " allBasicDataList size 0 ");
            SJcException ctrExp = SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
            throw ctrExp;
        }
        confirmData.setVMBasicData(allBasicDataList);
        List<SJmoLdevDetail> ldevDetailList = this.getCache(SJctrVolumeMigrationMacro.KEY_CLASS_LDEV_DETAIL);
        confirmData.setLdevDetaillist(ldevDetailList);
        List<SJmoLdevNicknameInfo> ldevNickNameInfList = this.getCache(SJctrVolumeMigrationMacro.KEY_CLASS_LDEV_NICKNAME);
        confirmData.setLdevNicknameInfolist(ldevNickNameInfList);
        List<SJmoHDPRelation> hdpRelationList = this.getCache(SJctrVolumeMigrationMacro.KEY_CLASS_HDP_RELATION);
        confirmData.setHDPRelationlist(hdpRelationList);
        List<SJmoPoolNameInfo> poolNameinfList = this.getCache(SJctrVolumeMigrationMacro.KEY_CLASS_POOLNAME_INFO);
        confirmData.setPoolNameInfolist(poolNameinfList);
        List<SJmoLocalReplicationPairVolInfo> localReplicationList = this.getCache(SJctrVolumeMigrationMacro.KEY_CLASS_LOCAL_REPLICATION_INFO);
        confirmData.setLocalReplicationPairVolInfolist(localReplicationList);
        List<SJmoPgDetail> pgDetailList = this.getCache(SJctrVolumeMigrationMacro.KEY_CLASS_PG_DETAIL_INFO);
        confirmData.setPgDetaillist(pgDetailList);
        List<SJmoPoolDetail> poolDetailList = this.getCache(SJctrVolumeMigrationMacro.KEY_CLASS_POOL_DETAIL);
        confirmData.setPoolDetaillist(poolDetailList);
        List<SJmoClprIndex> clprIndexList = this.getCache(SJctrVolumeMigrationMacro.KEY_CLASS_CLPR_INDEX);
        confirmData.setClprIndexlist(clprIndexList);
        List<SJmoPgScatteredInfo> pgScatteredInfoList = this.getCache(SJctrVolumeMigrationMacro.KEY_CLASS_GET_PG_SCATTERD_INFO);
        confirmData.setPgScatteredInfoList(pgScatteredInfoList);
        return confirmData;
    }

    @Override
    public void makeDataModel() {
        ArrayList selectSourceVolList = new ArrayList(this.getCache("KEY_ SELECT_SOURCE_VOLUME"));
        ArrayList srcVolDataList = new ArrayList(this.getCache("KEY_ SOURCE_VOLUMES"));
        SJctrAvailableSourceVolsData srcVolData = (SJctrAvailableSourceVolsData)srcVolDataList.get(0);
        ArrayList targetVolDataList = new ArrayList(this.getCache("KEY_TARGET_VOLUMES"));
        SJctrAvailableTargetVolsData targetVolData = (SJctrAvailableTargetVolsData)targetVolDataList.get(0);
        ArrayList<SJctrVMProvTypeStringWrapper> comboDispList = new ArrayList<SJctrVMProvTypeStringWrapper>(this.getCache("KEY_SOURCE_VOLDISPLAY_ORDER"));
        SJctrSelectedMigrationPlansTableModel selectedMigPlansTable = (SJctrSelectedMigrationPlansTableModel)this.getDataObjectModel("COM_SEL_MIG_TABLE");
        SJctrProvisioningTypeDataModel provisionCombo = (SJctrProvisioningTypeDataModel)this.getDataObjectModel("COM_ATTR");
        provisionCombo.setEnableListener(false);
        SJctrTargetVolumesTableModel targetTable = (SJctrTargetVolumesTableModel)this.getDataObjectModel("COM_AVAIL_VOL_TABLE");
        SJctrSourceVolumeTableModel sourceTable = (SJctrSourceVolumeTableModel)this.getDataObjectModel("COM_SEL_VOL_TABLE");
        List<Object> filterVolumeList = new ArrayList();
        if (selectSourceVolList.isEmpty()) {
            provisionCombo.refComboBox(null);
            filterVolumeList = new ArrayList();
        } else {
            SJmoLdevDetail selectSourceVolume = (SJmoLdevDetail)selectSourceVolList.get(0);
            ArrayList dispList = SJctrVolumeMigrationUtility.createComboBoxData(selectSourceVolume, targetVolData, comboDispList);
            provisionCombo.refComboBox(dispList);
            provisionCombo.setSelectedIndex(0);
            if (!dispList.isEmpty()) {
                String selectedDataName = dispList.get(0).toString();
                filterVolumeList = targetVolData.getAvailableLdevList(selectSourceVolume, selectedDataName);
            }
        }
        sourceTable.setBasicData(SJctrVolumeMigrationMacro.KEY_CLASS_LDEV_DETAIL, selectSourceVolList);
        targetTable.setBasicDataList(filterVolumeList);
        this.setTableCapacityUnit(sourceTable, targetTable, selectedMigPlansTable);
        provisionCombo.setEnableListener(true);
        super.makeDataModel();
    }

    private void createTargetVolumeArea() {
        SJctrProvisioningTypeDataModel provisionCombo = (SJctrProvisioningTypeDataModel)this.getDataObjectModel("COM_ATTR");
        SJctrTargetVolumesTableModel targetTable = (SJctrTargetVolumesTableModel)this.getDataObjectModel("COM_AVAIL_VOL_TABLE");
        List<SJctrVMProvTypeStringWrapper> comboDispList = this.getCache("KEY_SOURCE_VOLDISPLAY_ORDER");
        provisionCombo.setEnableListener(false);
        List<Object> filterVolumeList = new ArrayList();
        ArrayList selectSourceVolList = new ArrayList(this.getCache("KEY_ SELECT_SOURCE_VOLUME"));
        if (selectSourceVolList.isEmpty()) {
            provisionCombo.refComboBox(null);
            filterVolumeList = new ArrayList();
        } else {
            SJmoLdevDetail selectSourceVolume = (SJmoLdevDetail)selectSourceVolList.get(0);
            SJctrAvailableTargetVolsData targetVolumeData = (SJctrAvailableTargetVolsData)this.getCache("KEY_TARGET_VOLUMES").get(0);
            ArrayList dispList = SJctrVolumeMigrationUtility.createComboBoxData(selectSourceVolume, targetVolumeData, comboDispList);
            provisionCombo.refComboBox(dispList);
            provisionCombo.setSelectedIndex(0);
            if (!dispList.isEmpty()) {
                String selectedDataName = dispList.get(0).toString();
                filterVolumeList = targetVolumeData.getAvailableLdevList(selectSourceVolume, selectedDataName);
            }
        }
        targetTable.clearRowData();
        targetTable.addRowData(filterVolumeList);
        provisionCombo.setEnableListener(true);
        targetTable.setDirtyAll();
        provisionCombo.setDirtyAll();
    }

    private void selectAction() {
        HashMap map = new HashMap();
        for (int iCnt = 0; iCnt < this.strParamListDD71.length; ++iCnt) {
            String strKey = this.strParamListDD71[iCnt][0].toString();
            if (this.strParamListDD71[iCnt][1] instanceof String) {
                map.put(strKey, this.getCache(strKey));
                continue;
            }
            Class paramClass = (Class)this.strParamListDD71[iCnt][1];
            map.put(strKey, this.getCache(paramClass));
        }
        SJctrUserController uc = this.getOwner();
        SJctrRelatedDispDataObject relatedDisp = this.createDialog(SJctrVolumeMigrationMacro.KEY_CLASS_SELECT_SOURCEVOL_DC, map);
        this.addUpdateDisp(relatedDisp);
    }

    private void addAction() {
        SJctrAvailableTargetVolsData targetLdevData;
        SJctrTargetVolumesTableModel targetTable;
        List<Object> addDataList;
        SJmoLdevDetail addData;
        this.msgList = new ArrayList<SJcMessage>();
        SJctrSourceVolumeTableModel selectSrcTable = (SJctrSourceVolumeTableModel)this.getDataObjectModel("COM_SEL_VOL_TABLE");
        List<?> sourceLdevList = selectSrcTable.getBasicDataList(SJctrVolumeMigrationMacro.KEY_CLASS_LDEV_DETAIL);
        SJmoLdevDetail srcLdevDetail = (SJmoLdevDetail)sourceLdevList.get(0);
        if (this.checkAddTargetVolume(srcLdevDetail, addData = (SJmoLdevDetail)(addDataList = (targetTable = (SJctrTargetVolumesTableModel)this.getDataObjectModel("COM_AVAIL_VOL_TABLE")).getSelectedRowData()).get(0), targetLdevData = (SJctrAvailableTargetVolsData)this.getCache("KEY_TARGET_VOLUMES").get(0))) {
            this.addMigrationPlansTableAction();
        }
    }

    private void removeAction() {
        SJctrSelectedMigrationPlansTableModel selectedMigPlansTable = (SJctrSelectedMigrationPlansTableModel)this.getDataObjectModel("COM_SEL_MIG_TABLE");
        List<Object> removeDataList = selectedMigPlansTable.getSelectedRowData();
        if (!removeDataList.isEmpty()) {
            selectedMigPlansTable.removeSelectedRowData();
            for (int i = 0; i < removeDataList.size(); ++i) {
                SJctrVMBasicData removeData = (SJctrVMBasicData)removeDataList.get(i);
                ArrayList ldevDetailList = new ArrayList(this.getCache(SJctrVolumeMigrationMacro.KEY_CLASS_LDEV_DETAIL));
                SJmoLdevIndex sourceLdevIndex = removeData.getSourceLdevIndex();
                SJmoLdevIndex targetLdevIndex = removeData.getTargetLdevIndex();
                int source = Collections.binarySearch(ldevDetailList, sourceLdevIndex);
                int target = Collections.binarySearch(ldevDetailList, targetLdevIndex);
                if (source < 0 || target < 0) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), " removeAction ", " ldevDetailData nothing ");
                    SJcException ctrExp = SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
                    throw ctrExp;
                }
                SJmoLdevDetail targetLdevDetail = (SJmoLdevDetail)ldevDetailList.get(target);
                SJmoLdevDetail sourceLdevDetail = (SJmoLdevDetail)ldevDetailList.get(source);
                SJctrAvailableSourceVolsData sourceVolData = (SJctrAvailableSourceVolsData)this.getCache("KEY_ SOURCE_VOLUMES").get(0);
                SJctrAvailableTargetVolsData targetVolData = (SJctrAvailableTargetVolsData)this.getCache("KEY_TARGET_VOLUMES").get(0);
                sourceVolData.addVolData(sourceLdevDetail, targetLdevDetail);
                targetVolData.addVolData(sourceLdevDetail, targetLdevDetail);
            }
            this.createTargetVolumeArea();
            this.updateFooter();
        }
    }

    private void createErrorTable(List<SJctrErrorColumnData> errList) {
        SJctrRelatedDispDataObject relDisp = this.createDialog(SJctrErrorDataController.class, null);
        SJctrUserController userCtr = this.getOwner();
        SJctrDataController beginDC = this.getWizardWindow().getParentDC();
        SJctrTableDataModel tblModel = (SJctrTableDataModel)beginDC.getDataObjectModel("COM_TABLE");
        SJctrLogUty.warn(this.getClass().getSimpleName(), " createErrorTable ", " NG Data");
        throw SJctrVolumeMigrationUtility.makeErrInfTable(relDisp, userCtr, tblModel, errList);
    }

    private void addMigrationPlansTableAction() {
        SJctrSourceVolumeTableModel selectSrcTable = (SJctrSourceVolumeTableModel)this.getDataObjectModel("COM_SEL_VOL_TABLE");
        List<?> sourceLdevDetailList = selectSrcTable.getBasicDataList(SJctrVolumeMigrationMacro.KEY_CLASS_LDEV_DETAIL);
        SJmoLdevDetail srcLdevDetail = (SJmoLdevDetail)sourceLdevDetailList.get(0);
        SJctrTargetVolumesTableModel targetTable = (SJctrTargetVolumesTableModel)this.getDataObjectModel("COM_AVAIL_VOL_TABLE");
        List<Object> addDataList = targetTable.getSelectedRowData();
        SJmoLdevDetail targetLdevDetail = (SJmoLdevDetail)addDataList.get(0);
        SJctrSelectedMigrationPlansTableModel selectedMigPlansTable = (SJctrSelectedMigrationPlansTableModel)this.getDataObjectModel("COM_SEL_MIG_TABLE");
        SJctrProvisioningTypeDataModel provisionCombo = (SJctrProvisioningTypeDataModel)this.getDataObjectModel("COM_ATTR");
        provisionCombo.setEnableListener(false);
        SJmoLdevDetail sourceLdevIndex = srcLdevDetail;
        SJmoLdevDetail targetLdevIndex = targetLdevDetail;
        SJctrVMBasicData vmBasicData = new SJctrVMBasicData(sourceLdevIndex, targetLdevIndex);
        ArrayList<SJctrVMBasicData> vmBasicDataList = new ArrayList<SJctrVMBasicData>();
        vmBasicDataList.add(vmBasicData);
        selectedMigPlansTable.addRowDataTop(vmBasicDataList);
        selectSrcTable.clearRowData();
        selectSrcTable.addRowData(new ArrayList());
        targetTable.clearRowData();
        targetTable.addRowData(new ArrayList());
        provisionCombo.refComboBox(null);
        SJctrAvailableSourceVolsData sourceVolData = (SJctrAvailableSourceVolsData)this.getCache("KEY_ SOURCE_VOLUMES").get(0);
        SJctrAvailableTargetVolsData targetVolData = (SJctrAvailableTargetVolsData)this.getCache("KEY_TARGET_VOLUMES").get(0);
        sourceVolData.removeVolData(srcLdevDetail, targetLdevDetail);
        targetVolData.removeVolData(srcLdevDetail, targetLdevDetail);
        ArrayList list = new ArrayList();
        this.putCache("KEY_ SELECT_SOURCE_VOLUME", list);
        provisionCombo.setEnableListener(true);
        this.updateFooter();
        this.setDirtyAll();
    }

    private boolean isExistComboBoxData(String strSelectItem, ArrayList dispList) {
        boolean bFlg = false;
        for (int i = 0; i < dispList.size(); ++i) {
            String strItem = dispList.get(i).toString();
            if (!strItem.equals(strSelectItem)) continue;
            bFlg = true;
            break;
        }
        return bFlg;
    }

    private int checkSourceAndTargetVolume(SJmoLdevDetail ldevDetail, List<SJmoLdevIndex> availableLdevList, SJctrResourceGroupUtility rsgUtil) {
        int iRetChk = 0;
        if (this.isExistMigratePlan(ldevDetail)) {
            iRetChk = 206108;
            return iRetChk;
        }
        if (rsgUtil.isSelRscLdevInSysRsg(ldevDetail)) {
            iRetChk = 206115;
            return iRetChk;
        }
        if (!SJctrVolumeMigrationUtility.chkLdevRsgGrp(ldevDetail, availableLdevList)) {
            iRetChk = 206107;
            return iRetChk;
        }
        int checkResult = this.checkVolume(ldevDetail);
        if (checkResult != 0) {
            iRetChk = checkResult;
            return iRetChk;
        }
        return iRetChk;
    }

    private boolean checkSourceVolume(SJmoLdevDetail ldevDetail, List<SJmoLdevIndex> ldevIndexList) {
        int target;
        boolean bSourceVolCheck = true;
        if (ldevIndexList != null && !ldevIndexList.isEmpty() && (target = Collections.binarySearch(ldevIndexList, ldevDetail)) < 0) {
            bSourceVolCheck = false;
        }
        return bSourceVolCheck;
    }

    private int checkVolume(SJmoLdevDetail ldevDetail) {
        int iRetChk = 0;
        if (ldevDetail.getbMiddleVolume()) {
            iRetChk = 206102;
            return iRetChk;
        }
        switch (ldevDetail.getByVolumeType()) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: 
            case 5: {
                iRetChk = 206103;
                break;
            }
            default: {
                SJctrLogUty.warn("SJctrVolumeMigrationUtility", "getProvisoningTypeDispString", "VolType invalid:" + ldevDetail.getByVolumeType());
                throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
            }
        }
        if (ldevDetail.getbPoolVol()) {
            iRetChk = 206104;
            return iRetChk;
        }
        if (ldevDetail.getbJNLVolume()) {
            iRetChk = 206105;
            return iRetChk;
        }
        if (ldevDetail.getBLockVolume()) {
            iRetChk = 206106;
            return iRetChk;
        }
        if (ldevDetail.getbTseVol()) {
            iRetChk = 206110;
            return iRetChk;
        }
        if (ldevDetail.getbLUPathCmdDev()) {
            iRetChk = 206111;
            return iRetChk;
        }
        SJctrComCVSUtility cvsUtil = this.getComUtility().getCVSUtility();
        String strEmuType = cvsUtil.getEmulationTypeName(ldevDetail.getIEmulationType());
        if (strEmuType.equals("3390-V")) {
            iRetChk = 206112;
            return iRetChk;
        }
        if (strEmuType.equals("6588-A")) {
            iRetChk = 206113;
            return iRetChk;
        }
        if (ldevDetail.getbOdmVol()) {
            iRetChk = 206114;
            return iRetChk;
        }
        if (ldevDetail.getBVirtMode()) {
            iRetChk = 206172;
            return iRetChk;
        }
        if (ldevDetail.getBPoolOnlyLDEV()) {
            iRetChk = 206171;
            return iRetChk;
        }
        SJmoHUVMVirtualLdev huvmVirtualLdev = null;
        List<?> huvmVirtualLdevList = this.getCache(SJctrVolumeMigrationMacro.KEY_CLASS_GET_HUVM_VIRTUAL_LDEV);
        int itarget = Collections.binarySearch(huvmVirtualLdevList, ldevDetail);
        if (0 > itarget) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), " checkVolume ", " ldevDetailData nothing ");
            SJcException ctrExp = SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
            throw ctrExp;
        }
        huvmVirtualLdev = (SJmoHUVMVirtualLdev)huvmVirtualLdevList.get(itarget);
        if ((huvmVirtualLdev.getSVAttrHuvm() & 0x2000) != 0) {
            iRetChk = 206170;
            return iRetChk;
        }
        if (ldevDetail.getByVolumeType() == 3 && ldevDetail.getBFPTVol()) {
            iRetChk = 206220;
            return iRetChk;
        }
        return iRetChk;
    }

    private boolean checkTargetVolume(SJmoLdevDetail targetVolume) {
        boolean bRetChk = true;
        if (0 < targetVolume.getILUPathNumber()) {
            bRetChk = false;
            return bRetChk;
        }
        return bRetChk;
    }

    private void createDialogWindowOKCancel(SJcMessage msg) {
        this.msgList.remove(0);
        SJctrRelatedDispDataObject related = this.createMsgDialog(msg);
        SJctrUserController uc = this.getOwner();
        SJctrMessageDataController msgDC = (SJctrMessageDataController)uc.getDataController(related);
        msgDC.addButton(SJctrMessageDataController.MD_OK, new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrMigrateVolumesDC.this.fireMessageEvent(NOTIFY_MIGRATE_VOLUME.DIAROGOK);
            }
        });
        msgDC.addButton(SJctrMessageDataController.MD_CANCEL);
        this.addUpdateDisp(related);
    }

    private void migarateVolMsgDialogOKAction() {
        if (this.msgList.isEmpty()) {
            this.addMigrationPlansTableAction();
        } else {
            SJcMessage msg = this.msgList.get(0);
            this.createDialogWindowOKCancel(msg);
        }
    }

    private boolean checkCLPR(SJmoLdevDetail srcLdevDetail, SJmoLdevDetail targetLdevDetail) {
        boolean bFlg = false;
        if (srcLdevDetail.getSCLPR() != targetLdevDetail.getSCLPR()) {
            bFlg = true;
        }
        return bFlg;
    }

    private void checkCacheData() {
        for (int iCnt = 0; iCnt < this.cacheDataList.length; ++iCnt) {
            SJcException ctrExp;
            List<?> cacheList = this.getCache(this.cacheDataList[iCnt]);
            String cahceDataListName = this.cacheDataList[iCnt].getName();
            if (cahceDataListName.equals(SJctrVolumeMigrationMacro.KEY_CLASS_LDEV_DETAIL.getName())) {
                if (cacheList == null) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), " checkCacheData ", this.cacheDataList[iCnt].getName() + "  = cacheList null ");
                    ctrExp = SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
                    throw ctrExp;
                }
                if (cacheList.isEmpty()) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), " checkCacheData ", this.cacheDataList[iCnt].getName() + "  = cacheList size 0 ");
                    ctrExp = SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(206097);
                    throw ctrExp;
                }
            }
            if ((cahceDataListName.equals(SJctrVolumeMigrationMacro.KEY_CLASS_RSG_GETALLRSG.getName()) || cahceDataListName.equals(SJctrVolumeMigrationMacro.KEY_CLASS_LDEV_STATUS.getName())) && (cacheList == null || cacheList.isEmpty())) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), " checkCacheData ", this.cacheDataList[iCnt].getName() + "  = cacheList null or size 0 ");
                ctrExp = SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
                throw ctrExp;
            }
            if (!this.cacheDataList[iCnt].getName().equals(SJctrVolumeMigrationMacro.KEY_CLASS_GET_RMI_MIGPLAN_DATA.getName())) continue;
            SJmoThroughRmiData migPlansData = (SJmoThroughRmiData)cacheList.get(0);
            if (migPlansData == null) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), " checkCacheData ", " migPlansData null ");
                SJcException ctrExp2 = SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
                throw ctrExp2;
            }
            Robj_interface_HIHsmManualPlanProgressEx objRMI = (Robj_interface_HIHsmManualPlanProgressEx)migPlansData.getObjRmi();
            if (objRMI == null) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), " checkCacheData ", " objRMI null ");
                SJcException ctrExp3 = SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
                throw ctrExp3;
            }
            if (objRMI instanceof Robj_interface_HIHsmManualPlanProgressEx) continue;
            SJctrLogUty.warn(this.getClass().getSimpleName(), " checkCacheData ", " data instanceof false ");
            SJcException ctrExp4 = SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
            throw ctrExp4;
        }
    }

    private boolean checkAddTargetVolume(SJmoLdevDetail srcLdevDetail, SJmoLdevDetail targetLdevDetail, SJctrAvailableTargetVolsData targetLdevData) {
        SJcMessage msg;
        boolean bRetChk = true;
        int iPoolCheck = this.checkAddPoolCapacity(srcLdevDetail, targetLdevDetail, targetLdevData);
        if (iPoolCheck == 206101) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), " checkAddTargetVolume ", " iPoolCheck PoolUsedCapacity over 100 ");
            SJcException ctrExp = SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(206101);
            throw ctrExp;
        }
        SJctrSelectedMigrationPlansTableModel selectedMigPlansTable = (SJctrSelectedMigrationPlansTableModel)this.getDataObjectModel("COM_SEL_MIG_TABLE");
        if (8 == selectedMigPlansTable.getAllRowData().size()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), " addAction ", " selectedMigPlansTable select over 8");
            SJcException ctrExp = SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(206098);
            throw ctrExp;
        }
        if (this.checkCLPR(srcLdevDetail, targetLdevDetail)) {
            bRetChk = false;
            msg = SJctrVolumeMigrationUtility.getMsgObject(206109);
            this.msgList.add(msg);
        }
        if (iPoolCheck == 206099) {
            bRetChk = false;
            msg = SJctrVolumeMigrationUtility.getMsgObject(iPoolCheck);
            this.msgList.add(msg);
        }
        if (iPoolCheck == 206100) {
            bRetChk = false;
            msg = SJctrVolumeMigrationUtility.getMsgObject(iPoolCheck);
            this.msgList.add(msg);
        }
        if (!bRetChk) {
            msg = this.msgList.get(0);
            this.createDialogWindowOKCancel(msg);
        }
        return bRetChk;
    }

    private int checkAddPoolCapacity(SJmoLdevDetail srcLdevDetail, SJmoLdevDetail targetLdevDetail, SJctrAvailableTargetVolsData targetLdevData) {
        int iTargetPool;
        int iFlg = 0;
        boolean bNFCompPool = false;
        if (!targetLdevDetail.getbAouVvol()) {
            return iFlg;
        }
        List<SJmoHDPRelation> allDpVolList = this.getCache(SJctrVolumeMigrationMacro.KEY_CLASS_HDP_RELATION);
        ArrayList<SJmoLdevDetail> ldevDetailList = new ArrayList<SJmoLdevDetail>(this.getCache(SJctrVolumeMigrationMacro.KEY_CLASS_LDEV_DETAIL));
        List<?> startPoolList = this.getCache(SJctrVolumeMigrationMacro.KEY_CLASS_POOL_DETAIL);
        List<SJmoPoolDetail> latestPoolList = targetLdevData.getPoolList();
        ArrayList<SJmoPoolDetail> poolDetailList = new ArrayList<SJmoPoolDetail>(latestPoolList.size());
        for (SJmoPoolDetail pooldtl : latestPoolList) {
            try {
                poolDetailList.add((SJmoPoolDetail)pooldtl.clone());
            }
            catch (CloneNotSupportedException e) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), " checkAddPoolCapacity ", " CloneNotSupportedException ");
                SJcException ctrExp = SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
                throw ctrExp;
            }
        }
        SJmoPoolDetail targetVolPoolDetail = SJctrVolumeMigrationUtility.findHDPRelationData(allDpVolList, poolDetailList, targetLdevDetail);
        bNFCompPool = SJctrVolumeMigrationUtility.chkPoolVirtMode(targetVolPoolDetail.getPoolId(), ldevDetailList);
        long targetPages = 0L;
        long addPoolPages = 0L;
        double dPoolUsedRate = 0.0;
        double dPoolUseRateMax = 0.0;
        double dPoolUseRateMin = 0.0;
        targetPages = targetVolPoolDetail.getPoolUsedPages();
        addPoolPages = this.getComUtility().getVmUtility().getAddSrcVolLdevPages(srcLdevDetail, targetLdevDetail, targetVolPoolDetail, allDpVolList, this.getComUtility());
        targetVolPoolDetail.setPoolUsedPages(targetPages + addPoolPages);
        dPoolUsedRate = SJctrVolumeMigrationUtility.getDPoolUsedPercent(targetVolPoolDetail);
        SJctrLogUty.warn(this.getClass().getSimpleName(), "checkAddPoolCapacity", "Logial Use Rate:" + dPoolUsedRate);
        if (bNFCompPool && (iTargetPool = Collections.binarySearch(startPoolList, targetVolPoolDetail)) >= 0) {
            SJmoPoolDetail targetVolStartPool = (SJmoPoolDetail)startPoolList.get(iTargetPool);
            targetPages = targetVolStartPool.getLPoolActualUsedPages();
            addPoolPages = this.getComUtility().getVmUtility().getAddSrcVolLdevPages(srcLdevDetail, targetLdevDetail, targetVolPoolDetail, allDpVolList, this.getComUtility());
            long lMinUsedPage = (addPoolPages += targetVolPoolDetail.getLPoolActualUsedPages() - targetVolStartPool.getLPoolActualUsedPages()) / 16L + targetPages;
            if (0L != addPoolPages % 16L) {
                ++lMinUsedPage;
            }
            long lMaxUsedPage = targetPages + addPoolPages;
            double dMinUsedPage = lMinUsedPage;
            double dMaxUsedPage = lMaxUsedPage;
            dPoolUseRateMax = dMaxUsedPage / (double)targetVolPoolDetail.getLPoolActualPages() * 100.0;
            dPoolUseRateMin = dMinUsedPage / (double)targetVolPoolDetail.getLPoolActualPages() * 100.0;
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkAddPoolCapacity", "Actual Use Page Max:" + lMaxUsedPage + ", Min:" + lMinUsedPage);
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkAddPoolCapacity", "Actual Use Rate: Max:" + dPoolUseRateMax + ", Min:" + dPoolUseRateMin);
        }
        if (100.0 <= dPoolUsedRate) {
            iFlg = 206101;
            return iFlg;
        }
        if (bNFCompPool && 100.0 <= dPoolUseRateMin) {
            iFlg = 206101;
            return iFlg;
        }
        double dPoolDepletionThreshold = 100.0;
        double dPoolThreshold = targetVolPoolDetail.getPoolThreshold();
        if (targetVolPoolDetail.getSPoolThresholdMode() == SJctrPoolUtility.THRESHOLD_MODE_DEPLETION_ON) {
            dPoolDepletionThreshold = targetVolPoolDetail.getSPoolDepletionThreshold();
        }
        if (dPoolDepletionThreshold < dPoolUsedRate) {
            iFlg = 206099;
        } else if (dPoolThreshold < dPoolUsedRate) {
            iFlg = 206100;
        }
        if (bNFCompPool) {
            if (targetVolPoolDetail.getSPoolThresholdMode() == SJctrPoolUtility.THRESHOLD_MODE_DEPLETION_ON) {
                if (dPoolDepletionThreshold < dPoolUseRateMax && dPoolDepletionThreshold != 100.0) {
                    iFlg = 206099;
                }
            } else if (dPoolThreshold < dPoolUseRateMax && dPoolThreshold != 100.0) {
                iFlg = 206100;
            }
        }
        return iFlg;
    }

    private void exitEvent(SJctrMessageEvent event) {
        List selectLdevDetailList;
        Map transMap = null;
        Object noticeObject = event.getNofifyObject();
        if (noticeObject instanceof Map && (selectLdevDetailList = (List)(transMap = (Map)noticeObject).get("KEY_ SELECT_SOURCE_VOLUME")) != null && !selectLdevDetailList.isEmpty()) {
            this.putCache("KEY_ SELECT_SOURCE_VOLUME", selectLdevDetailList);
            SJctrSourceVolumeTableModel sourceTable = (SJctrSourceVolumeTableModel)this.getDataObjectModel("COM_SEL_VOL_TABLE");
            sourceTable.clearRowData();
            sourceTable.addRowData(selectLdevDetailList);
            sourceTable.setDirtyAll();
            this.createTargetVolumeArea();
        }
    }

    private void checkVolumeForSourceAndTargetData() {
        List<SJmoLdevIndex> ldevIndexList = this.getCache("KEY_SELECT_LDEV_INDEX");
        List<SJmoLdevDetail> ldevDetailList = this.getCache(SJctrVolumeMigrationMacro.KEY_CLASS_LDEV_DETAIL);
        List<SJmoHDPRelation> hdpRelationList = this.getCache(SJctrVolumeMigrationMacro.KEY_CLASS_HDP_RELATION);
        List<SJmoPoolDetail> poolDetailList = this.getCache(SJctrVolumeMigrationMacro.KEY_CLASS_POOL_DETAIL);
        List<?> allRsgInfoList = this.getCache(SJctrVolumeMigrationMacro.KEY_CLASS_RSG_GETALLRSG);
        SJmoRSGgetAllRsgs allRsg = (SJmoRSGgetAllRsgs)allRsgInfoList.get(0);
        List<SJmoPgScatteredInfo> pgScatterInfoList = this.getCache(SJctrVolumeMigrationMacro.KEY_CLASS_GET_PG_SCATTERD_INFO);
        SJctrResourceGroupUtility rsgUtil = SJctrVolumeMigrationUtility.makeRsgUtil(this, allRsg);
        List<SJmoLdevIndex> availableLdevList = SJctrVolumeMigrationUtility.getAvailableRsgLdevList(rsgUtil);
        SJctrComUtility coumUtil = this.getComUtility();
        ArrayList<SJctrVMProvTypeStringWrapper> comboDispList = new ArrayList<SJctrVMProvTypeStringWrapper>();
        this.errColumnList = new ArrayList<SJctrErrorColumnData>();
        SJctrAvailableSourceVolsData sourceVolData = new SJctrAvailableSourceVolsData(hdpRelationList, coumUtil, ldevIndexList, pgScatterInfoList, ldevDetailList, poolDetailList);
        SJctrAvailableTargetVolsData targetVolData = new SJctrAvailableTargetVolsData(hdpRelationList, coumUtil, poolDetailList, pgScatterInfoList, ldevDetailList);
        for (int i = 0; i < ldevDetailList.size(); ++i) {
            int iPoint;
            SJctrVMProvTypeStringWrapper tmpWrapper;
            SJmoLdevDetail ldevdetail;
            block6: {
                int iSourceAndTargetVolCheck;
                block5: {
                    ldevdetail = ldevDetailList.get(i);
                    iSourceAndTargetVolCheck = this.checkSourceAndTargetVolume(ldevdetail, availableLdevList, rsgUtil);
                    if (0 != iSourceAndTargetVolCheck) break block5;
                    if (!this.checkSourceVolume(ldevdetail, ldevIndexList)) break block6;
                    sourceVolData.setVolData(ldevdetail, 1);
                    tmpWrapper = new SJctrVMProvTypeStringWrapper(ldevdetail, coumUtil);
                    iPoint = Collections.binarySearch(comboDispList, tmpWrapper, new SJctrVMProvTypeComparator());
                    if (iPoint >= 0) break block6;
                    iPoint = -iPoint - 1;
                    comboDispList.add(iPoint, tmpWrapper);
                    break block6;
                }
                if (ldevIndexList == null || ldevIndexList.isEmpty() || !this.checkSourceVolume(ldevdetail, ldevIndexList)) continue;
                SJctrErrorColumnData errColumn = SJctrVolumeMigrationUtility.makeVMCtrlErrColumnData(iSourceAndTargetVolCheck, ldevdetail);
                this.errColumnList.add(errColumn);
                continue;
            }
            if (!this.checkTargetVolume(ldevdetail)) continue;
            targetVolData.setVolData(ldevdetail, 1);
            tmpWrapper = new SJctrVMProvTypeStringWrapper(ldevdetail, coumUtil);
            iPoint = Collections.binarySearch(comboDispList, tmpWrapper, new SJctrVMProvTypeComparator());
            if (iPoint >= 0) continue;
            iPoint = -iPoint - 1;
            comboDispList.add(iPoint, tmpWrapper);
        }
        sourceVolData.execSrcVolFilter(targetVolData);
        if (ldevIndexList != null && !ldevIndexList.isEmpty()) {
            this.errColumnList.addAll(sourceVolData.getErrList());
            if (!this.errColumnList.isEmpty()) {
                SJctrErrorColumnDataComparator COMPARATOR = new SJctrErrorColumnDataComparator();
                Collections.sort(this.errColumnList, COMPARATOR);
                this.createErrorTable(this.errColumnList);
            }
        } else if (!sourceVolData.isBExist()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), " checkVolumeForSourceAndTargetData ", " sourceVolData nothing ");
            SJcException ctrErr = SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(206097);
            throw ctrErr;
        }
        ArrayList<SJctrAvailableSourceVolsData> sourceVolDataList = new ArrayList<SJctrAvailableSourceVolsData>();
        sourceVolDataList.add(sourceVolData);
        ArrayList<SJctrAvailableTargetVolsData> targetVolDataList = new ArrayList<SJctrAvailableTargetVolsData>();
        targetVolDataList.add(targetVolData);
        this.putCache("KEY_ SOURCE_VOLUMES", sourceVolDataList);
        this.putCache("KEY_TARGET_VOLUMES", targetVolDataList);
        this.putCache("KEY_SOURCE_VOLDISPLAY_ORDER", comboDispList);
    }

    private boolean isExistMigratePlan(SJmoLdevDetail ldevDetail) {
        boolean bFlg = false;
        int checkVolIndex = ldevDetail.getIndex();
        if (this.manualPlanPlogressDataSet.contains(checkVolIndex)) {
            bFlg = true;
        }
        return bFlg;
    }

    private void changeRmiDataForCheck() {
        HashSet<Integer> set = new HashSet<Integer>();
        List<?> migPlansList = this.getCache(SJctrVolumeMigrationMacro.KEY_CLASS_GET_RMI_MIGPLAN_DATA);
        SJmoThroughRmiData migPlansData = (SJmoThroughRmiData)migPlansList.get(0);
        Robj_interface_HIHsmManualPlanProgressEx applyOut = (Robj_interface_HIHsmManualPlanProgressEx)migPlansData.getObjRmi();
        int[] iSizeArray = applyOut.getSourceLDKC();
        for (int iCnt = 0; iCnt < iSizeArray.length; ++iCnt) {
            int iSrcLDKC = applyOut.getSourceLDKC()[iCnt];
            int iSrcCU = applyOut.getSourceCU()[iCnt];
            int iSrcLDEV = applyOut.getSourceLDEV()[iCnt];
            int iSrcLdevIndex = SJctrVolumeMigrationUtility.createLdevIndex(iSrcLDKC, iSrcCU, iSrcLDEV);
            set.add(iSrcLdevIndex);
            int itargetLDKC = applyOut.getTargetLDKC()[iCnt];
            int itargetCU = applyOut.getTargetCU()[iCnt];
            int itargetLDEV = applyOut.getTargetLDEV()[iCnt];
            int itargetLdevIndex = SJctrVolumeMigrationUtility.createLdevIndex(itargetLDKC, itargetCU, itargetLDEV);
            set.add(itargetLdevIndex);
        }
        this.manualPlanPlogressDataSet = set;
    }

    private void changeProvisioningTypeAction() {
        SJctrProvisioningTypeDataModel provisionCombo = (SJctrProvisioningTypeDataModel)this.getDataObjectModel("COM_ATTR");
        String strSelectKeyName = provisionCombo.getSelection();
        SJctrAvailableTargetVolsData targetVolData = (SJctrAvailableTargetVolsData)this.getCache("KEY_TARGET_VOLUMES").get(0);
        SJmoLdevDetail selectSourceVolume = (SJmoLdevDetail)this.getCache("KEY_ SELECT_SOURCE_VOLUME").get(0);
        if (targetVolData != null) {
            List<SJmoLdevDetail> dataList = targetVolData.getAvailableLdevList(selectSourceVolume, strSelectKeyName);
            SJctrTargetVolumesTableModel targetTable = (SJctrTargetVolumesTableModel)this.getDataObjectModel("COM_AVAIL_VOL_TABLE");
            targetTable.clearRowData();
            targetTable.addRowData(dataList);
            targetTable.setDirty();
        }
    }

    private void setTableCapacityUnit(SJctrSourceVolumeTableModel sourceTable, SJctrTargetVolumesTableModel targetTable, SJctrSelectedMigrationPlansTableModel selectedMigPlansTable) {
        boolean bOpenFlg = false;
        boolean bMfFlg = false;
        SJctrAvailableSourceVolsData sourceVolData = (SJctrAvailableSourceVolsData)this.getCache("KEY_ SOURCE_VOLUMES").get(0);
        bOpenFlg = sourceVolData.isBOpenVolFlg();
        bMfFlg = sourceVolData.isBMFVolFlg();
        sourceTable.setCapacityFlg(true);
        targetTable.setCapacityFlg(true);
        selectedMigPlansTable.setCapacityFlg(true);
        sourceTable.setDpVolumeFlg(false);
        targetTable.setDpVolumeFlg(false);
        selectedMigPlansTable.setDpVolumeFlg(false);
        sourceTable.setOpenVolumeFlg(bOpenFlg);
        targetTable.setOpenVolumeFlg(bOpenFlg);
        selectedMigPlansTable.setOpenVolumeFlg(bOpenFlg);
        targetTable.setMainframeVolumeFlg(bMfFlg);
        sourceTable.setMainframeVolumeFlg(bMfFlg);
        selectedMigPlansTable.setMainframeVolumeFlg(bMfFlg);
    }

    public static enum NOTIFY_MIGRATE_VOLUME implements SJctrNotifyState
    {
        SELECT,
        CHANGE_PROVISION,
        ADD,
        REMOVE,
        DIAROGOK;

    }
}

