/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.volumemigration.migrationplans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import sanproject.common.Robj_interface_HIHsmManualPlanProgress2;
import sanproject.common.Robj_interface_HIHsmManualPlanProgress2_OUT;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrSystemParamContainer;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.SJctrVolumeMigrationUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.volumemigration.com.SJctrVMBasicData;
import sanproject.sn2.controller.wizard.volumemigration.com.SJctrVMDialogDataController;
import sanproject.sn2.controller.wizard.volumemigration.com.SJctrVolumeMigrationConfirmData;
import sanproject.sn2.controller.wizard.volumemigration.com.SJctrVolumeMigrationMacro;
import sanproject.sn2.controller.wizard.volumemigration.deletemigrationplans.SJctrDeleteMigrationPlansSubWizard;
import sanproject.sn2.controller.wizard.volumemigration.migrationplans.SJctrMigrationPlanInfo;
import sanproject.sn2.controller.wizard.volumemigration.migrationplans.SJctrMigrationPlansTableModel;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrMigrationPlansDC
extends SJctrVMDialogDataController {
    public SJctrMigrationPlansDC() throws SJcException {
        super(34664532);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public boolean checkStartData() {
        boolean bRet = true;
        List<?> migPlansList = this.getCache("KEY_MIGPLANDATA");
        if (migPlansList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkStartData", "migPlansList null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (migPlansList.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkStartData", "MigrationPlan List size 0");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        Robj_interface_HIHsmManualPlanProgress2_OUT migPlanData = (Robj_interface_HIHsmManualPlanProgress2_OUT)migPlansList.get(0);
        if (migPlanData == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkStartData", "MigrationPlan RMI Data null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        List<?> rsgInfoList = this.getCache(SJctrVolumeMigrationMacro.KEY_RSG_INFO);
        if (rsgInfoList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkStartData", "RsgInfo List null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (rsgInfoList.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkStartData", "RsgInfo List size 0");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        SJmoRSGgetAllRsgs rsgData = (SJmoRSGgetAllRsgs)rsgInfoList.get(0);
        if (rsgData == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkStartData", "RsgInfo Data null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        return bRet;
    }

    @Override
    public boolean checkConstructData() {
        boolean bRet = true;
        List<?> migPlansList = this.getCache("KEY_MIGPLANDATA");
        List<?> rsgInfoList = this.getCache(SJctrVolumeMigrationMacro.KEY_RSG_INFO);
        SJctrResourceGroupUtility rsgUtil = SJctrVolumeMigrationUtility.makeRsgUtil(this, (SJmoRSGgetAllRsgs)rsgInfoList.get(0));
        List<SJmoLdevIndex> availableLdevList = SJctrVolumeMigrationUtility.getAvailableRsgLdevList(rsgUtil);
        List<SJctrMigrationPlanInfo> basicDataList = this.createPlanDataList((Robj_interface_HIHsmManualPlanProgress2_OUT)migPlansList.get(0), availableLdevList);
        if (basicDataList.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "BasicDataList size 0");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(206088);
        }
        ((SJctrMigrationPlansTableModel)this.getDataObjectModel("COM_TABLE")).setBasicDataList(basicDataList);
        SJctrMigrationPlansTableModel tableModel = (SJctrMigrationPlansTableModel)this.getDataObjectModel("COM_TABLE");
        List<SJmoLdevDetail> ldevDetailList = this.getCache(SJctrVolumeMigrationMacro.KEY_CLASS_LDEV_DETAIL);
        SJctrVolumeMigrationUtility.makeMigrationPlanCapacityUnit(tableModel, basicDataList, ldevDetailList);
        return bRet;
    }

    private void initDataModel() {
        this.addDataObjectModel("COM_TABLE", new SJctrMigrationPlansTableModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE));
    }

    private void initListener() {
        this.addMessageEventListener(MIG_PLANS_MSG.DEL_MIGPLANS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrMigrationPlansDC.this.delMigPlansEvent();
            }
        });
    }

    private void delMigPlansEvent() {
        SJctrTableDataModel tblMdl = (SJctrTableDataModel)this.getDataObjectModel("COM_TABLE");
        List<Object> selData = tblMdl.getSelectedRowDataOrder();
        if (selData.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "delMigPlansEvent", "Not Selected");
        } else {
            if (!this.isEnablePP()) {
                throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(206094);
            }
            if (!this.isEnableRole()) {
                throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(206094);
            }
            ArrayList<SJctrVMBasicData> migPlanList = new ArrayList<SJctrVMBasicData>(selData.size());
            for (Object rowObj : selData) {
                migPlanList.add((SJctrVMBasicData)rowObj);
            }
            SJctrVolumeMigrationConfirmData delMigConfirmData = new SJctrVolumeMigrationConfirmData();
            delMigConfirmData.setVMBasicData(migPlanList);
            ArrayList<SJctrVolumeMigrationConfirmData> confrimDataList = new ArrayList<SJctrVolumeMigrationConfirmData>();
            confrimDataList.add(delMigConfirmData);
            HashMap dataMap = new HashMap();
            dataMap.put("KEY_MIGPLAN_CONFIRMDATA", confrimDataList);
            SJctrUserController uc = this.getOwner();
            SJctrRelatedDispDataObject newRelated = this.createWizard(SJctrDeleteMigrationPlansSubWizard.class, dataMap);
            SJctrRelatedDispDataObject removeRelated = uc.removeRelatedDispData(this.getuId());
            this.addUpdateDisp(removeRelated);
            this.addUpdateDisp(newRelated);
        }
    }

    private List<SJctrMigrationPlanInfo> createPlanDataList(Robj_interface_HIHsmManualPlanProgress2_OUT rmiPlanData, List<SJmoLdevIndex> availableLdevList) {
        ArrayList<SJctrMigrationPlanInfo> migPlanDataList = new ArrayList<SJctrMigrationPlanInfo>();
        Robj_interface_HIHsmManualPlanProgress2[] rmiPlan = rmiPlanData.getPlans();
        for (int iCnt = 0; iCnt < rmiPlan.length; ++iCnt) {
            SJmoLdevIndex srcLdev = new SJmoLdevIndex();
            SJmoLdevIndex targetLdev = new SJmoLdevIndex();
            Robj_interface_RJiLDEVIndex srcTmp = rmiPlan[iCnt].getSourceRJiLDEVIndex();
            Robj_interface_RJiLDEVIndex targetTmp = rmiPlan[iCnt].getTargetRJiLDEVIndex();
            srcLdev.setLdevIndex(srcTmp.getSLDKC(), srcTmp.getSCU(), srcTmp.getSLDEV());
            targetLdev.setLdevIndex(targetTmp.getSLDKC(), targetTmp.getSCU(), targetTmp.getSLDEV());
            if (!SJctrVolumeMigrationUtility.chkLdevRsgGrp(srcLdev, targetLdev, availableLdevList)) continue;
            SJctrMigrationPlanInfo planInfo = new SJctrMigrationPlanInfo(srcLdev, targetLdev, rmiPlan[iCnt].getOwnerID(), rmiPlan[iCnt].isHUVM(), rmiPlan[iCnt].getProgress(), rmiPlan[iCnt].getStatus());
            migPlanDataList.add(planInfo);
        }
        Collections.sort(migPlanDataList);
        return migPlanDataList;
    }

    private boolean isEnablePP() {
        boolean bPPRet = true;
        SJctrSystemParamContainer sysCont = this.getOwner().getAuthorizeContainer().getSystemParamContainer();
        SJctrLicenseContainer licenseCont = this.getOwner().getAuthorizeContainer().getLisenceContainer();
        if (!sysCont.isLocalHost()) {
            bPPRet &= licenseCont.checkPP(SJctrLicenseContainer.PPID_SN);
        }
        return bPPRet;
    }

    private boolean isEnableRole() {
        boolean bRoleRet = true;
        bRoleRet &= this.getOwner().getAuthorizeContainer().getRoleResourceContainer().checkAuthority(32);
        return bRoleRet &= this.getOwner().getAuthorizeContainer().getRoleResourceContainer().checkAuthority(104);
    }

    public static enum MIG_PLANS_MSG implements SJctrNotifyState
    {
        DEL_MIGPLANS;

    }
}

