/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.vpm.comdialog.changesetting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrVpmUtility;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.vpm.comdialog.changesetting.SJctrCangeSettingClprNameArea;
import sanproject.sn2.model.data.system.SJmoClprInfo;

public class SJctrChangeSettingDialogDC
extends SJctrDialogDataController {
    public static final int DISP_ID = 33595495;
    public static final String KEY_CNG_NAME_CLPR_INFO = "COM_CNG_NAME_CLPR_INFO";
    public static final String KEY_ALL_DETAIL_CLPR_INFO = "COM_ALL_DETAIL_CLPR_INFO";
    public static final String KEY_CLPR_NAME = "COM_CLPR_NAME";
    private SJctrCangeSettingClprNameArea clprNameArea = null;
    private List<SJmoClprInfo> selectClprInfo = Collections.EMPTY_LIST;
    private List<SJmoClprInfo> defaltClprinfo = Collections.EMPTY_LIST;

    public SJctrChangeSettingDialogDC() throws SJcException {
        super(33595495);
        this.initDataModel();
    }

    private void initDataModel() {
        this.clprNameArea = new SJctrCangeSettingClprNameArea();
        this.addDataObjectModel(KEY_CLPR_NAME, this.clprNameArea);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_OKCANCEL));
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        if (this.selectClprInfo.size() == 1) {
            this.clprNameArea.setStrFixTextBox(this.selectClprInfo.get(0).getStrClprName());
        }
    }

    @Override
    public boolean checkStartData() {
        List<?> orgClprInfoList = this.getCache(KEY_CNG_NAME_CLPR_INFO);
        List<?> orgChkClprList = this.getCache(KEY_ALL_DETAIL_CLPR_INFO);
        if (orgClprInfoList == null || orgClprInfoList.isEmpty() || orgChkClprList == null || orgChkClprList.isEmpty()) {
            SJctrLogUty.warn("SJctrChangeSettingDialogDC", "checkStartData", "Data Illegal");
            SJctrVpmUtility.makeErrorDialog(107002);
        }
        this.selectClprInfo = new ArrayList<SJmoClprInfo>(orgClprInfoList.size());
        this.defaltClprinfo = new ArrayList(orgChkClprList);
        Collections.sort(this.defaltClprinfo);
        for (SJmoClprInfo orgClprInfo : orgClprInfoList) {
            int index;
            try {
                this.selectClprInfo.add((SJmoClprInfo)orgClprInfo.clone());
            }
            catch (CloneNotSupportedException e) {
                SJctrLogUty.warn("SJctrChangeSettingDialogDC", "checkStartData", "SJmoClprInfo clone Error");
                SJctrVpmUtility.makeErrorDialog(107002);
            }
            if ((index = Collections.binarySearch(this.defaltClprinfo, orgClprInfo)) <= 0) continue;
            this.defaltClprinfo.remove(index);
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        String strInintNum = this.clprNameArea.getStrStartNumTextBox();
        int iNumLen = strInintNum.length();
        if (this.selectClprInfo.size() > 1 && iNumLen == 0) {
            SJctrLogUty.warn("SJctrChangeSettingDialogDC", "checkEndData", "InitialNumber Non-input");
            SJctrVpmUtility.makeErrorDialog(105011);
        }
        int iInitNumCnt = 0;
        boolean bInitFlg = false;
        if (!strInintNum.isEmpty()) {
            iInitNumCnt = Integer.parseInt(strInintNum);
            bInitFlg = true;
        }
        SJctrVpmUtility vpmUtil = this.getComUtility().getVPMUtility();
        String strPrefix = this.clprNameArea.getStrFixTextBox();
        for (SJmoClprInfo clpr : this.selectClprInfo) {
            String strClprName = strPrefix;
            if (bInitFlg) {
                String str = SJctrComUtility.toDecString(iInitNumCnt);
                if (9 < str.length()) {
                    SJctrVpmUtility.makeErrorDialog(205187);
                }
                String strNumber = SJctrComUtility.toPaddingZeroString(iInitNumCnt, iNumLen);
                if (16 < (strClprName = strClprName + strNumber).length()) {
                    SJctrVpmUtility.makeErrorDialog(205187);
                }
                ++iInitNumCnt;
            }
            SJctrVpmUtility.chkClprName(strClprName, clpr, this.defaltClprinfo);
            clpr.setStrClprName(strClprName);
        }
        this.putCache(KEY_CNG_NAME_CLPR_INFO, this.selectClprInfo);
        return true;
    }
}

