/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.datasupplier;

import com.hitachi.sanproject.data.SanData;
import com.hitachi.sanproject.rmi.SanRemote;
import com.hitachi.sanproject.rmi.SanResponse;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import sanproject.common.RCobj_interface_CheckRet;
import sanproject.serverux.data.SANRmiException;
import sanproject.serverux.dataimpl.DISKgetDKCDKUStatusInfo;
import sanproject.serverux.dataimpl.DKCSystemOptionEx;
import sanproject.serverux.dataimpl.DKCgetSystemOptionEx_IN;
import sanproject.serverux.dataimpl.DKCgetSystemOptionEx_OUT;
import sanproject.serverux.dataimpl.RJiAllConstInfo_IN;
import sanproject.serverux.dataimpl.RJiAllConstInfo_OUT;
import sanproject.serverux.sn.RmiObj_Webcon;
import sanproject.sn2.base.system.inf.SJbaseSystemInterface;
import sanproject.sn2.base.system.inf.SJbaseSystemStatusInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcSingletonManagerUty;
import sanproject.sn2.datasupplier.SJdsDataChange;
import sanproject.sn2.datasupplier.SJdsMethodInf;
import sanproject.sn2.datasupplier.SJdsRmiConnector;
import sanproject.sn2.datasupplier.SJdsRmiErrorInf;
import sanproject.sn2.datasupplier.SJdsRmiKvPoller;
import sanproject.sn2.datasupplier.SJdsRmiPoller;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.datasupplier.SJdsSupplierCondition;
import sanproject.sn2.datasupplier.SJdsSupplierConst;
import sanproject.sn2.datasupplier.SJdsSupplierException;
import sanproject.sn2.model.SJmoDataChange;
import sanproject.sn2.model.SJmoSNBaseStatusInterface;
import sanproject.sn2.model.SJmoUtility;

public class SJdsSupplierMgr
implements SJbaseSystemInterface,
SJdsSupplierConst {
    private SJdsRmiConnector m_Connector = null;
    private SJdsSupplierCondition m_Condition = null;
    private SJdsRmiPoller m_Poller = null;
    private SJdsRmiKvPoller m_KvPoller = null;
    private SJdsDataChange m_DataChange = null;
    SJdsSupplierAgent m_Agent = null;
    private int m_iWaitExcTimeOut = 3600;
    private String m_strRmiUrl;
    private String m_strUser;
    private String m_strPass;
    private int m_iVender;
    private String m_strOwnUrl;
    private URL m_urlHostPath;
    private String m_startPrmUserName;
    private String m_startPrmObstacleTimer;
    private String m_startPrmVenderID;
    private int m_startPrmLanguage;
    private String m_startPrmParameterVersion;
    private String m_startPrmExtSPSheetFlag;
    private String m_startPrmOSType;
    private boolean m_login_Flag = false;
    private RmiObj_Webcon m_RmiObj = null;
    private SanRemote m_RmiObjKV = null;
    private SanData m_generalParam = null;
    private RCobj_interface_CheckRet m_CheckRetObj = null;
    private SJdsRmiErrorInf m_RmiErrInf = null;
    private SJdsRmiErrorInf m_RmiErrInfDKCDKUStat = null;
    private boolean m_bGetDatChgTbl = false;
    private ArrayList m_DatChgTbl = null;
    private DISKgetDKCDKUStatusInfo m_DkcDkuStat = null;
    private int m_iExclusiveGet = 0;
    private int m_iExclusiveGetStat = 0;
    private int m_iExclusiveSet = 0;
    private boolean m_bLock = false;
    private HashMap<Object, Object> m_hMacroData = null;
    private DKCSystemOptionEx m_SystemOption = null;
    private Object m_SysOptSynObj = null;
    private int m_RestartNum = 0;
    private SanResponse m_allLookList = null;
    private boolean m_bInitializingRMIObj = false;

    public static SJdsSupplierMgr getSupplierMgr() {
        return (SJdsSupplierMgr)SJcSingletonManagerUty.getInstance(SJdsSupplierMgr.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void initialize() {
        SJdsSupplierMgr sJdsSupplierMgr = this;
        synchronized (sJdsSupplierMgr) {
            if (this.m_bInitializingRMIObj) {
                return;
            }
            this.m_bInitializingRMIObj = true;
        }
        boolean bRet = false;
        this.initSupplier();
        if (5 != this.getSupplierCondition() && 6 != this.getSupplierCondition()) {
            bRet = this.m_login_Flag;
            if (bRet) {
                try {
                    int iUserCount = this.m_RmiObj.useMonitor(true);
                }
                catch (RemoteException RemExp) {
                    SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "initialize", "catch RemoteException", RemExp);
                }
                catch (SANRmiException SanExp) {
                    SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "initialize", "catch SANRmiException", SanExp);
                }
                finally {
                    this.setStartParameter();
                    int iObstacleTimer = 0;
                    if (this.m_startPrmObstacleTimer.length() != 0) {
                        iObstacleTimer = Integer.parseInt(this.m_startPrmObstacleTimer);
                    }
                    this.m_Poller = new SJdsRmiPoller(this.m_RmiObj, iObstacleTimer);
                    this.m_KvPoller = new SJdsRmiKvPoller(iObstacleTimer);
                    this.m_RmiErrInfDKCDKUStat = new SJdsRmiErrorInf();
                    bRet = this.getDataChangeTable();
                    if (bRet) {
                        this.m_DataChange = new SJdsDataChange(this.m_DatChgTbl);
                        this.m_hMacroData = this.getMacroDataInf();
                        this.getSystemOptionInfo(true);
                        this.setSupplierCondition(2);
                        this.m_Poller.start();
                        this.m_KvPoller.start();
                    } else {
                        SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "initialize", "get DataChangeTable failed FuncID=" + this.m_RmiErrInf.getFuncID() + " ModuleID=" + this.m_RmiErrInf.getModuleID() + " MsgID=" + this.m_RmiErrInf.getMsgID());
                        try {
                            if (null != this.m_RmiObj) {
                                this.m_RmiObj.logOff();
                                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "initialize", "RMI logoff Success");
                            } else {
                                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "initialize", "RMI logoff failed, because the RMI object was null.");
                            }
                        }
                        catch (RemoteException e) {
                            SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "initialize", "RMI logoff RemoteException", e);
                        }
                        finally {
                            this.m_generalParam = null;
                            this.m_RmiObjKV = null;
                            this.m_RmiObj = null;
                            this.m_login_Flag = false;
                            this.setSupplierCondition(4);
                        }
                    }
                }
            } else {
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "initialize", "RMI login failed FuncID=" + this.m_RmiErrInf.getFuncID() + " ModuleID=" + this.m_RmiErrInf.getModuleID() + " MsgID=" + this.m_RmiErrInf.getMsgID());
                this.setSupplierCondition(4);
            }
        }
        this.m_bInitializingRMIObj = false;
    }

    @Override
    public void abort_initialize() {
        SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "abort_initialize", "The DataSupplier abort_initialize started");
        this.finish();
        SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "abort_initialize", "The DataSupplier abort_initialize ended");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() {
        if (null != this.m_Connector) {
            this.m_Connector.stopLoginRmi();
        }
        if (null != this.m_Poller) {
            this.m_Poller.setStopPolling();
        }
        if (null != this.m_KvPoller) {
            this.m_KvPoller.setStopPolling();
        }
        int iCnt = 0;
        while (1 == this.getSupplierCondition()) {
            try {
                if (600 < iCnt) {
                    SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "finish", "Time out. Cnt=" + iCnt);
                    break;
                }
                Thread.sleep(1000L);
                ++iCnt;
            }
            catch (Exception jvExp) {
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "finish", "wait loop suspended", jvExp);
                break;
            }
        }
        this.setSupplierCondition(5);
        this.m_Connector = null;
        this.m_Poller = null;
        this.m_KvPoller = null;
        this.m_DataChange = null;
        this.m_DkcDkuStat = null;
        this.m_strRmiUrl = null;
        this.m_strUser = null;
        this.m_strPass = null;
        this.m_iVender = 0;
        this.m_strOwnUrl = null;
        this.m_urlHostPath = null;
        this.m_startPrmUserName = null;
        this.m_startPrmObstacleTimer = null;
        this.m_startPrmVenderID = null;
        this.m_startPrmLanguage = 0;
        this.m_startPrmParameterVersion = null;
        this.m_startPrmExtSPSheetFlag = null;
        this.m_startPrmOSType = null;
        this.m_iExclusiveGet = 0;
        this.m_iExclusiveGetStat = 0;
        this.m_iExclusiveSet = 0;
        this.m_bLock = false;
        this.m_CheckRetObj = null;
        this.m_RmiErrInf = null;
        this.m_RmiErrInfDKCDKUStat = null;
        this.m_DatChgTbl = null;
        this.m_bGetDatChgTbl = false;
        this.macroDataClean();
        this.m_allLookList = null;
        this.m_SystemOption = null;
        this.m_SysOptSynObj = null;
        try {
            if (null != this.m_RmiObj) {
                this.m_RmiObj.logOff();
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "finish", "RMI logoff Success");
            } else {
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "finish", "RMI logoff failed, because the RMI object was null.");
            }
        }
        catch (RemoteException e) {
            SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "finish", "RMI logoff RemoteException", e);
        }
        finally {
            this.m_generalParam = null;
            this.m_RmiObjKV = null;
            this.m_RmiObj = null;
            this.m_login_Flag = false;
            this.setSupplierCondition(6);
        }
    }

    @Override
    public void abort_finish() {
        SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "abort_finish", "The DataSupplier abort_finish started");
        this.finish();
        SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "abort_finish", "The DataSupplier abort_finish ended");
    }

    @Override
    public SJbaseSystemStatusInterface getStatus() {
        SJmoSNBaseStatusInterface snbaseStatusIf = new SJmoSNBaseStatusInterface();
        switch (this.getSupplierCondition()) {
            case 0: {
                snbaseStatusIf.setPhase(0);
                snbaseStatusIf.setFatal(false);
                snbaseStatusIf.setReqRetry(false);
                snbaseStatusIf.setErrorCode(null);
                break;
            }
            case 1: {
                snbaseStatusIf.setPhase(1);
                snbaseStatusIf.setFatal(false);
                snbaseStatusIf.setReqRetry(false);
                snbaseStatusIf.setErrorCode(null);
                break;
            }
            case 2: {
                snbaseStatusIf.setPhase(2);
                snbaseStatusIf.setFatal(false);
                snbaseStatusIf.setReqRetry(false);
                snbaseStatusIf.setErrorCode(null);
                break;
            }
            case 3: {
                snbaseStatusIf.setPhase(2);
                snbaseStatusIf.setFatal(false);
                snbaseStatusIf.setReqRetry(false);
                snbaseStatusIf.setErrorCode(null);
                break;
            }
            case 4: {
                snbaseStatusIf.setPhase(1);
                snbaseStatusIf.setFatal(false);
                snbaseStatusIf.setReqRetry(true);
                snbaseStatusIf.setErrorCode(null);
                break;
            }
            case 5: {
                snbaseStatusIf.setPhase(3);
                snbaseStatusIf.setFatal(false);
                snbaseStatusIf.setReqRetry(false);
                snbaseStatusIf.setErrorCode(null);
                break;
            }
            case 6: {
                snbaseStatusIf.setPhase(4);
                snbaseStatusIf.setFatal(false);
                snbaseStatusIf.setReqRetry(false);
                snbaseStatusIf.setErrorCode(null);
                break;
            }
            case 7: {
                snbaseStatusIf.setPhase(2);
                snbaseStatusIf.setFatal(false);
                snbaseStatusIf.setReqRetry(true);
                snbaseStatusIf.setErrorCode(null);
                break;
            }
            default: {
                snbaseStatusIf.setPhase(2);
                snbaseStatusIf.setFatal(false);
                snbaseStatusIf.setReqRetry(false);
                snbaseStatusIf.setErrorCode(null);
                SJdsSupplierMgr.putLogDetail("DataSupplier", this.getClass().getSimpleName(), "getStatus", "getStatus Status disagreement = " + this.getSupplierCondition());
            }
        }
        return snbaseStatusIf;
    }

    public void initSupplier() {
        SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "initSupplier", "Start");
        this.m_login_Flag = false;
        this.m_strRmiUrl = "";
        this.m_strUser = "";
        this.m_strPass = "";
        this.m_iVender = 0;
        this.m_strOwnUrl = "";
        this.m_urlHostPath = null;
        this.m_startPrmUserName = "";
        this.m_startPrmObstacleTimer = "";
        this.m_startPrmVenderID = "";
        this.m_startPrmLanguage = 0;
        this.m_startPrmParameterVersion = "";
        this.m_startPrmExtSPSheetFlag = "";
        this.m_startPrmOSType = "";
        this.m_DkcDkuStat = null;
        this.m_iExclusiveGet = 0;
        this.m_iExclusiveGetStat = 0;
        this.m_iExclusiveSet = 0;
        this.m_bLock = false;
        this.m_DatChgTbl = null;
        this.m_bGetDatChgTbl = false;
        this.m_RmiErrInf = null;
        this.m_RmiErrInfDKCDKUStat = null;
        this.m_allLookList = null;
        this.m_SystemOption = null;
        this.m_SysOptSynObj = new Object();
        this.m_Connector = new SJdsRmiConnector();
        this.m_Condition = new SJdsSupplierCondition();
        this.setSupplierCondition(1);
        this.m_RmiErrInf = new SJdsRmiErrorInf();
        try {
            if (this.checkJRE()) {
                this.m_strRmiUrl = new String("//" + this.getCodeBase().getHost() + "/RMIControl");
                this.m_strUser = SJcEnvUty.getManageUserName();
                this.m_strPass = SJcEnvUty.getManagePassword();
                String strVender = this.getParameter("RSDJAVAV");
                this.m_iVender = Integer.parseInt(strVender);
                this.m_strOwnUrl = "";
                this.m_urlHostPath = this.getCodeBase();
                boolean bLoginRet = this.m_Connector.loginRmi(this.m_strRmiUrl, this.m_strUser, this.m_strPass, this.m_iVender, this.m_strOwnUrl, this.m_urlHostPath);
                if (bLoginRet) {
                    this.m_RmiObj = this.m_Connector.getRmiObject();
                    this.m_RmiObjKV = this.m_Connector.getRmiObjectKV();
                    this.m_generalParam = this.m_Connector.getSanData();
                    this.m_CheckRetObj = this.m_Connector.getCheckRet();
                    this.m_login_Flag = true;
                }
                if (!this.m_login_Flag) {
                    this.m_RmiErrInf.delInformation();
                    this.m_RmiErrInf = this.m_Connector.getRmiErrInf();
                    SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "initSupplier", "FuncID =" + this.m_RmiErrInf.getFuncID() + " ModuleID=" + this.m_RmiErrInf.getModuleID() + " MsgID=" + this.m_RmiErrInf.getMsgID());
                    SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "initSupplier", "Finish Failure");
                } else {
                    SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "initSupplier", " Finish Success");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "initSupplier", "END");
    }

    public String getParameter(String key) {
        String returnValue = "";
        returnValue = key.equals("RSDJAVAU") ? "flex_users" : (key.equals("RSDJAVAO") ? "50" : (key.equals("RSDJAVAV") ? "98" : (key.equals("RSDJAVAG") ? "0" : (key.equals("RSDVersion") ? "" : (key.equals("RSDJAVAExternal") ? "" : "")))));
        return returnValue;
    }

    public URL getCodeBase() {
        URL returnValue;
        String value = "http://localhost/san/";
        try {
            returnValue = new URL(value);
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace(System.err);
            returnValue = null;
        }
        return returnValue;
    }

    private boolean checkJRE() {
        boolean bRet = true;
        try {
            String JREVer = System.getProperty("java.vm.version");
            SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "checkJRE java.vm.version " + JREVer, "");
            if (JREVer.compareToIgnoreCase("1.4") < 0) {
                this.m_RmiErrInf.delInformation();
                this.m_RmiErrInf.setInformation(201, 23, 107020);
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "checkJRE", "FuncID=" + this.m_RmiErrInf.getFuncID() + " ModuleID=" + this.m_RmiErrInf.getModuleID() + " MsgID=" + this.m_RmiErrInf.getMsgID());
                bRet = false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return bRet;
    }

    private void setStartParameter() {
        this.m_startPrmUserName = this.getParameter("RSDJAVAU");
        this.m_startPrmObstacleTimer = this.getParameter("RSDJAVAO");
        this.m_startPrmVenderID = this.getParameter("RSDJAVAV");
        String strStaLang = this.getParameter("RSDJAVAG");
        this.m_startPrmLanguage = Integer.parseInt(strStaLang);
        this.m_startPrmParameterVersion = this.getParameter("RSDVersion");
        this.m_startPrmExtSPSheetFlag = this.getParameter("RSDJAVAExternal");
        String PrmOS = "";
        String opeOS = System.getProperty("os.name");
        PrmOS = opeOS.indexOf("Windows") == -1 ? "1" : "0";
        this.m_startPrmOSType = PrmOS;
    }

    private boolean getDataChangeTable() {
        boolean bRet = true;
        if (!this.m_bGetDatChgTbl) {
            this.m_RmiErrInf.delInformation();
            SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "getDataChangeTable Start", "");
            ArrayList FileNameList = this.getFileNameList(this.m_CheckRetObj.getNOEMTYPE());
            try {
                SJdsSupplierAgent Agent = this.getAgent();
                this.m_DatChgTbl = Agent.getDataChangeTable(FileNameList);
                this.m_RmiErrInf.setInformation(0, 0, 0);
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "getDataChangeTable Normal End", "");
                this.m_bGetDatChgTbl = true;
            }
            catch (SJdsSupplierException e) {
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "getDataChangeTable SJdsSupplierException", "", e);
                this.m_RmiErrInf.setInformation(Integer.parseInt(e.getMsg().getFunctionID()), Integer.parseInt(e.getMsg().getModuleID()), Integer.parseInt(e.getMsg().getMsgID()));
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "getDataChangeTable", "FuncID=" + this.m_RmiErrInf.getFuncID() + " ModuleID=" + this.m_RmiErrInf.getModuleID() + " MsgID=" + this.m_RmiErrInf.getMsgID());
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "getDataChangeTable Error End", "");
                bRet = false;
            }
        }
        return bRet;
    }

    private ArrayList getFileNameList(int iOeminf) {
        SJmoDataChange sjmoDtChg = new SJmoDataChange(iOeminf);
        ArrayList alRet = sjmoDtChg.getFileNameListEx(iOeminf, null);
        return alRet;
    }

    public RCobj_interface_CheckRet getCheckRetObj() {
        return this.m_CheckRetObj;
    }

    public int getSupplierCondition() {
        int iCondition = 0;
        if (null != this.m_Condition) {
            iCondition = this.m_Condition.getCondition();
        }
        return iCondition;
    }

    public void setSupplierCondition(int iCondition) {
        if (null != this.m_Condition) {
            this.m_Condition.setCondition(iCondition);
        }
    }

    synchronized boolean checkGetExec() {
        if (this.m_iExclusiveGet > 0 || this.m_iExclusiveSet > 0 || this.m_iExclusiveGetStat > 0) {
            return false;
        }
        ++this.m_iExclusiveGet;
        return true;
    }

    synchronized boolean checkSetExec() throws SJdsSupplierException {
        SJdsRmiErrorInf chkErrInf = new SJdsRmiErrorInf();
        SJdsSupplierException chkSplExp = new SJdsSupplierException();
        if (this.m_iExclusiveSet > 0) {
            SJdsSupplierMgr.putLogDetail("DataSupplier", this.getClass().getSimpleName(), "checkSetExec", "iKind Error");
            chkErrInf.setInformation(201, 23, 107003);
            SJdsSupplierMgr.putLogDetail("DataSupplier", this.getClass().getSimpleName(), "checkSetExec", "FuncID=" + chkErrInf.getFuncID() + " ModuleID=" + chkErrInf.getModuleID() + " MsgID=" + chkErrInf.getMsgID());
            SJmoUtility.setException(chkSplExp, chkErrInf.getFuncID(), chkErrInf.getModuleID(), chkErrInf.getMsgID());
            throw chkSplExp;
        }
        if (this.m_iExclusiveGet > 0 || this.m_iExclusiveGetStat > 0) {
            return false;
        }
        ++this.m_iExclusiveSet;
        SJdsSupplierMgr.putLogDetail("DataSupplier", this.getClass().getSimpleName(), "execSetOff", "m_iExclusiveSet: " + this.m_iExclusiveSet);
        return true;
    }

    synchronized void setExclusiveOfGetStat() {
        ++this.m_iExclusiveGetStat;
    }

    synchronized void execGetOff() {
        --this.m_iExclusiveGet;
    }

    synchronized void execSetOff() {
        --this.m_iExclusiveSet;
        SJdsSupplierMgr.putLogDetail("DataSupplier", this.getClass().getSimpleName(), "execSetOff", "m_iExclusiveSet: " + this.m_iExclusiveSet);
    }

    synchronized void execGetStatOff() {
        --this.m_iExclusiveGetStat;
    }

    synchronized void execLockOff() {
        --this.m_iExclusiveGetStat;
        this.m_bLock = false;
    }

    public SJdsDataChange getDataChange() {
        return this.m_DataChange;
    }

    public SJdsSupplierAgent getAgent() {
        boolean bloop = true;
        while (bloop) {
            if (4 == this.getSupplierCondition() || 7 == this.getSupplierCondition() || 5 == this.getSupplierCondition() || 6 == this.getSupplierCondition()) {
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "getAgent", "SJdsSupplierMgr Commu Error");
                SJdsSupplierException supExp = new SJdsSupplierException();
                SJmoUtility.setException(supExp, 201, 23, 107003);
                throw supExp;
            }
            if (this.m_login_Flag) {
                if (null == this.m_Agent) {
                    this.m_Agent = new SJdsSupplierAgent();
                }
                bloop = false;
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "getAgent", "getAgent sleep Exception", e);
            }
        }
        return this.m_Agent;
    }

    public SJdsSupplierAgent getAgentOnce() {
        SJdsSupplierAgent agentOnce = null;
        boolean bloop = true;
        while (bloop) {
            if (4 == this.getSupplierCondition() || 7 == this.getSupplierCondition() || 5 == this.getSupplierCondition() || 6 == this.getSupplierCondition()) {
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "getAgentOnce", "SJdsSupplierMgr Commu Error");
                SJdsSupplierException supExp = new SJdsSupplierException();
                SJmoUtility.setException(supExp, 201, 23, 107003);
                throw supExp;
            }
            if (this.m_login_Flag) {
                agentOnce = new SJdsSupplierAgent();
                bloop = false;
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "getAgentOnce", "getAgentOnce sleep Exception", e);
            }
        }
        return agentOnce;
    }

    public void setDKCDKUStatusInfo(DISKgetDKCDKUStatusInfo statInfo) {
        this.m_DkcDkuStat = statInfo;
        this.m_RmiErrInfDKCDKUStat = this.m_Poller.getRmiErrInf();
    }

    public DISKgetDKCDKUStatusInfo getDKCDKUStatusInfo() {
        return this.m_DkcDkuStat;
    }

    public SJdsRmiErrorInf getRmiErrInf() {
        return this.m_RmiErrInf;
    }

    public boolean isNowRunning() {
        boolean bRet = false;
        int iSupStat = 0;
        iSupStat = this.getSupplierCondition();
        if (iSupStat == 0 || iSupStat == 1 || iSupStat == 4 || iSupStat == 7 || iSupStat == 5 || iSupStat == 6) {
            bRet = true;
        }
        return bRet;
    }

    @Override
    public boolean destroy() {
        return false;
    }

    public RmiObj_Webcon getRmiObj() {
        return this.m_RmiObj;
    }

    public SanRemote getRmiObjKV() {
        return this.m_RmiObjKV;
    }

    public SanData getSanData() {
        return this.m_generalParam;
    }

    public static void putLogDetail(String strFunc, String strClass, String strMethod, String strErr) {
        SJcLogUty.getLogger("SN_Supplier.log").info(strFunc, strClass, strMethod, strErr);
    }

    public static void putLogDetail(String strFunc, String strClass, String strMethod, String strErr, Throwable thExp) {
        SJcLogUty.getLogger("SN_Supplier.log").info(strFunc, strClass, strMethod, strErr, thExp);
    }

    public DISKgetDKCDKUStatusInfo getDkcDkuStatusInfoFromRMI() throws SJdsSupplierException {
        DISKgetDKCDKUStatusInfo statInf = null;
        SJdsSupplierException supExp = null;
        SJdsMethodInf methodInf = new SJdsMethodInf("getDKCDKUStatusInfo");
        Object objRet = this.getAgent().getServerInf(methodInf, true);
        if (null == objRet || !(objRet instanceof DISKgetDKCDKUStatusInfo)) {
            if (null != objRet) {
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "getDkcDkuStatusInfoFromRMI", "Invalid class:" + objRet.getClass().getName());
            } else {
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "getDkcDkuStatusInfoFromRMI", "Invalid class(null)");
            }
            supExp = new SJdsSupplierException();
            SJmoUtility.setException(supExp, 201, 23, 107003);
            throw supExp;
        }
        statInf = (DISKgetDKCDKUStatusInfo)objRet;
        this.setDKCDKUStatusInfo(statInf);
        return statInf;
    }

    private HashMap<Object, Object> getMacroDataInf() {
        HashMap hMacroData = null;
        hMacroData = new HashMap();
        SJdsSupplierAgent SupAgent = this.getAgentOnce();
        if (SupAgent != null) {
            try {
                SJdsMethodInf constMethodInf = new SJdsMethodInf("getCmnData");
                constMethodInf.setInfo(new Class[]{Object.class}, new Object[]{new RJiAllConstInfo_IN()}, 0);
                RJiAllConstInfo_OUT constOut = (RJiAllConstInfo_OUT)SupAgent.getServerInf(constMethodInf, false);
                if (constOut != null && constOut.getAllConst() != null) {
                    hMacroData = constOut.getAllConst();
                }
            }
            catch (Exception e) {
                SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "getMacroDataInf", "Exception " + e.getMessage());
            }
        }
        return hMacroData;
    }

    public Map<Object, Object> getMacroMap() {
        HashMap<Object, Object> hMacroData = null;
        hMacroData = this.m_hMacroData;
        if (null == hMacroData) {
            hMacroData = new HashMap();
        }
        Map<Object, Object> unModifiedMap = Collections.unmodifiableMap(hMacroData);
        return unModifiedMap;
    }

    private void macroDataClean() {
        if (null != this.m_hMacroData) {
            if (!this.m_hMacroData.isEmpty()) {
                this.m_hMacroData.clear();
            }
            this.m_hMacroData = null;
        }
    }

    public SanResponse getAllLookList() {
        return this.m_allLookList;
    }

    public void setAllLookList(SanResponse allLookList) {
        this.m_allLookList = allLookList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DKCSystemOptionEx getSystemOptionInfo(boolean bRefresh) {
        if (bRefresh) {
            try {
                Object object = this.m_SysOptSynObj;
                synchronized (object) {
                    SJdsSupplierAgent supAgt = this.getAgentOnce();
                    if (supAgt == null) {
                        SJdsSupplierMgr.putLogDetail("DataSupplier", this.getClass().getSimpleName(), "getSystemOptionInfo", "Agent null");
                        this.m_SystemOption = null;
                        return this.m_SystemOption;
                    }
                    DKCgetSystemOptionEx_IN sysOptInput = new DKCgetSystemOptionEx_IN();
                    DKCgetSystemOptionEx_OUT sysOptOut = (DKCgetSystemOptionEx_OUT)supAgt.getDataInf(sysOptInput, false);
                    this.m_SystemOption = sysOptOut.getSysOpt();
                }
            }
            catch (Exception e) {
                SJdsSupplierMgr.putLogDetail("DataSupplier", this.getClass().getSimpleName(), "getSystemOptionInfo", "Catch Exception", e);
                this.m_SystemOption = null;
            }
        }
        return this.m_SystemOption;
    }

    protected void finalize() throws Throwable {
        this.macroDataClean();
        super.finalize();
    }

    public void restart() {
        if (this.m_RestartNum < 50) {
            ++this.m_RestartNum;
            SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "restart", "RMI Reconnect:" + this.m_RestartNum);
            if (!this.m_bInitializingRMIObj) {
                if (null != this.m_Poller) {
                    this.m_Poller.setStopPolling();
                }
                this.setSupplierCondition(1);
                this.initialize();
            }
        } else {
            SJdsSupplierMgr.putLogDetail("DataSupplier", "SJdsSupplierMgr", "restart", "RMI Reconnect Over Max");
            this.setSupplierCondition(7);
        }
    }
}

