/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.httpcli.exec;

import java.io.FileNotFoundException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.httpcli.com.SJhtclDef;
import sanproject.sn2.httpcli.com.SJhtclHttpCliUty;
import sanproject.sn2.httpcli.com.SJhtclParameterUty;
import sanproject.sn2.httpcli.com.SJhtclRelocationLogUty;
import sanproject.sn2.httpcli.exec.SJhtclExecBase;
import sanproject.sn2.httpcli.exec.com.SJhtclRelocationLogApplyTaskManager;

public class SJhtclRelocationLogDownLoad
extends SJhtclExecBase {
    private static final String LOG_FUNCTION = "HTTP_CLI";
    private static final String LOG_TITLE = SJhtclRelocationLogDownLoad.class.getSimpleName();
    private static final String PREFIX_DOWNLOAD_LOG_NAME = "Log_";
    private static final String FILE_EXTENSION_TGZ = ".tgz";

    public SJhtclRelocationLogDownLoad(SJbaseUserSessionInterface session, Map requestMap) {
        super(session, requestMap);
    }

    @Override
    protected boolean checkParameters() {
        boolean bResult = false;
        String strLogName = SJhtclParameterUty.getStrFromMap(this.requestMap, "logname");
        if (strLogName != null && strLogName.length() > 0) {
            bResult = true;
        }
        return bResult;
    }

    @Override
    protected boolean checkRole() {
        boolean bResult = false;
        SJcRoleResourceContainer resourceContainer = this.session.getRoleResourceInfo();
        if (resourceContainer.checkAuthority(32)) {
            bResult = true;
        }
        return bResult;
    }

    @Override
    protected boolean checkPP() {
        boolean bResult = false;
        if (this.isEnablePP(SJctrLicenseContainer.PPID_SN)) {
            bResult = true;
        }
        return bResult;
    }

    @Override
    protected HashMap<String, Object> executeCommand() {
        String LOG_SUBTITLE = "executeCommand";
        HashMap<String, Object> responseMap = new HashMap();
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, "executeCommand", "Start.");
        SJhtclRelocationLogApplyTaskManager mgr = SJhtclRelocationLogApplyTaskManager.getRelocationLogApplyTaskMgr();
        String strTaskCode = "";
        try {
            HashMap<String, Date> logInfMap = null;
            try {
                List<String> strFileList = SJhtclRelocationLogUty.getRelocationLogFileList();
                logInfMap = SJhtclRelocationLogUty.makeRelocationLogInfo(strFileList);
                if (logInfMap.size() == 0) {
                    htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "Relocation log is nothing");
                    responseMap = SJhtclHttpCliUty.getErrorMapCmd("107027");
                    return responseMap;
                }
            }
            catch (FileNotFoundException ex) {
                htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "DirectoryNotFound. directoryPath:" + ex.getMessage());
                responseMap = SJhtclHttpCliUty.getErrorMapCmd("107027");
                return responseMap;
            }
            String strLogName = SJhtclParameterUty.getStrFromMap(this.requestMap, "logname");
            htclLogger.info(LOG_FUNCTION, LOG_TITLE, "executeCommand", " logName : " + strLogName);
            if (32 < strLogName.trim().length()) {
                htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "LOGNAME_MAX_SIZE_ERROR");
                responseMap = SJhtclHttpCliUty.getErrorMapCmd("107021");
                return responseMap;
            }
            for (String strCheck : SJhtclDef.ReportCheckList) {
                if (strLogName.indexOf(strCheck) < 0) continue;
                htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "LOGNAME_INPUT_CHECK_ERROR");
                responseMap = SJhtclHttpCliUty.getErrorMapCmd("107022");
                return responseMap;
            }
            HashMap<String, Date> logInfTargetMap = new HashMap<String, Date>();
            if ("LatestLog".equals(strLogName)) {
                List<Map.Entry<String, Date>> entries = SJhtclRelocationLogUty.sortRelocationLogAtCreateTimeDesc(logInfMap);
                String strKey = entries.get(0).getKey();
                logInfTargetMap.put(strKey, logInfMap.get(strKey));
            } else {
                if (!logInfMap.containsKey(strLogName)) {
                    htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "Not found relocation log.");
                    responseMap = SJhtclHttpCliUty.getErrorMapCmd("107019");
                    return responseMap;
                }
                logInfTargetMap.put(strLogName, logInfMap.get(strLogName));
            }
            String strTargetLogName = logInfTargetMap.keySet().toArray()[0].toString();
            Date dtCreateTime = (Date)logInfTargetMap.get(strTargetLogName);
            Map<String, String> codeMap = mgr.createRelocationLogApplyTask(null, "download", dtCreateTime);
            String strErrorCode = codeMap.get("errCode");
            if (!strErrorCode.equals("")) {
                SJcException sjcEx = new SJcException("205", "25", strErrorCode);
                SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "download RelocationLog", "Failed to download.", sjcEx);
                throw sjcEx;
            }
            strTaskCode = codeMap.get("taskCode");
            responseMap.put("ResponseDownFileTaskCode", strTaskCode);
            responseMap = this.getResponseMap(strTargetLogName, responseMap);
            htclLogger.info(LOG_FUNCTION, LOG_TITLE, "executeCommand", "Relocation Log Name : " + responseMap.get("ResponseDownFileKey") + "DLKey : " + responseMap.get("ResponseKey"));
        }
        catch (SJcException ex) {
            mgr.errorTask(strTaskCode);
            htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "Catch SJcException ex : " + ex);
            responseMap = SJhtclHttpCliUty.getErrorMap(ex.getMsg());
            return responseMap;
        }
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, "executeCommand", "End.");
        return responseMap;
    }

    private HashMap<String, Object> getResponseMap(String strFileName, HashMap<String, Object> responseMap) {
        String strRelocationLogPath = SJhtclRelocationLogUty.getRelocationLogBasePath();
        String strDownloadFilePath = strRelocationLogPath.concat(strFileName).concat(FILE_EXTENSION_TGZ);
        String strDownloadKey = SJcFileUty.setDownloadFile(strDownloadFilePath);
        responseMap.put("sessionObj", this.session);
        responseMap.put("ResponseKeyType", "FILE");
        responseMap.put("ResponseKey", strDownloadKey);
        responseMap.put("ResponseDownFileKey", PREFIX_DOWNLOAD_LOG_NAME + strFileName + FILE_EXTENSION_TGZ);
        return responseMap;
    }
}

