/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.httpcli.exec;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.serverux.dataimpl.REPORTReportInfo;
import sanproject.serverux.dataimpl.REPORTgetReportHistory;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.httpcli.com.SJhtclHttpCliUty;
import sanproject.sn2.httpcli.com.SJhtclParameterUty;
import sanproject.sn2.httpcli.com.SJhtclReportUty;
import sanproject.sn2.httpcli.exec.SJhtclExecBase;
import sanproject.sn2.httpcli.exec.com.SJhtclReportRMIUtility;

public class SJhtclReportDownLoad
extends SJhtclExecBase {
    private static final String LOG_FUNCTION = "HTTP_CLI";
    private static final String LOG_TITLE = SJhtclReportDownLoad.class.getSimpleName();
    private static SJcLoggerInterface htclLogger = null;
    private static final String ARCHIVE = "ARCHIVE";
    private static final String REPORT_ = "Report_";
    private static final String FILE_EXTENSION = ".tgz";

    public SJhtclReportDownLoad(SJbaseUserSessionInterface session, Map requestMap) {
        super(session, requestMap);
        htclLogger = SJhtclHttpCliUty.getHtclLogger();
    }

    @Override
    protected HashMap<String, Object> executeCommand() {
        String LOG_SUBTITLE = "executeCommand";
        HashMap<String, Object> responseMap = new HashMap();
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, "executeCommand", "Start.");
        String reportID = SJhtclParameterUty.getStrFromMap(this.requestMap, "report_id");
        String reportName = SJhtclParameterUty.getStrFromMap(this.requestMap, "report");
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, "executeCommand", "reportID : " + reportID + " reportName : " + reportName);
        try {
            boolean role = this.checkDLRole();
            REPORTgetReportHistory reportHistory = SJhtclReportRMIUtility.getReportList();
            REPORTReportInfo[] reportArray = reportHistory.getReportList();
            List<REPORTReportInfo> reportList = Arrays.asList(reportArray);
            REPORTReportInfo dlReport = null;
            if ((reportID == null || reportID.length() <= 0) && "LatestReport".equals(reportName)) {
                if (reportList.size() == 0) {
                    htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "reportList is nothing");
                    responseMap = SJhtclHttpCliUty.getErrorMapCmd("107012");
                    return responseMap;
                }
                reportList = SJhtclReportUty.sortReportAtCreateTime(reportList);
                if (!role) {
                    dlReport = SJhtclReportUty.getRepCreatedBySessionUser(reportList, this.session);
                    if (dlReport == null) {
                        htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "downloadable report is nothing");
                        responseMap = SJhtclHttpCliUty.getErrorMapCmd("107015");
                        return responseMap;
                    }
                } else {
                    dlReport = reportList.get(0);
                }
            } else {
                reportList = reportID != null && reportID.length() > 0 ? SJhtclReportUty.getReportListByID(reportList, reportID) : SJhtclReportUty.getReportListByName(reportList, reportName);
                if (reportList.size() == 0) {
                    htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "Not found report.");
                    responseMap = SJhtclHttpCliUty.getErrorMapCmd("107001");
                    return responseMap;
                }
                reportList = SJhtclReportUty.sortReportAtCreateTime(reportList);
                if (!role) {
                    dlReport = SJhtclReportUty.getRepCreatedBySessionUser(reportList, this.session);
                    if (dlReport == null) {
                        htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "Authority is insufficient");
                        responseMap = SJhtclHttpCliUty.getErrorMapCmd("107016");
                        return responseMap;
                    }
                } else {
                    dlReport = reportList.get(0);
                }
            }
            responseMap = this.getResponseMap(dlReport, responseMap);
            htclLogger.info(LOG_FUNCTION, LOG_TITLE, "executeCommand", "reportName : " + responseMap.get("ResponseDownFileKey") + "DLKey : " + responseMap.get("ResponseKey"));
        }
        catch (SJcException ex) {
            htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "Catch SJcException ex : " + ex);
            responseMap = SJhtclHttpCliUty.getErrorMap(ex.getMsg());
            return responseMap;
        }
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, "executeCommand", "End.");
        return responseMap;
    }

    private HashMap<String, Object> getResponseMap(REPORTReportInfo dlReport, HashMap<String, Object> responseMap) {
        File absolDir = new File(dlReport.getOutputDir());
        String dirName = absolDir.getName();
        File parentPass = absolDir.getParentFile();
        String parentDir = parentPass.getName();
        String dlFileName = REPORT_ + dlReport.getSzReportName() + FILE_EXTENSION;
        String dlFilePass = SJcFileUty.concatFolderPath(parentDir, dirName);
        dlFilePass = SJcFileUty.concatFolderPath(dlFilePass, ARCHIVE);
        String reportKey = SJcFileUty.setDownloadFile(dlFilePass, dlFileName);
        responseMap.put("sessionObj", this.session);
        responseMap.put("ResponseKeyType", "FILE");
        responseMap.put("ResponseKey", reportKey);
        responseMap.put("ResponseDownFileKey", dlFileName);
        return responseMap;
    }

    private boolean checkDLRole() {
        String LOG_SUBTITLE = "checkDLRole";
        boolean snInitializeIs = false;
        SJcRoleResourceContainer role = this.session.getRoleResourceInfo();
        snInitializeIs = role.checkAuthority(33);
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "role : " + snInitializeIs);
        return snInitializeIs;
    }

    @Override
    protected boolean checkParameters() {
        boolean res = false;
        String reportID = SJhtclParameterUty.getStrFromMap(this.requestMap, "report_id");
        String reportName = SJhtclParameterUty.getStrFromMap(this.requestMap, "report");
        if (reportID != null && reportID.length() > 0) {
            res = true;
        }
        if (reportName != null && reportName.length() > 0) {
            res = true;
        }
        return res;
    }

    @Override
    protected boolean checkPP() {
        boolean res = false;
        if (this.isEnablePP(SJctrLicenseContainer.PPID_SN)) {
            res = true;
        }
        return res;
    }

    @Override
    protected boolean checkRole() {
        boolean res = false;
        SJcRoleResourceContainer resourceContainer = this.session.getRoleResourceInfo();
        if (resourceContainer.checkAuthority(32)) {
            res = true;
        }
        return res;
    }
}

