/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.httpcli.exec.com;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.httpcli.com.SJhtclHttpCliUty;
import sanproject.sn2.httpcli.exec.com.SJhtclRelocationLogApplyTask;

public class SJhtclRelocationLogApplyTaskManager {
    private static final String LOG_FUNCTION = "HTTP_CLI";
    private static final String LOG_TITLE = SJhtclRelocationLogApplyTaskManager.class.getSimpleName();
    private static SJcLoggerInterface htclLogger = null;
    private static final int MAX_TASK_COUNT = 512;
    private static SJhtclRelocationLogApplyTaskManager applyMgr = null;
    private final TreeMap<String, SJhtclRelocationLogApplyTask> taskMgrMap = new TreeMap();
    public static final String TASK_NAME_CREATE = "add";
    public static final String TASK_NAME_DOWNLOAD = "download";
    public static final String TASK_NAME_DELETE = "delete";
    public static final String TASK_CODE_KEY = "taskCode";
    public static final String ERROR_CODE_KEY = "errCode";
    public static final String CODE_EMPTY = "";
    private static final long EXEC_TIME_MAX = 1800000L;

    public static SJhtclRelocationLogApplyTaskManager getRelocationLogApplyTaskMgr() {
        if (applyMgr == null) {
            applyMgr = new SJhtclRelocationLogApplyTaskManager();
            htclLogger = SJhtclHttpCliUty.getHtclLogger();
        }
        return applyMgr;
    }

    private void putTaskMap(String key, SJhtclRelocationLogApplyTask task) {
        if (!this.taskMgrMap.isEmpty()) {
            String removeKey = this.taskMgrMap.firstKey();
            Iterator<String> it = this.taskMgrMap.keySet().iterator();
            while (this.taskMgrMap.size() >= 512) {
                if (this.taskMgrMap.get(removeKey).getTaskStatus() == 3) {
                    htclLogger.info(LOG_FUNCTION, LOG_TITLE, "putTaskMap", "Delete Task : " + this.taskMgrMap.get(removeKey).getTaskName());
                    this.taskMgrMap.remove(removeKey);
                    continue;
                }
                if (it.hasNext()) {
                    removeKey = it.next();
                    continue;
                }
                this.taskMgrMap.remove(this.taskMgrMap.firstKey());
            }
        }
        this.taskMgrMap.put(key, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execRelocationLogApplyTask(String taskCode) {
        TreeMap<String, SJhtclRelocationLogApplyTask> treeMap = this.taskMgrMap;
        synchronized (treeMap) {
            SJhtclRelocationLogApplyTask task = this.taskMgrMap.get(taskCode);
            task.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> createRelocationLogApplyTask(Object request, String taskName, Date startDate) {
        TreeMap<String, SJhtclRelocationLogApplyTask> treeMap = this.taskMgrMap;
        synchronized (treeMap) {
            SJhtclRelocationLogApplyTask task = new SJhtclRelocationLogApplyTask(request, taskName, startDate);
            task.init();
            String taskCode = Integer.toHexString(task.hashCode());
            String errCode = this.getExecTaskErrCode(taskName);
            if (errCode.equals(CODE_EMPTY)) {
                this.putTaskMap(taskCode, task);
            }
            HashMap<String, String> codeMap = new HashMap<String, String>();
            codeMap.put(TASK_CODE_KEY, taskCode);
            codeMap.put(ERROR_CODE_KEY, errCode);
            return codeMap;
        }
    }

    private String getExecTaskErrCode(String taskName) {
        String errCode = CODE_EMPTY;
        for (String currentKey : this.taskMgrMap.keySet()) {
            if (this.taskMgrMap.get(currentKey).getTaskStatus() != 2) continue;
            String checkTaskName = this.taskMgrMap.get(currentKey).getTaskName();
            if (checkTaskName.equals(TASK_NAME_CREATE)) {
                errCode = "107023";
            } else if (checkTaskName.equals(TASK_NAME_DELETE)) {
                errCode = "107025";
            } else if (checkTaskName.equals(TASK_NAME_DOWNLOAD)) {
                long startTime = this.taskMgrMap.get(currentKey).getStartTime();
                long currentTime = System.nanoTime();
                long execTime = (currentTime - startTime) / 1000000L;
                if (execTime > 1800000L) {
                    this.taskMgrMap.get(currentKey).setTaskStatusError();
                } else if (!taskName.equals(TASK_NAME_DOWNLOAD)) {
                    errCode = "107024";
                }
            }
            if (errCode.equals(CODE_EMPTY)) continue;
            break;
        }
        return errCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTask(String taskCode) {
        TreeMap<String, SJhtclRelocationLogApplyTask> treeMap = this.taskMgrMap;
        synchronized (treeMap) {
            if (this.taskMgrMap.containsKey(taskCode)) {
                this.taskMgrMap.get(taskCode).setTaskStatusEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void errorTask(String taskCode) {
        TreeMap<String, SJhtclRelocationLogApplyTask> treeMap = this.taskMgrMap;
        synchronized (treeMap) {
            if (this.taskMgrMap.containsKey(taskCode)) {
                this.taskMgrMap.get(taskCode).setTaskStatusError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTaskStatus(String taskCode) {
        TreeMap<String, SJhtclRelocationLogApplyTask> treeMap = this.taskMgrMap;
        synchronized (treeMap) {
            int taskStatus = 4;
            if (this.taskMgrMap.containsKey(taskCode)) {
                taskStatus = this.taskMgrMap.get(taskCode).getTaskStatus();
            }
            return taskStatus;
        }
    }
}

