/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.httpcli.request;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import sanproject.sn2.base.session.SJbaseLoginEntry;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.httpcli.com.SJhtclHttpCliUty;
import sanproject.sn2.httpcli.com.SJhtclParameterUty;
import sanproject.sn2.httpcli.request.inf.SJhtclRequestInterface;

public class SJhtclRequestLogin
implements SJhtclRequestInterface {
    private static final String LOG_FUNCTION = "HTTP_CLI";
    private static final String LOG_TITLE = SJhtclRequestLogin.class.getSimpleName();
    private static SJcLoggerInterface htclLogger = null;

    public SJhtclRequestLogin() {
        htclLogger = SJhtclHttpCliUty.getHtclLogger();
    }

    @Override
    public HashMap<String, Object> processRequest(HttpServletRequest req) {
        String LOG_SUBTITLE = "processRequest";
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, "processRequest", "Start. -user:" + req.getParameter("user"));
        HashMap<String, Object> responseMap = new HashMap();
        if (!this.checkParameters(req.getParameterMap())) {
            responseMap = SJhtclHttpCliUty.getErrorMapBase("107003");
        } else {
            String userId = req.getParameter("user");
            String pass = req.getParameter("pass");
            SJbaseLoginEntry loginEntry = new SJbaseLoginEntry();
            loginEntry.setUserid(userId);
            loginEntry.setPassword(pass);
            loginEntry.setLoginType("NOR");
            loginEntry.setLang("EN");
            loginEntry.setHttpRequest(req);
            try {
                SJbaseUserSessionInterface session = SJhtclHttpCliUty.getSessionManager().login(loginEntry);
                responseMap = SJhtclHttpCliUty.getSessionMap(session.getSessionID());
                htclLogger.info(LOG_FUNCTION, LOG_TITLE, "processRequest", "HTTP CLI user login succeed. -user:" + session.getUserName() + " -GlobalSessionID:" + session.getSessionID());
            }
            catch (SJcException sjce) {
                htclLogger.error(LOG_FUNCTION, LOG_TITLE, "processRequest", "Failed to login.");
                responseMap = SJhtclHttpCliUty.getErrorMap(sjce.getMsg());
            }
            catch (Throwable th) {
                htclLogger.error(LOG_FUNCTION, LOG_TITLE, "processRequest", "Unknown error occurred.", th);
                responseMap = SJhtclHttpCliUty.getErrorMapBase("107001");
            }
        }
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, "processRequest", "End.");
        return responseMap;
    }

    private boolean checkParameters(Map<String, Object> requestMap) {
        String LOG_SUBTITLE = "checkParameters";
        boolean res = true;
        if (requestMap == null) {
            htclLogger.error(LOG_FUNCTION, LOG_TITLE, "checkParameters", "requestMap is null.");
            res = false;
        } else if (SJhtclParameterUty.getStrFromMap(requestMap, "user") == null) {
            htclLogger.error(LOG_FUNCTION, LOG_TITLE, "checkParameters", "Login parameter is invalid.");
            res = false;
        } else if (SJhtclParameterUty.getStrFromMap(requestMap, "pass") == null) {
            htclLogger.error(LOG_FUNCTION, LOG_TITLE, "checkParameters", "Login parameter is invalid.");
            res = false;
        }
        return res;
    }
}

