/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.kmip.client.communicate;

import java.util.ArrayList;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.kms.kmip.client.communicate.ConnectKmsModule;
import sanproject.sn2.kms.kmip.client.communicate.ConnectKmsModuleThread;
import sanproject.sn2.kms.kmip.client.exception.KMSConfigException;
import sanproject.sn2.kms.kmip.client.exception.KmsCommunicationException;
import sanproject.sn2.kms.kmip.client.exception.KmsTimeoutException;
import sanproject.sn2.kms.kmip.client.exception.ReadPropertyFileException;
import sanproject.sn2.kms.kmip.client.info.KeyInfo;
import sanproject.sn2.kms.kmip.client.info.OutputInfo;
import sanproject.sn2.kms.kmip.client.ttlv.TTLV;
import sanproject.sn2.kms.util.SJkmsLogUtil;

public class Connector {
    private static final String module = "Connector";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TTLV sendMessageToKMS(KeyInfo keyInfo, TTLV sendTTLV) throws KMSConfigException, ReadPropertyFileException, KmsCommunicationException, KmsTimeoutException {
        String method = "sendMessageToKMS";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        ConnectKmsModule connectKmsModule = new ConnectKmsModule(keyInfo.getProperties(), keyInfo.isKeyStoreUpdateMode(), keyInfo.isTrustStoreUpdateMode(), keyInfo.getPassword());
        ArrayList<OutputInfo> arrayOutputList = new ArrayList<OutputInfo>();
        keyInfo.setOutputInfo(arrayOutputList);
        OutputInfo tmpOutputInfo = new OutputInfo();
        for (int i = 0; i < connectKmsModule.confAry.length; ++i) {
            boolean flag = false;
            if (!connectKmsModule.confAry[i].getEnabled()) continue;
            if (connectKmsModule.confAry[i].getConfigErrCode() == 10) {
                STD_LOGGER.info(module, method, " - Check the configuration object", " - invalid");
                tmpOutputInfo.setResultStatus("Connection Failed");
                tmpOutputInfo.setResultReason("KMSConfigException");
                continue;
            }
            if (i == 0 && keyInfo.isSecondaryMode()) continue;
            int timeoutCount = -1;
            int retryTimes = connectKmsModule.confAry[i].getRetryTimes();
            int retryInterval = connectKmsModule.confAry[i].getRetryInterval();
            do {
                STD_LOGGER.info(module, method, " - Start the communication process", " - retry times:" + (timeoutCount + 1) + ":" + connectKmsModule.confAry[i].getKmsName());
                ConnectKmsModuleThread kmsModuleThread = null;
                try {
                    kmsModuleThread = new ConnectKmsModuleThread(i, sendTTLV, connectKmsModule);
                    kmsModuleThread.setDaemon(true);
                    kmsModuleThread.start();
                    try {
                        int timeout = connectKmsModule.confAry[i].getTimeout();
                        if (timeout == 0) {
                            STD_LOGGER.info(module, method, " - Set Timeout", " - 999000");
                            kmsModuleThread.join(999000L);
                        } else {
                            STD_LOGGER.info(module, method, " - Set Timeout", " - " + timeout * 1000);
                            kmsModuleThread.join(timeout * 1000);
                        }
                    }
                    catch (InterruptedException e) {
                        STD_LOGGER.error(module, method, " - ", " - interrupted" + e);
                    }
                    if (kmsModuleThread.isAlive() && kmsModuleThread.isConnect) {
                        STD_LOGGER.info(module, method, " - ", " - No response from the KMS -timeout");
                        throw new KmsTimeoutException();
                    }
                    TTLV t = kmsModuleThread.getResv();
                    if (t == null) {
                        throw new KmsCommunicationException();
                    }
                    t.setKms(connectKmsModule.confAry[i].getKmsName());
                    TTLV tTLV = t;
                    return tTLV;
                }
                catch (KmsCommunicationException e) {
                    STD_LOGGER.info(module, method, " - failes in the communication process", " - retry times :" + (timeoutCount + 1));
                    if (++timeoutCount >= retryTimes) continue;
                    try {
                        Thread.sleep(retryInterval * 1000);
                    }
                    catch (InterruptedException ie) {
                        STD_LOGGER.error(module, method, " - ", " - interrupted" + ie);
                    }
                }
                catch (KmsTimeoutException e) {
                    STD_LOGGER.info(module, method, " - failes in KMS TimeOut", " - retry times :" + (timeoutCount + 1));
                    if (++timeoutCount < retryTimes) {
                        try {
                            Thread.sleep(retryInterval * 1000);
                        }
                        catch (InterruptedException ie) {
                            STD_LOGGER.error(module, method, " - ", " - interrupted" + ie);
                        }
                        continue;
                    }
                    throw new KmsTimeoutException();
                }
                finally {
                    connectKmsModule.closeConnection();
                    if (kmsModuleThread != null) {
                        kmsModuleThread = null;
                    }
                }
            } while (timeoutCount < retryTimes);
            if (flag) continue;
            STD_LOGGER.error(module, method, " - Communicate with KMS", " - failed");
            tmpOutputInfo.setResultStatus("Connection Failed");
            tmpOutputInfo.setResultReason("KmsCommunicationException");
            if (i != 0) continue;
            keyInfo.setSecondaryMode(true);
        }
        keyInfo.getOutputInfoList().add(tmpOutputInfo);
        STD_LOGGER.info(module, method, " - ", " - end");
        return null;
    }
}

