/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.kmip.client.convert;

import java.util.ArrayList;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.kms.kmip.client.convert.Converter;
import sanproject.sn2.kms.kmip.client.exception.KeyInfoBlankException;
import sanproject.sn2.kms.kmip.client.exception.RequestCommandException;
import sanproject.sn2.kms.kmip.client.exception.ResponseException;
import sanproject.sn2.kms.kmip.client.info.InputInfo;
import sanproject.sn2.kms.kmip.client.info.KeyInfo;
import sanproject.sn2.kms.kmip.client.info.OutputInfo;
import sanproject.sn2.kms.kmip.client.info.common.RequestHeaderContents;
import sanproject.sn2.kms.kmip.client.ttlv.TTLV;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVInteger;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVStructure;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVTextString;
import sanproject.sn2.kms.util.SJkmsLogUtil;

public class ConverterDeleteAttribute
extends Converter {
    private static final String module = "ConverterDeleteAttribute";

    @Override
    public TTLV makeSendTTLV(KeyInfo ki) throws RequestCommandException, KeyInfoBlankException {
        String method = "makeSendTTLV";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        InputInfo ii = ki.getInputInfo();
        String uniqueIdentifier = ii.getUniqueIdentifier();
        if (uniqueIdentifier == null || uniqueIdentifier.length() == 0) {
            STD_LOGGER.info(module, method, " - check UUID num", " - invalid");
            throw new KeyInfoBlankException();
        }
        ArrayList<String> attrList = ii.getRegisteredAttributesList();
        if (attrList == null || attrList.size() == 0) {
            STD_LOGGER.info(module, method, " - check registeredAttributes num", " - invalid");
            throw new KeyInfoBlankException();
        }
        TTLVStructure tReq = new TTLVStructure(120);
        RequestHeaderContents rhc = ii.getRequestHeaderContents();
        if (rhc != null) {
            rhc.setBatchCount(attrList.size());
        }
        tReq.addValue(this.getRequestHeader(rhc, attrList.size()));
        for (int i = 0; i < attrList.size(); ++i) {
            TTLVStructure tBI = this.getBatchItem(15, i + 1);
            tReq.addValue(tBI);
            TTLVStructure tPay = new TTLVStructure(121);
            tBI.addValue(tPay);
            tPay.addValue(new TTLVTextString(-108, uniqueIdentifier));
            TTLVStructure ta = new TTLVStructure(8);
            String attrName = attrList.get(i);
            if (attrName == null || attrName.length() == 0) {
                STD_LOGGER.info(module, method, " - check attribute name", " - invalid");
                throw new KeyInfoBlankException();
            }
            ta.addValue(new TTLVTextString(10, attrName));
            ta.addValue(new TTLVInteger(9, 0));
            tPay.addValue(ta);
        }
        STD_LOGGER.info(module, method, " - ", " - end");
        return tReq;
    }

    @Override
    public void parseBatchItemList(TTLVStructure resvTTLV, KeyInfo ki) throws ResponseException {
        String method = "parseBatchItemList";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        ArrayList<OutputInfo> oiList = ki.getOutputInfoList();
        if (resvTTLV.getValueSize((byte)15) < 0) {
            return;
        }
        ArrayList<TTLV> al = resvTTLV.getValueList((byte)15);
        for (int i = 0; i < al.size(); ++i) {
            OutputInfo oi = new OutputInfo();
            if (al.get(i).getType() != 1) {
                STD_LOGGER.info(module, method, " - check Type of Batch Item", " - invalid");
                throw new ResponseException();
            }
            TTLVStructure tRP = this.checkBatchItem((TTLVStructure)al.get(i), oi);
            if (tRP != null) {
                this.checkValue(tRP, (byte)-108, (byte)7, 1);
                TTLVTextString tUI = (TTLVTextString)tRP.getValueList((byte)-108).get(0);
                ArrayList<String> uniqueIdentifierList = new ArrayList<String>();
                uniqueIdentifierList.add(tUI.getValue());
                oi.setUniqueIdentifierList(uniqueIdentifierList);
            }
            oiList.add(oi);
        }
        ki.setOutputInfo(oiList);
        STD_LOGGER.info(module, method, " - ", " - end");
    }
}

