/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.kmip.client.convert;

import java.util.ArrayList;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.kms.kmip.client.convert.Converter;
import sanproject.sn2.kms.kmip.client.exception.KeyInfoBlankException;
import sanproject.sn2.kms.kmip.client.exception.RequestCommandException;
import sanproject.sn2.kms.kmip.client.exception.ResponseException;
import sanproject.sn2.kms.kmip.client.info.InputInfo;
import sanproject.sn2.kms.kmip.client.info.KeyInfo;
import sanproject.sn2.kms.kmip.client.info.OutputInfo;
import sanproject.sn2.kms.kmip.client.info.common.RequestHeaderContents;
import sanproject.sn2.kms.kmip.client.ttlv.TTLV;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVStructure;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVTextString;
import sanproject.sn2.kms.util.SJkmsLogUtil;

public class ConverterGetAttributeList
extends Converter {
    private static final String module = "ConverterGetAttributeList";

    @Override
    public TTLV makeSendTTLV(KeyInfo ki) throws RequestCommandException, KeyInfoBlankException {
        String method = "makeSendTTLV";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        InputInfo ii = ki.getInputInfo();
        TTLVStructure tReq = new TTLVStructure(120);
        RequestHeaderContents rhc = ii.getRequestHeaderContents();
        if (rhc != null) {
            rhc.setBatchCount(1);
        }
        tReq.addValue(this.getRequestHeader(rhc, 1));
        TTLVStructure tBI = this.getBatchItem(12);
        tReq.addValue(tBI);
        TTLVStructure tPay = new TTLVStructure(121);
        tBI.addValue(tPay);
        String s = ii.getUniqueIdentifier();
        if (s == null || s.length() == 0) {
            STD_LOGGER.info(module, method, " - check UUID", " - invalid");
            throw new KeyInfoBlankException();
        }
        tPay.addValue(new TTLVTextString(-108, s));
        STD_LOGGER.info(module, method, " - ", " - end");
        return tReq;
    }

    @Override
    public void parseBatchItemList(TTLVStructure resvTTLV, KeyInfo ki) throws ResponseException {
        String method = "parseBatchItemList";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        ArrayList<OutputInfo> oiList = ki.getOutputInfoList();
        OutputInfo oi = new OutputInfo();
        if (resvTTLV.getValueSize((byte)15) < 0) {
            return;
        }
        ArrayList<TTLV> al = resvTTLV.getValueList((byte)15);
        if (al.get(0).getType() != 1) {
            STD_LOGGER.info(module, method, " - check Type of Batch Item", " - invalid");
            throw new ResponseException();
        }
        TTLVStructure tRP = this.checkBatchItem((TTLVStructure)al.get(0), oi);
        if (tRP != null) {
            this.checkValue(tRP, (byte)-108, (byte)7, 1);
            TTLVTextString tUI = (TTLVTextString)tRP.getValueList((byte)-108).get(0);
            ArrayList<String> uniqueIdentifierList = new ArrayList<String>();
            uniqueIdentifierList.add(tUI.getValue());
            oi.setUniqueIdentifierList(uniqueIdentifierList);
            al = tRP.getValueList((byte)10);
            ArrayList<String> registeredAttributesList = new ArrayList<String>();
            for (int j = 0; j < al.size(); ++j) {
                if (al.get(j).getType() != 7) {
                    STD_LOGGER.info(module, method, " - check Type of Attribute Name", " - invalid");
                    throw new ResponseException();
                }
                TTLVTextString tt = (TTLVTextString)al.get(j);
                registeredAttributesList.add(tt.getValue());
            }
            oi.setRegisteredAttributesList(registeredAttributesList);
        }
        oiList.add(oi);
        ki.setOutputInfo(oiList);
        STD_LOGGER.info(module, method, " - ", " - end");
    }
}

