/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.kmip.client.convert;

import java.util.ArrayList;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.kms.kmip.client.convert.Converter;
import sanproject.sn2.kms.kmip.client.exception.KeyInfoBlankException;
import sanproject.sn2.kms.kmip.client.exception.RequestCommandException;
import sanproject.sn2.kms.kmip.client.exception.ResponseException;
import sanproject.sn2.kms.kmip.client.info.InputInfo;
import sanproject.sn2.kms.kmip.client.info.KeyInfo;
import sanproject.sn2.kms.kmip.client.info.OutputInfo;
import sanproject.sn2.kms.kmip.client.info.common.CryptographicParameters;
import sanproject.sn2.kms.kmip.client.info.common.Name;
import sanproject.sn2.kms.kmip.client.info.common.RequestHeaderContents;
import sanproject.sn2.kms.kmip.client.ttlv.TTLV;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVDateTime;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVEnumeration;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVInteger;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVStructure;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVTextString;
import sanproject.sn2.kms.util.SJkmsLogUtil;

public class ConverterLocate
extends Converter {
    private static final String module = "ConverterLocate";

    @Override
    public TTLV makeSendTTLV(KeyInfo ki) throws RequestCommandException, KeyInfoBlankException {
        TTLVStructure tAttr;
        String method = "makeSendTTLV";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        InputInfo ii = ki.getInputInfo();
        TTLVStructure tReq = new TTLVStructure(120);
        RequestHeaderContents rhc = ii.getRequestHeaderContents();
        if (rhc != null) {
            rhc.setBatchCount(1);
        }
        tReq.addValue(this.getRequestHeader(rhc, 1));
        TTLVStructure tBI = this.getBatchItem(8);
        tReq.addValue(tBI);
        TTLVStructure tPay = new TTLVStructure(121);
        tBI.addValue(tPay);
        tPay.addValue(new TTLVInteger(79, 512));
        TTLVStructure ta = new TTLVStructure(8);
        ta.addValue(new TTLVTextString(10, "Object Type"));
        int mode = this.getMode(ii);
        if (mode == 0) {
            STD_LOGGER.info(module, method, " - check mode", " - invalid");
            throw new KeyInfoBlankException();
        }
        String sortOfData = ii.getSortOfData();
        String keyType = sortOfData.substring(sortOfData.indexOf(":") + 1);
        if (keyType.startsWith("KEKdynamic")) {
            ta.addValue(new TTLVEnumeration(11, 2));
        } else {
            ta.addValue(new TTLVEnumeration(11, 7));
        }
        tPay.addValue(ta);
        ta = new TTLVStructure(8);
        ta.addValue(new TTLVTextString(10, "Object Group"));
        ta.addValue(new TTLVTextString(11, ii.getSortOfData()));
        tPay.addValue(ta);
        String s = ii.getProductID();
        if (s == null || s.length() == 0) {
            throw new KeyInfoBlankException();
        }
        ta = new TTLVStructure(8);
        ta.addValue(new TTLVTextString(10, "x-ProductID"));
        ta.addValue(new TTLVTextString(11, s));
        tPay.addValue(ta);
        if (mode == 2) {
            ta = new TTLVStructure(8);
            ta.addValue(new TTLVTextString(10, "x-SplitID"));
            ta.addValue(new TTLVInteger(11, ii.getSplitID()));
            tPay.addValue(ta);
            if (ii.getRegularBackup() == 0) {
                ta = new TTLVStructure(8);
                ta.addValue(new TTLVTextString(10, "x-RegularBackup"));
                ta.addValue(new TTLVTextString(11, Integer.toString(ii.getRegularBackup())));
                tPay.addValue(ta);
            }
        }
        if (mode == 3) {
            ta = new TTLVStructure(8);
            ta.addValue(new TTLVTextString(10, "x-KEKUID"));
            s = ii.getUniqueIdentifier();
            if (s == null || s.length() == 0) {
                throw new KeyInfoBlankException();
            }
            ta.addValue(new TTLVTextString(11, s));
            tPay.addValue(ta);
        }
        if (ii.getAttrNeeds("Name")) {
            Name name = ii.getNameList().get(0);
            if (name.getNameValue() == null || name.getNameValue().length() == 0) {
                throw new KeyInfoBlankException();
            }
            if (name.getNameType() == 0) {
                throw new KeyInfoBlankException();
            }
            TTLVStructure tAttr2 = new TTLVStructure(8);
            tPay.addValue(tAttr2);
            tAttr2.addValue(new TTLVTextString(10, "Name"));
            TTLVStructure tAttrName = new TTLVStructure(83);
            tAttr2.addValue(tAttrName);
            tAttrName.addValue(new TTLVTextString(85, name.getNameValue()));
            tAttrName.addValue(new TTLVEnumeration(84, name.getNameType()));
        }
        if (ii.getAttrNeeds("Cryptographic Usage Mask")) {
            tAttr = new TTLVStructure(8);
            tPay.addValue(tAttr);
            tAttr.addValue(new TTLVTextString(10, "Cryptographic Usage Mask"));
            TTLVStructure tAttrValue = new TTLVStructure(11);
            tAttr.addValue(tAttrValue);
            CryptographicParameters cp = ii.getCryptographicParameters();
            if (ii.getCryptographicParameters().getAttrNeeds(0)) {
                tAttrValue.addValue(new TTLVEnumeration(17, cp.getBlockCipherMode()));
            }
            if (ii.getCryptographicParameters().getAttrNeeds(1)) {
                tAttrValue.addValue(new TTLVEnumeration(95, cp.getPaddingMethod()));
            }
            if (ii.getCryptographicParameters().getAttrNeeds(2)) {
                tAttrValue.addValue(new TTLVEnumeration(56, cp.getHashingAlgorithm()));
            }
            if (ii.getCryptographicParameters().getAttrNeeds(3)) {
                tAttrValue.addValue(new TTLVEnumeration(-125, cp.getKeyRoleType()));
            }
        }
        if (ii.getAttrNeeds("State")) {
            tAttr = new TTLVStructure(8);
            tPay.addValue(tAttr);
            tAttr.addValue(new TTLVTextString(10, "State"));
            tAttr.addValue(new TTLVEnumeration(11, ii.getState()));
        }
        if (ii.getAttrNeeds("Activation Date")) {
            tAttr = new TTLVStructure(8);
            tPay.addValue(tAttr);
            tAttr.addValue(new TTLVTextString(10, "Activation Date"));
            tAttr.addValue(new TTLVDateTime(11, ii.getActivationDate()));
        }
        if (ii.getAttrNeeds("Deactivation Date")) {
            tAttr = new TTLVStructure(8);
            tPay.addValue(tAttr);
            tAttr.addValue(new TTLVTextString(10, "Deactivation Date"));
            tAttr.addValue(new TTLVDateTime(11, ii.getDeactivationDate()));
        }
        if (ii.getAttrNeeds("Compromise Occurrence Date")) {
            tAttr = new TTLVStructure(8);
            tPay.addValue(tAttr);
            tAttr.addValue(new TTLVTextString(10, "Compromise Occurrence Date"));
            tAttr.addValue(new TTLVDateTime(11, ii.getCompromiseOccurrenceDate()));
        }
        if (ii.getAttrNeeds("Compromise Date")) {
            tAttr = new TTLVStructure(8);
            tPay.addValue(tAttr);
            tAttr.addValue(new TTLVTextString(10, "Compromise Date"));
            tAttr.addValue(new TTLVDateTime(11, ii.getCompromiseDate()));
        }
        if (ii.getAttrNeeds("Revocation Reason")) {
            tAttr = new TTLVStructure(8);
            tPay.addValue(tAttr);
            tAttr.addValue(new TTLVTextString(10, "Revocation Reason"));
            tAttr.addValue(new TTLVEnumeration(11, ii.getRevocationReason()));
        }
        STD_LOGGER.info(module, method, " - ", " - end");
        return tReq;
    }

    protected int getMode(InputInfo ii) {
        String method = "getMode";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        String[] compareString = new String[]{"VSP:DEK", "VSP:KEK", "HUS_VM:KEK", "HUS_VM:KEKdynamic", "R800:KEK", "R800:KEKdynamic"};
        String s = ii.getSortOfData();
        if (s == null) {
            STD_LOGGER.info(module, method, " - check SortOfData", " - invalid");
            return 0;
        }
        for (int i = 0; i < compareString.length; ++i) {
            if (s.compareToIgnoreCase(compareString[i]) != 0) continue;
            STD_LOGGER.info(module, method, " - ", " - end");
            return 1;
        }
        String husvm_dek = "HUS_VM:DEK";
        String r800_dek = "R800:DEK";
        if (s.compareToIgnoreCase(r800_dek) == 0 || s.compareToIgnoreCase(husvm_dek) == 0) {
            STD_LOGGER.info(module, method, " - ", " - end");
            return ii.getSplitFlag() ? 2 : 3;
        }
        STD_LOGGER.info(module, method, " - check SortOfData", " - mismatch");
        return 0;
    }

    @Override
    public void parseBatchItemList(TTLVStructure resvTTLV, KeyInfo ki) throws ResponseException {
        String method = "parseBatchItemList";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        ArrayList<OutputInfo> oiList = ki.getOutputInfoList();
        if (resvTTLV.getValueSize((byte)15) < 0) {
            return;
        }
        ArrayList<TTLV> al = resvTTLV.getValueList((byte)15);
        for (int i = 0; i < al.size(); ++i) {
            OutputInfo oi = new OutputInfo();
            if (al.get(i).getType() != 1) {
                STD_LOGGER.info(module, method, " - check Type of Batch Item", " - invalid");
                throw new ResponseException();
            }
            TTLVStructure tRP = this.checkBatchItem((TTLVStructure)al.get(i), oi);
            if (tRP != null) {
                ArrayList<String> uniqueIdentifierList = new ArrayList<String>();
                for (int j = 0; j < tRP.getValueSize(); ++j) {
                    TTLVTextString tUI = (TTLVTextString)tRP.getValueList((byte)-108).get(j);
                    uniqueIdentifierList.add(tUI.getValue());
                }
                oi.setUniqueIdentifierList(uniqueIdentifierList);
            }
            oiList.add(oi);
        }
        ki.setOutputInfo(oiList);
        STD_LOGGER.info(module, method, " - ", " - end");
    }
}

