/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.kmip.client.ttlv;

import java.util.ArrayList;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.kms.util.SJkmsLogUtil;

public abstract class TTLV {
    private static final String module = "TTLV";
    public static final byte POS_TAG = 0;
    public static final byte POS_TYPE = 3;
    public static final byte POS_LENGTH = 4;
    public static final byte POS_VALUE = 8;
    public static final byte TAG_HEADER = 66;
    public static final byte TAG_HEADER_EXT = 84;
    public static final byte TAG_ACTIVATION_DATE = 1;
    public static final byte TAG_APPLICATION_DATA = 2;
    public static final byte TAG_APPLICATION_NAMESPACE = 3;
    public static final byte TAG_APPLICATION_SPECIFIC_INFORMATION = 4;
    public static final byte TAG_ARCHIVE_DATE = 5;
    public static final byte TAG_ASYNCHRONOUS_CORRELATION_VALUE = 6;
    public static final byte TAG_ASYNCHRONOUS_INDICATOR = 7;
    public static final byte TAG_ATTRIBUTE = 8;
    public static final byte TAG_ATTRIBUTE_INDEX = 9;
    public static final byte TAG_ATTRIBUTE_NAME = 10;
    public static final byte TAG_ATTRIBUTE_VALUE = 11;
    public static final byte TAG_AUTHENTICATION = 12;
    public static final byte TAG_BATCH_COUNT = 13;
    public static final byte TAG_BATCH_ERROR_CONTINUATION_OPTION = 14;
    public static final byte TAG_BATCH_ITEM = 15;
    public static final byte TAG_BATCH_ORDER_OPTION = 16;
    public static final byte TAG_BLOCK_CIPHER_MODE = 17;
    public static final byte TAG_CANCELLATION_RESULT = 18;
    public static final byte TAG_CERTIFICATE = 19;
    public static final byte TAG_CERTIFICATE_IDENTIFIER = 20;
    public static final byte TAG_CERTIFICATE_ISSUER = 21;
    public static final byte TAG_CERTIFICATE_ISSUER_ALTERNATIVE_NAME = 22;
    public static final byte TAG_CERTIFICATE_ISSUER_DISTINGUISHED_NAME = 23;
    public static final byte TAG_CERTIFICATE_REQUEST = 24;
    public static final byte TAG_CERTIFICATE_REQUEST_TYPE = 25;
    public static final byte TAG_CERTIFICATE_SUBJECT = 26;
    public static final byte TAG_CERTIFICATE_SUBJECT_ALTERNATIVE_NAME = 27;
    public static final byte TAG_CERTIFICATE_SUBJECT_DISTINGUISHED_NAME = 28;
    public static final byte TAG_CERTIFICATE_TYPE = 29;
    public static final byte TAG_CERTIFICATE_VALUE = 30;
    public static final byte TAG_COMMON_TEMPLATE_ATTRIBUTE = 31;
    public static final byte TAG_COMPROMISE_DATE = 32;
    public static final byte TAG_COMPROMISE_OCCURRENCE_DATE = 33;
    public static final byte TAG_CONTACT_INFORMATION = 34;
    public static final byte TAG_CREDENTIAL = 35;
    public static final byte TAG_CREDENTIAL_TYPE = 36;
    public static final byte TAG_CREDENTIAL_VALUE = 37;
    public static final byte TAG_CRITICALITY_INDICATOR = 38;
    public static final byte TAG_CRT_COEFFICIENT = 39;
    public static final byte TAG_CRYPTOGRAPHIC_ALGORITHM = 40;
    public static final byte TAG_CRYPTOGRAPHIC_DOMAIN_PARAMETERS = 41;
    public static final byte TAG_CRYPTOGRAPHIC_LENGTH = 42;
    public static final byte TAG_CRYPTOGRAPHIC_PARAMETERS = 43;
    public static final byte TAG_CRYPTOGRAPHIC_USAGE_MASK = 44;
    public static final byte TAG_CUSTOM_ATTRIBUTE = 45;
    public static final byte TAG_D = 46;
    public static final byte TAG_DEACTIVATION_DATE = 47;
    public static final byte TAG_DERIVATION_DATA = 48;
    public static final byte TAG_DERIVATION_METHOD = 49;
    public static final byte TAG_DERIVATION_PARAMETERS = 50;
    public static final byte TAG_DESTROY_DATE = 51;
    public static final byte TAG_DIGEST = 52;
    public static final byte TAG_DIGEST_VALUE = 53;
    public static final byte TAG_ENCRYPTION_KEY_INFORMATION = 54;
    public static final byte TAG_G = 55;
    public static final byte TAG_HASHING_ALGORITHM = 56;
    public static final byte TAG_INITIAL_DATE = 57;
    public static final byte TAG_INITIALIZATION_VECTOR = 58;
    public static final byte TAG_ISSUER = 59;
    public static final byte TAG_ITERATION_COUNTITERATION = 60;
    public static final byte TAG_IV_COUNTER_NONCE = 61;
    public static final byte TAG_J = 62;
    public static final byte TAG_KEY = 63;
    public static final byte TAG_KEY_BLOCK = 64;
    public static final byte TAG_KEY_COMPRESSION_TYPE = 65;
    public static final byte TAG_KEY_FORMAT_TYPE = 66;
    public static final byte TAG_KEY_MATERIAL = 67;
    public static final byte TAG_KEY_PART_IDENTIFIER = 68;
    public static final byte TAG_KEY_VALUE = 69;
    public static final byte TAG_KEY_WRAPPING_DATA = 70;
    public static final byte TAG_KEY_WRAPPING_SPECIFICATION = 71;
    public static final byte TAG_LAST_CHANGE_DATE = 72;
    public static final byte TAG_LEASE_TIME = 73;
    public static final byte TAG_LINK = 74;
    public static final byte TAG_LINK_TYPE = 75;
    public static final byte TAG_LINKED_OBJECT_IDENTIFIER = 76;
    public static final byte TAG_MAC_SIGNATURE = 77;
    public static final byte TAG_MAC_SIGNATURE_KEY_INFROMATION = 78;
    public static final byte TAG_MAXIMUM_ITEMS = 79;
    public static final byte TAG_MAXIMUM_RESPONSE_SIZE = 80;
    public static final byte TAG_MESSAGE_EXTENSION = 81;
    public static final byte TAG_MODULUS = 82;
    public static final byte TAG_NAME = 83;
    public static final byte TAG_NAME_TYPE = 84;
    public static final byte TAG_NAME_VALUE = 85;
    public static final byte TAG_OBJECT_GROUP = 86;
    public static final byte TAG_OBJECT_TYPE = 87;
    public static final byte TAG_OFFSET = 88;
    public static final byte TAG_OPAQUE_DATA_TYPE = 89;
    public static final byte TAG_OPAQUE_DATA_VALUE = 90;
    public static final byte TAG_OPAQUE_OBJECT = 91;
    public static final byte TAG_OPERATION = 92;
    public static final byte TAG_OPERATION_POLICY_NAME = 93;
    public static final byte TAG_P = 94;
    public static final byte TAG_PADDING_METHOD = 95;
    public static final byte TAG_PRIME_EXPONENT_P = 96;
    public static final byte TAG_PRIME_EXPONENT_Q = 97;
    public static final byte TAG_PRIME_FIELD_SIZE = 98;
    public static final byte TAG_PRIVATE_EXPONENT = 99;
    public static final byte TAG_PRIVATE_KEY = 100;
    public static final byte TAG_PRIVATE_KEY_TEMPLATE_ATTRIBUTE = 101;
    public static final byte TAG_PRIVATE_KEY_UNIQUE_IDENTIFIER = 102;
    public static final byte TAG_PROCESS_START_DATE = 103;
    public static final byte TAG_PROTECT_STOP_DATE = 104;
    public static final byte TAG_PROTOCOL_VERSION = 105;
    public static final byte TAG_PROTOCOL_VERSION_MAJOR = 106;
    public static final byte TAG_PROTOCOL_VERSION_MINOR = 107;
    public static final byte TAG_PUBLIC_EXPONENT = 108;
    public static final byte TAG_PUBLIC_KEY = 109;
    public static final byte TAG_PUBLIC_KEY_TEMPLATE_ATTRIBUTE = 110;
    public static final byte TAG_PUBLIC_KEY_UNIQUE_IDENTIFIER = 111;
    public static final byte TAG_PUT_FUNCTION = 112;
    public static final byte TAG_Q = 113;
    public static final byte TAG_Q_STRING = 114;
    public static final byte TAG_QLENGTH = 115;
    public static final byte TAG_QUERY_FUNCTION = 116;
    public static final byte TAG_RECOMMENDED_CURVE = 117;
    public static final byte TAG_REPLACED_UNIQUE_IDENTIFIER = 118;
    public static final byte TAG_REQUEST_HEADER = 119;
    public static final byte TAG_REQUEST_MESSAGE = 120;
    public static final byte TAG_REQUEST_PAYLOAD = 121;
    public static final byte TAG_RESPONSE_HEADER = 122;
    public static final byte TAG_RESPONSE_MESSAGE = 123;
    public static final byte TAG_RESPONSE_PAYLOAD = 124;
    public static final byte TAG_RESULT_MESSAGE = 125;
    public static final byte TAG_RESULT_REASON = 126;
    public static final byte TAG_RESULT_STATUS = 127;
    public static final byte TAG_REVOCATION_MESSAGE = -128;
    public static final byte TAG_REVOCATION_REASON = -127;
    public static final byte TAG_REVOCATION_REASON_CODE = -126;
    public static final byte TAG_KEY_ROLE_TYPE = -125;
    public static final byte TAG_SALT = -124;
    public static final byte TAG_SECRET_DATA = -123;
    public static final byte TAG_SECRET_DATA_TYPE = -122;
    public static final byte TAG_SERIAL_NUMAER = -121;
    public static final byte TAG_SERVER_INFORMATION = -120;
    public static final byte TAG_SPLIT_KEY = -119;
    public static final byte TAG_SPLIT_KEY_METHOD = -118;
    public static final byte TAG_SPLIT_KEY_PARTS = -117;
    public static final byte TAG_SPLIT_KEY_THRESHOLD = -116;
    public static final byte TAG_STATE = -115;
    public static final byte TAG_STORAGE_STATUS_MASK = -114;
    public static final byte TAG_SYMMETRIC_KEY = -113;
    public static final byte TAG_TEMPLATE = -112;
    public static final byte TAG_TEMPLATE_ATTRIBUTE = -111;
    public static final byte TAG_TIME_STAMP = -110;
    public static final byte TAG_UNIQUE_BATCH_ITEM_ID = -109;
    public static final byte TAG_UNIQUE_IDENTIFIER = -108;
    public static final byte TAG_USAGE_LIMITS = -107;
    public static final byte TAG_USAGE_LIMITS_COUNT = -106;
    public static final byte TAG_USAGE_LIMITS_TOTAL = -105;
    public static final byte TAG_USAGE_LIMITS_UNIT = -104;
    public static final byte TAG_USERNAME = -103;
    public static final byte TAG_VALIDITY_DATE = -102;
    public static final byte TAG_VALIDITY_INDICATOR = -101;
    public static final byte TAG_VENDOR_EXTENSION = -100;
    public static final byte TAG_VENDOR_IDENTIFICATION = -99;
    public static final byte TAG_WRAPPING_METHOD = -98;
    public static final byte TAG_X = -97;
    public static final byte TAG_Y = -96;
    public static final byte TAG_PASSWORD = -95;
    public static final byte TAG_DEVICE_IDENTIFIER = -94;
    public static final byte TAG_ENCODING_OPTION = -93;
    public static final byte TAG_EXTENSION_INFORMATION = -92;
    public static final byte TAG_EXTENSION_NAME = -91;
    public static final byte TAG_EXTENSION_TAG = -90;
    public static final byte TAG_EXTENSION_TYPE = -89;
    public static final byte TAG_FRESH = -88;
    public static final byte TAG_MACHINE_IDENTIFIER = -87;
    public static final byte TAG_MEDIA_IDENTIFIER = -86;
    public static final byte TAG_NETWORK_IDENTIFIER = -85;
    public static final byte TAG_OBJECT_GROUP_MEMBER = -84;
    public static final byte TAG_CERTIFICATE_LENGTH = -83;
    public static final byte TAG_DIGITAL_SIGNATURE_ALGORITHM = -82;
    public static final byte TAG_CERTIFICATE_SERIAL_NUMBER = -81;
    public static final byte TAG_DEVICE_SERIAL_NUMBER = -80;
    public static final byte TAG_ISSUER_ALTERNATIVE_NAME = -79;
    public static final byte TAG_ISSUER_DISTINGUISHED_NAME = -78;
    public static final byte TAG_SUBJECT_ALTERNATIVE_NAME = -77;
    public static final byte TAG_SUBSUBJECT_DISTINGUISHED_NAME = -76;
    public static final byte TAG_X_509_CERTIFICATE_IDENTIFIER = -75;
    public static final byte TAG_X_509_CERTIFICATE_ISSUER = -74;
    public static final byte TAG_X_509_CERTIFICATE_SUBJECT = -73;
    public static final byte TYPE_STRUCTURE = 1;
    public static final byte TYPE_INTEGER = 2;
    public static final byte TYPE_LONG_INTEGER = 3;
    public static final byte TYPE_BIG_INTEGER = 4;
    public static final byte TYPE_ENUMERATION = 5;
    public static final byte TYPE_BOOLEAN = 6;
    public static final byte TYPE_TEXT_STRING = 7;
    public static final byte TYPE_BYTE_STRING = 8;
    public static final byte TYPE_DATE_TIME = 9;
    public static final byte TYPE_INTERVAL = 10;
    public static final int OPERATION_CREATE = 1;
    public static final int OPERATION_CREATE_KEY_PAIR = 2;
    public static final int OPERATION_REGISTER = 3;
    public static final int OPERATION_RE_KEY = 4;
    public static final int OPERATION_DERIVE_KEY = 5;
    public static final int OPERATION_CERTIFY = 6;
    public static final int OPERATION_RE_CERTIFY = 7;
    public static final int OPERATION_LOCATE = 8;
    public static final int OPERATION_CHECK = 9;
    public static final int OPERATION_GET = 10;
    public static final int OPERATION_GET_ATTRIBUTES = 11;
    public static final int OPERATION_GET_ATTRIBUTE_LIST = 12;
    public static final int OPERATION_ADD_ATTRIBUTE = 13;
    public static final int OPERATION_MODIFY_ATTRIBUTE = 14;
    public static final int OPERATION_DELETE_ATTRIBUTE = 15;
    public static final int OPERATION_OBTAIN_LEASE = 16;
    public static final int OPERATION_GET_USAGE_ALLOCATION = 17;
    public static final int OPERATION_ACTIVATE = 18;
    public static final int OPERATION_REVOKE = 19;
    public static final int OPERATION_DESTROY = 20;
    public static final int OPERATION_ARCHIVE = 21;
    public static final int OPERATION_RECOVER = 22;
    public static final int OPERATION_VALIDATE = 23;
    public static final int OPERATION_QUERY = 24;
    public static final int OPERATION_CANCEL = 25;
    public static final int OPERATION_POLL = 26;
    public static final int OPERATION_NOTIFY = 27;
    public static final int OPERATION_PUT = 28;
    public static final int OPERATION_RE_KEY_KEY_PAIR = 29;
    public static final int OPERATION_DISCOVER_VERSIONS = 30;
    public static final int QUERY_FUNCTION_QUERY_OPERATIONS = 1;
    public static final int QUERY_FUNCTION_QUERY_OBJECTS = 2;
    public static final int QUERY_FUNCTION_QUERY_SERVER_INFORMATION = 3;
    public static final int QUERY_FUNCTION_QUERY_APPLICATION_NAMESPACES = 4;
    public static final int QUERY_FUNCTION_QUERY_EXTENSION_LIST = 5;
    public static final int QUERY_FUNCTION_QUERY_EXTENSION_MAP = 6;
    public static final int REVOCATION_REASON_CODE_UNSPECIFIED = 1;
    public static final int REVOCATION_REASON_CODE_KEY_COMPROMISE = 2;
    public static final int REVOCATION_REASON_CODE_CA_COMPROMISE = 3;
    public static final int REVOCATION_REASON_CODE_AFFILIATION_CHANGED = 4;
    public static final int REVOCATION_REASON_CODE_SUPERSEDED = 5;
    public static final int REVOCATION_REASON_CODE_CESSATION_OF_OPERATION = 6;
    public static final int REVOCATION_REASON_CODE_PRIVILEGE_WITHDRAWN = 7;
    public static final int CRYPTOGRAPHIC_ALGORITHM_DES = 1;
    public static final int CRYPTOGRAPHIC_ALGORITHM_3DES = 2;
    public static final int CRYPTOGRAPHIC_ALGORITHM_AES = 3;
    public static final int CRYPTOGRAPHIC_ALGORITHM_RSA = 4;
    public static final int CRYPTOGRAPHIC_ALGORITHM_DSA = 5;
    public static final int CRYPTOGRAPHIC_ALGORITHM_ECDSA = 6;
    public static final int CRYPTOGRAPHIC_ALGORITHM_HMAC_SHA1 = 7;
    public static final int CRYPTOGRAPHIC_ALGORITHM_HMAC_SHA224 = 8;
    public static final int CRYPTOGRAPHIC_ALGORITHM_HMAC_SHA256 = 9;
    public static final int CRYPTOGRAPHIC_ALGORITHM_HMAC_SHA384 = 10;
    public static final int CRYPTOGRAPHIC_ALGORITHM_HMAC_SHA512 = 11;
    public static final int CRYPTOGRAPHIC_ALGORITHM_HMAC_MD5 = 12;
    public static final int CRYPTOGRAPHIC_ALGORITHM_DH = 13;
    public static final int CRYPTOGRAPHIC_ALGORITHM_ECDH = 14;
    public static final int CRYPTOGRAPHIC_ALGORITHM_ECMQV = 15;
    public static final int CRYPTOGRAPHIC_ALGORITHM_BLOWFISH = 16;
    public static final int CRYPTOGRAPHIC_ALGORITHM_CAMELLIA = 17;
    public static final int CRYPTOGRAPHIC_ALGORITHM_CAST5 = 18;
    public static final int CRYPTOGRAPHIC_ALGORITHM_IDEA = 19;
    public static final int CRYPTOGRAPHIC_ALGORITHM_MARS = 20;
    public static final int CRYPTOGRAPHIC_ALGORITHM_RC2 = 21;
    public static final int CRYPTOGRAPHIC_ALGORITHM_RC4 = 22;
    public static final int CRYPTOGRAPHIC_ALGORITHM_RC5 = 23;
    public static final int CRYPTOGRAPHIC_ALGORITHM_SKIPJACK = 24;
    public static final int CRYPTOGRAPHIC_ALGORITHM_TWOFISH = 25;
    public static final int NAME_TYPE_UNINTERPRETED_TEXT_STRING = 1;
    public static final int NAME_TYPE_URI = 2;
    public static final int STATE_PRE_ACTIVE = 1;
    public static final int STATE_ACTIVE = 2;
    public static final int STATE_DEACTIVATED = 3;
    public static final int STATE_COMPROMISED = 4;
    public static final int STATE_DESTROYED = 5;
    public static final int STATE_DESTROYED_COMPROMISED = 6;
    public static final int CREDENTIAL_TYPE_USERNAME_AND_PASSWORD = 1;
    public static final int CREDENTIAL_TYPE_USERNAME_DEVICE = 2;
    public static final int BLOCK_CIPHER_MODE_CBC = 1;
    public static final int BLOCK_CIPHER_MODE_ECB = 2;
    public static final int BLOCK_CIPHER_MODE_PCBC = 3;
    public static final int BLOCK_CIPHER_MODE_CFB = 4;
    public static final int BLOCK_CIPHER_MODE_OFB = 5;
    public static final int BLOCK_CIPHER_MODE_CTR = 6;
    public static final int BLOCK_CIPHER_MODE_CMAC = 7;
    public static final int BLOCK_CIPHER_MODE_CCM = 8;
    public static final int BLOCK_CIPHER_MODE_GCM = 9;
    public static final int BLOCK_CIPHER_MODE_CBC_MAC = 10;
    public static final int BLOCK_CIPHER_MODE_XTS = 11;
    public static final int BLOCK_CIPHER_MODE_AESKEYWRAPPADDING = 12;
    public static final int BLOCK_CIPHER_MODE_NISTKEYWRAP = 13;
    public static final int BLOCK_CIPHER_MODE_X9_102_AESKW = 14;
    public static final int BLOCK_CIPHER_MODE_X9_102_TDKW = 15;
    public static final int BLOCK_CIPHER_MODE_X9_102_AKW1 = 16;
    public static final int BLOCK_CIPHER_MODE_X9_102_AKW2 = 17;
    public static final int PADDING_METHOD_NONE = 1;
    public static final int PADDING_METHOD_OAEP = 2;
    public static final int PADDING_METHOD_PKCS5 = 3;
    public static final int PADDING_METHOD_SSL3 = 4;
    public static final int PADDING_METHOD_ZEROS = 5;
    public static final int PADDING_METHOD_ANSI_X9_23 = 6;
    public static final int PADDING_METHOD_ISO_10126 = 7;
    public static final int PADDING_METHOD_PKCS1_V1_5 = 8;
    public static final int PADDING_METHOD_X9_31 = 9;
    public static final int PADDING_METHOD_PSS = 10;
    public static final int HASHING_ALGORITHM_MD2 = 1;
    public static final int HASHING_ALGORITHM_MD4 = 2;
    public static final int HASHING_ALGORITHM_MD5 = 3;
    public static final int HASHING_ALGORITHM_SHA_1 = 4;
    public static final int HASHING_ALGORITHM_SHA_224 = 5;
    public static final int HASHING_ALGORITHM_SHA_256 = 6;
    public static final int HASHING_ALGORITHM_SHA_384 = 7;
    public static final int HASHING_ALGORITHM_SHA_512 = 8;
    public static final int HASHING_ALGORITHM_RIPEMD_160 = 9;
    public static final int HASHING_ALGORITHM_TIGER = 10;
    public static final int HASHING_ALGORITHM_WHIRLPOOL = 11;
    public static final int KEY_ROLE_TYPE_BDK = 1;
    public static final int KEY_ROLE_TYPE_CVK = 2;
    public static final int KEY_ROLE_TYPE_DEK = 3;
    public static final int KEY_ROLE_TYPE_MKAC = 4;
    public static final int KEY_ROLE_TYPE_MKSMC = 5;
    public static final int KEY_ROLE_TYPE_MKSMI = 6;
    public static final int KEY_ROLE_TYPE_MKDAC = 7;
    public static final int KEY_ROLE_TYPE_MKDN = 8;
    public static final int KEY_ROLE_TYPE_MKCP = 9;
    public static final int KEY_ROLE_TYPE_MKOTH = 10;
    public static final int KEY_ROLE_TYPE_KEK = 11;
    public static final int KEY_ROLE_TYPE_MAC16609 = 12;
    public static final int KEY_ROLE_TYPE_MAC97971 = 13;
    public static final int KEY_ROLE_TYPE_MAC97972 = 14;
    public static final int KEY_ROLE_TYPE_MAC97973 = 15;
    public static final int KEY_ROLE_TYPE_MAC97974 = 16;
    public static final int KEY_ROLE_TYPE_MAC97975 = 17;
    public static final int KEY_ROLE_TYPE_ZPK = 18;
    public static final int KEY_ROLE_TYPE_PVKIBM = 19;
    public static final int KEY_ROLE_TYPE_PVKPVV = 20;
    public static final int KEY_ROLE_TYPE_PVKOTH = 21;
    public static final int KEY_FORMAT_TYPE_RAW = 1;
    public static final int KEY_FORMAT_TYPE_OPAQUE = 2;
    public static final int KEY_FORMAT_TYPE_PKCS1 = 3;
    public static final int KEY_FORMAT_TYPE_PKCS8 = 4;
    public static final int KEY_FORMAT_TYPE_X_509 = 5;
    public static final int KEY_FORMAT_TYPE_ECPRIVATEKEY = 6;
    public static final int KEY_FORMAT_TYPE_TRANSPARENT_SYMMETRIC_KEY = 7;
    public static final int KEY_FORMAT_TYPE_TRANSPARENT_DSA_PRIVATE_KEY = 8;
    public static final int KEY_FORMAT_TYPE_TRANSPARENT_DSA_PUBLIC_KEY = 9;
    public static final int KEY_FORMAT_TYPE_TRANSPARENT_RSA_PRIVATE_KEY = 10;
    public static final int KEY_FORMAT_TYPE_TRANSPARENT_RSA_PUBLIC_KEY = 11;
    public static final int KEY_FORMAT_TYPE_TRANSPARENT_DH_PRIVATE_KEY = 12;
    public static final int KEY_FORMAT_TYPE_TRANSPARENT_DH_PUBLIC_KEY = 13;
    public static final int KEY_FORMAT_TYPE_TRANSPARENT_ECDSA_PRIVATE_KEY = 14;
    public static final int KEY_FORMAT_TYPE_TRANSPARENT_ECDSA_PUBLIC_KEY = 15;
    public static final int KEY_FORMAT_TYPE_TRANSPARENT_ECDH_PRIVATE_KEY = 16;
    public static final int KEY_FORMAT_TYPE_TRANSPARENT_ECDH_PUBLIC_KEY = 17;
    public static final int KEY_FORMAT_TYPE_TRANSPARENT_ECMQV_PRIVATE_KEY = 18;
    public static final int KEY_FORMAT_TYPE_TRANSPARENT_ECMQV_PUBLIC_KEY = 19;
    public static final int BATCH_ERROR_CONTINUATION_CONTINUE = 1;
    public static final int BATCH_ERROR_CONTINUATION_STOP = 2;
    public static final int BATCH_ERROR_CONTINUATION_UNDO = 3;
    public static final int SECRET_DATA_TYPE_PASSWORD = 1;
    public static final int SECRET_DATA_TYPE_SEED = 2;
    public static final int OBJECT_TYPE_CERTIFICATE = 1;
    public static final int OBJECT_TYPE_SYMMETRIC_KEY = 2;
    public static final int OBJECT_TYPE_PUBLIC_KEY = 3;
    public static final int OBJECT_TYPE_PRIVATE_KEY = 4;
    public static final int OBJECT_TYPE_SPLIT_KEY = 5;
    public static final int OBJECT_TYPE_TEMPLATE = 6;
    public static final int OBJECT_TYPE_SECRET_DATA = 7;
    public static final int OBJECT_TYPE_OPAQUE_OBJECT = 8;
    public static final byte TAG_DUMMY = 0;
    public static final byte PADDING_DATA = 0;
    protected String kmsName = null;
    protected byte tag;
    protected int length;

    public TTLV(byte tag) {
        String method = "constructor";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        this.init();
        this.tag = tag;
    }

    public TTLV(byte[] data, int pos) {
        String method = "constructor";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        this.init();
        this.tag = data[pos + 0 + 2];
        this.length = 0;
        for (int i = 4; i < 8; ++i) {
            this.length <<= 8;
            this.length += data[pos + i] & 0xFF;
        }
    }

    protected abstract void init();

    public String getKms() {
        return this.kmsName;
    }

    public void setKms(String kmsName) {
        this.kmsName = kmsName;
    }

    public byte getTag() {
        String method = "getTag";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        return this.tag;
    }

    public abstract byte getType();

    public int getLength() {
        String method = "getLength";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        return this.length;
    }

    public int getBinaryDataSize() {
        int surplus;
        String method = "getBinaryDataSize";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        int binaryDataSize = 8 + this.length - surplus + ((surplus = this.length & 7) > 0 ? 8 : 0);
        return binaryDataSize;
    }

    public void makeSendData(byte[] data) {
        String method = "makeSendData";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        this.makeSendData(data, 0);
    }

    public abstract void makeSendData(byte[] var1, int var2);

    protected void makeTTL(byte[] data, int pos) {
        String method = "makeTTL";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        data[pos + 0] = 66;
        data[pos + 0 + 1] = 0;
        data[pos + 0 + 2] = this.tag;
        data[pos + 3] = this.getType();
        int l = this.length;
        for (int i = 7; i >= 4; --i) {
            data[pos + i] = (byte)(l & 0xFF);
            l >>= 8;
        }
    }

    public static int parseLength(byte[] src, int pos) {
        String method = "parseLength";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        int r = 0;
        for (int i = 4; i < 8; ++i) {
            r <<= 8;
            r += src[i + pos] & 0xFF;
        }
        return r;
    }

    protected static int convertInteger(byte[] src) {
        String method = "convertInteger";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        int r = 0;
        for (int i = 0; i < src.length; ++i) {
            r <<= 8;
            r += src[i] & 0xFF;
        }
        return r;
    }

    protected static long convertLongInteger(byte[] src) {
        String method = "convertLongInteger";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        long r = 0L;
        for (int i = 0; i < src.length; ++i) {
            r <<= 8;
            r += (long)(src[i] & 0xFF);
        }
        return r;
    }

    protected static void convertByte(long src, byte[] dst) {
        String method = "convertByte";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        for (int i = dst.length - 1; i >= 0; --i) {
            dst[i] = (byte)(src & 0xFFL);
            src >>= 8;
        }
    }

    public static void convertByte(long src, ArrayList<Byte> dst) {
        String method = "convertByte";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        dst.clear();
        if (src == 0L) {
            dst.add((byte)0);
        }
        for (long l = src; l > 0L; l >>= 8) {
            dst.add((byte)(l & 0xFFL));
            src >>= 8;
        }
    }

    public static String printBinaryData(byte[] data) {
        if (data == null) {
            return "null";
        }
        String str = " binary :";
        for (int i = 0; i < data.length; ++i) {
            str = str + String.format(" %02X", data[i]);
        }
        return str;
    }

    public String printTTLV(int level) {
        String msg = "";
        for (int i = 0; i < level; ++i) {
            msg = msg + "\t";
        }
        byte[] data = new byte[this.getBinaryDataSize()];
        this.makeSendData(data, 0);
        for (int i = 0; i < data.length; ++i) {
            msg = msg + String.format(" %02X", data[i]);
        }
        return msg + "\n";
    }
}

