/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.util;

import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcSecureUty;
import sanproject.sn2.com.utility.SJcStringUty;
import sanproject.sn2.kms.common.SJkmsCreateInfo;
import sanproject.sn2.kms.exception.SJkmsCommunicationException;
import sanproject.sn2.kms.exception.SJkmsPasswordUtyException;
import sanproject.sn2.kms.util.SJkmsCommunicationUty;
import sanproject.sn2.kms.util.SJkmsConfigUtyCom;
import sanproject.sn2.kms.util.SJkmsLogUtil;

public class SJkmsPasswordUty {
    private static final String LOG_FUNCTION = "Kms";
    private static final String LOG_TITLE = "SJkmsPasswordUty";
    private static final String fixedString_KEK_PASS = "RSD_ShunKameoka_Works_ZFS_Drobo";
    private static final String fixedString_PASS_KEY = "TKSan0";
    private static final String fixedString_PASS_KEY_KEY = "HoriNamagakiLove";

    private SJkmsPasswordUty() {
    }

    public static SJkmsCreateInfo getPassword(String productID) throws SJkmsPasswordUtyException, SJkmsCommunicationException {
        String LOG_SUBTITLE = "getPassword";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getPassword", "start");
        if (productID == null || productID.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getPassword", "parameter is null");
            throw new SJkmsPasswordUtyException("107001");
        }
        SJkmsCreateInfo ret = null;
        try {
            ret = SJkmsCommunicationUty.create(productID);
        }
        catch (SJkmsCommunicationException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getPassword", "cannot generate password");
            throw ex;
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getPassword", "end");
        return ret;
    }

    public static byte[] getPassword_local(String productID) throws SJkmsPasswordUtyException {
        String LOG_SUBTITLE = "getPassword_local";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getPassword_local", "start");
        if (productID == null || productID.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getPassword_local", "parameter is null");
            throw new SJkmsPasswordUtyException("107001");
        }
        byte[] ret = null;
        try {
            long gmt = System.currentTimeMillis();
            int rnd = new Random().nextInt(1024);
            String src = productID + String.valueOf(gmt) + fixedString_KEK_PASS + String.valueOf(rnd);
            ret = SJcSecureUty.getHashValueString(src);
        }
        catch (Exception ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getPassword_local", "cannot generate password");
            throw new SJkmsPasswordUtyException("107001");
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getPassword_local", "end");
        return ret;
    }

    public static String convertPasswordtoStr(byte[] password) throws SJkmsPasswordUtyException {
        String LOG_SUBTITLE = "convertPasswordtoStr";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "convertPasswordtoStr", "start");
        if (password == null || password.length == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "convertPasswordtoStr", "parameter is null");
            throw new SJkmsPasswordUtyException("107001");
        }
        String ret = null;
        ret = SJcStringUty.byteToHexString(password);
        if (ret == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "convertPasswordtoStr", "error in byteToString");
            throw new SJkmsPasswordUtyException("107001");
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "convertPasswordtoStr", "end");
        return ret;
    }

    public static byte[] convertPasswordtoByte(String password) throws SJkmsPasswordUtyException {
        String LOG_SUBTITLE = "convertPasswordtoByte";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "convertPasswordtoByte", "start");
        if (password == null || password.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "convertPasswordtoByte", "parameter is null");
            throw new SJkmsPasswordUtyException("107001");
        }
        byte[] ret = null;
        ret = SJcStringUty.hexStringToByte(password);
        if (ret == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "convertPasswordtoByte", "error in StringtoByte");
            throw new SJkmsPasswordUtyException("107001");
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "convertPasswordtoByte", "end");
        return ret;
    }

    public static byte[] encryptPassword(String productID, byte[] password) throws SJkmsPasswordUtyException {
        String LOG_SUBTITLE = "encryptPassword";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "encryptPassword", "start");
        if (productID == null || productID.length() == 0 || password == null || password.length == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "encryptPassword", "parameter is null");
            throw new SJkmsPasswordUtyException("107001");
        }
        byte[] ret = null;
        try {
            String src = SJkmsConfigUtyCom.convertProductID(productID) + fixedString_PASS_KEY;
            byte[] key = SJkmsPasswordUty.generateKey(src.getBytes("UTF-8"), fixedString_PASS_KEY_KEY);
            ret = SJcSecureUty.encryptByteNoLog(password, key);
        }
        catch (Exception ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "encryptPassword", "cannot encrypt password");
            throw new SJkmsPasswordUtyException(ex, "107001");
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "encryptPassword", "end");
        return ret;
    }

    public static byte[] decryptPassword(String productID, byte[] password) throws SJkmsPasswordUtyException {
        String LOG_SUBTITLE = "decryptPassword";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "decryptPassword", "start");
        if (productID == null || productID.length() == 0 || password == null || password.length == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "decryptPassword", "parameter is null");
            throw new SJkmsPasswordUtyException("107001");
        }
        byte[] ret = null;
        try {
            String src = SJkmsConfigUtyCom.convertProductID(productID) + fixedString_PASS_KEY;
            byte[] key = SJkmsPasswordUty.generateKey(src.getBytes("UTF-8"), fixedString_PASS_KEY_KEY);
            ret = SJcSecureUty.decryptByte(password, key);
        }
        catch (Exception ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "decryptPassword", "cannot decrypt password");
            throw new SJkmsPasswordUtyException(ex, "107001");
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "decryptPassword", "end");
        return ret;
    }

    private static byte[] generateKey(byte[] byteData, String pass) throws SJkmsPasswordUtyException {
        String LOG_SUBTITLE = "generateKey";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "generateKey", "start");
        if (byteData == null || byteData.length == 0 || pass == null || pass.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "generateKey", "parameter is null");
            throw new SJkmsPasswordUtyException("107001");
        }
        byte[] ret = null;
        try {
            byte[] bufArr = new byte[16];
            if (byteData.length > 16) {
                System.arraycopy(byteData, 0, bufArr, 0, 16);
                byteData = bufArr;
            } else if (byteData.length < 16) {
                for (int i = 0; i < 16; ++i) {
                    bufArr[i] = 0;
                }
                System.arraycopy(byteData, 0, bufArr, 16 - bufArr.length, bufArr.length);
                byteData = bufArr;
            }
            SecretKeySpec key = new SecretKeySpec(pass.getBytes("UTF-8"), "AES");
            Cipher c = Cipher.getInstance("AES/ECB/NoPadding");
            c.init(1, key);
            ret = c.doFinal(byteData);
        }
        catch (Exception ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "generateKey", "cannot generate password");
            throw new SJkmsPasswordUtyException("107001");
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "generateKey", "end");
        return ret;
    }
}

