/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import sanproject.sn2.base.system.inf.SJbaseSystemInterface;
import sanproject.sn2.base.system.inf.SJbaseSystemStatusInterface;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcSingletonManagerUty;
import sanproject.sn2.controller.com.SJctrProgress;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.datasupplier.SJdsSupplierMgr;
import sanproject.sn2.model.SJmoDataChange;
import sanproject.sn2.model.SJmoException;
import sanproject.sn2.model.SJmoFileOutputThread;
import sanproject.sn2.model.SJmoGetAgent;
import sanproject.sn2.model.SJmoRefreshMgr;
import sanproject.sn2.model.SJmoSNBaseStatusInterface;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.SJmoMacroMgr;
import sanproject.sn2.model.data.SJmoModelDataMgr;
import sanproject.sn2.model.file.SJmoDataFile;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;
import sanproject.sn2.model.inf.SJmoMacroSet;
import sanproject.sn2.modelrc.SJmoRscMgr;
import sanproject.sn2.modelver.SJmoVersionMgr;
import sanproject.sn2.sn2com.utility.SJsncProductModelUty;
import sanproject.sn2.sn2com.utility.SJsncVersionCheckUty;

public class SJmoModelMgr
implements SJbaseSystemInterface,
SJctrProgress {
    private static SJmoVersionMgr m_VerMgr = null;
    private static SJdsSupplierMgr m_SupMgr = null;
    private SJmoModelDataMgr m_DataMgrOrg = null;
    private SJmoModelDataMgr m_DataMgrBak = null;
    private int m_iModelStatus = 0;
    private SJmoDataChange m_DataChg = null;
    private SJmoException m_MdlExp = new SJmoException();
    private int m_iLockCount = 0;
    private int m_iRefKind = -1;
    private SJmoException m_RefErr = null;
    private SJmoRefreshMgr m_RefMgr = null;
    private Object m_SetRefLockObj = null;
    private Object m_LockCntSyncObj = null;
    private SJmoFileOutputThread m_FileOutput = null;
    private long m_lFileOutputCount = 0L;
    private boolean m_bAbortInit = false;
    private SJmoMacroMgr m_MacroData = null;
    private Object m_ApplyRefChk = null;
    private boolean m_ChkApplyRef = false;
    private int m_FileVersion = 0;
    private int m_DataKeyNum = 0;

    public static SJmoModelMgr getModelMgr() throws SJmoException {
        return (SJmoModelMgr)SJcSingletonManagerUty.getInstance(SJmoModelMgr.class);
    }

    @Override
    public void initialize() {
        boolean bModelRead = false;
        SJmoUtility.putLogDetail("SJmoModelMgr", "initialize", "ModelMgr initialize start.");
        m_VerMgr = SJmoVersionMgr.getInstance();
        SJmoUtility.delException(this.m_MdlExp);
        this.m_iModelStatus = 1;
        SJmoUtility.putLog("Now ModelMgr Initialize!! Status = " + this.m_iModelStatus);
        this.m_iLockCount = 0;
        SJmoUtility.putLog("Now ModelMgr Initialize!! The lock counter is initialized. : " + this.m_iLockCount);
        this.m_DataMgrOrg = null;
        this.m_DataMgrBak = null;
        this.m_iRefKind = -1;
        this.m_RefErr = null;
        this.m_SetRefLockObj = new Object();
        this.m_LockCntSyncObj = new Object();
        this.m_FileOutput = null;
        this.m_lFileOutputCount = 30L;
        this.m_ApplyRefChk = new Object();
        this.m_ChkApplyRef = false;
        Date logDateBef = new Date();
        SJmoUtility.putLog("Now ModelMgr Initialize!! It begins to wait. : " + logDateBef.toString());
        SJmoModelDataMgr classObj = null;
        try {
            classObj = this.getFileData();
        }
        catch (Exception jvExp) {
            SJmoUtility.putLogDetail("SJmoModelMgr", "initialize", "Catch the JavaException FuncID=201 ModuleID=23 MsgID=107002");
        }
        while (SJdsSupplierMgr.getSupplierMgr().isNowRunning()) {
            if (this.m_bAbortInit) {
                SJmoUtility.putLogDetail("SJmoModelMgr", "initialize", "abort_initialize called");
                this.m_iModelStatus = 9;
                return;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (Exception jvExp) {
                SJmoUtility.putLog("Now ModelMgr Initialize!! Catch the JavaException.");
                jvExp.printStackTrace();
                this.m_iModelStatus = 9;
                return;
            }
        }
        Date logDateAft = new Date();
        SJmoUtility.putLog("Now ModelMgr Initialize!! It finishes waiting. : " + logDateAft.toString());
        m_SupMgr = SJdsSupplierMgr.getSupplierMgr();
        int iOemType = m_SupMgr.getCheckRetObj().getNOEMTYPE();
        ArrayList datchgtbl = m_SupMgr.getDataChange().getDatChgTblList();
        if (null != datchgtbl && 0 != datchgtbl.size()) {
            this.m_DataChg = new SJmoDataChange(iOemType);
            this.m_DataChg.makeDataChangeTable(datchgtbl);
        } else {
            SJmoUtility.putLogDetail("SJmoModelMgr", "initialize", "Get dataChange Table Failed FuncID=201 ModuleID=23 MsgID=107002");
            this.setModelException(201, 23, 107002);
        }
        this.m_MacroData = new SJmoMacroMgr(m_SupMgr.getMacroMap());
        SJmoMacroSet.setMacroValue(this.m_MacroData);
        if (this.m_bAbortInit) {
            SJmoUtility.putLogDetail("SJmoModelMgr", "initialize", "abort_initialize called");
            this.m_iModelStatus = 9;
            return;
        }
        if (classObj != null) {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "Initialize", "Model Version:" + SJmoDataMacro_IF.MODELDATA_VERSION + ",File Version:" + this.m_FileVersion);
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "Initialize", "Model KeyNum:" + SJmoDataMacro_IF.MODELDATAMGR_KEYNUM + ",File Version:" + this.m_DataKeyNum);
            if (SJmoDataMacro_IF.MODELDATA_VERSION == this.m_FileVersion && SJmoDataMacro_IF.MODELDATAMGR_KEYNUM == this.m_DataKeyNum) {
                this.m_DataMgrOrg = classObj;
                bModelRead = true;
            } else {
                this.initModelFileDir();
            }
        }
        if (this.m_bAbortInit) {
            SJmoUtility.putLogDetail("SJmoModelMgr", "initialize", "abort_initialize called");
            this.m_iModelStatus = 9;
            return;
        }
        int iVerInit = m_VerMgr.initialize(bModelRead);
        if (iVerInit != 0) {
            SJmoUtility.putLogDetail("SJmoModelMgr", "initialize", "Version Mgr Initialize fail FuncID=201 ModuleID=23 MsgID=108002");
            this.setModelException(201, 23, 108002);
            this.m_iModelStatus = 9;
        }
        if (9 != this.m_iModelStatus && null != this.m_DataMgrOrg) {
            this.m_iModelStatus = 2;
        }
        SJmoUtility.putLogDetail("SJmoModelMgr", "initalize", "ModelMgr initialize end.");
    }

    public void renewDataProc(int iUpdType, ArrayList updateList) {
        if (this.m_iModelStatus == 1 && this.m_bAbortInit) {
            this.m_iModelStatus = 9;
            m_VerMgr.rsvResult(false, false, null, false, iUpdType);
            return;
        }
        if (this.m_iModelStatus == 7 || this.m_iModelStatus == 8 || this.m_iModelStatus == 9 || this.m_iModelStatus == 0) {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "renewDataProc", "Do not update data. Model Status is finishing or finish or initialize failed or stop.");
            if (null != m_VerMgr) {
                m_VerMgr.rsvResult(false, false, null, false, iUpdType);
            }
            return;
        }
        this.m_DataMgrBak = new SJmoModelDataMgr();
        SJmoUtility.putLogDetail("SJmoModelMgr", "renewDataProc", "renewDataProc start(Request:" + iUpdType + " refresh Flg:" + this.getIRefKind() + ")");
        if (0 == iUpdType && this.getIRefKind() != -1) {
            m_VerMgr.rsvResult(false, false, null, false, iUpdType);
        } else {
            try {
                if (this.m_DataMgrOrg != null && iUpdType != 2) {
                    HashMap dataHash = this.m_DataMgrOrg.getCloneHash();
                    this.m_DataMgrBak.setCloneHash(dataHash);
                }
                this.m_RefMgr = new SJmoRefreshMgr(SJmoModelMgr.getModelMgr(), this.m_DataMgrBak, updateList, iUpdType);
                this.m_RefMgr.start();
            }
            catch (SJmoException mdExp) {
                int iErrCode = Integer.parseInt(mdExp.getMsg().getMsgID());
                SJmoUtility.putLog("Now ModelMgr renewDataProc!! Catch the SJmoException. = " + iErrCode);
                this.m_DataMgrBak = null;
                m_VerMgr.rsvResult(false, false, null, false, iUpdType);
            }
            catch (Exception jvExp) {
                SJmoUtility.putLog("Now ModelMgr renewDataProc!! Catch the JavaException.");
                jvExp.printStackTrace();
                this.m_DataMgrBak = null;
                m_VerMgr.rsvResult(false, false, null, false, iUpdType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startApplyRefresh() {
        boolean bRet = false;
        Object object = this.m_ApplyRefChk;
        synchronized (object) {
            if (!this.m_ChkApplyRef) {
                this.m_ChkApplyRef = true;
                bRet = true;
            }
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endApplyRefresh() {
        Object object = this.m_ApplyRefChk;
        synchronized (object) {
            this.m_ChkApplyRef = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws SJmoException {
        if (!this.startApplyRefresh()) {
            SJmoUtility.putLogDetail("SJmoModelMgr", "refresh", "Apply Refresh is Executed");
            return;
        }
        Object object = this.m_SetRefLockObj;
        synchronized (object) {
            int iWatchTime = 0;
            int iMdlErrLvl = -1;
            try {
                this.chkRefProc(2);
                this.delRefreshException();
                if (null != this.m_RefMgr && this.m_RefMgr.isAlive()) {
                    SJmoUtility.putLogDetail("SJmoModelMgr", "refresh", "SJmoRefreshMgr Thread stop demand");
                    this.m_RefMgr.stopThreadWithWait();
                }
                SJmoUtility.putLogDetail("SJmoModelMgr", "refresh", "Refresh demand is issued to the Version Mgr");
                m_VerMgr.refresh(2);
                while (this.getIRefKind() != -1) {
                    if (iWatchTime >= 3600000) {
                        SJmoUtility.putLogDetail("SJmoModelMgr", "refresh", "Refresh watch time limit");
                        this.setRefreshException(201, 23, 107014);
                        this.endRefresh();
                        break;
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interExp) {
                        SJmoUtility.putLogDetail("SJmoModelMgr", "refresh", "Thread Interrupt");
                    }
                    iWatchTime += 5000;
                }
            }
            catch (SJmoException moExp) {
                this.endRefresh();
                this.setRefreshException(201, 23, 107013);
            }
            finally {
                this.endApplyRefresh();
            }
            iMdlErrLvl = SJmoUtility.getModelErrLevel(this.m_MdlExp, m_SupMgr);
            if (null != this.m_RefErr || iMdlErrLvl >= 0) {
                if (null != this.m_RefErr && null != this.m_RefErr.getMsg()) {
                    SJmoUtility.putLogDetail("SJmoGetAgent", "getRefreshProg", "[Function ID : " + this.m_RefErr.getMsg().getFunctionID() + "]" + "[ModuleID : " + this.m_RefErr.getMsg().getModuleID() + "]" + "[MsgID : " + this.m_RefErr.getMsg().getMsgID() + "]");
                }
                if (null != this.m_MdlExp.getMsg()) {
                    SJmoUtility.putLogDetail("SJmoGetAgent", "getRefreshProg", "[Function ID : " + this.m_MdlExp.getMsg().getFunctionID() + "]" + "[ModuleID : " + this.m_MdlExp.getMsg().getModuleID() + "]" + "[MsgID : " + this.m_MdlExp.getMsg().getMsgID() + "]");
                }
                SJmoUtility.putLogDetail("SJmoModelMgr", "refresh", "Refresh abnormal end");
                throw SJmoUtility.getException(201, 23, 107008, "SJmoModelMgr", "refresh");
            }
        }
    }

    public void refreshView() {
        try {
            if (null != this.m_RefMgr && this.m_RefMgr.isAlive()) {
                SJmoUtility.putLogDetail("SJmoModelMgr", "refreshView", "SJmoRefreshMgr Thread stop demand");
                this.m_RefMgr.stopThreadWithWait();
            }
            SJmoUtility.putLogDetail("SJmoModelMgr", "refreshView", "Refresh demand is issued to the Version Mgr");
            m_VerMgr.refresh(0);
        }
        catch (SJmoException moExp) {
            this.setRefreshException(201, 23, 107013);
        }
    }

    public void refreshAll() {
        try {
            if (null != this.m_RefMgr && this.m_RefMgr.isAlive()) {
                SJmoUtility.putLogDetail("SJmoModelMgr", "refreshAll", "SJmoRefreshMgr Thread stop demand");
                this.m_RefMgr.stopThreadWithWait();
            }
            SJmoUtility.putLogDetail("SJmoModelMgr", "refreshAll", "RefreshAll demand is issued to the Version Mgr");
            m_VerMgr.refreshAll();
        }
        catch (SJmoException moExp) {
            this.setRefreshException(201, 23, 107013);
        }
    }

    public SJmoGetAgent getDataAgent() throws SJmoException {
        SJmoGetAgent modelAgt = null;
        if (this.m_iModelStatus != 2 && this.m_iModelStatus != 6) {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "getDataAgent", "Model Unstart.");
            throw SJmoUtility.getException(201, 23, 107028, this.getClass().getSimpleName(), "getDataAgent");
        }
        modelAgt = new SJmoGetAgent(SJmoModelMgr.getModelMgr());
        return modelAgt;
    }

    void changeModelToRead() {
        this.m_iModelStatus = 6;
        SJmoUtility.putLog("Now changeModelToRead!! Status = " + this.m_iModelStatus);
        this.m_DataMgrOrg = this.m_DataMgrBak;
        Date updateTime = new Date();
        this.m_DataMgrOrg.setRenewLastUpdateTime(updateTime);
        this.m_iModelStatus = 2;
        SJmoUtility.putLog("Now changeModelToRead!! Status = " + this.m_iModelStatus);
    }

    SJmoModelDataMgr getModelToRead() throws SJmoException {
        try {
            if (this.m_DataMgrOrg != null) {
                while (this.m_iModelStatus == 6) {
                    Thread.sleep(50L);
                }
            } else {
                SJmoUtility.putLog("Now ModelMgr getModelToRead!! m_DataMgrOrg null");
                throw SJmoUtility.getException(201, 23, 107006, "SJmoModelMgr", "getModelToRead");
            }
        }
        catch (SJmoException mdExp) {
            int iErrCode = Integer.parseInt(mdExp.getMsg().getMsgID());
            SJmoUtility.putLog("Now ModelMgr getModelToRead!! Catch the SJmoException. = " + iErrCode);
            throw mdExp;
        }
        catch (Exception jvExp) {
            SJmoUtility.putLog("Now ModelMgr getModelToRead!! Catch the JavaException.");
            jvExp.printStackTrace();
            throw SJmoUtility.getException(201, 23, 107003, "SJmoModelMgr", "getModelToRead");
        }
        finally {
            return this.m_DataMgrOrg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lockModeltoRead() {
        Object object = this.m_LockCntSyncObj;
        synchronized (object) {
            ++this.m_iLockCount;
            SJmoUtility.putLog("lockModeltoRead LockCount = " + this.m_iLockCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlockModeltoRead() {
        Object object = this.m_LockCntSyncObj;
        synchronized (object) {
            --this.m_iLockCount;
            if (this.m_iLockCount < 0) {
                SJmoUtility.putLog("LockCount Injustice : " + this.m_iLockCount);
                this.m_iLockCount = 0;
            }
            SJmoUtility.putLog("unlockModeltoRead LockCount = " + this.m_iLockCount);
        }
    }

    public void endThread(SJmoException mdExp, int iUpdType, boolean bStopRst) {
        boolean bExpFlag = true;
        if (mdExp == null) {
            Date logDateBef = new Date();
            SJmoUtility.putLog("Now endThread!! It begins to wait. : " + logDateBef.toString());
            if (bStopRst) {
                bExpFlag = false;
                SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "endThread", "renewData stop.");
            } else {
                while (this.m_iLockCount > 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception jvExp) {
                        SJmoUtility.putLog("Now ModelMgr endThread!! Catch the JavaException.");
                        jvExp.printStackTrace();
                        bExpFlag = false;
                        break;
                    }
                }
            }
            Date logDateAft = new Date();
            SJmoUtility.putLog("Now endThread!! It finishes waiting. : " + logDateAft.toString());
            if (bExpFlag) {
                if (3 == iUpdType) {
                    try {
                        SJmoRscMgr rscMgr = SJmoRscMgr.getInstance();
                        rscMgr.rcvModelUpdate();
                    }
                    catch (SJmoException moExp) {
                        SJmoUtility.putLogDetail("SJmoModelMgr", "endThread", "RscMgr Access Failed");
                    }
                }
                SJmoModelMgr.getModelMgr().changeModelToRead();
                boolean bFcopy = false;
                if (this.m_lFileOutputCount >= 30L) {
                    bFcopy = true;
                    this.m_lFileOutputCount = 0L;
                }
                if (null == this.m_FileOutput) {
                    this.m_FileOutput = new SJmoFileOutputThread(bFcopy);
                    this.m_FileOutput.start();
                } else if (!this.m_FileOutput.isAlive()) {
                    this.m_FileOutput = new SJmoFileOutputThread(bFcopy);
                    this.m_FileOutput.start();
                }
                ++this.m_lFileOutputCount;
            }
        } else if (this.m_DataMgrOrg != null) {
            int iErrLv = -1;
            if (null != m_SupMgr) {
                iErrLv = SJmoUtility.getModelErrLevel(this.m_MdlExp, m_SupMgr);
            }
            if (1 != iErrLv && 2 != iErrLv) {
                this.m_iModelStatus = 2;
                SJmoUtility.putLog("Now endThread!! Status = " + this.m_iModelStatus);
            }
        }
        this.destoryModelToRenew();
    }

    @Override
    public void abort_initialize() {
        boolean iWaiteTime = false;
        SJmoUtility.putLogDetail("SJmoModelMgr", "abort_initialze", "The ModelMgr abort_initialize started");
        if (1 == this.m_iModelStatus) {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "abort_initialize", "Wait Model Initialize End");
            this.m_bAbortInit = true;
            for (int iWaitCnt = 0; iWaitCnt < 36; ++iWaitCnt) {
                if (1 == this.m_iModelStatus) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException intExp) {
                        SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "abort_initialize", "Thread Interrupt");
                    }
                    continue;
                }
                SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "abort_initialize", "Model Initialize finish");
                break;
            }
        }
        this.finish();
        SJmoUtility.putLogDetail("SJmoModelMgr", "abort_initialze", "The ModelMgr abort_initialize ended");
    }

    @Override
    public void abort_finish() {
        SJmoUtility.putLogDetail("SJmoModelMgr", "abort_finish", "The ModelMgr abort_finish started");
        this.finish();
        SJmoUtility.putLogDetail("SJmoModelMgr", "abort_finish", "The ModelMgr abort_finish ended");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() {
        int iWatchTime = 0;
        this.m_iModelStatus = 7;
        SJmoUtility.putLogDetail("SJmoModelMgr", "finish", "The ModelMgr finish started");
        try {
            if (null != this.m_RefMgr && this.m_RefMgr.isAlive()) {
                this.m_RefMgr.stopThread();
                while (1 != m_VerMgr.getVerStatus() && this.m_iModelStatus != 9) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException intExp) {
                        SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "finish", "Thread Interrupt");
                    }
                    if (900000 > (iWatchTime += 5000)) continue;
                    SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "finish", "Stop thread  watch time-out");
                    break;
                }
            } else if (1 != m_VerMgr.getVerStatus() && 0 != m_VerMgr.getVerStatus()) {
                SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "finish", "Wait VersionMgr status");
                for (int iWaitCnt = 0; iWaitCnt < 36; ++iWaitCnt) {
                    if (1 != m_VerMgr.getVerStatus() && 0 != m_VerMgr.getVerStatus()) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException intExp) {
                            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "finish", "Thread Interrupt");
                        }
                        continue;
                    }
                    SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "finish", "VersionMgr wait End");
                    break;
                }
            }
            this.m_RefMgr = null;
            if (this.m_DataMgrOrg != null) {
            } else {
                SJmoUtility.putLog("finalize ModelData Invalidity");
            }
        }
        catch (Exception jvExp) {
            SJmoUtility.putLog("Now ModelMgr finish!! Catch the JavaException.");
            jvExp.printStackTrace();
        }
        finally {
            m_VerMgr.finish();
            m_VerMgr = null;
            m_SupMgr = null;
            this.m_DataChg = null;
            SJmoUtility.delException(this.m_MdlExp);
            this.m_iLockCount = 0;
            this.m_iRefKind = -1;
            this.m_RefErr = null;
            this.m_DataMgrOrg = null;
            this.m_DataMgrBak = null;
            this.m_SetRefLockObj = null;
            this.m_LockCntSyncObj = null;
            this.m_FileOutput = null;
            this.m_lFileOutputCount = 0L;
            this.m_bAbortInit = false;
            this.m_iModelStatus = 8;
            this.m_ApplyRefChk = null;
            this.m_ChkApplyRef = false;
            if (this.m_MacroData != null) {
                this.m_MacroData.finishObj();
            }
            SJmoUtility.putLogDetail("SJmoModelMgr", "finish", "The ModelMgr finish ended");
        }
    }

    @Override
    public SJbaseSystemStatusInterface getStatus() {
        SJmoSNBaseStatusInterface snbaseStatusIf = new SJmoSNBaseStatusInterface();
        switch (this.m_iModelStatus) {
            case 0: {
                snbaseStatusIf.setPhase(0);
                snbaseStatusIf.setFatal(false);
                snbaseStatusIf.setReqRetry(false);
                snbaseStatusIf.setErrorCode(null);
                break;
            }
            case 1: {
                snbaseStatusIf.setPhase(1);
                snbaseStatusIf.setFatal(false);
                snbaseStatusIf.setReqRetry(false);
                snbaseStatusIf.setErrorCode(null);
                break;
            }
            case 2: {
                snbaseStatusIf.setPhase(2);
                snbaseStatusIf.setFatal(false);
                snbaseStatusIf.setReqRetry(false);
                snbaseStatusIf.setErrorCode(null);
                break;
            }
            case 6: {
                snbaseStatusIf.setPhase(2);
                snbaseStatusIf.setFatal(false);
                snbaseStatusIf.setReqRetry(false);
                snbaseStatusIf.setErrorCode(null);
                break;
            }
            case 7: {
                snbaseStatusIf.setPhase(3);
                snbaseStatusIf.setFatal(false);
                snbaseStatusIf.setReqRetry(false);
                snbaseStatusIf.setErrorCode(null);
                break;
            }
            case 8: {
                snbaseStatusIf.setPhase(4);
                snbaseStatusIf.setFatal(false);
                snbaseStatusIf.setReqRetry(false);
                snbaseStatusIf.setErrorCode(null);
                break;
            }
            case 9: {
                snbaseStatusIf.setPhase(1);
                snbaseStatusIf.setFatal(false);
                snbaseStatusIf.setReqRetry(true);
                snbaseStatusIf.setErrorCode(null);
                break;
            }
            default: {
                snbaseStatusIf.setPhase(2);
                snbaseStatusIf.setFatal(false);
                snbaseStatusIf.setReqRetry(true);
                snbaseStatusIf.setErrorCode(null);
                SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "getStatus", "ModelMgr Status Error. Value = " + this.m_iModelStatus);
            }
        }
        return snbaseStatusIf;
    }

    @Override
    public boolean destroy() {
        return true;
    }

    public SJmoDataChange getDataChange() {
        return this.m_DataChg;
    }

    public SJdsSupplierMgr getSupplierMgr() {
        return m_SupMgr;
    }

    public SJmoVersionMgr getVersionMgr() {
        return m_VerMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModelException(int iFuncID, int iModuleID, int iMsgID) {
        SJmoException sJmoException = this.m_MdlExp;
        synchronized (sJmoException) {
            if (null != m_SupMgr) {
                int iNewErrLv;
                int iSaveErrLv = SJmoUtility.getModelErrLevel(this.m_MdlExp, m_SupMgr);
                if (iSaveErrLv == 0) {
                    iSaveErrLv = 7;
                }
                if ((iNewErrLv = SJmoUtility.getErrLevel(iFuncID, iModuleID, iMsgID)) == 0) {
                    iNewErrLv = 7;
                }
                if ((-1 == iSaveErrLv || iSaveErrLv >= iNewErrLv) && iNewErrLv != -1) {
                    SJmoUtility.setException(this.m_MdlExp, iFuncID, iModuleID, iMsgID);
                }
            } else {
                SJmoUtility.setException(this.m_MdlExp, iFuncID, iModuleID, iMsgID);
            }
            SJmoUtility.putLogDetail("SJmoModelMgr", "setModelException", "setModelException end.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delModelException() {
        SJmoException sJmoException = this.m_MdlExp;
        synchronized (sJmoException) {
            SJmoUtility.delException(this.m_MdlExp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SJmoException getModelException() {
        SJmoException sJmoException = this.m_MdlExp;
        synchronized (sJmoException) {
            return this.m_MdlExp;
        }
    }

    public synchronized void setRefreshException(int iFuncID, int iModuleID, int iMsgID) {
        if (null == this.m_RefErr) {
            this.m_RefErr = new SJmoException();
            SJmoUtility.setException(this.m_RefErr, iFuncID, iModuleID, iMsgID);
        } else {
            int iNewErrLvl;
            int iSaveErrLvl = SJmoUtility.getModelErrLevel(this.m_RefErr, m_SupMgr);
            if (iSaveErrLvl == 0) {
                iSaveErrLvl = 7;
            }
            if ((iNewErrLvl = SJmoUtility.getErrLevel(iFuncID, iModuleID, iMsgID)) == 0) {
                iNewErrLvl = 7;
            }
            if (iSaveErrLvl >= iNewErrLvl && iNewErrLvl != -1) {
                SJmoUtility.setException(this.m_RefErr, iFuncID, iModuleID, iMsgID);
            }
        }
        this.setModelException(iFuncID, iModuleID, iMsgID);
        this.endRefresh();
        SJmoUtility.putLogDetail("SJmoModelMgr", "setRefreshException", "setRefreshException end.");
    }

    public synchronized SJmoException getRefreshException() {
        return this.m_RefErr;
    }

    public synchronized void delRefreshException() {
        this.m_RefErr = null;
        SJmoUtility.putLogDetail("SJmoModelMgr", "delRefreshException", "delRefreshException end.");
    }

    public synchronized int getIRefKind() {
        return this.m_iRefKind;
    }

    public synchronized void chkRefProc(int iRefKind) throws SJmoException {
        int iErrCode = 0;
        if (this.getIRefKind() == -1) {
            this.m_iRefKind = iRefKind;
            this.delRefreshException();
            try {
                SJmoException moExp = this.getModelException();
                if (null != moExp.getMsg().getFunctionID()) {
                    Thread.sleep(5000L);
                }
            }
            catch (Exception jvExp) {
                jvExp.printStackTrace();
                SJmoUtility.putLogDetail("SJmoModelMgr", "chkRefProc", "Error check failed");
            }
            if (this.getIRefKind() != 2 && !this.lockRMI()) {
                this.m_iRefKind = -1;
                throw SJmoUtility.getException(201, 23, 107025, "SJmoModelMgr", "chkRefProc");
            }
        } else {
            iErrCode = this.getIRefKind() == 0 || this.getIRefKind() == 1 ? 107007 : 107025;
            throw SJmoUtility.getException(201, 23, iErrCode, "SJmoModelMgr", "chkRefProc");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void endRefresh() {
        block8: {
            try {
                if (this.getIRefKind() == 2) break block8;
                if (1 == this.getIRefKind()) {
                    try {
                        SJmoRscMgr rscMgr = SJmoRscMgr.getInstance();
                        rscMgr.refreshDiffData();
                    }
                    catch (SJmoException moExp) {
                        SJmoUtility.putLogDetail("SJmoModelMgr", "endRefresh", "RscMgr Access Failed");
                    }
                }
                try {
                    this.unlockRMI();
                }
                catch (SJmoException exp) {
                    SJmoUtility.putLogDetail("SJmoModelMgr", "endRefresh", "unlockRMI Failed");
                }
            }
            finally {
                this.m_iRefKind = -1;
            }
        }
    }

    private boolean lockRMI() {
        boolean bRet = true;
        SJdsSupplierAgent supAgt = m_SupMgr.getAgent();
        if (null != supAgt) {
            try {
                SJmoUtility.putLogDetail("SJmoModelMgr", "lockRMI", "RMI Lock start");
                supAgt.lock("flex_users");
                SJmoUtility.putLogDetail("SJmoModelMgr", "lockRMI", "RMI Lock end");
            }
            catch (Exception jvExp) {
                SJmoUtility.putLogDetail("SJmoModelMgr", "lockRMI", "RMI Lock failed");
                this.setModelException(201, 23, 107011);
                bRet = false;
            }
        } else {
            SJmoUtility.putLogDetail("SJmoModelMgr", "lockRMI", "Instance none of Supplier Agent");
            bRet = false;
            this.setModelException(201, 23, 107003);
        }
        return bRet;
    }

    private void unlockRMI() {
        SJdsSupplierAgent supAgt = m_SupMgr.getAgent();
        if (null != supAgt) {
            try {
                SJmoUtility.putLogDetail("SJmoModelMgr", "unlockRMI", "RMI Unlock start");
                supAgt.unlock();
                SJmoUtility.putLogDetail("SJmoModelMgr", "unlockRMI", "RMI Unlock end");
            }
            catch (Exception jvExp) {
                SJmoUtility.putLogDetail("SJmoModelMgr", "unlockRMI", "RMI Unlock failed");
                this.setModelException(201, 23, 107012);
            }
        } else {
            SJmoUtility.putLogDetail("SJmoModelMgr", "unlockRMI", "Instance none of Supplier Agent");
            this.setModelException(201, 23, 107003);
        }
    }

    @Override
    public int getLeadTime() {
        int iLeadTime = 180;
        return iLeadTime;
    }

    @Override
    public int getProgress() {
        int iRefProg = 100;
        if (this.getIRefKind() != -1) {
            iRefProg = 1;
        }
        return iRefProg;
    }

    private void destoryModelToRenew() {
        this.m_DataMgrBak = null;
        System.gc();
    }

    public void endModelUpdate(SJmoException moExp, boolean bStopRst, int iUpdReq) {
        boolean bResult = true;
        boolean bInitSuccess = true;
        if (bStopRst) {
            bResult = false;
        } else if (null != moExp) {
            bResult = false;
            if (this.m_iModelStatus == 1) {
                this.m_iModelStatus = 9;
                bInitSuccess = false;
                SJmoUtility.putLogDetail("SJmoModelMgr", "endModelUpdate", "ModelMgr status is Initialize failed.");
                this.destoryModelToRenew();
            }
        } else if (1 == this.m_iModelStatus) {
            this.changeModelToRead();
        }
        if (bInitSuccess) {
            m_VerMgr.rsvResult(bResult, bStopRst, moExp, true, iUpdReq);
        } else {
            m_VerMgr.rsvResult(false, false, null, false, iUpdReq);
        }
    }

    private void initModelFileDir() {
        String[] fileList = SJcFileUty.getFileList("model");
        this.deleteModelFile(fileList);
    }

    private SJmoModelDataMgr getFileData() {
        SJmoModelDataMgr dataMgr = null;
        HashMap<String, Object> dataHash = new HashMap<String, Object>();
        try {
            SJcFileUty.deleteFile("model", "ModelObj");
        }
        catch (Exception exp) {
            SJmoUtility.putLogDetail("SJmoModelMgr", "getFileData", "oldfile delete failed");
        }
        String[] fileList = SJcFileUty.getFileList("model");
        ArrayList<String> alList = new ArrayList<String>(Arrays.asList(fileList));
        Collections.sort(alList);
        if (0 > Collections.binarySearch(alList, "Renew.tmp")) {
            for (int iFileCnt = 0; iFileCnt < fileList.length; ++iFileCnt) {
                try {
                    if (0 == fileList[iFileCnt].compareTo("M.DMY")) continue;
                    SJmoDataFile fileData = (SJmoDataFile)SJcFileUty.loadSerialize("model", fileList[iFileCnt]);
                    if (fileData.chkFileData()) {
                        if (0 == this.m_FileVersion) {
                            this.m_FileVersion = fileData.getSVersion();
                        }
                        dataHash.put(fileData.getStrKey(), fileData.getModelData());
                        continue;
                    }
                    SJmoUtility.putLogDetail("SJmoModelMgr", "getFileData", "fileData is Invaled(" + fileList[iFileCnt] + ")");
                    this.deleteModelFile(fileList);
                }
                catch (Exception exp) {
                    SJmoUtility.putLogDetail("SJmoModelMgr", "getFileData", "load file is failed(" + fileList[iFileCnt] + ")");
                    this.deleteModelFile(fileList);
                }
                break;
            }
            this.m_DataKeyNum = dataHash.size();
            dataMgr = new SJmoModelDataMgr();
            dataMgr.setCloneHash(dataHash);
        } else {
            SJmoUtility.putLogDetail("SJmoModelMgr", "getFileData", "getData Failed caused Renew.tmp exists");
            this.deleteModelFile(fileList);
        }
        return dataMgr;
    }

    private void deleteModelFile(String[] fileList) {
        for (int iFileCnt = 0; iFileCnt < fileList.length; ++iFileCnt) {
            if (0 == fileList[iFileCnt].compareTo("M.DMY")) continue;
            SJcFileUty.deleteFile("model", fileList[iFileCnt]);
        }
    }

    public SJmoMacroMgr getMacroMgr() {
        return this.m_MacroData;
    }

    public int getIDkcKind() {
        int iDkcKind = 0;
        try {
            String strVersion = SJsncVersionCheckUty.getVersion();
            if (strVersion.equals("83")) {
                iDkcKind = 1;
            } else if (strVersion.equals("80")) {
                iDkcKind = 2;
            } else {
                SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "getIDkcKind", "DKC Kind = " + strVersion);
            }
        }
        catch (Exception e) {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "getIDkcKind", e.toString());
        }
        return iDkcKind;
    }

    public int getHMModelKind() {
        int iDkcModel = 3;
        try {
            int iModel = SJsncProductModelUty.getProductModel();
            switch (iModel) {
                case 20: {
                    iDkcModel = 1;
                    break;
                }
                case 40: {
                    iDkcModel = 2;
                    break;
                }
                case 60: {
                    iDkcModel = 3;
                    break;
                }
                default: {
                    SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "getHMModelKind", "DKC Model = " + iModel);
                    iDkcModel = 3;
                    break;
                }
            }
        }
        catch (Exception e) {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "getHMModelKind", e.toString());
        }
        return iDkcModel;
    }
}

