/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model;

import sanproject.serverux.data.CheckRetEx;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcWordUty;
import sanproject.sn2.com.utility.message.inf.SJcMessageHandleInterface;
import sanproject.sn2.datasupplier.SJdsSupplierMgr;
import sanproject.sn2.model.SJmoException;

public class SJmoUtility {
    public static SJmoException getException(int iFuncID, int iModuleID, int iMsgID, String strClass, String strMethod) {
        SJmoException retExp = new SJmoException();
        SJmoUtility.setException(retExp, iFuncID, iModuleID, iMsgID);
        SJmoUtility.putLogDetail(strClass, strMethod, "SJmoException FuncID=" + iFuncID + " ModuleID=" + iModuleID + " MsgID=" + iMsgID);
        return retExp;
    }

    public static void setException(SJmoException MdlExp, int iFuncID, int iModuleID, int iMsgID) {
        String strFuncID = SJmoUtility.itoa(iFuncID, 3);
        String strModuleID = SJmoUtility.itoa(iModuleID, 2);
        String strMsgID = Integer.toString(iMsgID);
        SJcMessage msg = new SJcMessage(strFuncID, strModuleID, strMsgID);
        MdlExp.setMsg(msg);
    }

    public static void delException(SJmoException MdlExp) {
        SJcMessage msg = new SJcMessage(null, null, null);
        MdlExp.setMsg(msg);
    }

    public static int getErrLevel(int iFuncID, int iModuleID, int iMsgID) {
        String strLangType = "EN";
        String strFuncID = SJmoUtility.itoa(iFuncID, 3);
        String strModuleID = SJmoUtility.itoa(iModuleID, 2);
        String strMsgID = Integer.toString(iMsgID);
        SJcMessageHandleInterface MsgHdl = SJcWordUty.getMessageInfo(strLangType);
        String strBhv = MsgHdl.getBehavior(strFuncID, strModuleID, strMsgID);
        int iBhv = Integer.parseInt(strBhv);
        return iBhv;
    }

    public static int getModelErrLevel(SJmoException MdlExp, SJdsSupplierMgr SupMgr) {
        int iMdlErrLv = -1;
        SJcMessage Msg = MdlExp.getMsg();
        String strFuncID = Msg.getFunctionID();
        String strModuleID = Msg.getModuleID();
        String strMsgID = Msg.getMsgID();
        if (null != strFuncID && null != strModuleID && null != strMsgID) {
            int iFuncID = Integer.parseInt(strFuncID);
            int iModuleID = Integer.parseInt(strModuleID);
            int iMsgID = Integer.parseInt(strMsgID);
            iMdlErrLv = SJmoUtility.getErrLevel(iFuncID, iModuleID, iMsgID);
        }
        return iMdlErrLv;
    }

    public static int getOEMType(SJdsSupplierMgr SupMgr) {
        CheckRetEx chkRet = (CheckRetEx)SupMgr.getCheckRetObj();
        int iOEMType = chkRet.getNOEMTYPE();
        return iOEMType;
    }

    public static int getVender(SJdsSupplierMgr SupMgr) {
        int iOEMType = SJmoUtility.getOEMType(SupMgr);
        int iVender = iOEMType & 0xFF0000;
        return iVender;
    }

    public static void putLog(String strLog) {
        SJcLogUty.getLogger("SN_Model.log").info("model", "", strLog, "");
    }

    public static void putLogDetail(String strClass, String strMethod, String strErr) {
        SJcLogUty.getLogger("SN_Model.log").info("model", strClass, strMethod, strErr);
    }

    public static String itoh(int iSrc, int iCol) {
        return SJmoUtility.itoh(iSrc, iCol, false);
    }

    public static String itoh(int iSrc, int iCol, boolean bLow) {
        StringBuffer strRet = new StringBuffer();
        String strWork = "";
        strWork = !bLow ? Integer.toHexString(iSrc).toUpperCase() : Integer.toHexString(iSrc);
        int iLen = strWork.length();
        if (iLen > iCol) {
            strRet.append("");
            SJmoUtility.putLogDetail("SJmoUtility", "itoh", "The digit number exceeds specification.");
        } else {
            for (int iCnt = iLen; iCnt < iCol; ++iCnt) {
                strRet.append("0");
            }
            strRet.append(strWork);
        }
        return strRet.toString();
    }

    public static String itoa(int iSrc, int iCol) {
        StringBuffer strRet = new StringBuffer();
        String strWork = "";
        strWork = Integer.toString(iSrc);
        int iLen = strWork.length();
        if (iLen > iCol) {
            strRet.append("");
        } else {
            for (int iCnt = iLen; iCnt < iCol; ++iCnt) {
                strRet.append("0");
            }
            strRet.append(strWork);
        }
        return strRet.toString();
    }

    public static byte convertDriveType(byte driveType) {
        byte rtn;
        switch (driveType) {
            case 5: 
            case 6: 
            case 7: {
                rtn = 5;
                break;
            }
            case 8: {
                rtn = 9;
                break;
            }
            default: {
                rtn = driveType;
            }
        }
        return rtn;
    }
}

