/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.lu;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanObject;
import java.util.ArrayList;
import java.util.BitSet;
import sanproject.sn2.com.utility.SJcSecureUty;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.model.data.inf.SJmoData_IF;
import sanproject.sn2.model.data.lu.SJmoChapUserInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiName;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetIndex;
import sanproject.sn2.model.data.util.SJmoDataUtility;
import sanproject.sn2.model.inf.SJmoKeyValueDefine_IF;

public class SJmoIscsiTargetInfo
extends SJmoIscsiTargetIndex
implements SJmoData_IF,
SJmoKeyValueDefine_IF {
    private static final long serialVersionUID = 5029281821443292090L;
    private String strIscsiTargetName = "";
    private String strIscsiTargetAlias = "";
    private int iHostMode = -1;
    private BitSet btOption = new BitSet(64);
    private int iUserAuthentSwitch = -1;
    private int iAuthentMode = -1;
    private String strTargetUserName = "";
    private String strTargetSecret = "";
    private ArrayList<SJmoIscsiName> alIscsiName = new ArrayList();
    private ArrayList<SJmoChapUserInfo> alUserInfo = new ArrayList();

    public String getStrIscsiTargetName() {
        return this.strIscsiTargetName;
    }

    public String getStrIscsiTargetAlias() {
        return this.strIscsiTargetAlias;
    }

    public int getIHostMode() {
        return this.iHostMode;
    }

    public BitSet getBtOption() {
        return this.btOption;
    }

    public int getiUserAuthentSwitch() {
        return this.iUserAuthentSwitch;
    }

    public int getiAuthentMode() {
        return this.iAuthentMode;
    }

    public String getStrTargetUserName() {
        return this.strTargetUserName;
    }

    public String getStrTargetSecret() {
        if (null != this.strTargetSecret && this.strTargetSecret.length() != 0) {
            return SJcSecureUty.decryptStrToStr(this.strTargetSecret);
        }
        return this.strTargetSecret;
    }

    public ArrayList<SJmoIscsiName> getAlIscsiName() {
        return this.alIscsiName;
    }

    public ArrayList<SJmoChapUserInfo> getAlUserInfo() {
        return this.alUserInfo;
    }

    public void setStrIscsiTargetName(String strIscsiTargetName) {
        this.strIscsiTargetName = strIscsiTargetName;
    }

    public void setStrIscsiTargetAlias(String strIscsiTargetAlias) {
        this.strIscsiTargetAlias = strIscsiTargetAlias;
    }

    public void setIHostMode(int iHostMode) {
        this.iHostMode = iHostMode;
    }

    public void setBtOption(BitSet btOption) {
        this.btOption = btOption;
    }

    public void setiUserAuthentSwitch(int iUserAuthentSwitch) {
        this.iUserAuthentSwitch = iUserAuthentSwitch;
    }

    public void setiAuthentMode(int iAuthentMode) {
        this.iAuthentMode = iAuthentMode;
    }

    public void setStrTargetUserName(String strTargetUserName) {
        this.strTargetUserName = strTargetUserName;
    }

    public void setStrTargetSecret(String strTargetSecret) {
        this.strTargetSecret = null != strTargetSecret && strTargetSecret.length() != 0 ? SJcSecureUty.encryptStrToStr(strTargetSecret) : strTargetSecret;
    }

    public void setAlIscsiName(ArrayList<SJmoIscsiName> alIscsiName) {
        this.alIscsiName = alIscsiName;
    }

    public void setAlUserInfo(ArrayList<SJmoChapUserInfo> alUserInfo) {
        this.alUserInfo = alUserInfo;
    }

    public void setIscsiTgBaseInfo(short portId, SanObject rmiIscsiTgInfo) {
        if (rmiIscsiTgInfo == null) {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoIscsiTargetInfo", "setIscsiTgBaseInfo");
        }
        try {
            this.sPort = portId;
            this.sIscsiTarget = (short)rmiIscsiTgInfo.getInt("Id");
            this.strIscsiTargetName = rmiIscsiTgInfo.getString("Name");
            this.strIscsiTargetAlias = rmiIscsiTgInfo.getString("Alias");
            this.iHostMode = rmiIscsiTgInfo.getInt("HostModeId");
            this.btOption = rmiIscsiTgInfo.getBitSet("HostModeOption");
        }
        catch (SanDataException sdEx) {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoIscsiTargetInfo", "setIscsiTgBaseInfo");
        }
    }

    public void setIscsiTgChapInfo(SanObject rmiIscsiTgChapInfo) {
        if (rmiIscsiTgChapInfo == null) {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoIscsiTargetInfo", "setIscsiTgChapInfo");
        }
        try {
            this.iUserAuthentSwitch = rmiIscsiTgChapInfo.getInt("UserAuthSwitch");
            this.iAuthentMode = rmiIscsiTgChapInfo.getInt("AuthMode");
            this.strTargetUserName = rmiIscsiTgChapInfo.getString("UserId");
            this.setStrTargetSecret(rmiIscsiTgChapInfo.getString("Secret"));
        }
        catch (SanDataException sdEx) {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoIscsiTargetInfo", "setIscsiTgChapInfo");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SJmoIscsiTargetInfo retObj = (SJmoIscsiTargetInfo)super.clone();
        retObj.setBtOption((BitSet)this.btOption.clone());
        retObj.setAlUserInfo(SJmoDataUtility.alDeepCopy(retObj.getAlUserInfo()));
        retObj.setAlIscsiName(SJmoDataUtility.alDeepCopy(retObj.getAlIscsiName()));
        return retObj;
    }

    @Override
    public Object clone(byte byDataMode) throws CloneNotSupportedException {
        SJmoModelData_Base retObj = (SJmoModelData_Base)this.clone();
        retObj.setIDataMode(byDataMode);
        return retObj;
    }
}

