/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.replication.remote;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import sanproject.serverux.dataimpl.RMCPget1PathtoRCU;
import sanproject.serverux.dataimpl.RMCPget1RCU;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationCUInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUOptionInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUPathInfo;
import sanproject.sn2.model.data.util.SJmoDataUtility;

public class SJmoRemoteReplicationRCUInfo
extends SJmoRemoteReplicationCUInfo {
    private static final long serialVersionUID = 1533741491286644394L;
    private int iNumofSSID = -1;
    private int[] iSSID = null;
    private Date daRegisterTime = null;
    private Date daUpdateTime = null;
    private ArrayList<SJmoRemoteReplicationRCUPathInfo> pathInfoList = new ArrayList();
    private SJmoRemoteReplicationRCUOptionInfo rCUOption = null;

    public SJmoRemoteReplicationRCUInfo() {
    }

    public SJmoRemoteReplicationRCUInfo(RMCPget1RCU rmiRcu) {
        SJmoRemoteReplicationRCUPathInfo moRcuPathInfo = null;
        ArrayList<SJmoRemoteReplicationRCUPathInfo> moRcuPathInfoList = new ArrayList<SJmoRemoteReplicationRCUPathInfo>();
        ParsePosition pos = new ParsePosition(0);
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
        if (rmiRcu != null) {
            if (rmiRcu.getCUFree() != 1) {
                this.setSCu((short)rmiRcu.getCUNo());
            }
            this.setSLdkc(rmiRcu.getLDKC());
            this.setStrSN(rmiRcu.getSN());
            this.setICUFree(rmiRcu.getCUFree());
            this.setIRCUID(rmiRcu.getRCUID());
            this.setIControllerID(rmiRcu.getControllerID());
            this.setINumofSSID(rmiRcu.getNumofSSID());
            this.setISSID(rmiRcu.getSSID());
            Arrays.sort(this.iSSID);
            if (rmiRcu.getRegisterTime() != null) {
                Date daRegisterTime = ((DateFormat)df).parse(rmiRcu.getRegisterTime(), pos);
                if (pos.getErrorIndex() == -1) {
                    this.setDaRegisterTime(daRegisterTime);
                }
            } else {
                SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "Constructor", "RegisterTime is Null.");
            }
            if (rmiRcu.getUpdateTime() != null) {
                pos.setIndex(0);
                Date daUpdateTime = ((DateFormat)df).parse(rmiRcu.getUpdateTime(), pos);
                if (pos.getErrorIndex() == -1) {
                    this.setDaUpdateTime(daUpdateTime);
                }
            } else {
                SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "Constructor", "UpdateTime is Null.");
            }
            RMCPget1PathtoRCU[] pathInf = rmiRcu.PathInfo;
            for (int iCnt = 0; iCnt < rmiRcu.getNumofPath(); ++iCnt) {
                moRcuPathInfo = new SJmoRemoteReplicationRCUPathInfo(pathInf[iCnt]);
                moRcuPathInfoList.add(moRcuPathInfo);
            }
        } else {
            throw SJmoUtility.getException(201, 23, 107000, this.getClass().getSimpleName(), "Constructor");
        }
        Collections.sort(moRcuPathInfoList);
        this.setPathInfoList(moRcuPathInfoList);
        SJmoRemoteReplicationRCUOptionInfo rcuOptInfo = new SJmoRemoteReplicationRCUOptionInfo(rmiRcu.RCUOption);
        this.setRCUOption(rcuOptInfo);
    }

    public int getINumofSSID() {
        return this.iNumofSSID;
    }

    public int[] getISSID() {
        return this.iSSID;
    }

    public Date getDaRegisterTime() {
        return this.daRegisterTime;
    }

    public Date getDaUpdateTime() {
        return this.daUpdateTime;
    }

    public ArrayList<SJmoRemoteReplicationRCUPathInfo> getPathInfoList() {
        return this.pathInfoList;
    }

    public SJmoRemoteReplicationRCUOptionInfo getRCUOption() {
        return this.rCUOption;
    }

    public void setINumofSSID(int numofSSID) {
        this.iNumofSSID = numofSSID;
    }

    public void setISSID(int[] issid) {
        this.iSSID = issid;
    }

    public void setDaRegisterTime(Date daRegisterTime) {
        this.daRegisterTime = daRegisterTime;
    }

    public void setDaUpdateTime(Date daUpdateTime) {
        this.daUpdateTime = daUpdateTime;
    }

    public void setPathInfoList(ArrayList<SJmoRemoteReplicationRCUPathInfo> pathInfoList) {
        this.pathInfoList = pathInfoList;
    }

    public void setRCUOption(SJmoRemoteReplicationRCUOptionInfo option) {
        this.rCUOption = option;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SJmoRemoteReplicationRCUInfo retObj = (SJmoRemoteReplicationRCUInfo)super.clone();
        retObj.setPathInfoList(SJmoDataUtility.alDeepCopy(retObj.getPathInfoList()));
        if (retObj.getRCUOption() != null) {
            retObj.setRCUOption((SJmoRemoteReplicationRCUOptionInfo)retObj.getRCUOption().clone());
        } else {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "clone", "rCUOption is null.");
        }
        return retObj;
    }

    @Override
    public Object clone(byte byDataMode) throws CloneNotSupportedException {
        SJmoModelData_Base retObj = (SJmoModelData_Base)this.clone();
        retObj.setIDataMode(byDataMode);
        return retObj;
    }
}

