/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.replication.remote.manager;

import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.model.data.inf.SJmoDataMgr_IF;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.util.SJmoLdevUtility;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;

public class SJmoHAPairVolInfoMgr
extends SJmoModelData_Base
implements SJmoDataMgr_IF {
    private static final long serialVersionUID = -3276678212489747785L;
    private SJmoReplicationPairVolInfo[] haPairVolInfoList = new SJmoReplicationPairVolInfo[SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC];

    public SJmoHAPairVolInfoMgr(SJmoReplicationPairVolInfo[] haPairVolInfoList) {
        if (haPairVolInfoList == null) {
            throw SJmoUtility.getException(201, 23, 107000, this.getClass().getSimpleName(), "Constructor");
        }
        this.haPairVolInfoList = haPairVolInfoList;
    }

    public SJmoReplicationPairVolInfo getHAPairVolInfo(int iLdevId) {
        SJmoReplicationPairVolInfo retPairVolInfo = null;
        if (SJmoLdevUtility.isValidLdevId(iLdevId)) {
            retPairVolInfo = this.haPairVolInfoList[iLdevId];
        }
        return retPairVolInfo;
    }

    public SJmoReplicationPairVolInfo getHAPairVolInfo(SJmoLdevIndex ldevIdx) {
        return this.getHAPairVolInfo(ldevIdx.getIndex());
    }

    public void setHAPairVolInfo(SJmoReplicationPairVolInfo pairInfo) {
        if (SJmoLdevUtility.isValidLdevId(pairInfo.getIndex())) {
            this.haPairVolInfoList[pairInfo.getIndex()] = pairInfo;
        } else {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "setHAPairVolInfo", "pairInfo LDEVIndex invalid:" + pairInfo.getIndex());
        }
    }

    public SJmoReplicationPairVolInfo[] getHAPairVolInfoList() {
        return this.haPairVolInfoList;
    }

    public void setHAPairVolInfoList(SJmoReplicationPairVolInfo[] haPairVolInfoList) {
        this.haPairVolInfoList = haPairVolInfoList;
    }

    private SJmoReplicationPairVolInfo[] haPairListDeepCopy(SJmoReplicationPairVolInfo[] srcList) {
        SJmoReplicationPairVolInfo[] retList = null;
        if (null == srcList) {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "haPairListDeepCopy", "srcList is null.");
            return retList;
        }
        retList = new SJmoReplicationPairVolInfo[srcList.length];
        for (int iListCnt = 0; iListCnt < srcList.length; ++iListCnt) {
            if (null == srcList[iListCnt]) continue;
            try {
                retList[iListCnt] = (SJmoReplicationPairVolInfo)srcList[iListCnt].clone();
                continue;
            }
            catch (Exception e) {
                SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "haPairListDeepCopy", "clone failed iListCnt =" + iListCnt + e.toString());
            }
        }
        return retList;
    }

    @Override
    public Object getToOutSideObj() {
        Object retObj = null;
        try {
            retObj = super.clone();
        }
        catch (Exception e) {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "getToOutSideObj", "Exception " + e.toString());
        }
        return retObj;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SJmoHAPairVolInfoMgr retObj = (SJmoHAPairVolInfoMgr)super.clone();
        retObj.setHAPairVolInfoList(retObj.haPairListDeepCopy(retObj.haPairVolInfoList));
        return retObj;
    }

    @Override
    public Object clone(byte byDataMode) throws CloneNotSupportedException {
        SJmoModelData_Base retObj = (SJmoModelData_Base)this.clone();
        retObj.setIDataMode(byDataMode);
        return retObj;
    }
}

