/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.replication.remote.manager;

import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.model.data.inf.SJmoDataMgr_IF;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationMRCUInfo;
import sanproject.sn2.model.data.util.SJmoLdevUtility;
import sanproject.sn2.model.data.volume.SJmoCuIndex;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;

public class SJmoRemoteReplicationMRCUInfoMgr
extends SJmoModelData_Base
implements SJmoDataMgr_IF {
    private static final long serialVersionUID = -3512792116966635388L;
    private SJmoRemoteReplicationMRCUInfo[] mRCUInfoList = new SJmoRemoteReplicationMRCUInfo[SJmoDataMacro_IF.CUMAX_LDKC];
    private SJmoRemoteReplicationMRCUInfo mRCUFreeInfo = null;

    public SJmoRemoteReplicationMRCUInfoMgr(SJmoRemoteReplicationMRCUInfo[] mRCUofCU, SJmoRemoteReplicationMRCUInfo mRCUofFreeCU) {
        if (mRCUofCU == null || mRCUofFreeCU == null) {
            throw SJmoUtility.getException(201, 23, 107000, this.getClass().getSimpleName(), "Constructor");
        }
        this.setMRCUInfoList(mRCUofCU);
        this.setMRCUFreeInfo(mRCUofFreeCU);
    }

    public SJmoRemoteReplicationMRCUInfo getMRCUInfo(int iCuId) {
        SJmoRemoteReplicationMRCUInfo retMRCUInfo = null;
        if (SJmoLdevUtility.isValidCuId(iCuId)) {
            retMRCUInfo = this.mRCUInfoList[iCuId];
        }
        return retMRCUInfo;
    }

    public SJmoRemoteReplicationMRCUInfo getMRCUInfo(SJmoCuIndex cuIdx) {
        return this.getMRCUInfo(cuIdx.getIndex());
    }

    public SJmoRemoteReplicationMRCUInfo[] getMRCUInfoList() {
        return this.mRCUInfoListCopy(this.mRCUInfoList);
    }

    public void setMRCUInfo(SJmoRemoteReplicationMRCUInfo mrcuInfo) {
        if (SJmoLdevUtility.isValidCuId(mrcuInfo.getIndex())) {
            this.mRCUInfoList[mrcuInfo.getIndex()] = mrcuInfo;
        } else {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "setMRCUInfo", "mrcuInfo CUIndex invalid:" + mrcuInfo.getIndex());
        }
    }

    public void setMRCUInfoList(SJmoRemoteReplicationMRCUInfo[] infoList) {
        this.mRCUInfoList = infoList;
    }

    private SJmoRemoteReplicationMRCUInfo[] getShallowMRCUInfoList() {
        return this.mRCUInfoList;
    }

    private SJmoRemoteReplicationMRCUInfo[] mRCUInfoListCopy(SJmoRemoteReplicationMRCUInfo[] mrcuInfoList) {
        return this.mRCUInfoListClone(mrcuInfoList, false);
    }

    private SJmoRemoteReplicationMRCUInfo[] mRCUInfoListDeepCopy(SJmoRemoteReplicationMRCUInfo[] mrcuInfoList) {
        return this.mRCUInfoListClone(mrcuInfoList, true);
    }

    private SJmoRemoteReplicationMRCUInfo[] mRCUInfoListClone(SJmoRemoteReplicationMRCUInfo[] srcList, boolean bDeepCopy) {
        SJmoRemoteReplicationMRCUInfo[] retList = null;
        if (null != srcList) {
            retList = new SJmoRemoteReplicationMRCUInfo[srcList.length];
            for (int iListCnt = 0; iListCnt < srcList.length; ++iListCnt) {
                if (bDeepCopy) {
                    if (null == srcList[iListCnt]) continue;
                    try {
                        retList[iListCnt] = (SJmoRemoteReplicationMRCUInfo)srcList[iListCnt].clone();
                    }
                    catch (Exception e) {
                        SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "mRCUInfoListClone", "clone failed iListCnt =" + iListCnt + e.toString());
                    }
                    continue;
                }
                retList[iListCnt] = srcList[iListCnt];
            }
        } else {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "mRCUInfoListClone", "srcList is null.");
        }
        return retList;
    }

    @Override
    public Object getToOutSideObj() {
        Object retObj = null;
        try {
            retObj = super.clone();
        }
        catch (Exception e) {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "getToOutSideObj", "Exception " + e.toString());
        }
        return retObj;
    }

    public SJmoRemoteReplicationMRCUInfo getMRCUFreeInfo() {
        return this.mRCUFreeInfo;
    }

    public void setMRCUFreeInfo(SJmoRemoteReplicationMRCUInfo freeInfo) {
        this.mRCUFreeInfo = freeInfo;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SJmoRemoteReplicationMRCUInfoMgr retObj = (SJmoRemoteReplicationMRCUInfoMgr)super.clone();
        retObj.setMRCUInfoList(retObj.mRCUInfoListDeepCopy(retObj.getShallowMRCUInfoList()));
        if (retObj.getMRCUFreeInfo() != null) {
            retObj.setMRCUFreeInfo((SJmoRemoteReplicationMRCUInfo)retObj.getMRCUFreeInfo().clone());
        } else {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "clone", "mRCUFreeInfo is null.");
        }
        return retObj;
    }

    @Override
    public Object clone(byte byDataMode) throws CloneNotSupportedException {
        SJmoModelData_Base retObj = (SJmoModelData_Base)this.clone();
        retObj.setIDataMode(byDataMode);
        return retObj;
    }
}

