/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.util;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import sanproject.common.Robj_interface_CVSgetLDEVIDInfo;
import sanproject.common.Robj_interface_DCRgetAllDCRInfo;
import sanproject.common.Robj_interface_LUNMgetLDEVStatus;
import sanproject.common.Robj_interface_RJiLDEVInfoDetail3;
import sanproject.common.Robj_interface_RJiLUSEInfoDetail;
import sanproject.common.Robj_interface_RJiResourceName;
import sanproject.common.Robj_interface_RJiSSIDInfo;
import sanproject.serverux.dataimpl.CVSgetLDEVIDInfo;
import sanproject.serverux.dataimpl.DGD_ODGDgetLdevGuard;
import sanproject.serverux.dataimpl.DKCgetLDEVSecurityInfo;
import sanproject.serverux.dataimpl.LUNMgetLDEVStatus;
import sanproject.serverux.dataimpl.LUNMgetUUID;
import sanproject.serverux.dataimpl.POOLgetAOUVolRelation3;
import sanproject.serverux.dataimpl.RJiHURget1JNLG;
import sanproject.serverux.dataimpl.RJiLDEVInfoDetail3;
import sanproject.serverux.dataimpl.RJiLUSEInfoDetail;
import sanproject.serverux.dataimpl.RJiSSIDInfo;
import sanproject.sn2.model.SJmoDataChange;
import sanproject.sn2.model.SJmoException;
import sanproject.sn2.model.SJmoModelMgr;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.inf.SJmoDataIndex_IF;
import sanproject.sn2.model.data.volume.SJmoCuLdevIdInfo;
import sanproject.sn2.model.data.volume.SJmoDCRInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevGuardInfo;
import sanproject.sn2.model.data.volume.SJmoLdevJnlGroupInfo;
import sanproject.sn2.model.data.volume.SJmoLdevLuseInfo;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;
import sanproject.sn2.model.data.volume.SJmoLdevPinStatusInfo;
import sanproject.sn2.model.data.volume.SJmoLdevSecurityInfo;
import sanproject.sn2.model.data.volume.SJmoLdevStatusInfo;
import sanproject.sn2.model.data.volume.SJmoLdevUuidInfo;
import sanproject.sn2.model.data.volume.SJmoSsidDetail;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;

public class SJmoLdevUtility {
    static final String STR_3390_3 = "3390-3";
    static final String STR_3390_3R = "3390-3R";
    public static final int EMU_BIT_3390_3 = 1;
    public static final int EMU_BIT_RAMAC = 2;

    public static SJmoDataIndex_IF[] makeAlLdevDetail(Robj_interface_RJiLDEVInfoDetail3[] rmiData) throws SJmoException {
        SJmoDataIndex_IF[] ldDtl = new SJmoDataIndex_IF[SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC];
        if (null != rmiData) {
            for (int iObjCnt = 0; iObjCnt < rmiData.length; ++iObjCnt) {
                if (null != rmiData[iObjCnt]) {
                    SJmoLdevDetail ldTmp = new SJmoLdevDetail((RJiLDEVInfoDetail3)rmiData[iObjCnt]);
                    ldDtl[ldTmp.getIndex()] = ldTmp;
                    continue;
                }
                SJmoUtility.putLog("The array element is illegal. Array element number = [" + iObjCnt + "] : makeAlLdevDetail");
            }
        } else {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoLdevUtility", "makeAlLdevDetail");
        }
        return ldDtl;
    }

    public static SJmoDataIndex_IF[] makeAlLdevGuardInfo(DGD_ODGDgetLdevGuard[] rmiData, DGD_ODGDgetLdevGuard[] rmiDataMF) throws SJmoException {
        SJmoDataIndex_IF[] ldGrd = new SJmoDataIndex_IF[SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC];
        if (null != rmiData && null != rmiDataMF && rmiData.length == rmiDataMF.length) {
            for (int iObjCnt = 0; iObjCnt < rmiData.length; ++iObjCnt) {
                if (null != rmiData[iObjCnt] && null != rmiDataMF[iObjCnt]) {
                    for (int iLdevCnt = 0; iLdevCnt < SJmoDataMacro_IF.MAX_LDEV_CU; ++iLdevCnt) {
                        SJmoLdevGuardInfo ldGrdTmp;
                        if (0 != rmiData[iObjCnt].getByGuard(iLdevCnt)) {
                            ldGrdTmp = new SJmoLdevGuardInfo(rmiData[iObjCnt], iLdevCnt);
                            ldGrd[ldGrdTmp.getIndex()] = ldGrdTmp;
                        } else if (0 != rmiDataMF[iObjCnt].getByGuard(iLdevCnt)) {
                            ldGrdTmp = new SJmoLdevGuardInfo(rmiDataMF[iObjCnt], iLdevCnt);
                            ldGrd[ldGrdTmp.getIndex()] = ldGrdTmp;
                        }
                        if (0 == rmiData[iObjCnt].getByGuard(iLdevCnt) || 0 == rmiDataMF[iObjCnt].getByGuard(iLdevCnt)) continue;
                        SJmoUtility.putLog("[WARNING]Duplicate OPEN(0x" + Integer.toHexString(rmiData[iObjCnt].getByGuard(iLdevCnt)) + ") and MF(0x" + Integer.toHexString(rmiDataMF[iObjCnt].getByGuard(iLdevCnt)) + "). Array element number = [" + iObjCnt + "].[" + iLdevCnt + "] : makeAlLdevGuardInfo");
                    }
                    continue;
                }
                SJmoUtility.putLog("The array element is illegal. Array element number = [" + iObjCnt + "] : makeAlLdevGuardInfo");
            }
        } else {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoLdevUtility", "makeAlLdevGuardInfo");
        }
        return ldGrd;
    }

    public static SJmoDataIndex_IF[] makeAlLdevLuseInfo(Robj_interface_RJiLUSEInfoDetail[] rmiData) throws SJmoException {
        SJmoDataIndex_IF[] ldLuse = new SJmoDataIndex_IF[SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC];
        if (null != rmiData) {
            for (int iObjCnt = 0; iObjCnt < rmiData.length; ++iObjCnt) {
                if (null != rmiData[iObjCnt]) {
                    SJmoLdevLuseInfo ldLuseTmp = new SJmoLdevLuseInfo((RJiLUSEInfoDetail)rmiData[iObjCnt]);
                    ldLuse[ldLuseTmp.getIndex()] = ldLuseTmp;
                    continue;
                }
                SJmoUtility.putLog("The array element is illegal. Array element number = [" + iObjCnt + "] : makeAlLdevLuseInfo");
            }
        } else {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoLdevUtility", "makeAlLdevLuseInfo");
        }
        return ldLuse;
    }

    public static int getLdevIndex(short sLdkc, short sCu, short sLdev) {
        int iLdevIndex = -1;
        iLdevIndex = sLdkc << 16 | sCu << 8 | sLdev;
        return iLdevIndex;
    }

    public static SJmoDataIndex_IF[] makeAlLdevStatusInfo(Robj_interface_LUNMgetLDEVStatus[] rmiData) throws SJmoException {
        SJmoDataIndex_IF[] ldevStat = new SJmoDataIndex_IF[SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC];
        if (null != rmiData) {
            for (int iObjCnt = 0; iObjCnt < rmiData.length; ++iObjCnt) {
                if (null != rmiData[iObjCnt]) {
                    SJmoLdevStatusInfo ldStatTmp = new SJmoLdevStatusInfo((LUNMgetLDEVStatus)rmiData[iObjCnt]);
                    ldevStat[ldStatTmp.getIndex()] = ldStatTmp;
                    continue;
                }
                SJmoUtility.putLog("The array element is illegal. Array element number = [" + iObjCnt + "] : makeAlLdevStatusInfo");
            }
        } else {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoLdevUtility", "makeAlLdevStatusInfo");
        }
        return ldevStat;
    }

    public static SJmoDataIndex_IF[] makeAlCuLdevIdInfo(Robj_interface_CVSgetLDEVIDInfo[] rmiData) throws SJmoException {
        SJmoDataIndex_IF[] cuLdevId = new SJmoDataIndex_IF[SJmoDataMacro_IF.CUMAX_LDKC];
        if (null != rmiData) {
            for (int iObjCnt = 0; iObjCnt < rmiData.length; ++iObjCnt) {
                if (null != rmiData[iObjCnt]) {
                    SJmoCuLdevIdInfo cuLdevIdTmp = new SJmoCuLdevIdInfo((CVSgetLDEVIDInfo)rmiData[iObjCnt]);
                    cuLdevId[cuLdevIdTmp.getIndex()] = cuLdevIdTmp;
                    continue;
                }
                SJmoUtility.putLog("The array element is illegal. Array element number = [" + iObjCnt + "] : makeAlCuLdevIdInfo");
            }
        } else {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoLdevUtility", "makeAlCuLdevIdInfo");
        }
        return cuLdevId;
    }

    public static SJmoDataIndex_IF[] makeAlLdevSecurityInfo(DKCgetLDEVSecurityInfo[] rmiData) throws SJmoException {
        SJmoDataIndex_IF[] ldSec = new SJmoDataIndex_IF[SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC];
        if (null != rmiData) {
            for (int iObjCnt = 0; iObjCnt < rmiData.length; ++iObjCnt) {
                if (null != rmiData[iObjCnt]) {
                    SJmoLdevSecurityInfo ldSecTmp = new SJmoLdevSecurityInfo(rmiData[iObjCnt]);
                    ldSec[ldSecTmp.getIndex()] = ldSecTmp;
                    continue;
                }
                SJmoUtility.putLog("The array element is illegal. Array element number = [" + iObjCnt + "] : makeAlLdevSecurityInfo");
            }
        } else {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoLdevUtility", "makeAlLdevSecurityInfo");
        }
        return ldSec;
    }

    public static ArrayList makeAlSsidDetail(Robj_interface_RJiSSIDInfo[] rmiData) throws SJmoException {
        ArrayList<SJmoSsidDetail> alSsidDtl = new ArrayList<SJmoSsidDetail>();
        if (null != rmiData) {
            for (int iObjCnt = 0; iObjCnt < rmiData.length; ++iObjCnt) {
                if (null != rmiData[iObjCnt]) {
                    SJmoSsidDetail ssidTmp = new SJmoSsidDetail((RJiSSIDInfo)rmiData[iObjCnt]);
                    alSsidDtl.add(ssidTmp);
                    continue;
                }
                SJmoUtility.putLog("The array element is illegal. Array element number = [" + iObjCnt + "] : makeAlSsidDetail");
            }
        } else {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoLdevUtility", "makeAlSsidDetail");
        }
        return alSsidDtl;
    }

    public static SJmoDataIndex_IF[] makeDPVolInfo(POOLgetAOUVolRelation3[] rmiDPvolData) throws SJmoException {
        SJmoDataIndex_IF[] dpInf = new SJmoDataIndex_IF[SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC];
        if (null != rmiDPvolData) {
            for (int iObjCnt = 0; iObjCnt < rmiDPvolData.length; ++iObjCnt) {
                if (null == rmiDPvolData[iObjCnt]) continue;
                SJmoHDPRelation tmp = new SJmoHDPRelation(rmiDPvolData[iObjCnt]);
                dpInf[tmp.getIndex()] = tmp;
            }
        } else {
            SJmoUtility.putLog("makeDPVolInfoERROR The INPRAM rmiData=NULLl");
            throw SJmoUtility.getException(201, 23, 107000, "makeDPVolInfo", "rmiDPvolData");
        }
        return dpInf;
    }

    public static SJmoDataIndex_IF[] makeDcrInfo(Robj_interface_DCRgetAllDCRInfo[] rmiDcrData) throws SJmoException {
        SJmoDataIndex_IF[] dcrInf = new SJmoDataIndex_IF[SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC];
        if (null != rmiDcrData) {
            for (int iObjCnt = 0; iObjCnt < rmiDcrData.length; ++iObjCnt) {
                SJmoDCRInfo tmp;
                if (null == rmiDcrData[iObjCnt] || 0 > (tmp = new SJmoDCRInfo(rmiDcrData[iObjCnt])).getIndex() || tmp.getIndex() >= SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC) continue;
                dcrInf[tmp.getIndex()] = tmp;
            }
        } else {
            throw SJmoUtility.getException(201, 23, 107000, "makeDcrInfo", "rmiDcrData");
        }
        return dcrInf;
    }

    public static SJmoDataIndex_IF[] makeAlLdevUuidInfo(LUNMgetUUID[] rmiData) throws SJmoException {
        SJmoDataIndex_IF[] uuidArray = new SJmoDataIndex_IF[SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC];
        if (null != rmiData) {
            for (int iObjCnt = 0; iObjCnt < rmiData.length; ++iObjCnt) {
                if (null != rmiData[iObjCnt]) {
                    SJmoLdevUuidInfo uuidObj = new SJmoLdevUuidInfo(rmiData[iObjCnt]);
                    uuidArray[uuidObj.getIndex()] = uuidObj;
                    continue;
                }
                SJmoUtility.putLogDetail("SJmoLdevUtility", "makeAlLdevUuidInfo", "The array element is illegal. Array element number = [" + iObjCnt + "]");
            }
        } else {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoLdevUtility", "makeAlLdevUuidInfo");
        }
        return uuidArray;
    }

    public static SJmoDataIndex_IF[] makeLdevNicknameInfoList(Robj_interface_RJiResourceName[] rmiData) throws SJmoException {
        SJmoDataIndex_IF[] ldNicknameList = new SJmoDataIndex_IF[SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC];
        if (null != rmiData) {
            for (int iObjCnt = 0; iObjCnt < rmiData.length; ++iObjCnt) {
                if (null != rmiData[iObjCnt]) {
                    if (rmiData[iObjCnt].getType() == 1) {
                        SJmoLdevNicknameInfo ldNickname = new SJmoLdevNicknameInfo(rmiData[iObjCnt]);
                        ldNicknameList[ldNickname.getIndex()] = ldNickname;
                        continue;
                    }
                    SJmoUtility.putLogDetail("SJmoLdevUtility", "makeLdevNicknameInfoList", "The ResourseType is illigal. Array element number = [" + iObjCnt + "]");
                    continue;
                }
                SJmoUtility.putLogDetail("SJmoLdevUtility", "makeLdevNicknameInfoList", "The array element was null. Array element number = [" + iObjCnt + "]");
            }
        } else {
            throw SJmoUtility.getException(201, 23, 107000, " SJmoLdevUtility", " makeLdevNicknameInfoList");
        }
        return ldNicknameList;
    }

    public static SJmoDataIndex_IF[] makeAlLdevPinStatusInfo(SanResponse sanRes) throws SJmoException {
        SJmoDataIndex_IF[] ldPinStatList = new SJmoDataIndex_IF[SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC];
        if (null != sanRes) {
            try {
                SanList ldevList = sanRes.getList("Ldevs");
                for (SanObject ldevPinStatObj : ldevList) {
                    int[] ldevPinStat = ldevPinStatObj.getIntArray("Id");
                    SJmoLdevPinStatusInfo ldPinStatError = new SJmoLdevPinStatusInfo(ldevPinStat);
                    ldPinStatList[ldPinStatError.getIndex()] = ldPinStatError;
                }
            }
            catch (SanDataException sde) {
                SJmoUtility.putLog("[SJmoLdevUtility][makeAlLdevPinStatusInfo]SanDataException occurred. [code:" + sde.getCode() + "]" + sde.getMessage());
                throw SJmoUtility.getException(201, 23, 107000, "SJmoLdevUtility", "makeAlLdevPinStatusInfo");
            }
        } else {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoLdevUtility", "makeAlLdevPinStatusInfo");
        }
        return ldPinStatList;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getRamacStat(ArrayList<SJmoLdevDetail> alLdev) throws SJmoException {
        int iRet = 0;
        if (null == alLdev) {
            SJmoUtility.putLogDetail("SJmoLdevUtility", "getRamacStat", "invalid param(class null)");
            throw SJmoUtility.getException(201, 23, 107000, "SJmoLdevUtility", "getRamacStat");
        }
        SJmoDataChange dataChg = SJmoModelMgr.getModelMgr().getDataChange();
        if (null == dataChg) {
            SJmoUtility.putLogDetail("SJmoLdevUtility", "getRamacStat", "Data change table failed");
            throw SJmoUtility.getException(201, 23, 107000, "SJmoLdevUtility", "getRamacStat");
        }
        int iNormal = dataChg.getEmulationId(STR_3390_3);
        int iRamac = dataChg.getEmulationId(STR_3390_3R);
        if (-1 == iNormal || -1 == iRamac) {
            SJmoUtility.putLogDetail("SJmoLdevUtility", "getRamacStat", "Emulation not exist Norm:" + iNormal + " Ramac:" + iRamac);
            return iRet;
        }
        int iLdev = 0;
        while (iLdev < alLdev.size()) {
            SJmoLdevDetail ldTmp = alLdev.get(iLdev);
            if (null == ldTmp) {
                SJmoUtility.putLogDetail("SJmoLdevUtility", "getRamacStat", "invalid object(class null)");
                throw SJmoUtility.getException(201, 23, 107000, "SJmoLdevUtility", "getRamacStat");
            }
            int iEmu = ldTmp.getIEmulationType();
            if (iEmu == iNormal) {
                iRet |= 1;
            } else if (iEmu == iRamac) {
                iRet |= 2;
            }
            ++iLdev;
        }
        return iRet;
    }

    public static SJmoDataIndex_IF[] setLdevJnlg(ArrayList<RJiHURget1JNLG> alRmi, SJmoDataIndex_IF[] lsLdevJnlg) {
        SJmoDataIndex_IF[] moData = lsLdevJnlg;
        for (int iJnlg = 0; iJnlg < alRmi.size(); ++iJnlg) {
            RJiHURget1JNLG jnlg = alRmi.get(iJnlg);
            ArrayList alVolume = jnlg.getJnlVols();
            int iJnlgID = jnlg.getJnlGrpNumber();
            for (int iVol = 0; iVol < alVolume.size(); ++iVol) {
                Integer intVolume = (Integer)alVolume.get(iVol);
                if (null == moData[intVolume]) continue;
                ((SJmoLdevJnlGroupInfo)moData[intVolume]).setIJnlGroup(iJnlgID);
            }
        }
        return moData;
    }

    public static boolean isValidLdevId(int iChkLdevId) {
        boolean bRet = false;
        if (iChkLdevId >= 0 && iChkLdevId <= SJmoDataMacro_IF.NUM_MAX_LDEV_LDKC) {
            bRet = true;
        }
        return bRet;
    }

    public static boolean isValidCuId(int isChkCuId) {
        boolean bRet = false;
        if (isChkCuId >= 0 && isChkCuId <= SJmoDataMacro_IF.NUM_MAX_CU_LDKC) {
            bRet = true;
        }
        return bRet;
    }

    public static boolean isTopVolume(SJmoLdevDetail ldevDtl) {
        return ldevDtl.getSLUSEEmlCount() > 0;
    }
}

