/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.volume;

import sanproject.serverux.dataimpl.RJiPGInfoDetail2;
import sanproject.sn2.model.SJmoException;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.inf.SJmoData_IF;
import sanproject.sn2.model.data.inf.SJmoPgData_IF;
import sanproject.sn2.model.data.volume.SJmoPgIndex;

public class SJmoPgDetail
extends SJmoPgIndex
implements SJmoData_IF,
SJmoPgData_IF {
    static final long serialVersionUID = -4475773219546570933L;
    private short sCLPR = (short)-1;
    private int iRaidLevel = -1;
    private String strHDDType = "";
    private int iBaseEmulationType = -1;
    private long lPGLBASize = -1L;
    private long lPDEVSize = -1L;
    private short sPDEVCount = (short)-1;
    private byte byDriveType = (byte)-1;
    private byte byProtectionLevel = (byte)-1;
    private int iHDDrpm = -1;
    private boolean bOdmSetting = false;
    private boolean bVirtSupport = false;
    private boolean bVirtMode = false;
    private int iCopybackMode = -1;

    public short getCLPR() {
        return this.sCLPR;
    }

    public void setCLPR(short sclpr) {
        this.sCLPR = sclpr;
    }

    public int getRaidLevel() {
        return this.iRaidLevel;
    }

    public void setRaidLevel(int raidLevel) {
        this.iRaidLevel = raidLevel;
    }

    public String getHDDType() {
        return this.strHDDType;
    }

    public void setHDDType(String strHDDType) {
        this.strHDDType = strHDDType;
    }

    public int getBaseEmulationType() {
        return this.iBaseEmulationType;
    }

    public void setBaseEmulationType(int baseEmulationType) {
        this.iBaseEmulationType = baseEmulationType;
    }

    public long getPGLBASize() {
        return this.lPGLBASize;
    }

    public void setPGLBASize(long size) {
        this.lPGLBASize = size;
    }

    public long getPDEVSize() {
        return this.lPDEVSize;
    }

    public void setPDEVSize(long size) {
        this.lPDEVSize = size;
    }

    public short getPDEVCount() {
        return this.sPDEVCount;
    }

    public void setPDEVCount(short count) {
        this.sPDEVCount = count;
    }

    public byte getDriveType() {
        return this.byDriveType;
    }

    public void setDriveType(byte bySetData) {
        this.byDriveType = bySetData;
    }

    public byte getProtectionLevel() {
        return this.byProtectionLevel;
    }

    public void setProtectionLevel(byte byProtectLv) {
        this.byProtectionLevel = byProtectLv;
    }

    public int getHDDrpm() {
        return this.iHDDrpm;
    }

    public void setHDDrpm(int rpm) {
        this.iHDDrpm = rpm;
    }

    public boolean getBOdmSetting() {
        return this.bOdmSetting;
    }

    public void setBOdmSetting(boolean bOdmSetting) {
        this.bOdmSetting = bOdmSetting;
    }

    public boolean getBVirtSupport() {
        return this.bVirtSupport;
    }

    public void setBVirtSupport(boolean bVirtSupport) {
        this.bVirtSupport = bVirtSupport;
    }

    public boolean getBVirtMode() {
        return this.bVirtMode;
    }

    public void setBVirtMode(boolean bVirtMode) {
        this.bVirtMode = bVirtMode;
    }

    public int getCopybackMode() {
        return this.iCopybackMode;
    }

    public void setCopybackMode(int iCopybackMode) {
        this.iCopybackMode = iCopybackMode;
    }

    public int getQuickFormatCount() {
        int count = 1;
        long l8TB = 0x400000000L;
        long lPdevSizeWork = this.getPDEVSize();
        if (this.getBVirtSupport()) {
            lPdevSizeWork /= 8L;
        }
        while (lPdevSizeWork > l8TB && count < 4) {
            ++count;
            lPdevSizeWork -= l8TB;
        }
        return count;
    }

    public SJmoPgDetail() {
    }

    public SJmoPgDetail(RJiPGInfoDetail2 rmiData) throws SJmoException {
        this.setAllData(rmiData);
    }

    @Override
    public void setAllData(Object setObj) throws SJmoException {
        RJiPGInfoDetail2 pgTmp;
        if (null != setObj && setObj instanceof RJiPGInfoDetail2) {
            pgTmp = (RJiPGInfoDetail2)setObj;
            this.setFB4(pgTmp.getIFB4());
            this.setPG(pgTmp.getIPG());
            this.getIndexKey();
            this.setCLPR(pgTmp.getSCLPR());
            this.setRaidLevel(pgTmp.getIRaidLevel());
            if (null != pgTmp.getStrHDDType()) {
                this.setHDDType(pgTmp.getStrHDDType());
            }
        } else {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoPgDetail", "setAllData");
        }
        this.setBaseEmulationType(pgTmp.getIBaseEmulationType());
        this.setPGLBASize(pgTmp.getLPGLBASize());
        this.setPDEVSize(pgTmp.getLPDEVSize());
        this.setPDEVCount(pgTmp.getSPDEVCount());
        this.setDriveType(SJmoUtility.convertDriveType(pgTmp.getByDriveTypeDetail()));
        this.setProtectionLevel(pgTmp.getByProtectionLevel());
        this.setHDDrpm(pgTmp.getNHDDrpm());
        this.setBOdmSetting(pgTmp.isEnabledOdmSetting());
        this.setBVirtSupport(pgTmp.isBVirtualizationSupport());
        this.setBVirtMode(pgTmp.isBVirtualizationMode());
        this.setCopybackMode(pgTmp.getCopybackMode());
    }
}

