/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.modelrc.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.kind.SJmoGetExDVirtualPgInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.data.exdevice.SJmoExDPgInfo;
import sanproject.sn2.model.data.exdevice.SJmoExDVirtualPgInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoPgIndex;
import sanproject.sn2.modelrc.util.SJmoRscUtil;

public class SJmoRscUtilPg
extends SJmoRscUtil {
    private HashMap m_hExdPgInfo_MBase = new HashMap();
    private HashMap m_hExdPgInfo_MCtrl = new HashMap();
    private HashMap m_hExdPgInfo_Rsv = new HashMap();
    private ArrayList m_alLdevDetailInfo_Rsv = new ArrayList();
    private HashMap m_hExdPgInfo_Diff = new HashMap();
    private ArrayList m_alLdevDetailInfo_Diff = new ArrayList();
    private HashMap m_hLdevDetailInfo_Pg = new HashMap();

    @Override
    public void setModelData(List lsModelData) {
        int iLpCnt = 0;
        boolean iLpCnt2 = false;
        Object alExdVpg = null;
        SJmoUtility.putLogDetail("SJmoRscUtilPg", "setModelData", "Start");
        if (null != lsModelData) {
            try {
                for (iLpCnt = 0; iLpCnt < lsModelData.size(); ++iLpCnt) {
                    ArrayList alModelList;
                    if (null == lsModelData.get(iLpCnt) || (alModelList = (ArrayList)lsModelData.get(iLpCnt)).size() <= 0 || null == alModelList.get(0) || !(alModelList.get(0) instanceof SJmoExDVirtualPgInfo) || !this.m_hExdPgInfo_MBase.isEmpty()) continue;
                    SJmoExDVirtualPgInfo vpgInfo = (SJmoExDVirtualPgInfo)alModelList.get(0);
                    this.setPgInfoForModel(vpgInfo.getAlVpgForExd());
                    this.setPgInfoForModel(vpgInfo.getAlVpgForHdp());
                    this.setPgInfoForModel(vpgInfo.getAlVpgForQs());
                    this.setPgInfoForModel(vpgInfo.getAlVpgForFicon());
                    this.setPgInfoForModel(vpgInfo.getAlVpgForOthers());
                    this.m_hExdPgInfo_MCtrl = this.m_hExdPgInfo_MBase;
                }
            }
            catch (Exception exp) {
                SJmoUtility.putLogDetail("SJmoRscUtilPg", "setModelData", "internal err:" + exp.toString());
                throw SJmoUtility.getException(201, 23, 107021, " SJmoRscUtilPg", "setModelData");
            }
        } else {
            SJmoUtility.putLogDetail("SJmoRscUtilPg", "setModelData", "List is null");
            throw SJmoUtility.getException(201, 23, 107021, " SJmoRscUtilPg", "setModelData");
        }
        SJmoUtility.putLogDetail("SJmoRscUtilPg", "setModelData", "End");
    }

    private void setPgInfoForModel(ArrayList alPgInfo) {
        int iLpCnt = 0;
        if (null != alPgInfo) {
            for (iLpCnt = 0; iLpCnt < alPgInfo.size(); ++iLpCnt) {
                SJmoExDPgInfo pgInfo = (SJmoExDPgInfo)alPgInfo.get(iLpCnt);
                this.m_hExdPgInfo_MBase.put(pgInfo.getIndexKey(), pgInfo);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setRsvData(List lsRsvData) {
        int iLpCnt = 0;
        int iLpCnt2 = 0;
        int iSrcIndex = 0;
        if (null == lsRsvData) {
            SJmoUtility.putLogDetail("SJmoRscUtilPg", "setRsvData", "List is null");
            throw SJmoUtility.getException(201, 23, 107021, " SJmoRscUtilPg", "setRsvData");
        }
        try {
            iLpCnt = 0;
            while (true) {
                ArrayList alRsvData;
                if (iLpCnt >= lsRsvData.size()) {
                    this.renewLdevMap();
                    return;
                }
                if (null != lsRsvData.get(iLpCnt) && (alRsvData = (ArrayList)lsRsvData.get(iLpCnt)).size() > 0 && null != alRsvData.get(0)) {
                    if (alRsvData.get(0) instanceof SJmoExDPgInfo) {
                        for (iLpCnt2 = 0; iLpCnt2 < alRsvData.size(); ++iLpCnt2) {
                            SJmoExDPgInfo pgInfo = (SJmoExDPgInfo)alRsvData.get(iLpCnt2);
                            this.m_hExdPgInfo_Rsv.put(pgInfo.getIndexKey(), pgInfo);
                        }
                    } else if (alRsvData.get(0) instanceof SJmoLdevDetail) {
                        iLpCnt2 = 0;
                        while (iLpCnt2 < alRsvData.size()) {
                            SJmoLdevDetail ldev = (SJmoLdevDetail)alRsvData.get(iLpCnt2);
                            if (ldev.getIFB4() >= 16485 && ldev.getIFB4() <= 16516) {
                                Collections.sort(this.m_alLdevDetailInfo_Rsv);
                                iSrcIndex = Collections.binarySearch(this.m_alLdevDetailInfo_Rsv, ldev);
                                if (iSrcIndex >= 0) {
                                    this.m_alLdevDetailInfo_Rsv.set(iSrcIndex, ldev);
                                } else {
                                    this.m_alLdevDetailInfo_Rsv.add(ldev);
                                }
                            }
                            ++iLpCnt;
                        }
                    }
                }
                ++iLpCnt;
            }
        }
        catch (Exception exp) {
            SJmoUtility.putLogDetail("SJmoRscUtilPg", "setRsvData", "internal err:" + exp.toString());
            throw SJmoUtility.getException(201, 23, 107021, " SJmoRscUtilPg", "setRsvData");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void delRsvData(List lsRsvData) {
        int iLpCnt = 0;
        int iLpCnt2 = 0;
        int iSrcIndex = 0;
        if (null == lsRsvData) {
            SJmoUtility.putLogDetail("SJmoRscUtilPg", "delRsvData", "List is null");
            throw SJmoUtility.getException(201, 23, 107021, " SJmoRscUtilPg", "delRsvData");
        }
        try {
            iLpCnt = 0;
            while (true) {
                ArrayList alRsvData;
                if (iLpCnt >= lsRsvData.size()) {
                    this.renewLdevMap();
                    return;
                }
                if (null != lsRsvData.get(iLpCnt) && (alRsvData = (ArrayList)lsRsvData.get(iLpCnt)).size() > 0 && null != alRsvData.get(0)) {
                    if (alRsvData.get(0) instanceof SJmoExDPgInfo) {
                        for (iLpCnt2 = 0; iLpCnt2 < alRsvData.size(); ++iLpCnt2) {
                            SJmoExDPgInfo pgInfo = (SJmoExDPgInfo)alRsvData.get(iLpCnt2);
                            if (!this.m_hExdPgInfo_Rsv.containsKey(pgInfo.getIndexKey())) continue;
                            this.m_hExdPgInfo_Rsv.remove(pgInfo.getClass());
                        }
                    } else if (alRsvData.get(0) instanceof SJmoLdevDetail) {
                        iLpCnt2 = 0;
                        while (iLpCnt2 < alRsvData.size()) {
                            SJmoLdevDetail ldev = (SJmoLdevDetail)alRsvData.get(iLpCnt2);
                            Collections.sort(this.m_alLdevDetailInfo_Rsv);
                            iSrcIndex = Collections.binarySearch(this.m_alLdevDetailInfo_Rsv, ldev);
                            if (iSrcIndex >= 0) {
                                this.m_alLdevDetailInfo_Rsv.remove(iSrcIndex);
                            }
                            ++iLpCnt;
                        }
                    }
                }
                ++iLpCnt;
            }
        }
        catch (Exception exp) {
            SJmoUtility.putLogDetail("SJmoRscUtilPg", "delRsvData", "internal err:" + exp.toString());
            throw SJmoUtility.getException(201, 23, 107021, " SJmoRscUtilPg", "delRsvData");
        }
    }

    @Override
    public void clearRsvData() {
        SJmoUtility.putLogDetail("SJmoRscUtilPg", "clearRsvData", "Start");
        try {
            this.m_hExdPgInfo_Rsv.clear();
            this.m_alLdevDetailInfo_Rsv.clear();
            this.renewLdevMap();
        }
        catch (Exception exp) {
            SJmoUtility.putLogDetail("SJmoRscUtilPg", "clearRsvData", "internal err:" + exp.toString());
            throw SJmoUtility.getException(201, 23, 107021, " SJmoRscUtilPg", "clearRsvData");
        }
        SJmoUtility.putLogDetail("SJmoRscUtilPg", "clearRsvData", "End");
    }

    @Override
    public List getRsvData() {
        ArrayList<ArrayList> lsRsv = new ArrayList<ArrayList>();
        ArrayList alPgInfo = new ArrayList();
        Set keySet = this.m_hExdPgInfo_Rsv.keySet();
        for (String strKey : keySet) {
            alPgInfo.add(this.m_hExdPgInfo_Rsv.get(strKey));
        }
        lsRsv.add(alPgInfo);
        lsRsv.add(this.m_alLdevDetailInfo_Rsv);
        return lsRsv;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setDiffData(List lsDiffData) {
        int iLpCnt = 0;
        int iLpCnt2 = 0;
        boolean iSrcIndex = false;
        if (null == lsDiffData) {
            SJmoUtility.putLogDetail("SJmoRscUtilPg", "setDiffData", "List is null");
            throw SJmoUtility.getException(201, 23, 107021, " SJmoRscUtilPg", "setDiffData");
        }
        try {
            iLpCnt = 0;
            while (true) {
                ArrayList alRsvData;
                if (iLpCnt >= lsDiffData.size()) {
                    this.renewLdevMap();
                    return;
                }
                if (null != lsDiffData.get(iLpCnt) && (alRsvData = (ArrayList)lsDiffData.get(iLpCnt)).size() > 0 && null != alRsvData.get(0)) {
                    if (alRsvData.get(0) instanceof SJmoExDPgInfo) {
                        for (iLpCnt2 = 0; iLpCnt2 < alRsvData.size(); ++iLpCnt2) {
                            SJmoExDPgInfo pgInfo = (SJmoExDPgInfo)alRsvData.get(iLpCnt2);
                            this.m_hExdPgInfo_Diff.put(pgInfo.getIndexKey(), pgInfo);
                        }
                    } else if (alRsvData.get(0) instanceof SJmoLdevDetail) {
                        this.m_alLdevDetailInfo_Diff = alRsvData;
                    }
                }
                ++iLpCnt;
            }
        }
        catch (Exception exp) {
            SJmoUtility.putLogDetail("SJmoRscUtilPg", "setDiffData", "internal err:" + exp.toString());
            throw SJmoUtility.getException(201, 23, 107021, " SJmoRscUtilPg", "setDiffData");
        }
    }

    private void renewLdevMap() {
        SJmoLdevDetail ldev;
        int iLpCnt = 0;
        SJmoPgIndex pgIndex = null;
        this.m_hLdevDetailInfo_Pg.clear();
        for (iLpCnt = 0; iLpCnt < this.m_alLdevDetailInfo_Rsv.size(); ++iLpCnt) {
            ldev = (SJmoLdevDetail)this.m_alLdevDetailInfo_Rsv.get(iLpCnt);
            pgIndex = new SJmoPgIndex();
            pgIndex.setFB4(ldev.getIFB4());
            pgIndex.setPG(ldev.getIPG());
            this.m_hLdevDetailInfo_Pg.put(pgIndex.getIndexKey(), ldev);
        }
        for (iLpCnt = 0; iLpCnt < this.m_alLdevDetailInfo_Diff.size(); ++iLpCnt) {
            ldev = (SJmoLdevDetail)this.m_alLdevDetailInfo_Diff.get(iLpCnt);
            pgIndex = new SJmoPgIndex();
            pgIndex.setFB4(ldev.getIFB4());
            pgIndex.setPG(ldev.getIPG());
            this.m_hLdevDetailInfo_Pg.put(pgIndex.getIndexKey(), ldev);
        }
    }

    @Override
    public List getNeccessityCls() {
        ArrayList<SJmoGetDirect> lsGetDirect = new ArrayList<SJmoGetDirect>();
        SJmoGetDirect pgDirect = new SJmoGetDirect();
        SJmoGetExDVirtualPgInfo getPg = new SJmoGetExDVirtualPgInfo();
        pgDirect.setGetKind(getPg);
        lsGetDirect.add(pgDirect);
        SJmoGetDirect ldevDirect = new SJmoGetDirect();
        SJmoGetLdevDetail getldev = new SJmoGetLdevDetail();
        ldevDirect.setGetKind(getldev);
        lsGetDirect.add(ldevDirect);
        return lsGetDirect;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int chkPgID(SJmoPgIndex pgId) {
        int iRet = 1;
        boolean bChk = true;
        String strErrLog = "";
        if (null != pgId) {
            if (pgId.getFB4() < 1 || pgId.getFB4() > 17152) {
                bChk = false;
                strErrLog = strErrLog + " FB4#:" + pgId.getFB4();
            }
            if (pgId.getPG() < 1 || pgId.getPG() > 4096) {
                bChk = false;
                strErrLog = strErrLog + " PG#:" + pgId.getPG();
            }
        } else {
            bChk = false;
            strErrLog = strErrLog + " input Param is null";
        }
        if (bChk) {
            try {
                if (null != this.m_hExdPgInfo_MCtrl.get(pgId.getIndexKey())) return iRet;
                if (null != this.m_hExdPgInfo_Rsv.get(pgId.getIndexKey())) return iRet;
                if (null != this.m_hExdPgInfo_Diff.get(pgId.getIndexKey())) return iRet;
                if (null != this.m_hLdevDetailInfo_Pg.get(pgId.getIndexKey())) return iRet;
                return 0;
            }
            catch (Exception exp) {
                SJmoUtility.putLogDetail("SJmoRscUtilPg", "chkPgID", "internal err:" + exp.toString());
                throw SJmoUtility.getException(201, 23, 107021, " SJmoRscUtilPg", "chkPgID");
            }
        }
        SJmoUtility.putLogDetail("SJmoRscUtilPg", "chkPgID", "Paramater Error " + strErrLog);
        throw SJmoUtility.getException(201, 23, 107022, "SJmoRscUtilPg", "chkPgID");
    }

    public int chkPgID(int iFB4, int iPG) {
        int iRet = 1;
        SJmoPgIndex pgIndex = new SJmoPgIndex();
        pgIndex.setFB4(iFB4);
        pgIndex.setPG(iPG);
        iRet = this.chkPgID(pgIndex);
        return iRet;
    }

    @Override
    protected List getModelData() {
        ArrayList lsModel = new ArrayList();
        ArrayList alPgInfo = new ArrayList();
        SJmoExDVirtualPgInfo exdVpg = new SJmoExDVirtualPgInfo();
        ArrayList<SJmoExDVirtualPgInfo> alVpg = new ArrayList<SJmoExDVirtualPgInfo>();
        SJmoUtility.putLogDetail("SJmoRscUtilPg", "getModelData", "getModelData Start");
        try {
            Set keySet = this.m_hExdPgInfo_MBase.keySet();
            for (String strKey : keySet) {
                alPgInfo.add(this.m_hExdPgInfo_MBase.get(strKey));
            }
            lsModel.add(alPgInfo);
            exdVpg.setAlVpgForHdp(alPgInfo);
            alVpg.add(exdVpg);
            lsModel.add(alVpg);
        }
        catch (Exception moExp) {
            SJmoUtility.putLogDetail("SJmoRscUtilPg", "getModelData", "err:" + moExp.toString());
            throw SJmoUtility.getException(201, 23, 107021, " SJmoRscUtilPg", "getModelData");
        }
        SJmoUtility.putLogDetail("SJmoRscUtilPg", "getModelData", "getModelData End");
        return lsModel;
    }

    @Override
    public void clearModelData() {
        SJmoUtility.putLogDetail("SJmoRscUtilPg", "clearModelData", "clearModelData Start");
        this.m_hExdPgInfo_MCtrl = this.m_hExdPgInfo_MBase;
        SJmoUtility.putLogDetail("SJmoRscUtilPg", "clearModelData", "clearModelData End");
    }
}

