/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.main;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import sanproject.sn2.rptdt.conf.bean.Csv;
import sanproject.sn2.rptdt.conf.bean.GenerateReport;
import sanproject.sn2.rptdt.conf.bean.RefCsv;
import sanproject.sn2.rptdt.conf.bean.Report;
import sanproject.sn2.rptdt.conf.bean.RptdtConfig;
import sanproject.sn2.rptdt.csv.SJdtCSVWrapperManager;
import sanproject.sn2.rptdt.csv.wrapper.SJdtCSVWrapperBase;
import sanproject.sn2.rptdt.exception.SJdtRPTDTException;
import sanproject.sn2.rptdt.main.SJdtStatusWriter;
import sanproject.sn2.rptdt.report.SJdtReportGeneratorManager;
import sanproject.sn2.rptdt.report.generator.ReportInfo;
import sanproject.sn2.rptdt.report.generator.SJdtCommonReportGenerator;
import sanproject.sn2.rptdt.report.generator.SJdtReportGeneratorBase;
import sanproject.sn2.rptdt.util.SJdtRPTDTDevice;
import sanproject.sn2.rptdt.util.SJdtRPTDTUtils;

public class SJdtRPTDTMain {
    private static Logger logger = Logger.getLogger(SJdtRPTDTMain.class.getName());
    private static final String LOG_CONFIG_FILE_PATH_KEY = "log.config.file.path";
    public static final String ENCODING = "utf-8";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String CONFIG_BASE_DIR = "/sanproject/sn2/rptdt/conf";
    private static final String RPTDT_HMCONFIG_FILE_PATH = "/sanproject/sn2/rptdt/conf/rptdt-hmconfig.xml";
    private static final String CSV_HMVALIDATOR_FILE_PATH = "/sanproject/sn2/rptdt/conf/csv_hmvalidator.properties";
    private static final String REPORT_HMGUIDANCE_FILE_PATH = "/sanproject/sn2/rptdt/conf/report_hmguidance_en.properties";
    private static final String VELOCIYT_CONFIG_FILE_PATH = "/sanproject/sn2/rptdt/conf/velocity.properties";
    private static final String[] HM_DEVVER_KEY_ARRAY = new String[]{"83", "84"};
    private static final int PRINTOUTTOOL_VERSION_LENGS = 2;
    private static final int DKCMAIN_VERSION_LENGTH = 8;

    public static void main(String[] args) {
        int errorLevel = 0;
        SJdtStatusWriter statusWriter = new SJdtStatusWriter(new StringWriter());
        try {
            SJdtRPTDTMain.readLogConfiguration();
            logger.info("# -- XPDT START -- #");
            logger.info(SJdtRPTDTMain.getPlatformInfo());
            SJdtRPTDTMain.execute(args, statusWriter);
        }
        catch (SJdtRPTDTException e) {
            logger.severe(e.getStatusInfo() + LINE_SEPARATOR + SJdtRPTDTUtils.getPrintStackTrace(e));
            if (args.length == 2) {
                SJdtRPTDTUtils.deleteAllFile(args[1]);
            }
            statusWriter.setAllStatus(e.getAllStatus());
            errorLevel = 1;
        }
        catch (Exception e) {
            logger.severe("Unexpected Exception" + LINE_SEPARATOR + SJdtRPTDTUtils.getPrintStackTrace(e));
            SJdtRPTDTUtils.deleteAllFile(args[1]);
            statusWriter.clear();
            statusWriter.setAllStatus("20520-107003");
            errorLevel = 2;
        }
        catch (Error e) {
            logger.severe("Error" + LINE_SEPARATOR + SJdtRPTDTUtils.getPrintStackTrace(e));
            SJdtRPTDTUtils.deleteAllFile(args[1]);
            statusWriter.clear();
            statusWriter.setAllStatus("20520-107002");
            errorLevel = 3;
        }
        SJdtRPTDTMain.outputStatusInfo(statusWriter);
        logger.info("# -- XPDT   END -- #");
        System.exit(errorLevel);
    }

    private static void readLogConfiguration() throws SJdtRPTDTException {
        String logConfigFilePath = System.getProperty(LOG_CONFIG_FILE_PATH_KEY);
        InputStream in = null;
        try {
            in = SJdtRPTDTMain.class.getResourceAsStream(logConfigFilePath);
            LogManager.getLogManager().readConfiguration(in);
            logger.info("logConfigFilePath=[" + logConfigFilePath + "]");
        }
        catch (SecurityException e) {
            throw new SJdtRPTDTException(e, "20520-107004");
        }
        catch (IOException e) {
            throw new SJdtRPTDTException(e, "20520-107004");
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private static String getPlatformInfo() {
        Properties p = System.getProperties();
        StringBuilder sb = new StringBuilder();
        sb.append("OS=[").append(p.getProperty("os.name"));
        sb.append("(").append(p.getProperty("os.arch")).append(", ");
        sb.append(p.getProperty("sun.os.patch.level")).append(")], ");
        sb.append("JRE=[").append(p.getProperty("java.runtime.name"));
        sb.append("(").append(p.getProperty("java.runtime.version")).append(")]");
        return sb.toString();
    }

    private static void execute(String[] args, SJdtStatusWriter statusWriter) throws SJdtRPTDTException {
        if (args.length != 2) {
            logger.severe("args.length=[" + args.length + "]");
            throw new SJdtRPTDTException("20520-107005");
        }
        String inputDir = SJdtRPTDTUtils.setEndPathSeparator(args[0]);
        String outputDir = SJdtRPTDTUtils.setEndPathSeparator(args[1]);
        logger.info("args[0] , args[1]  =[" + args[0] + "," + args[1] + "]");
        logger.info("inputDir, outputDir=[" + inputDir + "," + outputDir + "]");
        SJdtRPTDTMain.setDevInfo(inputDir);
        RptdtConfig rptdtConfig = SJdtRPTDTMain.getRptdtConfigBean();
        List<Report> reportList = SJdtRPTDTMain.getGenerateReportList(rptdtConfig);
        List<Csv> csvList = SJdtRPTDTMain.getReferenceCsvList(rptdtConfig, reportList);
        SJdtReportGeneratorManager.generateDir(outputDir);
        SJdtRPTDTMain.existsFile(inputDir, outputDir, csvList);
        SJdtCSVWrapperManager.setInputDir(inputDir);
        SJdtReportGeneratorManager.setOutputDir(outputDir);
        SJdtRPTDTMain.validateCsvFile(csvList);
        SJdtRPTDTMain.initVelocity();
        List<ReportInfo> reportInfoList = SJdtRPTDTMain.initGenerateReport(reportList);
        SJdtCommonReportGenerator.generate(reportInfoList);
        SJdtRPTDTMain.generateReport(reportInfoList, statusWriter);
        SJdtRPTDTMain.generateIndexHtmlFile(reportInfoList);
    }

    public static RptdtConfig getRptdtConfigBean() throws SJdtRPTDTException {
        RptdtConfig rptdtConfig = null;
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            SJdtRPTDTDevice devinfo = new SJdtRPTDTDevice();
            is = SJdtRPTDTMain.class.getClass().getResourceAsStream(SJdtRPTDTDevice.getConfig_path());
            isr = new InputStreamReader(is, ENCODING);
            br = new BufferedReader(isr);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{RptdtConfig.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            rptdtConfig = (RptdtConfig)unmarshaller.unmarshal((Reader)br);
        }
        catch (IOException e) {
            throw new SJdtRPTDTException(e, "20520-107006");
        }
        catch (JAXBException e) {
            throw new SJdtRPTDTException(e, "20520-107006");
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (isr != null) {
                    isr.close();
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                logger.warning(e.getMessage());
            }
        }
        return rptdtConfig;
    }

    private static List<Report> getGenerateReportList(RptdtConfig rptdtConfig) throws SJdtRPTDTException {
        ArrayList<Report> reportList = new ArrayList<Report>();
        List<Report> allReportList = rptdtConfig.getReportList().getReport();
        HashMap<String, Report> allReportMap = new HashMap<String, Report>();
        for (Report report : allReportList) {
            allReportMap.put(report.getName(), report);
        }
        List<GenerateReport> generateReportList = rptdtConfig.getGenerateReportList().getGenerateReport();
        logger.info("----- Generate report -----");
        for (GenerateReport report : generateReportList) {
            String doFlg = report.getDoFlg();
            if (!Boolean.parseBoolean(doFlg)) continue;
            String generateReportFileName = report.getName();
            logger.info("[" + generateReportFileName + "]");
            reportList.add((Report)allReportMap.get(generateReportFileName));
        }
        logger.info("---------------------------");
        logger.info("reportList.size()=[" + reportList.size() + "]");
        if (reportList.size() < 1) {
            throw new SJdtRPTDTException("20520-107007");
        }
        return reportList;
    }

    private static List<Csv> getReferenceCsvList(RptdtConfig rptdtConfig, List<Report> reportList) {
        ArrayList<Csv> csvList = new ArrayList<Csv>();
        List<Csv> allCsvList = rptdtConfig.getCsvList().getCsv();
        HashMap<String, Csv> allCsvMap = new HashMap<String, Csv>();
        for (Csv csv : allCsvList) {
            String csvFileName = csv.getName();
            allCsvMap.put(csvFileName, csv);
        }
        LinkedHashMap csvMap = new LinkedHashMap();
        for (Report report : reportList) {
            List<RefCsv> refCsvList = report.getRefCsvList().getRefCsv();
            for (RefCsv refCsv : refCsvList) {
                String refCsvFileName = refCsv.getName();
                if (!allCsvMap.containsKey(refCsvFileName)) continue;
                Csv csv = (Csv)allCsvMap.get(refCsvFileName);
                csvMap.put(csv, null);
            }
        }
        Set keys = csvMap.keySet();
        for (Csv csv : keys) {
            csvList.add(csv);
        }
        return csvList;
    }

    private static void existsFile(String inputDirPath, String outputDirPath, List<Csv> csvList) throws SJdtRPTDTException {
        SJdtRPTDTMain.existsDirectory(inputDirPath);
        SJdtRPTDTMain.existsDirectory(outputDirPath);
        SJdtRPTDTMain.existsCsvFile(inputDirPath, csvList);
    }

    private static void existsDirectory(String dirPath) throws SJdtRPTDTException {
        File inputDir = new File(dirPath);
        if (!inputDir.exists()) {
            logger.severe("Directory not found [" + dirPath + "]");
            throw new SJdtRPTDTException("20520-107008");
        }
    }

    private static void existsCsvFile(String inputDirPath, List<Csv> csvList) throws SJdtRPTDTException {
        for (Csv csv : csvList) {
            String csvFileName = csv.getName();
            String csvFilePath = inputDirPath + csvFileName;
            File csvFile = new File(csvFilePath);
            if (!csv.isFileCheck() || csvFile.exists()) continue;
            logger.severe("File not found [" + csvFileName + "]");
            throw new SJdtRPTDTException("20520-107008");
        }
    }

    private static void validateCsvFile(List<Csv> csvList) throws SJdtRPTDTException {
        try {
            Properties csvValidatorProc = null;
            SJdtRPTDTDevice devinfo = new SJdtRPTDTDevice();
            csvValidatorProc = SJdtRPTDTUtils.getPropertyData(SJdtRPTDTDevice.getValidat_path());
            SJdtCSVWrapperManager.setValidatorData(csvValidatorProc);
            for (Csv csv : csvList) {
                String csvFileName = csv.getName();
                String wrapperClassName = csv.getWrapper().getName();
                SJdtCSVWrapperBase csvWrapper = (SJdtCSVWrapperBase)SJdtRPTDTUtils.getInstance(wrapperClassName);
                csvWrapper.init(csvFileName, true);
                if (csvWrapper.isFileExists() && csv.isValidateCheck()) {
                    csvWrapper.validate();
                }
                SJdtCSVWrapperManager.setCsvWrapper(csvFileName, csvWrapper);
            }
        }
        catch (IOException e) {
            throw new SJdtRPTDTException(e, "20520-107009");
        }
        catch (ClassNotFoundException e) {
            throw new SJdtRPTDTException(e, "20520-107009");
        }
        catch (InstantiationException e) {
            throw new SJdtRPTDTException(e, "20520-107009");
        }
        catch (IllegalAccessException e) {
            throw new SJdtRPTDTException(e, "20520-107009");
        }
        catch (SJdtRPTDTException e) {
            e.setAllStatus("20520-107009");
            throw e;
        }
    }

    private static void initVelocity() throws SJdtRPTDTException {
        try {
            Properties velocityProc = SJdtRPTDTUtils.getPropertyData(VELOCIYT_CONFIG_FILE_PATH);
            Velocity.init((Properties)velocityProc);
        }
        catch (IOException e) {
            throw new SJdtRPTDTException(e, "20520-107010");
        }
        catch (Exception e) {
            throw new SJdtRPTDTException(e, "20520-107010");
        }
    }

    private static List<ReportInfo> initGenerateReport(List<Report> reportList) throws SJdtRPTDTException {
        List<ReportInfo> reportInfoList = null;
        try {
            Properties guidanceProc = SJdtRPTDTUtils.getPropertyData(SJdtRPTDTDevice.getGuidance_path());
            SJdtReportGeneratorManager.setGuidanceData(guidanceProc);
            reportInfoList = SJdtRPTDTMain.getReportInfo(reportList, guidanceProc);
        }
        catch (IOException e) {
            throw new SJdtRPTDTException(e, "20520-107011");
        }
        return reportInfoList;
    }

    private static List<ReportInfo> getReportInfo(List<Report> reportList, Properties guidanceProc) throws SJdtRPTDTException {
        ArrayList<ReportInfo> reportInfoList = new ArrayList<ReportInfo>();
        try {
            for (Report report : reportList) {
                boolean isCsvFileExist = false;
                List<RefCsv> refCsvList = report.getRefCsvList().getRefCsv();
                for (RefCsv refCsv : refCsvList) {
                    String refCsvFileName = refCsv.getName();
                    SJdtCSVWrapperBase csvWrapper = SJdtCSVWrapperManager.getCsvWrapper(refCsvFileName);
                    if (!csvWrapper.isFileExists()) continue;
                    isCsvFileExist = true;
                    break;
                }
                if (!isCsvFileExist) {
                    String skipReportFileName = report.getName();
                    logger.info("[" + skipReportFileName + "] is skipped because all csv files used in this report do not exist.");
                    continue;
                }
                String reportFileName = report.getName();
                String reportClassName = report.getGenerator().getName();
                SJdtReportGeneratorBase reportGenerator = (SJdtReportGeneratorBase)SJdtRPTDTUtils.getInstance(reportClassName);
                String reportName = reportGenerator.getReportName();
                boolean isGraphicReport = reportGenerator.isGraphicReport();
                boolean useTableSort = reportGenerator.useTableSort();
                boolean useContentsFooter = reportGenerator.useContentsFooter();
                String key = "Common.menu." + reportName;
                String menuLinkStr = guidanceProc.getProperty(key);
                ReportInfo reportInfo = new ReportInfo();
                reportInfo.setReportFileName(reportFileName);
                reportInfo.setReportName(reportName);
                reportInfo.setReportGenerator(reportGenerator);
                reportInfo.setIsGraphicReport(isGraphicReport);
                reportInfo.setUseTableSort(useTableSort);
                reportInfo.setUseContentsFooter(useContentsFooter);
                reportInfo.setMenuLinkStr(menuLinkStr);
                reportInfoList.add(reportInfo);
            }
        }
        catch (ClassNotFoundException e) {
            throw new SJdtRPTDTException(e, "20520-107012");
        }
        catch (InstantiationException e) {
            throw new SJdtRPTDTException(e, "20520-107012");
        }
        catch (IllegalAccessException e) {
            throw new SJdtRPTDTException(e, "20520-107012");
        }
        return reportInfoList;
    }

    private static void generateReport(List<ReportInfo> reportInfoList, SJdtStatusWriter statusWriter) throws SJdtRPTDTException {
        for (ReportInfo reportInfo : reportInfoList) {
            String reportFileName = reportInfo.getReportFileName();
            SJdtReportGeneratorBase reportGenerator = reportInfo.getReportGenerator();
            logger.info("Generate start [" + reportFileName + "]");
            try {
                reportGenerator.generate(reportInfoList);
                statusWriter.setReportStatus(reportFileName, "20520-107100");
            }
            catch (SJdtRPTDTException e) {
                logger.severe("Failed to generate a report [" + reportFileName + "]");
                String reportStatus = e.getReportStatus();
                if ("20520-107107".equals(reportStatus)) {
                    statusWriter.setAllStatus("20520-109002");
                    statusWriter.setReportStatus(e.getReportFileName(), e.getReportStatus());
                    continue;
                }
                statusWriter.clear();
                throw new SJdtRPTDTException("20520-107001");
            }
        }
    }

    private static void generateIndexHtmlFile(List<ReportInfo> reportInfoList) throws SJdtRPTDTException {
        try {
            ReportInfo reportInfo = reportInfoList.get(0);
            String reportName = reportInfo.getReportName();
            String htmlFileName = "index.html";
            VelocityContext context = SJdtReportGeneratorManager.getVelocityContext();
            context.put("reportTitle", (Object)SJdtReportGeneratorManager.getGuidanceValue(reportInfo.getMenuLinkStr()));
            context.put("reportName", (Object)reportName);
            context.put("menuFramesetName", (Object)reportName);
            context.put("contentsFramesetName", (Object)reportName);
            String generateFilePath = SJdtReportGeneratorManager.outputDir + htmlFileName;
            SJdtReportGeneratorManager.generateFile(context, "/sanproject/sn2/rptdt/template/common/vm/reportFrameset.vm", generateFilePath);
        }
        catch (SJdtRPTDTException e) {
            e.setAllStatus("20520-107019");
            throw e;
        }
    }

    private static void outputStatusInfo(SJdtStatusWriter statusWriter) {
        String statusInfo = statusWriter.getStatusInfo();
        logger.info("Status Information" + LINE_SEPARATOR + statusInfo);
        statusWriter.close();
        System.out.print(statusInfo);
    }

    public static void setDevInfo(String csvFilePath) throws SJdtRPTDTException {
        try {
            File objFile = new File(csvFilePath + "MicroVersion.csv");
            if (!objFile.exists()) {
                logger.severe("File not found [" + csvFilePath + "MicroVersion.csv" + "]");
                throw new SJdtRPTDTException("20520-107008");
            }
            String model = "";
            SJdtCSVWrapperManager.setInputDir(csvFilePath);
            SJdtCSVWrapperBase csvWrapper = (SJdtCSVWrapperBase)SJdtRPTDTUtils.getInstance("sanproject.sn2.rptdt.csv.wrapper.SJdtHMMicroVersionCSVWrapper");
            csvWrapper.init("MicroVersion.csv", false);
            String[] microVersionRecord = csvWrapper.getRecord(0);
            String printoutTool = csvWrapper.getValue(microVersionRecord, "Printout Tool");
            String dkcMain = csvWrapper.getValue(microVersionRecord, "DKCMAIN");
            if (printoutTool.length() < 2 || dkcMain.length() < 8) {
                logger.severe("Version Info is not found [Printout Tool]:" + printoutTool);
                throw new SJdtRPTDTException("20520-107022");
            }
            String chkstr = printoutTool.substring(0, 2);
            model = dkcMain.substring(6, 8);
            for (int i = 0; i < HM_DEVVER_KEY_ARRAY.length; ++i) {
                if (!chkstr.equals(HM_DEVVER_KEY_ARRAY[i])) continue;
                SJdtRPTDTDevice.setDev_info("HM");
                SJdtRPTDTDevice.setConfig_path(RPTDT_HMCONFIG_FILE_PATH);
                SJdtRPTDTDevice.setValidat_path(CSV_HMVALIDATOR_FILE_PATH);
                SJdtRPTDTDevice.setGuidance_path(REPORT_HMGUIDANCE_FILE_PATH);
                SJdtRPTDTDevice.setModelInfo(model);
                break;
            }
            if (SJdtRPTDTDevice.getDev_info().equals("") || SJdtRPTDTDevice.getModel(model).equals("")) {
                if (chkstr.equals("")) {
                    logger.severe("Device Info or Model Info not found [ Device:" + SJdtRPTDTDevice.getDev_info() + ",Model:" + SJdtRPTDTDevice.getModelInfo() + "]");
                } else {
                    logger.severe("Device Info: [ " + chkstr + "]," + "[Model Info:" + model + "]");
                }
                throw new SJdtRPTDTException("20520-107022");
            }
            logger.info("Device Info [" + SJdtRPTDTDevice.getDev_info() + "]");
            logger.info("Model Info [" + SJdtRPTDTDevice.getModelInfo() + "]");
        }
        catch (ClassNotFoundException e) {
            throw new SJdtRPTDTException(e, "20520-107009");
        }
        catch (InstantiationException e) {
            throw new SJdtRPTDTException(e, "20520-107009");
        }
        catch (IllegalAccessException e) {
            throw new SJdtRPTDTException(e, "20520-107009");
        }
        catch (SJdtRPTDTException e) {
            e.setAllStatus("20520-107022");
            throw e;
        }
    }
}

