/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.report.generator;

import java.io.File;
import java.math.BigDecimal;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import sanproject.sn2.rptdt.exception.SJdtRPTDTException;
import sanproject.sn2.rptdt.main.SJdtRPTDTMain;
import sanproject.sn2.rptdt.report.SJdtReportGeneratorManager;
import sanproject.sn2.rptdt.report.generator.ReportInfo;
import sanproject.sn2.rptdt.util.SJdtRPTDTDevice;
import sanproject.sn2.rptdt.util.SJdtRPTDTUtils;

public abstract class SJdtReportGeneratorBase {
    private static Logger logger = Logger.getLogger(SJdtReportGeneratorBase.class.getName());
    public static final String REPORT_FRAMESET_VM_FILE_PATH = "/sanproject/sn2/rptdt/template/common/vm/reportFrameset.vm";
    private static final String MENU_FRAMESET_VM_FILE_PATH = "/sanproject/sn2/rptdt/template/common/vm/menuFrameset.vm";
    private static final String MENU_BODY_VM_FILE_PATH = "/sanproject/sn2/rptdt/template/common/vm/menuBody.vm";
    private static final String CONTENTS_FRAMESET_VM_FILE_PATH = "/sanproject/sn2/rptdt/template/common/vm/contentsFrameset.vm";
    protected static final String CONTENTS_FRAMESET_3PANE_VM_FILE_PATH = "/sanproject/sn2/rptdt/template/common/vm/contentsFrameset_3pane.vm";
    private static final String CONTENTS_TITLE_VM_FILE_PATH = "/sanproject/sn2/rptdt/template/common/vm/contentsTitle.vm";
    private static final String CONTENTS_BODY_ERROR_VM_FILE_PATH = "/sanproject/sn2/rptdt/template/common/vm/contentsBody_Error.vm";
    protected final String OUTPUT_HTML_DIR = SJdtReportGeneratorManager.outputDir + this.getReportName() + File.separator + "html" + File.separator;
    protected final String OUTPUT_CSS_DIR = SJdtReportGeneratorManager.outputDir + this.getReportName() + File.separator + "css" + File.separator;
    protected final String OUTPUT_IMG_DIR = SJdtReportGeneratorManager.outputDir + this.getReportName() + File.separator + "img" + File.separator;
    protected final String OUTPUT_DATA_DIR = SJdtReportGeneratorManager.outputDir + this.getReportName() + File.separator + "data" + File.separator;
    protected static final String MENU_FRAMESET_PREFIX = "menuFrameset_";
    protected static final String MENU_BODY_PREFIX = "menuBody_";
    protected static final String CONTENTS_FRAMESET_PREFIX = "contentsFrameset_";
    protected static final String CONTENTS_TITLE_PREFIX = "contentsTitle_";
    protected static final String CONTENTS_FOOTER_PREFIX = "contentsFooter_";
    protected static final String CONTENTS_BODY_PREFIX = "contentsBody_";
    protected static final String CONTENTS_MENU_PREFIX = "contentsMenu_";
    public static final String MENU_LINK_VIEW = "Common.menu.";
    public static final String EXPLANATION = "Common.explanation.";
    protected static final String NOT_APPLICABLE = "N/A";
    protected static final String STR_HYPHEN = "-";
    protected static final String STR_BLANK = " ";
    protected static final String DELIMITER_SLASH = "/";
    protected static final String[] PACKAGETYPE_ISCSI = new String[]{"10iSCSI2o(CHB)", "10iSCSI2c(CHB)"};
    public static final String PACKAGETYPE_HNAS = "NAS Module(CHB)";
    protected static final String NUMBER_EXCLUDED_ZERO_REGEX = "^[1-9]\\d{0,9}$";
    private static final BigDecimal BIG_DECIMAL_1000 = new BigDecimal(1000);
    protected final String ENABLED = "Enabled";

    public void generate(List<ReportInfo> reportInfoList) throws SJdtRPTDTException {
        this.generateReportDir();
        try {
            this.generateReportFrameset();
            this.generateMenuFrameset();
            this.generateMenuBody(reportInfoList);
            this.generateContentsFrameset();
            this.generateContentsTitle();
            this.generateContentsFooter();
            this.generateContentsMenu();
        }
        catch (SJdtRPTDTException e) {
            logger.severe(e.getMessage() + SJdtRPTDTMain.LINE_SEPARATOR + SJdtRPTDTUtils.getPrintStackTrace(e));
            throw e;
        }
        try {
            this.generateContentsBody();
        }
        catch (SJdtRPTDTException e) {
            logger.severe(e.getMessage() + SJdtRPTDTMain.LINE_SEPARATOR + SJdtRPTDTUtils.getPrintStackTrace(e));
            e.setReportStatus(this.getReportFramesetHtmlFileName(), "20520-107107");
            this.generateContentsBodyAsError(e);
            throw e;
        }
        catch (Exception e) {
            logger.severe(e.getMessage() + SJdtRPTDTMain.LINE_SEPARATOR + SJdtRPTDTUtils.getPrintStackTrace(e));
            SJdtRPTDTException re = new SJdtRPTDTException(e, null, this.getReportFramesetHtmlFileName(), "20520-107107");
            this.generateContentsBodyAsError(re);
            throw re;
        }
        logger.info(SJdtRPTDTUtils.getMemoryInfo());
    }

    protected void generateReportDir() {
        SJdtReportGeneratorManager.generateDir(this.OUTPUT_HTML_DIR);
    }

    protected void generateReportFrameset() throws SJdtRPTDTException {
        try {
            VelocityContext context = SJdtReportGeneratorManager.getVelocityContext();
            context.put("reportTitle", (Object)SJdtReportGeneratorManager.getGuidanceValue(this.getMenuLinkViewKey()));
            context.put("reportName", (Object)this.getReportName());
            context.put("menuFramesetName", (Object)this.getReportName());
            context.put("contentsFramesetName", (Object)this.getReportName());
            String generateFilePath = SJdtReportGeneratorManager.outputDir + this.getReportFramesetHtmlFileName();
            SJdtReportGeneratorManager.generateFile(context, REPORT_FRAMESET_VM_FILE_PATH, generateFilePath);
        }
        catch (SJdtRPTDTException e) {
            e.setReportStatus(this.getReportFramesetHtmlFileName(), "20520-107101");
            throw e;
        }
    }

    private void generateMenuFrameset() throws SJdtRPTDTException {
        try {
            VelocityContext context = SJdtReportGeneratorManager.getVelocityContext();
            context.put("reportName", (Object)this.getReportName());
            String generateFilePath = this.OUTPUT_HTML_DIR + this.getMenuFramesetHtmlFileName();
            SJdtReportGeneratorManager.generateFile(context, MENU_FRAMESET_VM_FILE_PATH, generateFilePath);
        }
        catch (SJdtRPTDTException e) {
            e.setReportStatus(this.getReportFramesetHtmlFileName(), "20520-107102");
            throw e;
        }
    }

    private void generateMenuBody(List<ReportInfo> reportInfoList) throws SJdtRPTDTException {
        try {
            VelocityContext context = SJdtReportGeneratorManager.getVelocityContext();
            context.put("reportInfoList", reportInfoList);
            context.put("currentMenuLinkStr", (Object)SJdtReportGeneratorManager.getGuidanceValue(this.getMenuLinkViewKey()));
            String generateFilePath = this.OUTPUT_HTML_DIR + this.getMenuBodyHtmlFileName();
            SJdtReportGeneratorManager.generateFile(context, MENU_BODY_VM_FILE_PATH, generateFilePath);
        }
        catch (SJdtRPTDTException e) {
            e.setReportStatus(this.getReportFramesetHtmlFileName(), "20520-107103");
            throw e;
        }
    }

    protected void generateContentsFrameset() throws SJdtRPTDTException {
        try {
            VelocityContext context = SJdtReportGeneratorManager.getVelocityContext();
            context.put("reportName", (Object)this.getReportName());
            String generateFilePath = this.OUTPUT_HTML_DIR + this.getContentsFramesetHtmlFileName();
            SJdtReportGeneratorManager.generateFile(context, CONTENTS_FRAMESET_VM_FILE_PATH, generateFilePath);
        }
        catch (SJdtRPTDTException e) {
            e.setReportStatus(this.getReportFramesetHtmlFileName(), "20520-107104");
            throw e;
        }
    }

    protected void generateContentsFrameset3pane() throws SJdtRPTDTException {
        try {
            VelocityContext context = SJdtReportGeneratorManager.getVelocityContext();
            context.put("contentsTitleName", (Object)this.getReportName());
            context.put("contentsBodyName", (Object)this.getReportName());
            context.put("contentsFooterName", (Object)this.getReportName());
            String generateFrontFilePath = this.OUTPUT_HTML_DIR + this.getContentsFramesetHtmlFileName();
            SJdtReportGeneratorManager.generateFile(context, CONTENTS_FRAMESET_3PANE_VM_FILE_PATH, generateFrontFilePath);
        }
        catch (SJdtRPTDTException e) {
            e.setReportStatus(this.getReportFramesetHtmlFileName(), "20520-107104");
            throw e;
        }
    }

    protected void generateContentsTitle() throws SJdtRPTDTException {
        try {
            VelocityContext context = SJdtReportGeneratorManager.getVelocityContext();
            context.put("contensTitle", (Object)SJdtReportGeneratorManager.getGuidanceValue(this.getMenuLinkViewKey()));
            context.put("explanation", (Object)SJdtReportGeneratorManager.getGuidanceValue(this.getExplanationKey()));
            String generateFilePath = this.OUTPUT_HTML_DIR + this.getContentsTitleHtmlFileName();
            SJdtReportGeneratorManager.generateFile(context, CONTENTS_TITLE_VM_FILE_PATH, generateFilePath);
        }
        catch (SJdtRPTDTException e) {
            e.setReportStatus(this.getReportFramesetHtmlFileName(), "20520-107105");
            throw e;
        }
    }

    protected void generateContentsFooter() throws SJdtRPTDTException {
    }

    protected void generateContentsMenu() throws SJdtRPTDTException {
    }

    public void generateContentsBodyAsError(SJdtRPTDTException e) throws SJdtRPTDTException {
        try {
            VelocityContext context = SJdtReportGeneratorManager.getVelocityContext();
            context.put("errorTitle", (Object)SJdtReportGeneratorManager.getGuidanceValue("Error.contensBody.title"));
            context.put("errorDescription", (Object)SJdtReportGeneratorManager.getGuidanceValue("Error.contensBody.description"));
            context.put("errorCode", (Object)SJdtReportGeneratorManager.getGuidanceValue("Error.contensBody.code"));
            context.put("errorMessage", (Object)SJdtReportGeneratorManager.getGuidanceValue("Error.contensBody.message"));
            String errorCode = e.getReportStatus();
            String errorMessage = e.getMessage();
            context.put("valueOfErrorCode", (Object)errorCode);
            context.put("valueOfErrorMessage", (Object)errorMessage);
            String generateFilePath = this.OUTPUT_HTML_DIR + this.getContentsBodyHtmlFileName();
            SJdtReportGeneratorManager.generateFile(context, CONTENTS_BODY_ERROR_VM_FILE_PATH, generateFilePath);
        }
        catch (SJdtRPTDTException re) {
            re.setReportStatus(this.getReportFramesetHtmlFileName(), "20520-107108");
            throw re;
        }
    }

    protected String getOnOffToDisplayStr(String csvStr) {
        String displayStr = null;
        displayStr = "On".equals(csvStr) ? "Enabled" : ("Off".equals(csvStr) ? "Disabled" : ("".equals(csvStr) ? "" : NOT_APPLICABLE));
        return displayStr;
    }

    public String getDriveTypeRpm(String deviceType, String rpm) {
        if (deviceType.startsWith("SSD")) {
            String driveTypeRpm = "";
            driveTypeRpm = SJdtRPTDTDevice.isHmdev() ? deviceType + DELIMITER_SLASH + rpm : deviceType + DELIMITER_SLASH + STR_HYPHEN;
            return driveTypeRpm;
        }
        BigDecimal rpmBigDecimal = BigDecimal.ZERO;
        if (rpm.matches(NUMBER_EXCLUDED_ZERO_REGEX)) {
            rpmBigDecimal = new BigDecimal(rpm).divide(BIG_DECIMAL_1000);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(deviceType);
        sb.append(DELIMITER_SLASH);
        sb.append(rpmBigDecimal.toString());
        sb.append("k");
        return sb.toString();
    }

    protected String changeHyphenDisplayStr(String csvStr) {
        String displayStr = null;
        displayStr = "".equals(csvStr) ? STR_HYPHEN : csvStr;
        return displayStr;
    }

    public boolean isInternalGroup(String eccGroup) {
        boolean result = false;
        if (StringUtils.isEmpty((String)eccGroup)) {
            return result;
        }
        String s = eccGroup.substring(0, 1);
        if (StringUtils.isNumeric((String)s)) {
            result = true;
        }
        return result;
    }

    public boolean isIscsi(String packageType) {
        boolean result = false;
        for (String searchStr : PACKAGETYPE_ISCSI) {
            if (!packageType.equals(searchStr)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean isUnified(String packageType) {
        boolean result = false;
        if (packageType.equals(PACKAGETYPE_HNAS)) {
            result = true;
        }
        return result;
    }

    public abstract String getReportName();

    public abstract String getMenuLinkViewKey();

    public abstract String getExplanationKey();

    public abstract String getReportFramesetHtmlFileName();

    public abstract String getMenuFramesetHtmlFileName();

    public abstract String getMenuBodyHtmlFileName();

    public abstract String getContentsFramesetHtmlFileName();

    public abstract String getContentsTitleHtmlFileName();

    public abstract String getContentsBodyHtmlFileName();

    public abstract void generateContentsBody() throws SJdtRPTDTException;

    public abstract boolean isGraphicReport();

    public abstract boolean useTableSort();

    public abstract boolean useContentsFooter();
}

