/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.servlet.login;

import java.io.IOException;
import java.net.InetAddress;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sanproject.sn2.base.session.SJbaseUserSessionManager;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcProductUty;
import sanproject.sn2.com.utility.SJcSingletonManagerUty;
import sanproject.sn2.com.utility.SJcSystemUty;

public class SJsvlSVPLauncherServlet
extends HttpServlet {
    private final String LOG_FUNCTION = "Login_SVP";
    private final String LOG_TITLE = ((Object)((Object)this)).getClass().getSimpleName();
    private final String ENCODE_UTF8 = "UTF-8";
    private final String KEY_USERNAME = "UserName";
    private final String KEY_PASS = "Pass";
    private final String LOGINTYPE = "SVP";
    private static final String FORWARD_URL = "/index.do";
    private SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String LOG_SUBTITLE = "doPost";
        this.STD_LOGGER.info("Login_SVP", this.LOG_TITLE, "doPost", "Start.");
        request.setCharacterEncoding("UTF-8");
        response.setContentType("text/html;charset=UTF-8");
        InetAddress ipAddress = InetAddress.getByName(request.getRemoteAddr());
        if (!SJcSystemUty.chkIP_Myself(ipAddress)) {
            response.sendError(403);
            return;
        }
        String userId = request.getParameter("UserName");
        String globalSessionID = request.getParameter("Pass");
        if (userId == null || globalSessionID == null) {
            this.STD_LOGGER.error("Login_SVP", this.LOG_TITLE, "doPost", "userId : " + userId + ", globalSessionID" + globalSessionID);
            response.sendError(404);
            return;
        }
        this.logoutSession(globalSessionID);
        String venderID = SJcProductUty.getVenderID();
        String snLanguage = this.getLanguage(venderID);
        request.setAttribute("SN_Language", (Object)snLanguage);
        request.setAttribute("SN_View_LoginType", (Object)"SVP");
        request.setAttribute("SN_View_UserName", (Object)userId);
        request.setAttribute("SN_View_Password", (Object)globalSessionID);
        this.STD_LOGGER.info("Login_SVP", this.LOG_TITLE, "doPost", "End.");
        RequestDispatcher dispatch = request.getRequestDispatcher(FORWARD_URL);
        dispatch.forward((ServletRequest)request, (ServletResponse)response);
    }

    private String getLanguage(String venderID) {
        String returnValue = null;
        returnValue = "HIE".equals(venderID) || "HPE".equals(venderID) ? "EN" : ("HIJ".equals(venderID) || "HPJ".equals(venderID) ? "JA" : "EN");
        return returnValue;
    }

    private void logoutSession(String gid) {
        String LOG_SUBTITLE = "logoutSession";
        this.STD_LOGGER.trace("Login_SVP", this.LOG_TITLE, "logoutSession", "Start.");
        SJbaseUserSessionManager sessionManager = (SJbaseUserSessionManager)SJcSingletonManagerUty.getSingleton(SJbaseUserSessionManager.class);
        if (sessionManager == null) {
            this.STD_LOGGER.warn("Login_SVP", this.LOG_TITLE, "logoutSession", "Failed to get instance of SJbaseUserSessionManager.");
        } else {
            SJbaseUserSessionInterface userSession = sessionManager.getUserSession(gid);
            if (userSession != null) {
                try {
                    sessionManager.logout(gid);
                    this.STD_LOGGER.info("Login_SVP", this.LOG_TITLE, "logoutSession", "Success to logout: " + gid);
                }
                catch (SJcException e) {
                    this.STD_LOGGER.error("Login_SVP", this.LOG_TITLE, "logoutSession", "Failed to logout: " + gid, e);
                }
            }
        }
        this.STD_LOGGER.trace("Login_SVP", this.LOG_TITLE, "logoutSession", "End.");
    }
}

