/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.systemcall;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.LoggerFactory;
import sanproject.sn2.base.property.SJbaseSystemPropertiesManager;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.account.exception.SJcParamErrorException;
import sanproject.sn2.controller.com.gumLaunch.SJctrGumLaunchUty;

public class SJcmdGetGGIAuthUrl {
    private static final String LOG_FUNCTION = "SJcmdGetGGIAuthUrl";
    private static final String LOG_TITLE = "SJcmdGetGGIAuthUrl";
    private static String encode = "UTF-8";
    private static String szMsg;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void main(String[] argv) {
        String LOG_SUBTITLE = "main";
        SJbaseSystemPropertiesManager clsEnv = null;
        try {
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)lc);
            lc.reset();
            URL logurl = SJcmdGetGGIAuthUrl.class.getResource("logback.xml");
            configurator.doConfigure(logurl);
            System.setProperty("SN_DataPath", SJcEnvUty.getSnBasePath() + "san\\SN2\\SN2Files");
            System.setProperty("SN_EnvFile", SJcEnvUty.getSnBasePath() + "san\\SN2\\SN2Files\\data\\base\\setting\\system\\properties\\SN2_Startup.properties");
            System.setProperty("SN_EnvFileV", SJcEnvUty.getSnBasePath() + "san\\SN2\\SN2Files\\data\\base\\setting\\system\\properties\\SN2_StartupV.properties");
            System.setProperty("SN_LogPath", "AuthCredential");
            szMsg = "Start.";
            SJcLogUty.getLogger().info("SJcmdGetGGIAuthUrl", "SJcmdGetGGIAuthUrl", "main", szMsg);
            clsEnv = new SJbaseSystemPropertiesManager();
            clsEnv.initialize(0);
            if (argv.length != 2 || argv[0] == "" || argv[1] == "") {
                throw new SJcParamErrorException();
            }
            String szUserName = SJcmdGetGGIAuthUrl.asByteArray(argv[0]);
            String szPassword = SJcmdGetGGIAuthUrl.asByteArray(argv[1]);
            HashMap<String, Object> mMenu = new HashMap<String, Object>();
            Map<String, Object> ggiParam = SJctrGumLaunchUty.createParamMap("M1-0", null, "MAINTENANCE");
            mMenu.put("GGI_PARAMETER", ggiParam);
            mMenu.put("GGI_CTRL_ID", 99);
            String authUrl = SJctrGumLaunchUty.getGGIAuthUrl(szUserName, szPassword, mMenu);
            System.out.println("true," + authUrl);
        }
        catch (SJcException exp) {
            String szExpMsg = exp.getMsg().getFunctionID() + exp.getMsg().getModuleID() + "-" + exp.getMsg().getMsgID();
            System.out.println("false," + szExpMsg);
            szMsg = "SJcException." + szExpMsg;
            SJcLogUty.getLogger().error("SJcmdGetGGIAuthUrl", "SJcmdGetGGIAuthUrl", "main", szMsg, exp);
        }
        catch (Exception e) {
            System.out.println("false,dummy");
            szMsg = "Exception.";
            SJcLogUty.getLogger().error("SJcmdGetGGIAuthUrl", "SJcmdGetGGIAuthUrl", "main", szMsg, e);
        }
        finally {
            try {
                if (clsEnv != null) {
                    clsEnv.finish();
                }
            }
            catch (Exception e) {
                szMsg = "Exception.";
                SJcLogUty.getLogger().error("SJcmdGetGGIAuthUrl", "SJcmdGetGGIAuthUrl", "main", szMsg, e);
            }
            szMsg = "End.";
            SJcLogUty.getLogger().info("SJcmdGetGGIAuthUrl", "SJcmdGetGGIAuthUrl", "main", szMsg);
        }
    }

    private static String asByteArray(String ascii) {
        String result = new String();
        try {
            ArrayList<String> buf = new ArrayList<String>();
            for (int sub = 0; sub < ascii.length(); sub += 2) {
                String byteString = ascii.substring(sub, sub + 2);
                buf.add(byteString);
            }
            byte[] byteArray = new byte[buf.size()];
            for (int i = 0; i < byteArray.length; ++i) {
                String byteString = (String)buf.get(i);
                byteArray[i] = Byte.parseByte(byteString, 16);
            }
            result = new String(byteArray, encode);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }
}

