/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.baseinfo;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import sanproject.client.base.RJBasePanel;
import sanproject.client.baseinfo.RJBaseInfoTabIDList;
import sanproject.client.baseinfo.com.RJBaseInfoDataSupplier;
import sanproject.client.baseinfo.com.RJBaseInfoDef;
import sanproject.client.baseinfo.com.RJBaseInfoException;
import sanproject.client.baseinfo.com.RJBaseInfoTabPanel;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComFuncPanel;
import sanproject.client.com.RJComPanel;
import sanproject.client.com.RJcAbsGuideConst;
import sanproject.client.com.RJcConst;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcTabID;
import sanproject.client.com.RJcTabPanel;
import sanproject.client.data.RJDataControl;

public class RJBaseInfoPanel
extends RJComFuncPanel
implements RJBaseInfoDef {
    private JTabbedPane tabbedPanel = new JTabbedPane();
    protected RJcTabPanel[] childPanels = null;
    private Color tabFgClr;
    private Color tabBgClr;
    private Color selTabFgClr;
    private Color selTabBgClr;
    private boolean tabChangeMask = true;
    private int preIndex = 0;
    boolean exceptionFlag = false;
    protected RJBasePanel basePanel = null;
    private RJBaseInfoDataSupplier supplier;
    private ArrayList argInfoList = new ArrayList(4);

    public RJBaseInfoPanel(RJBaseInfoDataSupplier rJBaseInfoDataSupplier) {
        super(RJDataControl.getDataControl());
        this.supplier = rJBaseInfoDataSupplier;
        this.supplier.pushParentPanel(this);
        this.createArgInfo();
        this.initInstance();
    }

    private void createArgInfo() {
        try {
            Class<?> clazz = Class.forName("sanproject.client.baseinfo.com.RJBaseInfoDataSupplier");
            ArgInfo argInfo = new ArgInfo("sanproject.client.baseinfo.port.RJBaseInfoPortPanel");
            argInfo.setInfo(new Class[]{clazz}, new Object[]{this.supplier});
            this.argInfoList.add(argInfo);
            argInfo = new ArgInfo("sanproject.client.baseinfo.lu.RJBaseInfoLUPanel");
            argInfo.setInfo(new Class[]{clazz}, new Object[]{this.supplier});
            this.argInfoList.add(argInfo);
            argInfo = new ArgInfo("sanproject.client.baseinfo.ldev.RJBaseInfoLDEVPanel");
            argInfo.setInfo(new Class[]{clazz}, new Object[]{this.supplier});
            this.argInfoList.add(argInfo);
            argInfo = new ArgInfo("sanproject.client.baseinfo.aou.RJBaseInfoAOUPanel");
            argInfo.setInfo(new Class[]{clazz}, new Object[]{this.supplier});
            this.argInfoList.add(argInfo);
            argInfo = new ArgInfo("sanproject.client.baseinfo.pg.RJBaseInfoPGPanel");
            argInfo.setInfo(new Class[]{clazz}, new Object[]{this.supplier});
            this.argInfoList.add(argInfo);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.putLog("[MainPanel]", "[ChildInfo]", classNotFoundException.toString());
        }
    }

    protected void initInstance() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(800, 600));
        this.setForeground(RJcAbsGuideConst.stdFgClr);
        this.setBackground(this.getColor("FuncPanelBgClr"));
        this.tabFgClr = this.getColor("TabFgClr");
        this.tabBgClr = this.getColor("TabBgClr");
        this.selTabFgClr = this.getColor("SelTabFgClr");
        this.selTabBgClr = this.getColor("SelTabBgClr");
        this.childPanels = this.createChildPanels();
        this.tabbedPanel.setForeground(this.tabFgClr);
        this.tabbedPanel.setBackground(this.selTabBgClr);
        this.tabbedPanel.setFont(RJcConst.ppTabFont);
        for (int i = 0; i < this.childPanels.length; ++i) {
            CardLayout cardLayout = new CardLayout();
            JPanel jPanel = new JPanel(cardLayout);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            RJcTabPanel rJcTabPanel = this.childPanels[i];
            RJcTabID rJcTabID = rJcTabPanel.getTabID();
            rJcTabPanel.setParent(this);
            Color color = rJcTabPanel.getBorderColor();
            if (color != null) {
                jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
                jPanel2.setBackground(color);
            }
            ((RJBaseInfoTabPanel)rJcTabPanel).setCardLayout(cardLayout, jPanel);
            jPanel2.add((Component)rJcTabPanel, "Center");
            String string = rJcTabPanel.getTabTitle();
            if (string == null) {
                string = this.getText(rJcTabID.getID());
            }
            jPanel.add((Component)jPanel2, "NORMAL");
            jPanel.add((Component)this.createErrorPanel(), "ERROR");
            this.tabbedPanel.add((Component)jPanel, string);
            this.tabbedPanel.setForegroundAt(i, this.tabFgClr);
            this.tabbedPanel.setBackgroundAt(i, this.tabBgClr);
            this.tabbedPanel.setEnabledAt(i, rJcTabID.isEnabled() && !rJcTabID.isErrorStatus());
        }
        this.tabbedPanel.setForegroundAt(this.preIndex, this.selTabFgClr);
        this.tabbedPanel.setBackgroundAt(this.preIndex, this.selTabBgClr);
        this.tabbedPanel.setSelectedIndex(this.preIndex);
        this.tabbedPanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (RJBaseInfoPanel.this.tabChangeMask) {
                    RJBaseInfoPanel.this.tabStateChanged(changeEvent);
                }
            }
        });
        this.add((Component)this.tabbedPanel, "Center");
    }

    protected RJcTabPanel[] createChildPanels() {
        RJcTabPanel[] rJcTabPanelArray = new RJcTabPanel[]{};
        ArrayList arrayList = this.createTabIDList();
        ArrayList<RJcTabPanel> arrayList2 = new ArrayList<RJcTabPanel>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJcTabPanel rJcTabPanel;
            RJcTabID rJcTabID = (RJcTabID)iterator.next();
            if (rJcTabID == null || (rJcTabPanel = this.newTabPanel(rJcTabID.getPanelName())) == null) continue;
            rJcTabPanel.setTabID(rJcTabID);
            arrayList2.add(rJcTabPanel);
        }
        rJcTabPanelArray = arrayList2.toArray(rJcTabPanelArray);
        return rJcTabPanelArray;
    }

    protected void tabStateChanged(ChangeEvent changeEvent) {
        if (!this.showFrontTabPanel(changeEvent) && !this.exceptionFlag) {
            this.tabChangeMask = false;
            this.tabbedPanel.setSelectedIndex(this.preIndex);
            this.tabChangeMask = true;
            this.putLog("[BaseInfo]", "[Tab Change]", "back to tab.", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean showFrontTabPanel(ChangeEvent changeEvent) {
        boolean bl = false;
        if (this.childPanels[this.preIndex].chgTab()) {
            int n;
            boolean bl2 = false;
            try {
                this.waitCursor(this);
                n = RJCom.getEditMode(this.m_DataControl);
                bl2 = this.showPanelImpl(n != 0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.exceptionFlag = true;
                this.endRequest(3);
            }
            finally {
                this.defaultCursor(this);
            }
            n = this.tabbedPanel.getSelectedIndex();
            if (!this.exceptionFlag) {
                this.putLog("[FuncPanel]", "[Tab Change]", "TabName=[" + this.tabbedPanel.getTitleAt(n) + "], rc=" + bl2);
                if (bl2) {
                    this.tabbedPanel.setForegroundAt(this.preIndex, this.tabFgClr);
                    this.tabbedPanel.setBackgroundAt(this.preIndex, this.tabBgClr);
                    this.tabbedPanel.setForegroundAt(n, this.selTabFgClr);
                    this.tabbedPanel.setBackgroundAt(n, this.selTabBgClr);
                    this.preIndex = n;
                    bl = true;
                }
            } else {
                this.tabbedPanel.setForegroundAt(this.preIndex, this.tabFgClr);
                this.tabbedPanel.setBackgroundAt(this.preIndex, this.tabBgClr);
            }
            this.setEnabledTab();
        }
        return bl;
    }

    public String getSelectedTabTitle() {
        int n = this.tabbedPanel.getSelectedIndex();
        String string = this.tabbedPanel.getTitleAt(n);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean showPanel(boolean bl) {
        boolean bl2 = false;
        this.setEnabledTab();
        try {
            this.waitCursor(this);
            bl2 = this.showPanelImpl(bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.exceptionFlag = true;
            this.endRequest(3);
        }
        finally {
            this.defaultCursor(this);
        }
        return bl2;
    }

    protected boolean showPanelImpl(boolean bl) {
        this.exceptionFlag = false;
        RJBaseInfoTabPanel rJBaseInfoTabPanel = (RJBaseInfoTabPanel)this.getActiveComPanel();
        rJBaseInfoTabPanel.displayNormalPanel();
        boolean bl2 = rJBaseInfoTabPanel.showPanel(bl);
        return bl2;
    }

    protected void setEnabledTab() {
        for (int i = 0; i < this.childPanels.length; ++i) {
            RJcTabPanel rJcTabPanel = this.childPanels[i];
            RJcTabID rJcTabID = rJcTabPanel.getTabID();
            this.tabbedPanel.setEnabledAt(i, rJcTabID.isEnabled() && !rJcTabID.isErrorStatus());
        }
    }

    public boolean chgChk() {
        boolean bl = this.getActiveComPanel().chgChk();
        return bl;
    }

    public boolean rmvChk() {
        boolean bl = this.getActiveComPanel().rmvChk();
        return bl;
    }

    public void rmvObj() {
        for (int i = 0; i < this.childPanels.length; ++i) {
            this.childPanels[i].rmvObj();
        }
        this.tabbedPanel = null;
        this.childPanels = null;
    }

    public RJComPanel getActiveComPanel() {
        int n = this.tabbedPanel.getSelectedIndex();
        return this.childPanels[n];
    }

    public void endRequest(int n) {
        RJBaseInfoTabPanel rJBaseInfoTabPanel = (RJBaseInfoTabPanel)this.getActiveComPanel();
        rJBaseInfoTabPanel.closePanel();
        rJBaseInfoTabPanel.displayErrPanel();
        RJBaseInfoException rJBaseInfoException = new RJBaseInfoException("errLevel = " + n);
        throw rJBaseInfoException;
    }

    private JPanel createErrorPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        Border border = BorderFactory.createLineBorder(RJcGuide.color("BasicInfo/ERR_PANEL_BORDER"), 4);
        jPanel.setBorder(border);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(this.getColor("FuncPanelBgClr"));
        jPanel2.setForeground(RJcAbsGuideConst.stdFgClr);
        JLabel jLabel = new JLabel(RJcGuide.text("BasicInfo/ERR_PANEL_MSG"));
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        return jPanel;
    }

    protected String getText(String string) {
        String string2 = RJcGuide.text(string);
        return string2;
    }

    protected Color getColor(String string) {
        Color color = RJcGuide.color(string);
        return color;
    }

    protected void waitCursor(Component component) {
        RJCom.waitCursor(component);
    }

    protected void defaultCursor(Component component) {
        RJCom.defCursor(component);
    }

    public void setBasePanel(RJBasePanel rJBasePanel) {
        this.basePanel = rJBasePanel;
    }

    public RJBasePanel getBasePanel() {
        return this.basePanel;
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    private ArrayList createTabIDList() {
        ArrayList<RJcTabID> arrayList = new ArrayList<RJcTabID>();
        String[] stringArray = RJBaseInfoTabIDList.getTabIDList();
        for (int i = 0; i < stringArray.length; ++i) {
            RJcTabID rJcTabID = (RJcTabID)this.newInstance(stringArray[i]);
            arrayList.add(rJcTabID);
        }
        return arrayList;
    }

    private RJcTabPanel newTabPanel(String string) {
        RJcTabPanel rJcTabPanel = (RJcTabPanel)this.newInstance(string);
        return rJcTabPanel;
    }

    protected Object newInstance(String string) {
        Object var2_2 = null;
        ArgInfo argInfo = this.getArgInfo(string);
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(argInfo.getTypes());
            var2_2 = constructor.newInstance(argInfo.getArgs());
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.putLog("[BaseInfo]", "[reflect]", "[" + string + "] " + classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.putLog("[BaseInfo]", "[reflect]", "[" + string + "] " + noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.putLog("[BaseInfo]", "[reflect]", "[" + string + "] " + invocationTargetException);
            throw (RuntimeException)new RuntimeException().initCause(invocationTargetException.getCause());
        }
        catch (IllegalAccessException illegalAccessException) {
            this.putLog("[BaseInfo]", "[reflect]", "[" + string + "] " + illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.putLog("[BaseInfo]", "[reflect]", "[" + string + "] " + illegalArgumentException);
        }
        catch (InstantiationException instantiationException) {
            this.putLog("[BaseInfo]", "[newInstance]", "[" + string + "] " + instantiationException);
        }
        return var2_2;
    }

    protected ArgInfo getArgInfo(String string) {
        ArgInfo argInfo = new ArgInfo(string);
        int n = this.argInfoList.indexOf(argInfo);
        if (n >= 0) {
            argInfo = (ArgInfo)this.argInfoList.get(n);
        }
        return argInfo;
    }

    public void putLog(String string, String string2, String string3) {
        this.putLog(string, string2, string3, 0);
    }

    public void putLog(String string, String string2, String string3, int n) {
        super.putLog(string, string2, string3, n);
    }

    protected class ArgInfo {
        private String name = null;
        private Class[] types = null;
        private Object[] args = null;

        public ArgInfo(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void setInfo(Class[] classArray, Object[] objectArray) {
            this.types = classArray;
            this.args = objectArray;
        }

        public Class[] getTypes() {
            return this.types;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof ArgInfo) {
                bl = this.name.equals(((ArgInfo)object).getName());
            }
            return bl;
        }

        public int hashCode() {
            int n = this.name.hashCode();
            return n;
        }
    }
}

