/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com;

import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJcConst;
import sanproject.client.com.RJcElement;
import sanproject.client.com.RJcTablePanel;
import sanproject.client.com.RJcTreeViewRestorer;
import sanproject.client.com.abs.RJaTreeManager;
import sanproject.client.com.abs.RJaTreeNode;

public abstract class RJcTreePanel
extends RJaTreeManager
implements RJcConst {
    protected RJcTablePanel table = null;
    protected Object userObject = null;
    private String title = null;

    protected void setTablePanel(RJcTablePanel rJcTablePanel) {
        this.table = rJcTablePanel;
    }

    public RJcTablePanel getTablePanel() {
        return this.table;
    }

    protected void setUserObject(Object object) {
        this.userObject = object;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void init() {
        RJcTreeViewRestorer rJcTreeViewRestorer = new RJcTreeViewRestorer();
        try {
            rJcTreeViewRestorer.saveView(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.refreshTree();
            rJcTreeViewRestorer.restoreView(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    protected void setRootObject() {
    }

    public void expandRoot() {
        this.tree.expandPath(new TreePath(this.rootNode.getPath()));
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.selectNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selectNode() {
        try {
            RJCom.waitCursor(this);
            TreePath[] treePathArray = this.tree.getSelectionPaths();
            if (treePathArray != null) {
                for (int i = 0; i < treePathArray.length; ++i) {
                    RJaTreeNode rJaTreeNode = (RJaTreeNode)treePathArray[i].getLastPathComponent();
                    Object object = rJaTreeNode.getUserObject();
                    if (object instanceof RJcElement && !((RJcElement)object).isExpandMode()) {
                        rJaTreeNode.createChildren();
                    }
                    if (!this.isVisible()) continue;
                    rJaTreeNode.selectNode();
                }
            } else {
                this.resetTable();
            }
        }
        finally {
            RJCom.defCursor(this);
        }
    }

    public void clearSelectedPath() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null) {
            this.tree.clearSelection();
            this.resetTable();
        }
    }

    public void resetTable() {
        if (this.table != null && this.isVisible()) {
            this.table.reset();
        }
    }

    public void refreshTree() {
        this.clearSelectedPath();
        RJaTreeNode rJaTreeNode = this.getRootNode();
        this.tree.collapsePath(new TreePath(rJaTreeNode.getPath()));
        rJaTreeNode.removeChildren();
        this.resetTable();
        this.setRootObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expand(TreePath treePath) {
        try {
            RJCom.waitCursor(this);
            if (treePath != null) {
                super.expand(treePath);
            }
        }
        finally {
            RJCom.defCursor(this);
        }
    }
}

