/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com.restoreview;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JScrollPane;
import sanproject.client.com.restoreview.ScrollPaneComponentParser;
import sanproject.client.com.restoreview.UnsupportedComponentException;
import sanproject.client.com.restoreview.utility.ScrollPaneComponentUtilities;

public class DefaultScrollPaneComponentParser
implements ScrollPaneComponentParser {
    private JScrollPane mslpAnalysisComponent;

    public DefaultScrollPaneComponentParser() {
    }

    public DefaultScrollPaneComponentParser(JScrollPane jScrollPane) throws UnsupportedComponentException {
        this.setAnalysisComponent(jScrollPane);
    }

    protected void finalize() throws Throwable {
        this.mslpAnalysisComponent = null;
        super.finalize();
    }

    public void setAnalysisComponent(Component component) throws UnsupportedComponentException {
        if (!(component instanceof JScrollPane)) {
            String string = "Any components other than 'javax.swing.JScrollPane' are not supported.";
            throw new UnsupportedComponentException(string);
        }
        this.mslpAnalysisComponent = (JScrollPane)component;
    }

    protected Component getAnalysisComponent() {
        return this.mslpAnalysisComponent;
    }

    public Point findViewPosition(JScrollPane jScrollPane) {
        Point point = new Point(0, 0);
        JScrollPane jScrollPane2 = (JScrollPane)this.getAnalysisComponent();
        if (jScrollPane2 != null) {
            point = ScrollPaneComponentUtilities.getViewportViewPosition(jScrollPane);
            Dimension dimension = ScrollPaneComponentUtilities.getViewportSize(jScrollPane2);
            Dimension dimension2 = ScrollPaneComponentUtilities.getComponentSize(jScrollPane2);
            int n = point.getX() + (double)dimension.width > (double)dimension2.width ? dimension2.width - dimension.width : (int)point.getX();
            int n2 = point.getY() + (double)dimension.height > (double)dimension2.height ? dimension2.height - dimension.height : (int)point.getY();
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            point = new Point(n, n2);
        }
        return point;
    }
}

