/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.com;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager2;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.EventListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import sanproject.client.exdevice.com.ExpandablePanelList;
import sanproject.client.exdevice.event.ExpansionEvent;
import sanproject.client.exdevice.event.ExpansionListener;

public class ExpandablePanel
extends JPanel {
    private boolean expandable;
    private boolean contentsResizable;
    private boolean expanded;
    private boolean adjustSizeing;
    private JComponent defaultTitle;
    private JComponent titleComponent;
    private JComponent contentsComponent;
    private JPanel contentsPanel;
    private JComponent resizingComponent;
    private transient MouseListener titleMouseListener;
    static /* synthetic */ Class class$sanproject$client$exdevice$event$ExpansionListener;

    public ExpandablePanel() {
        this((JComponent)null);
    }

    public ExpandablePanel(JComponent jComponent) {
        this(jComponent, null);
    }

    public ExpandablePanel(JComponent jComponent, JComponent jComponent2) {
        JButton jButton = new JButton();
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        this.defaultTitle = jButton;
        this.resizingComponent = this.createRisizableComponent();
        this.titleMouseListener = this.createTitleMouseListener();
        this.expandable = true;
        this.expanded = false;
        this.contentsResizable = false;
        this.contentsPanel = new JPanel();
        LayoutManager2 layoutManager2 = new GridBagLayout();
        this.contentsPanel.setLayout(layoutManager2);
        this.contentsPanel.setOpaque(false);
        layoutManager2 = new BorderLayout();
        this.setLayout(layoutManager2);
        this.setOpaque(false);
        this.setTitleComponent(jComponent);
        this.setContentsComponent(jComponent2);
        this.setResizingComponent(this.resizingComponent);
    }

    public boolean isExpandable() {
        boolean bl = this.expandable;
        return bl;
    }

    public void setExpandable(boolean bl) {
        this.expandable = bl;
        JComponent jComponent = this.getTitleComponent();
        if (jComponent != null) {
            MouseListener mouseListener = this.getTitleMouseListener();
            if (mouseListener != null) {
                jComponent.removeMouseListener(mouseListener);
            }
            if (bl) {
                jComponent.addMouseListener(mouseListener);
            }
        }
    }

    public boolean isContentsResizable() {
        boolean bl = this.contentsResizable;
        return bl;
    }

    public void setContentsResizable(boolean bl) {
        this.contentsResizable = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpanded() {
        boolean bl;
        ExpandablePanel expandablePanel = this;
        synchronized (expandablePanel) {
            bl = this.expanded;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpanded(boolean bl) {
        ExpandablePanel expandablePanel = this;
        synchronized (expandablePanel) {
            this.expanded = bl;
        }
        this.revalidatePanel();
    }

    public JComponent getTitleComponent() {
        JComponent jComponent = this.titleComponent;
        return jComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTitleComponent(JComponent jComponent) {
        MouseListener mouseListener = this.getTitleMouseListener();
        JComponent jComponent2 = this.getTitleComponent();
        ExpandablePanel expandablePanel = this;
        synchronized (expandablePanel) {
            this.titleComponent = jComponent != null ? jComponent : this.defaultTitle;
            if (jComponent2 != null) {
                this.remove(jComponent2);
                jComponent2.removeMouseListener(mouseListener);
            }
            this.titleComponent.addMouseListener(mouseListener);
            this.add((Component)this.titleComponent, "North");
        }
        this.revalidatePanel();
    }

    public JComponent getContentsComponent() {
        JComponent jComponent = this.contentsComponent;
        return jComponent;
    }

    public void setContentsComponent(JComponent jComponent) {
        this.contentsComponent = jComponent;
        this.revalidatePanel();
    }

    public JComponent getResizingComponent() {
        JComponent jComponent = this.resizingComponent;
        return jComponent;
    }

    public void setResizingComponent(JComponent jComponent) {
        this.resizingComponent = jComponent;
        this.revalidatePanel();
    }

    public MouseListener getTitleMouseListener() {
        MouseListener mouseListener = this.titleMouseListener;
        return mouseListener;
    }

    public void setTitleMouseListener(MouseListener mouseListener) {
        MouseListener mouseListener2 = this.titleMouseListener;
        this.titleMouseListener = mouseListener;
        JComponent jComponent = this.getTitleComponent();
        if (jComponent != null) {
            jComponent.removeMouseListener(mouseListener2);
            jComponent.addMouseListener(mouseListener);
        }
    }

    public int getComponentVgap() {
        BorderLayout borderLayout = (BorderLayout)this.getLayout();
        int n = borderLayout.getVgap();
        return n;
    }

    public void setComponentVgap(int n) {
        BorderLayout borderLayout = (BorderLayout)this.getLayout();
        borderLayout.setVgap(n);
        this.revalidatePanel();
    }

    public void addExpansionListener(ExpansionListener expansionListener) {
        this.listenerList.add(class$sanproject$client$exdevice$event$ExpansionListener == null ? (class$sanproject$client$exdevice$event$ExpansionListener = ExpandablePanel.class$("sanproject.client.exdevice.event.ExpansionListener")) : class$sanproject$client$exdevice$event$ExpansionListener, expansionListener);
    }

    public void removeExpansionListener(ExpansionListener expansionListener) {
        this.listenerList.remove(class$sanproject$client$exdevice$event$ExpansionListener == null ? (class$sanproject$client$exdevice$event$ExpansionListener = ExpandablePanel.class$("sanproject.client.exdevice.event.ExpansionListener")) : class$sanproject$client$exdevice$event$ExpansionListener, expansionListener);
    }

    public boolean isAdjustSizeing() {
        boolean bl = this.adjustSizeing;
        return bl;
    }

    public void adjustPanelSize(int n) {
        JComponent jComponent;
        Serializable serializable;
        int n2 = 0;
        JComponent jComponent2 = this.getTitleComponent();
        if (jComponent2 != null) {
            serializable = jComponent2.getPreferredSize();
            n2 += ((Dimension)serializable).height;
        }
        int n3 = this.getComponentVgap();
        n2 += n3;
        if (this.isContentsResizable() && (jComponent = this.getResizingComponent()) != null) {
            serializable = jComponent.getPreferredSize();
            n2 += ((Dimension)serializable).height;
        }
        int n4 = n - n2;
        serializable = this.getContentsComponent();
        if (serializable != null) {
            Dimension dimension = ((JComponent)serializable).getPreferredSize();
            dimension.height = n4;
            ((JComponent)serializable).setPreferredSize(dimension);
        }
        this.revalidatePanel();
    }

    protected void revalidatePanel() {
        Serializable serializable;
        this.invalidate();
        boolean bl = this.isExpanded();
        JComponent jComponent = this.getTitleComponent();
        JComponent jComponent2 = this.getContentsComponent();
        Dimension dimension = jComponent.getPreferredSize();
        Dimension dimension2 = new Dimension(dimension.width, dimension.height);
        if (jComponent2 != null) {
            if (bl) {
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = -1;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.anchor = 10;
                gridBagConstraints.fill = 1;
                this.contentsPanel.add((Component)jComponent2, gridBagConstraints);
                if (this.isContentsResizable() && (serializable = this.getResizingComponent()) != null) {
                    this.contentsPanel.add((Component)serializable, gridBagConstraints);
                }
                this.add((Component)this.contentsPanel, "Center");
                int n = this.getComponentVgap();
                serializable = this.contentsPanel.getPreferredSize();
                dimension2.height = dimension.height + ((Dimension)serializable).height + n;
            } else {
                JComponent jComponent3 = this.getResizingComponent();
                if (jComponent3 != null) {
                    this.contentsPanel.remove(jComponent3);
                }
                this.remove(this.contentsPanel);
            }
        }
        this.doLayout();
        this.setPreferredSize(dimension2);
        this.repaint();
        this.validate();
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (container instanceof ExpandablePanelList) {
                serializable = (ExpandablePanelList)container;
                serializable.revalidatePanel();
                continue;
            }
            if (container instanceof ExpandablePanel) {
                serializable = (ExpandablePanel)container;
                ((ExpandablePanel)serializable).revalidatePanel();
                continue;
            }
            container.invalidate();
            container.doLayout();
            container.repaint();
            container.validate();
        }
    }

    protected JPanel getContentsPanel() {
        JPanel jPanel = this.contentsPanel;
        return jPanel;
    }

    protected JComponent createRisizableComponent() {
        ResizingComponent resizingComponent = new ResizingComponent();
        return resizingComponent;
    }

    protected MouseListener createTitleMouseListener() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseClicked(MouseEvent mouseEvent) {
                ExpandablePanel expandablePanel = ExpandablePanel.this;
                synchronized (expandablePanel) {
                    boolean bl = ExpandablePanel.this.isExpanded();
                    ExpandablePanel.this.setExpanded(!bl);
                    ExpandablePanel.this.fireExpansionEvent();
                }
            }
        };
        return mouseAdapter;
    }

    protected void fireExpansionEvent() {
        EventListener[] eventListenerArray = this.getListeners(class$sanproject$client$exdevice$event$ExpansionListener == null ? (class$sanproject$client$exdevice$event$ExpansionListener = ExpandablePanel.class$("sanproject.client.exdevice.event.ExpansionListener")) : class$sanproject$client$exdevice$event$ExpansionListener);
        ExpansionEvent.EventType eventType = this.isExpanded() ? ExpansionEvent.EXPANDED : ExpansionEvent.COLLAPSED;
        ExpansionEvent expansionEvent = new ExpansionEvent(this, eventType);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ExpansionListener expansionListener = (ExpansionListener)eventListenerArray[i];
            expansionListener.expansionStateChanged(expansionEvent);
        }
    }

    void setAdjustSizing(boolean bl) {
        this.adjustSizeing = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class ResizingComponent
    extends JComponent
    implements MouseListener,
    MouseMotionListener {
        private boolean pressing = false;
        private int dragHeight = 0;

        private ResizingComponent() {
            Cursor cursor = Cursor.getPredefinedCursor(9);
            Dimension dimension = new Dimension(0, 2);
            this.setCursor(cursor);
            this.setPreferredSize(dimension);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mousePressed(MouseEvent mouseEvent) {
            ResizingComponent resizingComponent = this;
            synchronized (resizingComponent) {
                this.pressing = true;
                this.dragHeight = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseReleased(MouseEvent mouseEvent) {
            ResizingComponent resizingComponent = this;
            synchronized (resizingComponent) {
                this.pressing = false;
                JComponent jComponent = ExpandablePanel.this.getContentsComponent();
                if (jComponent != null) {
                    JComponent jComponent2 = jComponent;
                    synchronized (jComponent2) {
                        Dimension dimension = jComponent.getPreferredSize();
                        Dimension dimension2 = new Dimension(dimension.width, dimension.height + this.dragHeight);
                        jComponent.setPreferredSize(dimension2);
                        ExpandablePanel.this.contentsPanel.doLayout();
                        ExpandablePanel.this.revalidatePanel();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseDragged(MouseEvent mouseEvent) {
            ResizingComponent resizingComponent = this;
            synchronized (resizingComponent) {
                if (this.pressing) {
                    this.dragHeight = mouseEvent.getY();
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Dimension dimension = this.getSize();
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
    }
}

