/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.com;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import sanproject.client.exdevice.com.ExpandablePanel;
import sanproject.client.exdevice.event.ExpansionEvent;
import sanproject.client.exdevice.event.ExpansionListener;
import sanproject.client.exdevice.utility.Debug;

public class ExpandablePanelList
extends JPanel {
    private transient ExpansionListener expansionListener = new ExpansionListener(){

        public void expansionStateChanged(ExpansionEvent expansionEvent) {
            if (ExpandablePanelList.this.isDisplayLimitation()) {
                Component component = (Component)expansionEvent.getSource();
                Component[] componentArray = ExpandablePanelList.this.getComponents();
                if (componentArray != null) {
                    for (int i = 0; i < componentArray.length; ++i) {
                        ExpandablePanel expandablePanel;
                        Component component2 = componentArray[i];
                        if (component2.equals(component) || !(component2 instanceof ExpandablePanel) || !(expandablePanel = (ExpandablePanel)component2).isExpandable()) continue;
                        expandablePanel.setExpanded(false);
                    }
                }
            }
            ExpandablePanelList.this.revalidatePanel();
        }
    };
    private Component glueComponent = Box.createGlue();
    private boolean displayLimitation = false;
    private int componentsVgap;

    public ExpandablePanelList() {
        this(0);
    }

    public ExpandablePanelList(int n) {
        super(new GridBagLayout());
        this.componentsVgap = n;
        this.setOpaque(false);
    }

    public void setLayout(LayoutManager layoutManager) {
        if (!(layoutManager instanceof GridBagLayout)) {
            String string = "The layout manager's change is not permitted.";
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException(string);
            throw unsupportedOperationException;
        }
        super.setLayout(layoutManager);
    }

    public boolean isDisplayLimitation() {
        boolean bl = this.displayLimitation;
        return bl;
    }

    public void setDisplayLimitation(boolean bl) {
        this.displayLimitation = bl;
    }

    public int getExpandablePanelCount() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (!(component instanceof ExpandablePanel)) continue;
            ++n;
        }
        return n;
    }

    public void adjustPanelSize(int n) {
        int n2;
        Debug.println("adjustPanelSize() call=" + n);
        Component[] componentArray = this.getComponents();
        ArrayList<ExpandablePanel> arrayList = new ArrayList<ExpandablePanel>();
        arrayList.ensureCapacity(componentArray.length);
        int n3 = 0;
        for (n2 = 0; n2 < componentArray.length; ++n2) {
            Component component = componentArray[n2];
            if (!(component instanceof ExpandablePanel)) continue;
            if (n2 != 0) {
                n3 += this.componentsVgap;
            }
            ExpandablePanel expandablePanel = (ExpandablePanel)component;
            expandablePanel.setAdjustSizing(true);
            if (expandablePanel.isContentsResizable()) {
                arrayList.add(expandablePanel);
            } else {
                Dimension dimension = component.getPreferredSize();
                n3 += dimension.height;
            }
            expandablePanel.setAdjustSizing(false);
        }
        if (!arrayList.isEmpty()) {
            n2 = arrayList.size();
            int n4 = n - n3;
            int n5 = n4 / n2;
            Debug.println(" -> fixed=" + n3);
            Debug.println(" -> space=" + n4);
            Debug.println("   -> target=" + n2);
            Debug.println("   -> average=" + n5);
            for (int i = 0; i < n2; ++i) {
                ExpandablePanel expandablePanel = (ExpandablePanel)arrayList.get(i);
                if (i != n2 - 1) {
                    expandablePanel.adjustPanelSize(n5);
                    n4 -= n5;
                    continue;
                }
                expandablePanel.adjustPanelSize(n4);
            }
            Debug.println("   -> last=" + n5);
            this.revalidatePanel();
        }
        Debug.println("adjustPanelSize() result=" + this.getPreferredSize().height);
    }

    public void addExpandablePanel(ExpandablePanel expandablePanel) {
        if (expandablePanel != null) {
            this.remove(this.glueComponent);
            int n = this.getExpandablePanelCount();
            int n2 = n != 0 ? this.componentsVgap : 0;
            GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(n2, 0, 0, 0);
            gridBagLayout.removeLayoutComponent(this.glueComponent);
            gridBagLayout.addLayoutComponent(expandablePanel, gridBagConstraints);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagLayout.addLayoutComponent(this.glueComponent, gridBagConstraints);
            this.add(expandablePanel);
            this.add(this.glueComponent);
            expandablePanel.addExpansionListener(this.expansionListener);
            this.revalidatePanel();
        }
    }

    public void removeExpandablePanel(ExpandablePanel expandablePanel) {
        if (expandablePanel != null) {
            expandablePanel.removeExpansionListener(this.expansionListener);
            GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
            gridBagLayout.removeLayoutComponent(expandablePanel);
            this.remove(expandablePanel);
            this.revalidatePanel();
        }
    }

    public void removeExpandablePanels() {
        Component[] componentArray = this.getComponents();
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                Component component = componentArray[i];
                if (!(component instanceof ExpandablePanel)) continue;
                ExpandablePanel expandablePanel = (ExpandablePanel)component;
                this.removeExpandablePanel(expandablePanel);
            }
        }
    }

    protected void addImpl(Component component, Object object, int n) {
        if (component != this.glueComponent && !(component instanceof ExpandablePanel)) {
            String string = "Additions of the component other than ExpandablePanel are not supported.";
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException(string);
            throw unsupportedOperationException;
        }
        super.addImpl(component, object, n);
    }

    protected void revalidatePanel() {
        Component[] componentArray = this.getComponents();
        if (componentArray != null) {
            Serializable serializable;
            int n;
            this.invalidate();
            int n2 = 0;
            for (n = 0; n < componentArray.length; ++n) {
                Component component = componentArray[n];
                serializable = component.getPreferredSize();
                n2 += ((Dimension)serializable).height;
            }
            int n3 = this.getExpandablePanelCount();
            n = (n3 - 1) * this.componentsVgap;
            Dimension dimension = this.getPreferredSize();
            dimension.height = n2 + n;
            this.doLayout();
            this.setPreferredSize(dimension);
            this.repaint();
            this.validate();
            for (serializable = this.getParent(); serializable != null; serializable = ((Component)serializable).getParent()) {
                JPanel jPanel;
                if (serializable instanceof ExpandablePanelList) {
                    jPanel = (ExpandablePanelList)serializable;
                    ((ExpandablePanelList)jPanel).revalidatePanel();
                    continue;
                }
                if (serializable instanceof ExpandablePanel) {
                    jPanel = (ExpandablePanel)serializable;
                    ((ExpandablePanel)jPanel).revalidatePanel();
                    continue;
                }
                ((Container)serializable).invalidate();
                ((Container)serializable).doLayout();
                ((Component)serializable).repaint();
                ((Container)serializable).validate();
            }
        }
    }

    public static void main(String[] stringArray) {
        ExpandablePanelList expandablePanelList = stringArray.length > 0 ? (stringArray[0].equals("1") ? ExpandablePanelList.createSampleList1() : (stringArray[0].equals("2") ? ExpandablePanelList.createSampleList2() : ExpandablePanelList.createSampleList())) : ExpandablePanelList.createSampleList();
        JScrollPane jScrollPane = new JScrollPane(expandablePanelList);
        jScrollPane.setVerticalScrollBarPolicy(22);
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.setBackground(Color.WHITE);
        JFrame jFrame = new JFrame("ExpandablePanelList Sample");
        Container container = jFrame.getContentPane();
        container.add(jScrollPane);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    private static ExpandablePanelList createSampleList() {
        ExpandablePanelList expandablePanelList = new ExpandablePanelList();
        for (int i = 0; i < 4; ++i) {
            GridLayout gridLayout = new GridLayout(0, 1);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(gridLayout);
            jPanel.setOpaque(true);
            jPanel.setBackground(Color.WHITE);
            Object object = new ButtonGroup();
            for (int j = 0; j < 8; ++j) {
                int n = j + 1;
                JRadioButton jRadioButton = new JRadioButton("Number" + n);
                jRadioButton.setOpaque(false);
                ((ButtonGroup)object).add(jRadioButton);
                jPanel.add(jRadioButton);
            }
            boolean bl = i % 2 != 0;
            object = bl ? "(resizable)" : "(notresizable)";
            String string = "Expansion" + i + (String)object + "";
            JButton jButton = new JButton(string);
            ExpandablePanel expandablePanel = new ExpandablePanel();
            expandablePanel.setTitleComponent(jButton);
            expandablePanel.setContentsComponent(jPanel);
            expandablePanel.setContentsResizable(bl);
            expandablePanelList.addExpandablePanel(expandablePanel);
        }
        return expandablePanelList;
    }

    private static ExpandablePanelList createSampleList1() {
        ExpandablePanelList expandablePanelList = new ExpandablePanelList(2);
        Color[] colorArray = new Color[]{Color.BLUE, Color.YELLOW, Color.RED, Color.MAGENTA};
        for (int i = 0; i < colorArray.length; ++i) {
            Color color = colorArray[i];
            Object object = "ExpandablePanel " + String.valueOf(i);
            JButton jButton = new JButton((String)object);
            ExpandablePanelList expandablePanelList2 = new ExpandablePanelList();
            for (int j = 0; j < 4; ++j) {
                Object object2 = "ExpandablePanel " + String.valueOf(i) + "-" + String.valueOf(j);
                JButton jButton2 = new JButton((String)object2);
                jButton2.setForeground(color);
                GridLayout gridLayout = new GridLayout(0, 1);
                JComponent jComponent = new JCheckBox("Item1");
                jComponent.setOpaque(false);
                JCheckBox jCheckBox = new JCheckBox("Item2");
                jCheckBox.setOpaque(false);
                JCheckBox jCheckBox2 = new JCheckBox("Item3");
                jCheckBox2.setOpaque(false);
                JCheckBox jCheckBox3 = new JCheckBox("Item4");
                jCheckBox3.setOpaque(false);
                object2 = new JPanel();
                ((Container)object2).setLayout(gridLayout);
                ((JComponent)object2).setOpaque(false);
                ((Container)object2).add(jComponent);
                ((Container)object2).add(jCheckBox);
                ((Container)object2).add(jCheckBox2);
                ((Container)object2).add(jCheckBox3);
                boolean bl = j % 2 != 0;
                jComponent = new ExpandablePanel(jButton2, (JComponent)object2);
                ((ExpandablePanel)jComponent).setContentsResizable(bl);
                expandablePanelList2.addExpandablePanel((ExpandablePanel)jComponent);
            }
            object = expandablePanelList2;
            boolean bl = i % 2 != 0;
            ExpandablePanel expandablePanel = new ExpandablePanel(jButton, (JComponent)object);
            expandablePanel.setContentsResizable(bl);
            expandablePanel.setOpaque(true);
            expandablePanel.setBackground(color);
            expandablePanelList.addExpandablePanel(expandablePanel);
        }
        return expandablePanelList;
    }

    private static ExpandablePanelList createSampleList2() {
        ExpandablePanelList expandablePanelList = new ExpandablePanelList();
        ExpandablePanel expandablePanel = new ExpandablePanel(new JLabel("--+ 3rd"), new JLabel("--- contents"));
        ExpandablePanel expandablePanel2 = new ExpandablePanel(new JLabel("-+ 2nd"), expandablePanel);
        ExpandablePanel expandablePanel3 = new ExpandablePanel(new JLabel("+ 1st"), expandablePanel2);
        expandablePanelList.addExpandablePanel(expandablePanel3);
        return expandablePanelList;
    }
}

