/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.data;

import java.math.BigInteger;
import sanproject.client.exdevice.data.EmulationTypeInfo;
import sanproject.client.exdevice.data.LprManager;
import sanproject.client.exdevice.data.PolicyInfo;
import sanproject.client.exdevice.data.PresetData;
import sanproject.client.exdevice.data.PresetManager;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.serverux.dataimpl.EXDPolicy;
import sanproject.serverux.dataimpl.EXDsetPolicy;

public class ChangePolicyData
extends PresetData {
    public static final int OP_CHG_POLICY = 1;
    private PolicyInfo mPolicyInfo = null;
    private EXDPolicy mBackup = null;

    ChangePolicyData(PolicyInfo policyInfo) {
        this.mPolicyInfo = policyInfo;
        this.mBackup = policyInfo.getEXDPolicy();
        EXDPolicy eXDPolicy = new EXDPolicy(this.mBackup);
        policyInfo.setEXDPolicy(eXDPolicy);
    }

    public PolicyInfo getPolicyInfo() {
        return this.mPolicyInfo;
    }

    Object getApplyData() {
        EXDPolicy eXDPolicy = this.mPolicyInfo.getEXDPolicy();
        EXDsetPolicy eXDsetPolicy = new EXDsetPolicy(eXDPolicy);
        return eXDsetPolicy;
    }

    protected int setApplyResult(Object object) {
        EXDsetPolicy eXDsetPolicy = (EXDsetPolicy)object;
        int n = eXDsetPolicy.getResult();
        if (n == 0) {
            this.mPolicyInfo.setModify(false);
        }
        return n;
    }

    void enterPreset() {
        this.mPolicyInfo.setModify(true);
    }

    void removePreset() {
        if (this.mPolicyInfo.isModify()) {
            this.mPolicyInfo.setModify(false);
            this.mPolicyInfo.setEXDPolicy(this.mBackup);
        }
    }

    public int compareTo(Object object) {
        int n = 1;
        if (object instanceof EXDPolicy) {
            EXDPolicy eXDPolicy = (EXDPolicy)object;
            n = this.mPolicyInfo.compareTo(eXDPolicy);
        } else {
            ChangePolicyData changePolicyData = (ChangePolicyData)object;
            n = this.mPolicyInfo.compareTo(changePolicyData.mPolicyInfo);
        }
        return n;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof EXDPolicy) {
            EXDPolicy eXDPolicy = (EXDPolicy)object;
            bl = this.mPolicyInfo.getId() == eXDPolicy.getPolicyID();
        } else if (object instanceof ChangePolicyData) {
            ChangePolicyData changePolicyData = (ChangePolicyData)object;
            bl = this.mPolicyInfo.equals(changePolicyData.mPolicyInfo);
        }
        return bl;
    }

    public String toString() {
        return this.mPolicyInfo.toString();
    }

    static boolean setPreset(PolicyInfo policyInfo, int n) {
        boolean bl = true;
        if (!bl) {
            ChangePolicyData changePolicyData = new ChangePolicyData(policyInfo);
            PresetManager presetManager = PresetManager.getInstance();
            bl = presetManager.add(changePolicyData, n);
        }
        return bl;
    }

    public static boolean setName(PolicyInfo policyInfo, String string) {
        boolean bl = ChangePolicyData.setPreset(policyInfo, 1);
        if (bl) {
            EXDPolicy eXDPolicy = policyInfo.getEXDPolicy();
            eXDPolicy.setNickname(string);
        }
        return bl;
    }

    public static boolean setEmulationType(PolicyInfo policyInfo, EmulationTypeInfo emulationTypeInfo) {
        boolean bl = ChangePolicyData.setPreset(policyInfo, 1);
        if (bl) {
            policyInfo.setEmulationTypeInfo(emulationTypeInfo);
        }
        return bl;
    }

    public static boolean setLdevMappingInterval(PolicyInfo policyInfo, int n) {
        boolean bl = ChangePolicyData.setPreset(policyInfo, 1);
        if (bl) {
            EXDPolicy eXDPolicy = policyInfo.getEXDPolicy();
            eXDPolicy.setLdevMappingInterval(n);
        }
        return bl;
    }

    public static boolean setLdevMaxDivide(PolicyInfo policyInfo, int n) {
        boolean bl = ChangePolicyData.setPreset(policyInfo, 1);
        if (bl) {
            EXDPolicy eXDPolicy = policyInfo.getEXDPolicy();
            eXDPolicy.setNumOfLdevInPG(n);
        }
        return bl;
    }

    public static boolean setLdevSize(PolicyInfo policyInfo, BigInteger bigInteger) {
        boolean bl = ChangePolicyData.setPreset(policyInfo, 1);
        if (bl) {
            EXDPolicy eXDPolicy = policyInfo.getEXDPolicy();
            eXDPolicy.setLdevSize(bigInteger.longValue());
        }
        return bl;
    }

    public static boolean setMappingStartLdev(PolicyInfo policyInfo, Robj_interface_RJiLDEVIndex robj_interface_RJiLDEVIndex) {
        boolean bl = ChangePolicyData.setPreset(policyInfo, 1);
        if (bl) {
            EXDPolicy eXDPolicy = policyInfo.getEXDPolicy();
            eXDPolicy.setMappingStartLdev(robj_interface_RJiLDEVIndex);
        }
        return bl;
    }

    public static boolean setClpr(PolicyInfo policyInfo, int n) {
        boolean bl = ChangePolicyData.setPreset(policyInfo, 1);
        if (bl) {
            EXDPolicy eXDPolicy = policyInfo.getEXDPolicy();
            eXDPolicy.setCLPR((short)n);
            LprManager lprManager = LprManager.getInstance();
            short s = lprManager.getSlpr(n);
            eXDPolicy.setSLPR(s);
        }
        return bl;
    }

    public static boolean setAutoDiscovery(PolicyInfo policyInfo, boolean bl) {
        boolean bl2 = ChangePolicyData.setPreset(policyInfo, 1);
        if (bl2) {
            EXDPolicy eXDPolicy = policyInfo.getEXDPolicy();
            eXDPolicy.setAutoDiscovery(bl);
        }
        return bl2;
    }

    public static boolean setCacheMode(PolicyInfo policyInfo, boolean bl) {
        boolean bl2 = ChangePolicyData.setPreset(policyInfo, 1);
        if (bl2) {
            EXDPolicy eXDPolicy = policyInfo.getEXDPolicy();
            eXDPolicy.setCacheMode(bl);
        }
        return bl2;
    }

    public static boolean setInflowControl(PolicyInfo policyInfo, boolean bl) {
        boolean bl2 = ChangePolicyData.setPreset(policyInfo, 1);
        if (bl2) {
            EXDPolicy eXDPolicy = policyInfo.getEXDPolicy();
            eXDPolicy.setInflowControl(bl);
        }
        return bl2;
    }

    public static boolean setSlprLimited(PolicyInfo policyInfo, boolean bl) {
        boolean bl2 = ChangePolicyData.setPreset(policyInfo, 1);
        if (bl2) {
            EXDPolicy eXDPolicy = policyInfo.getEXDPolicy();
            eXDPolicy.setSlprLimited(bl);
        }
        return bl2;
    }

    public static boolean setExceptOpenV(PolicyInfo policyInfo, boolean bl) {
        boolean bl2 = ChangePolicyData.setPreset(policyInfo, 1);
        if (bl2) {
            EXDPolicy eXDPolicy = policyInfo.getEXDPolicy();
            eXDPolicy.setExceptOpenV(bl);
        }
        return bl2;
    }
}

