/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.data;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import sanproject.client.exdevice.data.EXDException;
import sanproject.client.exdevice.data.EmulationTypeInfo;
import sanproject.client.exdevice.data.EmulationTypeManager;
import sanproject.client.exdevice.data.ExternalVolumeStatusManager;
import sanproject.client.exdevice.data.LdevManager;
import sanproject.client.exdevice.data.LogicalPathInfo;
import sanproject.client.exdevice.data.LogicalPathInfo_Fibre;
import sanproject.client.exdevice.data.LogicalPathPriorityComparator;
import sanproject.client.exdevice.data.PathGroupInfo;
import sanproject.client.exdevice.data.PathGroupManager;
import sanproject.client.exdevice.data.ProductInfo;
import sanproject.client.exdevice.data.ProductManager;
import sanproject.client.exdevice.data.VpgInfo;
import sanproject.client.exdevice.data.VpgManager;
import sanproject.common.Robj_interface_RJiLDEVInfoDetail;
import sanproject.common.Robj_interface_RJiPGIndex;
import sanproject.serverux.dataimpl.EXDExternalDevice;
import sanproject.serverux.dataimpl.EXDExternalVolume;
import sanproject.serverux.dataimpl.EXDLogicalPath;
import sanproject.serverux.dataimpl.EXDLogicalPath_Fiber;
import sanproject.serverux.dataimpl.EXDVolumeStatus;

public class ExternalVolumeInfo
implements Comparable {
    private static final String LOG_NAME = "ExternalVolumeInfo";
    private EXDExternalVolume mRmiObj = null;
    BigInteger mCapacity = null;
    private VpgInfo mVpgInfo = null;
    private EmulationTypeInfo mEmuInfo;
    private ProductInfo mProductInfo = null;
    private PathGroupInfo mPathGroup = null;
    LogicalPathInfo[] mLogicalPaths = null;
    static LogicalPathPriorityComparator mLPathPriorityComparator = new LogicalPathPriorityComparator();
    private Robj_interface_RJiLDEVInfoDetail[] mLdevs;

    ExternalVolumeInfo(EXDExternalVolume eXDExternalVolume) {
        this.mRmiObj = eXDExternalVolume;
    }

    public EXDExternalVolume getEXDExternalVolume() {
        return this.mRmiObj;
    }

    public int getId() {
        return this.mRmiObj.getExternalVolumeID();
    }

    public String getCharacteristic() {
        EXDExternalDevice eXDExternalDevice = this.mRmiObj.getExternalDeviceInfo();
        return eXDExternalDevice.getIdentity();
    }

    public String getCharacteristic2() {
        EXDExternalDevice eXDExternalDevice = this.mRmiObj.getExternalDeviceInfo();
        return eXDExternalDevice.getIdentity2();
    }

    public int getExDevInfo() {
        EXDExternalDevice eXDExternalDevice = this.mRmiObj.getExternalDeviceInfo();
        return eXDExternalDevice.getDriveType();
    }

    public String getDeviceName() {
        EXDExternalDevice eXDExternalDevice = this.mRmiObj.getExternalDeviceInfo();
        return eXDExternalDevice.getDeviceNameInInquiry();
    }

    public BigInteger getCapacity() {
        if (this.mCapacity == null) {
            EXDExternalDevice eXDExternalDevice = this.mRmiObj.getExternalDeviceInfo();
            long l = eXDExternalDevice.getVolumeSize();
            this.mCapacity = BigInteger.valueOf(l);
        }
        return this.mCapacity;
    }

    public boolean isCmd() {
        EXDExternalDevice eXDExternalDevice = this.mRmiObj.getExternalDeviceInfo();
        return eXDExternalDevice.isCommandDevice();
    }

    public boolean isInheritDrive() {
        EXDExternalDevice eXDExternalDevice = this.mRmiObj.getExternalDeviceInfo();
        return eXDExternalDevice.isInheritDrive();
    }

    VpgInfo getVpgInfo() {
        if (this.mVpgInfo == null) {
            VpgManager vpgManager = VpgManager.getInstance();
            this.mVpgInfo = vpgManager.getVpgInfo(this.getPgIndex());
        }
        return this.mVpgInfo;
    }

    public String getLdevSummary() {
        VpgInfo vpgInfo = this.getVpgInfo();
        return vpgInfo.getLdevSummary();
    }

    public Robj_interface_RJiPGIndex getPgIndex() {
        return this.mRmiObj;
    }

    public boolean isModify() {
        VpgInfo vpgInfo = this.getVpgInfo();
        return vpgInfo.isModify();
    }

    void setModify(boolean bl) {
        VpgInfo vpgInfo = this.getVpgInfo();
        vpgInfo.setModify(bl);
    }

    public EmulationTypeInfo getEmulationTypeInfo() {
        if (this.mEmuInfo == null) {
            int n = this.mRmiObj.getIBaseEmulationType();
            EmulationTypeManager emulationTypeManager = EmulationTypeManager.getInstance();
            this.mEmuInfo = emulationTypeManager.getEmulationTypeInfo(n);
        }
        return this.mEmuInfo;
    }

    void setEmulationTypeInfo(EmulationTypeInfo emulationTypeInfo) {
        this.mEmuInfo = emulationTypeInfo;
        int n = this.mEmuInfo.getEmulationId();
        this.mRmiObj.setIBaseEmulationType(n);
    }

    int getProductInfoId() {
        EXDExternalDevice eXDExternalDevice = this.mRmiObj.getExternalDeviceInfo();
        return eXDExternalDevice.referSubsystemID();
    }

    ProductInfo getProductInfo() {
        if (this.mProductInfo == null) {
            int n = this.getProductInfoId();
            ProductManager productManager = ProductManager.getInstance();
            this.mProductInfo = productManager.getProductInfo(n);
        }
        return this.mProductInfo;
    }

    public byte getPathMode() {
        return this.mRmiObj.getPathMode();
    }

    int getPathGroupId() {
        return this.mRmiObj.referPathGroupID();
    }

    public PathGroupInfo getPathGroupInfo() {
        if (this.mPathGroup == null) {
            int n = this.getPathGroupId();
            PathGroupManager pathGroupManager = PathGroupManager.getInstance();
            this.mPathGroup = pathGroupManager.getPathGroupInfo(n);
        }
        return this.mPathGroup;
    }

    public boolean isVmaValid() {
        return false;
    }

    public int getClpr() {
        return this.mRmiObj.getSCLPR();
    }

    public int getSlpr() {
        return this.mRmiObj.getSSLPR();
    }

    public boolean isCacheModeEnable() {
        return this.mRmiObj.getCacheMode();
    }

    public boolean isInflowControlEnable() {
        return this.mRmiObj.getInflowControl();
    }

    public int getExVolStatus() {
        ExternalVolumeStatusManager externalVolumeStatusManager = ExternalVolumeStatusManager.getInstance();
        externalVolumeStatusManager.refrectVolumeStatus(this);
        EXDVolumeStatus eXDVolumeStatus = this.mRmiObj.getVolumeStatus();
        return eXDVolumeStatus.getStatus();
    }

    public int getDestageProgress() {
        ExternalVolumeStatusManager externalVolumeStatusManager = ExternalVolumeStatusManager.getInstance();
        externalVolumeStatusManager.refrectVolumeStatus(this);
        EXDVolumeStatus eXDVolumeStatus = this.mRmiObj.getVolumeStatus();
        return eXDVolumeStatus.getDestageProgress();
    }

    EXDLogicalPath[] getEXDLogicalPath() {
        return this.mRmiObj.getLogicalPathList();
    }

    void setEXDLogicalPath(EXDLogicalPath[] eXDLogicalPathArray) {
        int n;
        this.mLogicalPaths = null;
        EXDLogicalPath[] eXDLogicalPathArray2 = this.getEXDLogicalPath();
        for (n = 0; n < eXDLogicalPathArray.length; ++n) {
            eXDLogicalPathArray2[n] = eXDLogicalPathArray[n];
        }
        while (n < eXDLogicalPathArray2.length) {
            eXDLogicalPathArray2[n] = null;
            ++n;
        }
    }

    public LogicalPathInfo[] getLogicalPathInfo() {
        if (this.mLogicalPaths == null) {
            ArrayList<LogicalPathInfo_Fibre> arrayList = new ArrayList<LogicalPathInfo_Fibre>();
            EXDLogicalPath[] eXDLogicalPathArray = this.getEXDLogicalPath();
            for (int i = 0; i < eXDLogicalPathArray.length; ++i) {
                if (eXDLogicalPathArray[i] == null || !(eXDLogicalPathArray[i] instanceof EXDLogicalPath_Fiber)) continue;
                LogicalPathInfo_Fibre logicalPathInfo_Fibre = new LogicalPathInfo_Fibre((EXDLogicalPath_Fiber)eXDLogicalPathArray[i]);
                arrayList.add(logicalPathInfo_Fibre);
            }
            Collections.sort(arrayList, mLPathPriorityComparator);
            LogicalPathInfo[] logicalPathInfoArray = new LogicalPathInfo[]{};
            this.mLogicalPaths = arrayList.toArray(logicalPathInfoArray);
        }
        return this.mLogicalPaths;
    }

    public Robj_interface_RJiLDEVInfoDetail[] getLdevInfo() throws EXDException {
        if (this.mLdevs == null) {
            short s = this.getVpgInfo().getEXDVpg().getNumOfLdev();
            if (s > 0) {
                LdevManager ldevManager = LdevManager.getInstance();
                this.mLdevs = ldevManager.getLdevInfo(this.getPgIndex());
            } else {
                this.mLdevs = new Robj_interface_RJiLDEVInfoDetail[0];
            }
        }
        return this.mLdevs;
    }

    void setLdevInfos(Robj_interface_RJiLDEVInfoDetail[] robj_interface_RJiLDEVInfoDetailArray) {
        this.mLdevs = robj_interface_RJiLDEVInfoDetailArray;
    }

    public boolean equals(Object object) {
        try {
            String string = ExternalVolumeInfo.getCompValue(this);
            String string2 = ExternalVolumeInfo.getCompValue(object);
            return string.equals(string2);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.getCharacteristic2();
    }

    public int compareTo(Object object) {
        String string = ExternalVolumeInfo.getCompValue(this);
        String string2 = ExternalVolumeInfo.getCompValue(object);
        return string.compareTo(string2);
    }

    private static String getCompValue(Object object) {
        String string = object instanceof ExternalVolumeInfo ? ((ExternalVolumeInfo)object).getCharacteristic2() : (object instanceof EXDExternalDevice ? ((EXDExternalDevice)object).getIdentity2() : (String)object);
        return string;
    }
}

