/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import sanproject.client.exdevice.data.AbstractDataControl;
import sanproject.client.exdevice.data.EXDException;
import sanproject.client.exdevice.data.FilterManager;
import sanproject.client.exdevice.data.PathGroupInfo;
import sanproject.client.exdevice.data.PathGroupMaintenanceData;
import sanproject.client.exdevice.data.PathGroupManager;
import sanproject.client.exdevice.data.PhysicalPathInfo;
import sanproject.client.exdevice.data.PhysicalPathManager;
import sanproject.client.exdevice.data.PortManager;
import sanproject.client.exdevice.data.PresetManager;
import sanproject.client.exdevice.data.ProductInfo;
import sanproject.client.exdevice.data.ProductManager;
import sanproject.client.exdevice.data.TargetPortInfo;
import sanproject.client.exdevice.data.TargetPortManager;
import sanproject.common.Robj_interface_RJiPortIndex;
import sanproject.common.Robj_interface_RJiPortInfoDetail;
import sanproject.serverux.dataimpl.EXDDiscoveryTargetPort;
import sanproject.serverux.dataimpl.EXDPathGroup;
import sanproject.serverux.dataimpl.EXDPhysicalPath;
import sanproject.serverux.dataimpl.EXDSubsystem;
import sanproject.serverux.dataimpl.EXDTargetPort;
import sanproject.serverux.dataimpl.EXDgetDiscoveryTargetPort_IN;
import sanproject.serverux.dataimpl.EXDgetDiscoveryTargetPort_OUT;
import sanproject.serverux.dataimpl.SanRmiInputInterface;

public class PathDirector {
    private AbstractDataControl mDctl;
    private ProductManager mProductManager = ProductManager.getInstance();
    private PhysicalPathManager mPhysicalPathManager = PhysicalPathManager.getInstance();
    private TargetPortManager mTargetPortManager = TargetPortManager.getInstance();
    private PortManager mPortManager = PortManager.getInstance();
    private PathGroupInfo mPathGroup = null;
    private boolean mflgIncludeOwnProduct = FilterManager.doShowOwnDevice();
    private HashMap mProductToPortMap = new HashMap();
    private HashMap mPhysicalPathMap = new HashMap();
    ArrayList mSelectedPathList = new ArrayList();
    private static final int ALTERNATE_MAX = 8;

    public PathDirector(AbstractDataControl abstractDataControl, PathGroupInfo pathGroupInfo) {
        Collection collection;
        if (abstractDataControl == null) {
            throw new NullPointerException();
        }
        this.mDctl = abstractDataControl;
        this.mPathGroup = pathGroupInfo;
        if (this.mPathGroup != null) {
            collection = this.mPathGroup.getPhysicalPathInfo();
            this.mSelectedPathList.addAll(collection);
        }
        collection = this.mPhysicalPathManager.getPhysicalPathInfo();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            PhysicalPathInfo physicalPathInfo = (PhysicalPathInfo)iterator.next();
            this.addPhysicalPath(physicalPathInfo);
            ProductInfo productInfo = physicalPathInfo.getProductInfo();
            int n = physicalPathInfo.referPortId();
            this.addProductToPortId(productInfo, n);
        }
    }

    public PathDirector(AbstractDataControl abstractDataControl) {
        this(abstractDataControl, null);
    }

    void addProductToPortId(ProductInfo productInfo, int n) {
        int n2;
        Robj_interface_RJiPortInfoDetail robj_interface_RJiPortInfoDetail;
        if (!this.mflgIncludeOwnProduct && productInfo.isOwn()) {
            return;
        }
        ArrayList<Robj_interface_RJiPortInfoDetail> arrayList = (ArrayList<Robj_interface_RJiPortInfoDetail>)this.mProductToPortMap.get(productInfo);
        if (arrayList == null) {
            arrayList = new ArrayList<Robj_interface_RJiPortInfoDetail>();
            this.mProductToPortMap.put(productInfo, arrayList);
        }
        if ((robj_interface_RJiPortInfoDetail = this.mPortManager.getPortInfo(n)) != null && (n2 = Collections.binarySearch(arrayList, robj_interface_RJiPortInfoDetail)) < 0) {
            arrayList.add(-(n2 + 1), robj_interface_RJiPortInfoDetail);
        }
    }

    public ProductInfo[] getDiscoveryProduct() {
        Set set = this.mProductToPortMap.keySet();
        Object[] objectArray = new ProductInfo[]{};
        objectArray = set.toArray(objectArray);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public Robj_interface_RJiPortInfoDetail[] getDiscoveryPort(ProductInfo productInfo) {
        ArrayList arrayList = (ArrayList)this.mProductToPortMap.get(productInfo);
        Robj_interface_RJiPortInfoDetail[] robj_interface_RJiPortInfoDetailArray = new Robj_interface_RJiPortInfoDetail[]{};
        return arrayList.toArray(robj_interface_RJiPortInfoDetailArray);
    }

    static final String physicalPathMapKey(ProductInfo productInfo, int n) {
        return productInfo + "@" + n;
    }

    void addPhysicalPath(PhysicalPathInfo physicalPathInfo) {
        int n;
        ProductInfo productInfo = physicalPathInfo.getProductInfo();
        String string = PathDirector.physicalPathMapKey(productInfo, n = physicalPathInfo.referPortId());
        ArrayList<PhysicalPathInfo> arrayList = (ArrayList<PhysicalPathInfo>)this.mPhysicalPathMap.get(string);
        if (arrayList != null) {
            int n2 = Collections.binarySearch(arrayList, physicalPathInfo);
            if (n2 < 0) {
                arrayList.add(-(n2 + 1), physicalPathInfo);
            }
        } else {
            arrayList = new ArrayList<PhysicalPathInfo>();
            arrayList.add(physicalPathInfo);
            this.mPhysicalPathMap.put(string, arrayList);
        }
    }

    public PhysicalPathInfo[] getPhysicalPath(ProductInfo productInfo, Robj_interface_RJiPortIndex robj_interface_RJiPortIndex) {
        String string = PathDirector.physicalPathMapKey(productInfo, robj_interface_RJiPortIndex.getSPort());
        ArrayList arrayList = (ArrayList)this.mPhysicalPathMap.get(string);
        PhysicalPathInfo[] physicalPathInfoArray = new PhysicalPathInfo[]{};
        if (arrayList != null) {
            physicalPathInfoArray = arrayList.toArray(physicalPathInfoArray);
        }
        return physicalPathInfoArray;
    }

    public void doDiscoveryAllPort() throws EXDException {
        Robj_interface_RJiPortInfoDetail[] robj_interface_RJiPortInfoDetailArray = this.mPortManager.getPortInfo();
        this.doDiscoveryPort((Robj_interface_RJiPortIndex[])robj_interface_RJiPortInfoDetailArray);
    }

    public void doDiscoveryPort(Robj_interface_RJiPortIndex[] robj_interface_RJiPortIndexArray) throws EXDException {
        if (robj_interface_RJiPortIndexArray == null || robj_interface_RJiPortIndexArray.length == 0) {
            return;
        }
        int[] nArray = new int[robj_interface_RJiPortIndexArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = robj_interface_RJiPortIndexArray[i].getSPort();
        }
        this.doDiscoveryPort(nArray);
    }

    public void doDiscoveryPort(int[] nArray) throws EXDException {
        int n;
        if (nArray == null || nArray.length == 0) {
            return;
        }
        EXDgetDiscoveryTargetPort_IN eXDgetDiscoveryTargetPort_IN = new EXDgetDiscoveryTargetPort_IN();
        for (n = 0; n < nArray.length; ++n) {
            eXDgetDiscoveryTargetPort_IN.setInitiatorPort((short)nArray[n]);
        }
        EXDgetDiscoveryTargetPort_OUT eXDgetDiscoveryTargetPort_OUT = (EXDgetDiscoveryTargetPort_OUT)this.mDctl.comGet((SanRmiInputInterface)eXDgetDiscoveryTargetPort_IN);
        for (int i = 0; i < nArray.length; ++i) {
            n = nArray[i];
            EXDDiscoveryTargetPort[] eXDDiscoveryTargetPortArray = eXDgetDiscoveryTargetPort_OUT.getDiscoveryTargetPort((short)n);
            for (int j = 0; j < eXDDiscoveryTargetPortArray.length; ++j) {
                EXDDiscoveryTargetPort eXDDiscoveryTargetPort = eXDDiscoveryTargetPortArray[j];
                EXDSubsystem eXDSubsystem = eXDDiscoveryTargetPort.getSubsystem();
                ProductInfo productInfo = this.mProductManager.createDiscoveryProductInfo(eXDSubsystem);
                this.addProductToPortId(productInfo, n);
                EXDTargetPort eXDTargetPort = eXDDiscoveryTargetPort.getTargetPort();
                eXDTargetPort.setSubsystemId(productInfo.getId());
                TargetPortInfo targetPortInfo = this.mTargetPortManager.createDiscoveryTargetPortInfo(eXDTargetPort);
                EXDPhysicalPath eXDPhysicalPath = eXDDiscoveryTargetPort.getPhysicalPath();
                eXDPhysicalPath.setTargetPortId(targetPortInfo.getId());
                PhysicalPathInfo physicalPathInfo = this.mPhysicalPathManager.createDiscoveryPhysicalPathInfo(eXDPhysicalPath);
                this.addPhysicalPath(physicalPathInfo);
            }
        }
    }

    public PhysicalPathInfo[] getSelectedPath() {
        PhysicalPathInfo[] physicalPathInfoArray = new PhysicalPathInfo[]{};
        return this.mSelectedPathList.toArray(physicalPathInfoArray);
    }

    public boolean addSelectedPath(PhysicalPathInfo physicalPathInfo) {
        boolean bl = this.canAddSelectedPath(physicalPathInfo);
        if (bl) {
            this.mSelectedPathList.add(physicalPathInfo);
        }
        return bl;
    }

    public boolean removeSelectedPath(PhysicalPathInfo physicalPathInfo) {
        boolean bl = this.canRemoveSelectedPath(physicalPathInfo);
        if (bl) {
            this.mSelectedPathList.remove(physicalPathInfo);
        }
        return bl;
    }

    public boolean priorityUp(PhysicalPathInfo physicalPathInfo) {
        boolean bl = this.canPriorityUp(physicalPathInfo);
        if (bl) {
            int n = this.mSelectedPathList.indexOf(physicalPathInfo);
            boolean bl2 = bl = n >= 1;
            if (bl) {
                this.mSelectedPathList.remove(n);
                this.mSelectedPathList.add(n - 1, physicalPathInfo);
            }
        }
        return bl;
    }

    public boolean priorityDown(PhysicalPathInfo physicalPathInfo) {
        boolean bl = this.canPriorityDown(physicalPathInfo);
        if (bl) {
            int n = this.mSelectedPathList.indexOf(physicalPathInfo);
            boolean bl2 = bl = n >= 0 && n < this.mSelectedPathList.size() - 1;
            if (bl) {
                this.mSelectedPathList.remove(n);
                this.mSelectedPathList.add(n + 1, physicalPathInfo);
            }
        }
        return bl;
    }

    public boolean canAddSelectedPath(PhysicalPathInfo physicalPathInfo) {
        if (this.mSelectedPathList.size() >= 8) {
            return false;
        }
        if (this.mSelectedPathList.contains(physicalPathInfo)) {
            return false;
        }
        if (!this.mSelectedPathList.isEmpty()) {
            PhysicalPathInfo physicalPathInfo2 = (PhysicalPathInfo)this.mSelectedPathList.get(0);
            ProductInfo productInfo = physicalPathInfo2.getProductInfo();
            ProductInfo productInfo2 = physicalPathInfo.getProductInfo();
            return productInfo.equals(productInfo2);
        }
        return true;
    }

    public boolean canRemoveSelectedPath(PhysicalPathInfo physicalPathInfo) {
        Comparable comparable;
        int n;
        Object object;
        int n2 = physicalPathInfo.getId();
        if (n2 < 0) {
            return true;
        }
        if (this.mPathGroup == null) {
            return true;
        }
        int n3 = this.mPathGroup.getId();
        EXDPathGroup eXDPathGroup = null;
        if (this.mPathGroup.isModify()) {
            object = PresetManager.getInstance();
            ArrayList arrayList = new ArrayList(((PresetManager)object).getAllEntry());
            for (n = 0; n < arrayList.size() && n3 != (eXDPathGroup = ((PathGroupMaintenanceData)(comparable = (PathGroupMaintenanceData)arrayList.get(n))).getOrgEXDPathGroup()).getPathGroupID(); ++n) {
            }
        }
        if (eXDPathGroup == null) {
            eXDPathGroup = this.mPathGroup.getEXDPathGroup();
        }
        object = eXDPathGroup.referAllPhysicalPathList();
        for (int i = 0; i < ((Object)object).length; ++i) {
            if (n2 == object[i] || object[i] < 0) continue;
            for (n = 0; n < this.mSelectedPathList.size(); ++n) {
                comparable = (PhysicalPathInfo)this.mSelectedPathList.get(n);
                if (object[i] != ((PhysicalPathInfo)comparable).getId()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canPriorityUp(PhysicalPathInfo physicalPathInfo) {
        return this.mSelectedPathList.size() > 1;
    }

    public boolean canPriorityDown(PhysicalPathInfo physicalPathInfo) {
        return this.mSelectedPathList.size() > 1;
    }

    public PathGroupInfo createPathGroup() {
        PathGroupManager pathGroupManager = PathGroupManager.getInstance();
        PhysicalPathInfo physicalPathInfo = (PhysicalPathInfo)this.mSelectedPathList.get(0);
        int n = physicalPathInfo.getTargetPortInfo().referSubsystemId();
        PathGroupInfo pathGroupInfo = pathGroupManager.createPathGroup(n);
        int[] nArray = pathGroupInfo.referPhysicalPathIdList();
        for (int i = 0; i < this.mSelectedPathList.size(); ++i) {
            PhysicalPathInfo physicalPathInfo2 = (PhysicalPathInfo)this.mSelectedPathList.get(i);
            nArray[i] = physicalPathInfo2.getId();
        }
        return pathGroupInfo;
    }

    public boolean commit() throws EXDException {
        boolean bl = PathGroupMaintenanceData.doChangeAlterPath(this.mPathGroup, this.getSelectedPath());
        return bl;
    }
}

