/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.luoperation;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JPopupMenu;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJcElement;
import sanproject.client.com.RJcMenuAction;
import sanproject.client.com.RJcPopupMenu;
import sanproject.client.data.RJDataControl;
import sanproject.client.exdevice.com.AbstractTableDataModel;
import sanproject.client.exdevice.com.TableColumnInfo;
import sanproject.client.exdevice.luoperation.ExternalPortColumnInfo;
import sanproject.client.exdevice.luoperation.LocalGuidance;
import sanproject.client.exdevice.luoperation.PathConfigurationPanel;
import sanproject.client.exdevice.luoperation.PhysicalPathElement;
import sanproject.client.exdevice.luoperation.PriorityColumnInfo;
import sanproject.client.exdevice.luoperation.TargetPortColumnInfo;

public class PathConfigTableDataModel
extends AbstractTableDataModel {
    private TableColumnInfo[] headers;
    private PathConfigurationPanel configPanel;
    private RJcMenuAction deleteAction;
    private RJcMenuAction priorityUpAction;
    private RJcMenuAction priorityDownAction;

    public PathConfigTableDataModel(PathConfigurationPanel pathConfigurationPanel) {
        String string = LocalGuidance.MENU_DELETE.getItemID();
        this.deleteAction = new RJcMenuAction(string){

            public void actionPerformed(ActionEvent actionEvent) {
                RJCom.putLog(RJDataControl.getDataControl(), "[ExDevice_LU]", "PathConfigDataModel", "[PathConfigDataModel] Path Delete.", 0);
                PathConfigTableDataModel.this.onSelectDeleteTarget(actionEvent);
            }

            public String toString() {
                String string = (String)this.getValue("Name");
                return string;
            }
        };
        string = LocalGuidance.MENU_PRIOLITYUP.getItemID();
        this.priorityUpAction = new RJcMenuAction(string){

            public void actionPerformed(ActionEvent actionEvent) {
                RJCom.putLog(RJDataControl.getDataControl(), "[ExDevice_LU]", "PathConfigDataModel", "[PathConfigDataModel] Path Priority Up.", 0);
                PathConfigTableDataModel.this.onSelectPriorityUp(actionEvent);
            }

            public String toString() {
                String string = (String)this.getValue("Name");
                return string;
            }
        };
        string = LocalGuidance.MENU_PRIOLITYDOWN.getItemID();
        this.priorityDownAction = new RJcMenuAction(string){

            public void actionPerformed(ActionEvent actionEvent) {
                RJCom.putLog(RJDataControl.getDataControl(), "[ExDevice_LU]", "PathConfigDataModel", "[PathConfigDataModel] Path Priority Down.", 0);
                PathConfigTableDataModel.this.onSelectPriorityDown(actionEvent);
            }

            public String toString() {
                String string = (String)this.getValue("Name");
                return string;
            }
        };
        this.configPanel = pathConfigurationPanel;
        this.setHeaderPush(false);
    }

    protected JPopupMenu createPopupMenu() {
        RJcPopupMenu rJcPopupMenu = null;
        this.updateActionsStatus();
        RJcMenuAction[] rJcMenuActionArray = new RJcMenuAction[]{this.deleteAction, new RJcMenuAction(), this.priorityUpAction, this.priorityDownAction};
        rJcPopupMenu = new RJcPopupMenu(rJcMenuActionArray);
        return rJcPopupMenu;
    }

    public TableColumnInfo[] getColumnInfos() {
        if (this.headers == null) {
            this.headers = new TableColumnInfo[]{new PriorityColumnInfo(), new ExternalPortColumnInfo(), new TargetPortColumnInfo()};
        }
        TableColumnInfo[] tableColumnInfoArray = this.headers;
        return tableColumnInfoArray;
    }

    public PhysicalPathElement[] getSelectedPhysicalPathElements() {
        int[] nArray = this.getSelectedRows();
        PhysicalPathElement[] physicalPathElementArray = this.getPhysicalPathElements(nArray);
        return physicalPathElementArray;
    }

    public PhysicalPathElement[] getPhysicalPathElements(int[] nArray) {
        RJcElement[] rJcElementArray = this.getElements(nArray);
        int n = rJcElementArray.length;
        ArrayList<RJcElement> arrayList = new ArrayList<RJcElement>();
        arrayList.ensureCapacity(n);
        for (int i = 0; i < n; ++i) {
            RJcElement rJcElement = rJcElementArray[i];
            if (!(rJcElement instanceof PhysicalPathElement)) continue;
            arrayList.add(rJcElement);
        }
        PhysicalPathElement[] physicalPathElementArray = new PhysicalPathElement[]{};
        physicalPathElementArray = arrayList.toArray(physicalPathElementArray);
        return physicalPathElementArray;
    }

    private void updateActionsStatus() {
        PhysicalPathElement[] physicalPathElementArray = this.getSelectedPhysicalPathElements();
        boolean bl = this.configPanel.canRemoveSelectedPaths(physicalPathElementArray);
        boolean bl2 = this.configPanel.canPriorityUpPaths(physicalPathElementArray);
        boolean bl3 = this.configPanel.canPriorityDownPaths(physicalPathElementArray);
        this.deleteAction.setEnabled(bl);
        this.priorityUpAction.setEnabled(bl2);
        this.priorityDownAction.setEnabled(bl3);
    }

    private void onSelectDeleteTarget(ActionEvent actionEvent) {
        PhysicalPathElement[] physicalPathElementArray = this.getSelectedPhysicalPathElements();
        this.configPanel.removeSelectedPaths(physicalPathElementArray);
    }

    private void onSelectPriorityUp(ActionEvent actionEvent) {
        PhysicalPathElement[] physicalPathElementArray = this.getSelectedPhysicalPathElements();
        this.configPanel.priorityUp(physicalPathElementArray);
    }

    private void onSelectPriorityDown(ActionEvent actionEvent) {
        PhysicalPathElement[] physicalPathElementArray = this.getSelectedPhysicalPathElements();
        this.configPanel.priorityDown(physicalPathElementArray);
    }
}

