/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.portoperation;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JPopupMenu;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJcElement;
import sanproject.client.com.RJcMenuAction;
import sanproject.client.com.RJcPopupMenu;
import sanproject.client.data.RJDataControl;
import sanproject.client.exdevice.com.AbstractTableDataModel;
import sanproject.client.exdevice.com.Operation;
import sanproject.client.exdevice.com.TableColumnInfo;
import sanproject.client.exdevice.data.PresetManager;
import sanproject.client.exdevice.portoperation.LocalGuidance;
import sanproject.client.exdevice.portoperation.LocalOperation;
import sanproject.client.exdevice.portoperation.PCBModeColumnInfo;
import sanproject.client.exdevice.portoperation.PortAttributeColumnInfo;
import sanproject.client.exdevice.portoperation.PortElement;
import sanproject.client.exdevice.portoperation.PortNameColumnInfo;
import sanproject.client.exdevice.portoperation.PortTreePanel;

public class FibrePortTableDataModel
extends AbstractTableDataModel {
    private TableColumnInfo[] headers;
    private RJcMenuAction toExternalAction;
    private RJcMenuAction toTargetAction;
    private PortTreePanel treePanel;

    public FibrePortTableDataModel(PortTreePanel portTreePanel) {
        this.treePanel = portTreePanel;
        String string = LocalGuidance.MENU_TOEXTERNAL.getItemID();
        this.toExternalAction = new RJcMenuAction(string){

            public void actionPerformed(ActionEvent actionEvent) {
                RJCom.putLog(RJDataControl.getDataControl(), "[ExDevice_Port]", "FibrePortDataModel", "[FibrePortDataModel] Port To External.", 0);
                FibrePortTableDataModel.this.onSelectPortToExternal(actionEvent);
            }

            public String toString() {
                String string = (String)this.getValue("Name");
                return string;
            }
        };
        string = LocalGuidance.MENU_TOTARGET.getItemID();
        this.toTargetAction = new RJcMenuAction(string){

            public void actionPerformed(ActionEvent actionEvent) {
                RJCom.putLog(RJDataControl.getDataControl(), "[ExDevice_Port]", "FibrePortDataModel", "[FibrePortDataModel] Port To Target.", 0);
                FibrePortTableDataModel.this.onSelectPortToTarget(actionEvent);
            }

            public String toString() {
                String string = (String)this.getValue("Name");
                return string;
            }
        };
    }

    public TableColumnInfo[] getColumnInfos() {
        if (this.headers == null) {
            this.headers = new TableColumnInfo[]{new PortNameColumnInfo(), new PortAttributeColumnInfo(), new PCBModeColumnInfo()};
        }
        TableColumnInfo[] tableColumnInfoArray = this.headers;
        return tableColumnInfoArray;
    }

    protected JPopupMenu createPopupMenu() {
        this.updateActionsStatus();
        RJcMenuAction[] rJcMenuActionArray = new RJcMenuAction[]{this.toExternalAction, this.toTargetAction};
        RJcPopupMenu rJcPopupMenu = new RJcPopupMenu(rJcMenuActionArray);
        return rJcPopupMenu;
    }

    public PortElement[] getSelectedPortElements() {
        int[] nArray = this.getSelectedRows();
        PortElement[] portElementArray = this.getPortElements(nArray);
        return portElementArray;
    }

    public PortElement[] getPortElements(int[] nArray) {
        PortElement[] portElementArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.rows != null && nArray.length > 0) {
            portElementArray = new ArrayList();
            Object object = this.getElements(nArray);
            Object object2 = Arrays.asList(object);
            portElementArray.addAll(object2);
            object = portElementArray.iterator();
            while (object.hasNext()) {
                object2 = (RJcElement)object.next();
                if (!(object2 instanceof PortElement)) continue;
                arrayList.add(object2);
            }
        }
        portElementArray = new PortElement[]{};
        portElementArray = arrayList.toArray(portElementArray);
        return portElementArray;
    }

    private void updateActionsStatus() {
        PresetManager presetManager;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = FibrePortTableDataModel.isEditable(13, 1);
        if (bl3 && Operation.isPossibleTo(presetManager = PresetManager.getInstance(), LocalOperation.CHANGE_ATTRIBUTE)) {
            PortElement portElement;
            boolean bl4;
            PortElement[] portElementArray = this.getSelectedPortElements();
            for (int i = 0; i < portElementArray.length && !(bl4 = (bl |= (portElement = portElementArray[i]).canChangeAttributeTo(3)) & (bl2 |= portElement.canChangeAttributeTo(6))); ++i) {
            }
        }
        this.toExternalAction.setEnabled(bl2);
        this.toTargetAction.setEnabled(bl);
    }

    private void onSelectPortToExternal(ActionEvent actionEvent) {
        PortElement[] portElementArray = this.getSelectedPortElements();
        int n = portElementArray.length;
        for (int i = 0; i < n; ++i) {
            PortElement portElement = portElementArray[i];
            boolean bl = portElement.canChangeAttributeTo(6);
            if (!bl) continue;
            portElement.changeAttributeTo(6);
        }
        this.treePanel.refreshTree();
    }

    private void onSelectPortToTarget(ActionEvent actionEvent) {
        PortElement[] portElementArray = this.getSelectedPortElements();
        int n = portElementArray.length;
        for (int i = 0; i < n; ++i) {
            PortElement portElement = portElementArray[i];
            boolean bl = portElement.canChangeAttributeTo(3);
            if (!bl) continue;
            portElement.changeAttributeTo(3);
        }
        this.treePanel.refreshTree();
    }
}

